#include "flash.h"
#include "derivative.h"

/*Function definitions with file level scope*/

unsigned char LaunchFlashCommand(unsigned char _paramNumber, \
                                 unsigned char _commandID, \
                                 unsigned char _param1, unsigned int _param2, \
                                 unsigned int  _param3, unsigned int _param4, \
                                 unsigned int  _param5, unsigned int _param6);
                                 
                                 

/******************************************************************************
Function Name	:	LaunchFlashCommand
Scope     :     Local
Engineer	:		  created by b19005, modified by b34618
Date			:	    01/12/08           2/23/2011
Arguments	:	    _paramNumber: Number of parambs that will be passed. This number
                              will determine CCOBIX final value.
                _commandID:   Command to execute.
                _param1:      CCOBIX0 FCCOB low byte
                _param2 - _param6: Data needed by command to exeucte.              
Return		:     FSTAT when command is executed, 1 when memory controller is busy
******************************************************************************/
unsigned char LaunchFlashCommand(unsigned char _paramNumber, \
                                 unsigned char _commandID, \
                                 unsigned char _param1, unsigned int _param2, \
                                 unsigned int  _param3, unsigned int _param4, \
                                 unsigned int  _param5, unsigned int _param6)
{
  unsigned char _status = 0;
  if(FSTAT_CCIF == 1)
	{																	
		/* Clear any error flags*/	
	  FSTAT = 0x30;

    /* Write the command id */
    FCCOBIX = 0;
		/*FCCOB HI byte Command */
		FCCOBHI = _commandID;
		/*FCCOB LO byte Parameter 1*/
		FCCOBLO = _param1;

    if(++FCCOBIX != _paramNumber) 
    {
      FCCOB = _param2;  /* Write next data word to CCOB buffer. */ 
      if(++FCCOBIX != _paramNumber) 
      {
  		  FCCOB = _param3;  /* Write next data word to CCOB buffer. */
        if(++FCCOBIX != _paramNumber) 
        {
   		    FCCOB = _param4;  /* Write next data word to CCOB buffer. */
          if(++FCCOBIX != _paramNumber) 
          {
            FCCOB = _param5;  /* Write next data word to CCOB buffer. */
            if(++FCCOBIX != _paramNumber) 
         		  FCCOB = _param6;  /* Write next data word to CCOB buffer. */
          } 											
        }  
	    }
    }
	  FCCOBIX = _paramNumber-1;
	  
	 	/* Clear command buffer empty flag by writing a 1 to it */
		FSTAT = 0x80;
    while (!FSTAT_CCIF) 
    {
      /* wait for the command to complete */  
    }
    /* Return status. */
    _status = FSTAT;  /* command completed */
  }
  else
  {
    _status = FLASH_BUSY;
  }
  
	return(_status);								   /* state machine busy */
}

/******************************************************************************
Function Name	:	FlshProgramEEPROM
Engineer	:		  created by b34618
Date			:	    2/23/2011
Arguments	:	    _address, _wordNumber, _word1, _word2, _word3, _word4.
Return		:     FSTAT value
******************************************************************************/
unsigned char FlshProgramEEPROM(unsigned long _address, unsigned char _wordNumber, \
                                unsigned int  _word1,   unsigned int  _word2, \
                                unsigned int  _word3,   unsigned int  _word4)
{
  unsigned char _status;
  unsigned int  _addressLo;
  unsigned char _addressHi;
  _addressHi = (unsigned char)((_address>>16)&0x000000FF);
  _addressLo  = (unsigned int)((_address&0x0000FFFF));
  if(_wordNumber > EEPROM_MAX_PROG_WORDS ||
     _wordNumber < EEPROM_MIN_PROG_WORDS)
  {
    _wordNumber = 1;
  }
  /*Transform word number to CCOBIX*/
  _wordNumber+= 2;
  
  /*Launch Flash Command*/
  _status = LaunchFlashCommand(_wordNumber, PROGRAM_EEPROM,
                               _addressHi,  _addressLo,
                               _word1,      _word2,
                               _word3,      _word4);
                               
  return(_status);
}

/******************************************************************************
Function Name	:	FlashEraseVerifyEEPROM
Engineer	:		  created by b34618
Date			:	    2/23/2011
Arguments	:	    none
Return		:     FSTAT value
******************************************************************************/
unsigned char FlashEraseVerifyEEPROM(void)
{
  return(LaunchFlashCommand(ER_VER_BLK_PAR_NUM, ERASE_VERIFY_BLOCK,
                            ER_VER_BLK_PAR_VAL, 0, 0, 0, 0, 0));
                                 
}

/******************************************************************************
Function Name	:	FlashEraseEEPROMSector
Engineer	:		  created by b34618
Date			:	    2/23/2011
Arguments	:	    none
Return		:     FSTAT value
******************************************************************************/
unsigned char FlashEraseEEPROMSector(unsigned long _address)
{
  unsigned int  _addressLo;
  unsigned char _addressHi;
  _addressHi = (unsigned char)((_address>>16)&0x000000FF);
  _addressLo  = (unsigned int)((_address&0x0000FFFF));
  
  
  return(LaunchFlashCommand(ER_EEPROM_SEC_PAR_NUM, ERASE_EEPROM_SECTOR,
                            _addressHi, _addressLo, 0, 0, 0, 0));
                                 
}

/******************************************************************************
Function Name	:	FlashEraseVerifyEEPROMSection
Engineer	:		  created by b34618
Date			:	    2/23/2011
Arguments	:	    none
Return		:     FSTAT value
******************************************************************************/
unsigned char FlashEraseVerifyEEPROMSection(unsigned long _address, unsigned int _wordNumber)
{
  unsigned int  _addressLo;
  unsigned char _addressHi;
  _addressHi = (unsigned char)((_address>>16)&0x000000FF);
  _addressLo  = (unsigned int)((_address&0x0000FFFF));
  
  return(LaunchFlashCommand(ER_VER_EEPROM_FLA_SEC_PAR_NUM, ERASE_VERIFY_EEPROM_FLASH_SECTION,
                            _addressHi, _addressLo, _wordNumber, 0, 0, 0));
                                 
}

/******************************************************************************
Function Name	:	FlashEraseEEPROMBlock
Engineer	:		  created by b34618
Date			:	    2/23/2011
Arguments	:	    none
Return		:     FSTAT value
NOTE      : Erase EEPROM Block needs to be executed from RAM Location. It is 
            not necessary to transfer the whole function, if LaunchFlashCommand
            is transferred to RAM the command will execute properly
******************************************************************************/
unsigned char FlashEraseEEPROMBlock(void)
{
  return(LaunchFlashCommand(ER_EEPROM_FLA_BLK_PAR_NUM, ERASE_EEPROM_FLASH_BLOCK,
                            EEPROM_GADDRESS_HI, EEPROM_GADDRESS_LO, 0, 0, 0, 0));
                                 
}


/******************************************************************************
Function Name	:	FlashConfigFLClock
Engineer		:  	b34618
Date			:	    2/14/11
Arguments	:	    None, Depends on BUS_CLOCK and FLASH_CLOCK_SPEED Macros
Returns		:     None
Notes			:	    This function will set flash clock to operate at 1Mhz
******************************************************************************/
void FlashConfigFLClock(void)
{
  unsigned long clock;
  clock = BUS_CLOCK/FLASH_CLOCK_SPEED;
  while (!FSTAT_CCIF) 
  {					
    /* wait for FTM reset to complete */
  }
  FCLKDIV = (unsigned char)clock;
}


