/******************************************************************************
* 
* Copyright (c) 2011 Freescale Semiconductor;
* All Rights Reserved                       
*
*******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
***************************************************************************//*!
*
* @file      screen_listbox.c
*
* @author    b01119
* 
* @version   0.0.3.0
* 
* @date      Feb-25-2011
* 
* @brief     Screen for testing listBox object and user chars
*
******************************************************************************/

#include "d4cd.h"

// declare the static functions headers
static void D4CD_ListBoxOnChange(D4CD_OBJECT* pThis, void* pUser);

// D4CD_LISTBOX declaration
D4CD_DECLARE_STD_LIST_BOX_BEGIN_AUTOSIZE(tstListBoxScr_ListBox, "Tst:", NULL, 0, 0, D4CD_ListBoxOnChange)
  D4CD_DECLARE_LIST_BOX_ITEM("Char \010", NULL)
  D4CD_DECLARE_LIST_BOX_ITEM("Char \011", NULL)
  D4CD_DECLARE_LIST_BOX_ITEM("Char \012", NULL)
  D4CD_DECLARE_LIST_BOX_ITEM("Char \013", NULL)
  D4CD_DECLARE_LIST_BOX_ITEM("Char \014", NULL)
  D4CD_DECLARE_LIST_BOX_ITEM("Char \015", NULL)
  D4CD_DECLARE_LIST_BOX_ITEM("Char \016", NULL)
  D4CD_DECLARE_LIST_BOX_ITEM("Char \017", NULL)
D4CD_DECLARE_LIST_BOX_END  
  

// D4CD_SCREEN declaration
D4CD_DECLARE_SCREEN_BEGIN(scr_testListBox, TestListBoxScreen_, 0 ,0, D4CD_SCREEN_CHAR_CNT, D4CD_SCREEN_LINE_CNT, "Test ListBox", D4CD_USER_CHAR_TABLE_DEFAULT, (D4CD_SCR_F_BCKG))
  D4CD_DECLARE_SCREEN_OBJECT(tstListBoxScr_ListBox)
D4CD_DECLARE_SCREEN_END()

// ListBox On Change call back function
static void D4CD_ListBoxOnChange(D4CD_OBJECT* pThis, void* pUser)
{
  D4CD_UNUSED(pThis);
  D4CD_UNUSED(pUser);
}

// One time called screen function in screen initialization proces
static void TestListBoxScreen_OnInit()
{

}

// Screen on Activate function called with each screen activation
static void TestListBoxScreen_OnActivate()
{
  
}


// Screen "Main" function called periodically in each D4CD_poll runs
static void TestListBoxScreen_OnMain()
{

}


// Screen on DeActivate function called with each screen deactivation
static void TestListBoxScreen_OnDeactivate()
{
    
}

// Screen on message function called with each internal massage for this screen
static Byte TestListBoxScreen_OnObjectMsg(D4CD_MESSAGE* pMsg)
{
  D4CD_UNUSED(pMsg);
  return D4CD_MSG_NOSKIP;
}