/******************************************************************************
* 
* Copyright (c) 2011 Freescale Semiconductor;
* All Rights Reserved                       
*
*******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
***************************************************************************//*!
*
* @file      screen_date.c
*
* @author    b01119
* 
* @version   0.0.2.0
* 
* @date      Jan-18-2011
* 
* @brief     Screen for testing date user object
*
******************************************************************************/

#include "d4cd.h"

// declare the static functions headers
static void D4CD_DateOnChange(D4CD_OBJECT* pThis);


// the date name table
const D4CD_CHAR monthNames[12][4] =
{
  "Jan",
  "Feb",
  "Mar",
  "Apr",
  "May",
  "Jun",
  "Jul",
  "Aug",
  "Sep",
  "Oct",
  "Nov",
  "Dec"      
};

const D4CD_DATE_MULTITEXT monthTable = 
{
 4,
 12,
 (D4CD_CHAR* const)&monthNames
};


// D4CD_DATE declaration
D4CD_DECLARE_STD_DATE_AUTOSIZE(tstDateScr_Date, 0, 0, NULL, &monthTable, D4CD_DateOnChange)

// D4CD_SCREEN declaration
D4CD_DECLARE_SCREEN_BEGIN(scr_testDate, TestDateScreen_, 0 ,0, D4CD_SCREEN_CHAR_CNT, D4CD_SCREEN_LINE_CNT, "Test Date", D4CD_USER_CHAR_TABLE_DEFAULT, (D4CD_SCR_F_BCKG))
  D4CD_DECLARE_SCREEN_OBJECT(tstDateScr_Date)
D4CD_DECLARE_SCREEN_END()

// Date On Change call back function
static void D4CD_DateOnChange(D4CD_OBJECT* pThis)
{
  D4CD_UNUSED(pThis);
}

// One time called screen function in screen initialization proces
static void TestDateScreen_OnInit()
{

}

// Screen on Activate function called with each screen activation
static void TestDateScreen_OnActivate()
{
  
}


// Screen "Main" function called periodically in each D4CD_poll runs
static void TestDateScreen_OnMain()
{

}


// Screen on DeActivate function called with each screen deactivation
static void TestDateScreen_OnDeactivate()
{
    
}

// Screen on message function called with each internal massage for this screen
static Byte TestDateScreen_OnObjectMsg(D4CD_MESSAGE* pMsg)
{
    D4CD_UNUSED(pMsg);
    return 0;
}