/******************************************************************************
* 
* Copyright (c) 2010 Freescale Semiconductor;
* All Rights Reserved                       
*
*******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
***************************************************************************//*!
*
* @file      d4cdlcdhw_gpio_8bit.h
*
* @author    b01119
* 
* @version   0.0.1.0
* 
* @date      Jan-6-2011
* 
* @brief     D4CD driver - gpio_8bit hardware lcd driver function header file 
*
*******************************************************************************/

#ifndef __D4CDLCDHW_GPIO_8BIT_H
#define __D4CDLCDHW_GPIO_8BIT_H

  #if (D4CD_MK_STR(D4CD_LLD_LCD_HW) == d4cdlcdhw_gpio_8bit_ID)

    /******************************************************************************
    * Includes
    ******************************************************************************/
    #include "d4cdlcdhw_gpio_8bit_cfg.h"
    
    /******************************************************************************
    * Constants
    ******************************************************************************/
   
    /******************************************************************************
    * Types
    ******************************************************************************/

    /******************************************************************************
    * Macros 
    ******************************************************************************/
    #define SET(x)           (x##_PORT) |= (1 << (x))
    #define RESET(x)         (x##_PORT) &= ~(1 << (x))
    #define SET_ALL(x)       (x##_PORT) = 0xFF
    #define RESET_ALL(x)     (x##_PORT) = 0 

    #define OUTPUT(x)        (x##_DDR) |= (1 << (x)) 
    #define INPUT(x)         (x##_DDR) &= ~(1 << (x))
    #define OUTPUT_ALL(x)    (x##_DDR) = 0xFF 
    #define INPUT_ALL(x)     (x##_DDR) = 0

    #ifndef D4CDLCD_INIT_EN
      #ifndef D4CDLCD_EN
      	#error "The Macro D4CDLCD_EN must be set in LCD low level driver configuration file." 
      #else
      	#define D4CDLCD_INIT_EN OUTPUT(D4CDLCD_EN);
      #endif	
    #endif
    
    #ifndef D4CDLCD_ASSERT_EN
    	#ifndef D4CDLCD_EN
      	#error "The Macro D4CDLCD_EN must be set in LCD low level driver configuration file." 
      #else
      	#define D4CDLCD_ASSERT_EN RESET(D4CDLCD_EN);
      #endif	
    #endif  
    
    #ifndef D4CDLCD_DEASSERT_EN
      #ifndef D4CDLCD_EN
      	#error "The Macro D4CDLCD_EN must be set in LCD low level driver configuration file." 
      #else
      	#define D4CDLCD_DEASSERT_EN SET(D4CDLCD_EN);
      #endif	
    #endif
    
    #ifndef D4CDLCD_INIT_RS
      #ifndef D4CDLCD_RS
      	#error "The Macro D4CDLCD_RS must be set in LCD low level driver configuration file." 
      #else
      	#define D4CDLCD_INIT_RS OUTPUT(D4CDLCD_RS);
      #endif	
    #endif
    
    #ifndef D4CDLCD_ASSERT_RS
    	#ifndef D4CDLCD_RS
      	#error "The Macro D4CDLCD_RS must be set in LCD low level driver configuration file." 
      #else
      	#define D4CDLCD_ASSERT_RS RESET(D4CDLCD_RS);
      #endif	
    #endif  
    
    #ifndef D4CDLCD_DEASSERT_RS
      #ifndef D4CDLCD_RS
      	#error "The Macro D4CDLCD_RS must be set in LCD low level driver configuration file." 
      #else
      	#define D4CDLCD_DEASSERT_RS SET(D4CDLCD_RS);
      #endif	
    #endif

    #ifndef D4CDLCD_INIT_RW
      #ifndef D4CDLCD_RW
      	#error "The Macro D4CDLCD_RW must be set in LCD low level driver configuration file." 
      #else
      	#define D4CDLCD_INIT_RW OUTPUT(D4CDLCD_RW);
      #endif	
    #endif
    
    #ifndef D4CDLCD_ASSERT_RW
    	#ifndef D4CDLCD_RW
      	#error "The Macro D4CDLCD_RW must be set in LCD low level driver configuration file." 
      #else
      	#define D4CDLCD_ASSERT_RW RESET(D4CDLCD_RW);
      #endif	
    #endif  
    
    #ifndef D4CDLCD_DEASSERT_RW
      #ifndef D4CDLCD_RW
      	#error "The Macro D4CDLCD_RW must be set in LCD low level driver configuration file." 
      #else
      	#define D4CDLCD_DEASSERT_RW SET(D4CDLCD_RW);
      #endif	
    #endif
    
    #ifdef D4CDLCD_BACKLIGHT

      #ifndef D4CDLCD_INIT_BACKLIGHT
      	#define D4CDLCD_INIT_BACKLIGHT OUTPUT(D4CDLCD_BACKLIGHT);
      #endif
      
      #ifndef D4CDLCD_ASSERT_BACKLIGHT
      	#define D4CDLCD_ASSERT_BACKLIGHT RESET(D4CDLCD_BACKLIGHT);
      #endif  
      
      #ifndef D4CDLCD_DEASSERT_BACKLIGHT
        #define D4CDLCD_DEASSERT_BACKLIGHT SET(D4CDLCD_BACKLIGHT);      
      #endif
      
    #endif

    #ifndef D4CDLCD_INIT_DATA
    #ifndef D4CDLCD_DATA
    	#error "The Macro D4CDLCD_DATA must be set in LCD low level driver configuration file." 
    #else    
    	#define D4CDLCD_INIT_DATA OUTPUT_ALL(D4CDLCD_DATA);
    #endif	
  #endif
  
  #ifndef D4CDLCD_DATA_WRITE
    #ifndef D4CDLCD_DATA
    	#error "The Macro D4CDLCD_DATA must be set in LCD low level driver configuration file." 
    #else    
    	#define D4CDLCD_DATA_WRITE(x) D4CDLCD_DATA = x;
    #endif	
  #endif
  
  #ifndef D4CDLCD_DATA_READ
    #ifndef D4CDLCD_DATA
    	#error "The Macro D4CDLCD_DATA must be set in LCD low level driver configuration file." 
    #else    
    	#define D4CDLCD_DATA_READ(x) x = D4CDLCD_DATA;
    #endif	
  #endif
  
  #ifndef D4CDLCD_DATA_SET2READ
    #ifndef D4CDLCD_DATA
    	#error "The Macro D4CDLCD_DATA must be set in LCD low level driver configuration file." 
    #else    
    	#define D4CDLCD_DATA_SET2READ INPUT_ALL(D4CDLCD_DATA);
    #endif	
  #endif
  
  #ifndef D4CDLCD_DATA_SET2WRITE
    #ifndef D4CDLCD_DATA
    	#error "The Macro D4CDLCD_DATA must be set in LCD low level driver configuration file." 
    #else    
    	#define D4CDLCD_DATA_SET2WRITE OUTPUT_ALL(D4CDLCD_DATA);
    #endif	
  #endif
  
    /******************************************************************************
    * Global variables
    ******************************************************************************/

    /******************************************************************************
    * Global functions
    ******************************************************************************/

  #endif
#endif /* __D4CDLCDHW_GPIO_8BIT_H */










