/******************************************************************************
* 
* Copyright (c) 2010 Freescale Semiconductor;
* All Rights Reserved                       
*
*******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
***************************************************************************//*!
*
* @file      d4cdlcd_hd44780.h
*
* @author    b01119
* 
* @version   0.0.1.0
* 
* @date      Jan-6-2011
* 
* @brief     D4CD driver - hd44780 lcd driver function header file 
*
*******************************************************************************/

#ifndef __D4CDLCD_HD44780_H
#define __D4CDLCD_HD44780_H

  #if (D4CD_MK_STR(D4CD_LLD_LCD) == d4cdlcd_hd44780_ID)

    /******************************************************************************
    * Includes
    ******************************************************************************/
    #include "d4cdlcd_hd44780_cfg.h"
    
    /******************************************************************************
    * Macros 
    ******************************************************************************/
     
    #ifndef D4CD_DISPLAY_LINE_CNT
      #define D4CD_DISPLAY_LINE_CNT 2
      #warning The display line count is set to default: D4CD_DISPLAY_LINE_CNT = 2.
    #endif
    
    #ifndef D4CD_DISPLAY_INTERFACE_MODE
      #define D4CD_DISPLAY_INTERFACE_MODE 8
      #warning The display interface mode is set to default: D4CD_DISPLAY_INTERFACE_MODE = 8.
    #endif  
    
    /******************************************************************************
    * Constants
    ******************************************************************************/
   
    #define D4CDLCD_CMD_DISPLAYOFF 0x08 // display off
    #define D4CDLCD_CMD_DISPLAYON 0x0c // display on
    #define D4CDLCD_CMD_CLS 0x01 // CLS
    #define D4CDLCD_CMD_CURSORMODE 0x06 // increment mode, cursor moves
    #define D4CDLCD_CMD_SHIFT 0x10 // can shift cursor or display in both direction 

    #if (D4CD_DISPLAY_LINE_CNT == 1)
      #define D4CDLCD_CMD_RESETMODE 0x30  // RESET, 8 bit bus, 1 line display
      #define D4CDLCD_CMD_MODE4BIT 0x28 // 4 bit mode, 1 line!
      #define D4CDLCD_CMD_MODE8BIT 0x38 // 8 bit mode, 1 lines!
      
    #elif (D4CD_DISPLAY_LINE_CNT == 2) | (D4CD_DISPLAY_LINE_CNT == 4)
      #define D4CDLCD_CMD_RESETMODE 0x38  // RESET, 8 bit bus, 2 or 4 lines display
      #define D4CDLCD_CMD_MODE4BIT 0x28 // 4 bit mode, 2 lines!
      #define D4CDLCD_CMD_MODE8BIT 0x38 // 8 bit mode, 2 lines!
      
    #else
      #error Unsupported Dispaly line cnt in D4CD_DISPLAY_LINE_CNT
    #endif

    #define D4CDLCD_CMD_RETURNCURSOR 0x02 // cursor back (long execution)
    

    #define D4CDLCD_SHIFT_CUR_L 0x00
    #define D4CDLCD_SHIFT_CUR_R 0x04
    #define D4CDLCD_SHIFT_DIS_L 0x08
    #define D4CDLCD_SHIFT_DIS_R 0x0C
   
    #ifndef D4CDLCD_DDRAM
      #define D4CDLCD_DDRAM 0x80 // DDRAM address offset
    #endif
    #ifndef D4CDLCD_CGRAM 
      #define D4CDLCD_CGRAM 0x40 // CGRAM address offset
    #endif
    
    
    #ifndef D4CDLCD_CHAR_HEIGHT
      #define D4CDLCD_CHAR_HEIGHT 8
    #endif  
    
    #if (D4CD_DISPLAY_INTERFACE_MODE == 4)
      #define D4CDLCD_CMD_MODE D4CDLCD_CMD_MODE4BIT  // RESET, 8 bit bus, 1 line display
      
    #elif (D4CD_DISPLAY_INTERFACE_MODE == 8)
      #define D4CDLCD_CMD_MODE D4CDLCD_CMD_MODE8BIT  // RESET, 8 bit bus, 2 or 4 lines display
      
    #else
      #error Unsupported Display interface mode in D4CD_DISPLAY_INTERFACE_MODE
    #endif

   
    /******************************************************************************
    * Types
    ******************************************************************************/

     
      
    /******************************************************************************
    * Global variables
    ******************************************************************************/

    /******************************************************************************
    * Global functions
    ******************************************************************************/

  #endif
#endif /* __D4CDLCD_HD44780_H */










