/******************************************************************************
* 
* Copyright (c) 2010 Freescale SemlistBoxductor;
* All Rights Reserved                       
*
*******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
***************************************************************************//*!
*
* @file      d4cd_list_box.h
*
* @author    b01119
* 
* @version   0.0.2.0
* 
* @date      Jan-12-2011
* 
* @brief     D4CD Driver listBox object header file
*
*******************************************************************************/

#ifndef __D4CD_LIST_BOX_H
#define __D4CD_LIST_BOX_H

extern const D4CD_OBJECT_SYS_FUNCTION d4cd_listBoxSysFunc;

/******************************************************************************
* Constants
******************************************************************************/

/******************************************************************************
* Types
******************************************************************************/

#ifndef D4CD_LIST_BOX_F_DEFAULT
  #define D4CD_LIST_BOX_F_DEFAULT  (D4CD_OBJECT_F_VISIBLE | D4CD_OBJECT_F_ENABLED | D4CD_OBJECT_F_TABSTOP | D4CD_OBJECT_F_CURSOR_EN)
#endif

#ifndef D4CD_LIST_BOX_TXT_PRTY_DEFAULT
  #define D4CD_LIST_BOX_TXT_PRTY_DEFAULT  (D4CD_TXT_PRTY_ALIGN_H_CENTER_MASK)
#endif

#ifndef D4CD_LISTBOX_ITEM_TXT_PRTY_DEFAULT
  #define D4CD_LISTBOX_ITEM_TXT_PRTY_DEFAULT  (D4CD_TXT_PRTY_ALIGN_H_CENTER_MASK)
#endif

#ifndef D4CD_LISTBOX_SEL_FOCUS_CHAR
  #define D4CD_LISTBOX_SEL_FOCUS_CHAR '>'
#endif

#ifndef D4CD_LISTBOX_SEL_NORMAL_CHAR
  #define D4CD_LISTBOX_SEL_NORMAL_CHAR ' '
#endif

#ifndef D4CD_LISTBOX_KEY_SCANCODE_PLUS
  #define D4CD_LISTBOX_KEY_SCANCODE_PLUS D4CD_KEY_SCANCODE_UP
#endif

#ifndef D4CD_LISTBOX_KEY_SCANCODE_MINUS
  #define D4CD_LISTBOX_KEY_SCANCODE_MINUS D4CD_KEY_SCANCODE_DOWN
#endif

#if (D4CD_LISTBOX_SEL_FOCUS_CHAR != 0) && (D4CD_LISTBOX_SEL_NORMAL_CHAR != 0)
  #define  D4CD_LISTBOX_SEL_CHAR D4CD_TRUE
#else
  #define  D4CD_LISTBOX_SEL_CHAR D4CD_FALSE
#endif

 
typedef Byte D4CD_LIST_BOX_INDEX;

typedef struct
{
  D4CD_CHAR* pText;
  void* pUser;
}D4CD_LIST_BOX_ITEMS;

typedef union
{
  D4CD_BIT_FIELD all;
  struct
  {
    unsigned bSet :1;
  }bits;
  
}D4CD_LISTBOX_STATUS;

typedef struct
{
  D4CD_LIST_BOX_INDEX index;      // current value
  D4CD_LISTBOX_STATUS status;
} D4CD_LIST_BOX_DATA;

// LIST_BOX configuration (in ROM by default)

typedef struct
{
    D4CD_CHAR* preText;          // text printed before the list box
    D4CD_CHAR* postText;         // text printed behind the list box
    D4CD_POINT scrPos;           // position on the screen
    D4CD_SIZE  scrSize;          // size on the screen for focus rectangle (bitmap has its own size)
    D4CD_LIST_BOX_ITEMS* pItems;           // LIST_BOX state X idication bitmaps
    void (*OnValueChanged)(D4CD_OBJECT* pThis, void* pUser);
    D4CD_LIST_BOX_DATA* pData;    
} D4CD_LIST_BOX;

/******************************************************************************
* Macros 
******************************************************************************/

// getting the LIST_BOX structure from general OBJECT
#define D4CD_GET_LIST_BOX(pObj) ((D4CD_LIST_BOX*)((pObj)->pParam))

/*********************************************************
*
* static declaration macros
*
*********************************************************/
          
#define _D4CD_DECLARE_LIST_BOX_BEGIN(type, name, preText, postText, x, y, cx, flags, pUser, pOnValch, pOnUsrMsg) \
    extern type D4CD_LIST_BOX_ITEMS name##_items[];\
    static D4CD_LIST_BOX_DATA name##_data; \
    static type D4CD_LIST_BOX name##_params = \
    { \
        preText,   /* perText */\
        postText,   /* postText */\
        { x, y },     /* scrPos     */ \
        { cx, 0 },   /* scrSize    */ \
        (D4CD_LIST_BOX_ITEMS*)&(name##_items[0]), /* pItems     */ \
        pOnValch,      /* OnValueCanged */ \
        &(name##_data) /* RAM-based data */ \
    }; \
    \
    D4CD_DECLARE_OBJECT(name, pOnUsrMsg, &d4cd_listBoxSysFunc, &(name##_params), (flags), pUser)\
    \
    type D4CD_LIST_BOX_ITEMS   name##_items[] = \
    {

#define D4CD_DECLARE_LIST_BOX_ITEM(pItemText, pItemUserPointer) { (pItemText), (void*)(pItemUserPointer)},

#define D4CD_DECLARE_LIST_BOX_END { NULL, NULL }};


#define D4CD_DECLARE_LIST_BOX_BEGIN(name, preText, postText, x, y, cx, flags, pUser, pOnValch, pOnUsrMsg) \
  _D4CD_DECLARE_LIST_BOX_BEGIN(D4CD_CONST, name, preText, postText, x, y, cx, flags, pUser, pOnValch, pOnUsrMsg)


#define D4CD_DECLARE_LIST_BOX_BEGIN_INRAM(name, preText, postText, x, y, cx, flags, pUser, pOnValch, pOnUsrMsg) \
  _D4CD_DECLARE_LIST_BOX_BEGIN(D4CD_NO_CONST, name, preText, postText, x, y, cx, flags, pUser, pOnValch, pOnUsrMsg)


#define D4CD_DECLARE_LIST_BOX_BEGIN_AUTOSIZE(name, preText, postText, x, y, flags, pUser, onvalch, pOnUsrMsg) \
  D4CD_DECLARE_LIST_BOX_BEGIN(name, preText, postText, x, y, 0, (flags), pUser, onvalch, pOnUsrMsg)

#define D4CD_DECLARE_STD_LIST_BOX_BEGIN(name, preText, postText, x, y, cx, onvalch) \
  D4CD_DECLARE_LIST_BOX_BEGIN(name, preText, postText, x, y, cx, (D4CD_LIST_BOX_F_DEFAULT), NULL, onvalch, NULL)

#define D4CD_DECLARE_STD_LIST_BOX_BEGIN_AUTOSIZE(name, preText, postText, x, y, onvalch)\
  D4CD_DECLARE_STD_LIST_BOX_BEGIN(name, preText, postText, x, y, 0, onvalch)



/******************************************************************************
* Global variables
******************************************************************************/

/******************************************************************************
* Global functions
******************************************************************************/

/*********************************************************
*
* global functions
*
*********************************************************/
void D4CD_ListBoxSetIndex(D4CD_OBJECT_PTR pThis, D4CD_LIST_BOX_INDEX index);
void D4CD_ListBoxChangeIndex(D4CD_OBJECT_PTR pThis, sByte incr);
D4CD_LIST_BOX_INDEX D4CD_ListBoxGetIndex(D4CD_OBJECT_PTR pThis);


D4CD_LIST_BOX_INDEX D4CD_ListBoxGetItemCount(D4CD_OBJECT_PTR pThis);
D4CD_LIST_BOX_INDEX D4CD_ListBoxFindUserDataItem(D4CD_OBJECT_PTR pThis, void* pUser);
void* D4CD_ListBoxGetItemUserData(D4CD_OBJECT_PTR pThis);
D4CD_CHAR* D4CD_ListBoxGetItemText(D4CD_OBJECT_PTR pThis);
// Obsolete functions, replaced by any general
#define D4CD_ListBoxSetText D4CD_SetText




#endif /* __D4CD_LIST_BOX_H */        


