/******************************************************************************
* 
* Copyright (c) 2010 Freescale Semiconductor;
* All Rights Reserved                       
*
*******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
***************************************************************************//*!
*
* @file      d4cd_label.h
*
* @author    b01119
* 
* @version   0.0.3.0
* 
* @date      Jan-18-2011
* 
* @brief     D4CD Driver label object header file
*
*******************************************************************************/

#ifndef __D4CD_LABEL_H
#define __D4CD_LABEL_H

extern const D4CD_OBJECT_SYS_FUNCTION d4cd_labelSysFunc;

/******************************************************************************
* Constants
******************************************************************************/

/******************************************************************************
* Types
******************************************************************************/




  

#ifndef D4CD_LBL_F_DEFAULT
  #define D4CD_LBL_F_DEFAULT  (D4CD_OBJECT_F_VISIBLE | D4CD_OBJECT_F_ENABLED)
#endif  

#ifndef D4CD_LBL_TXT_PRTY_DEFAULT
  #define D4CD_LBL_TXT_PRTY_DEFAULT  (D4CD_TXT_PRTY_ALIGN_H_CENTER_MASK)
#endif


// label configuration (goes to ROM by default)

typedef struct
{
    D4CD_STRING* textBuff;    // label text
    D4CD_CHAR* preText;          // text printed before the list box
    D4CD_CHAR* postText;         // text printed behind the list box
    D4CD_POINT scrPos;        // position on the screen 
    D4CD_SIZE  scrSize;       // size on the screen (focus rect only, bitmaps have own size)    
} D4CD_LABEL;


/******************************************************************************
* Macros 
******************************************************************************/

// getting the LABEL structure from general OBJECT
#define D4CD_GET_LABEL(pObj) ((D4CD_LABEL*)((pObj)->pParam))

/*********************************************************
*
* static declaration macros
*
*********************************************************/

#define D4CD_DECLARE_LABEL(name, preText, text, postText, x, y, cx, flags, pUser, pOnUsrMsg) \
    static D4CD_TEXT_PROPERTIES name##_textPrties = { D4CD_LBL_TXT_PRTY_DEFAULT << D4CD_BITFIELD_SHIFT}; \
    static D4CD_STRING name##_txtbuff = { text, sizeof(text), &name##_textPrties}; \
    static const D4CD_LABEL name##_params = \
    { \
        &name##_txtbuff, /* textBuff */ \
        preText,   /* perText */\
        postText,   /* postText */\
        { x, y },   /* scrPos */ \
        { cx, 0 }, /* scrSize */ \
    }; \
    \
    D4CD_DECLARE_OBJECT(name, pOnUsrMsg, &d4cd_labelSysFunc, &(name##_params), flags, pUser)
 
#define D4CD_DECLARE_STD_LABEL(name, preText, text, postText, x, y, cx) \
    D4CD_DECLARE_LABEL(name, preText, text, postText, x, y, cx, (D4CD_LBL_F_DEFAULT), NULL, NULL)

#define D4CD_DECLARE_LABEL_AUTOSIZE(name, preText, text, postText, x, y, flags, pUser, pOnUsrMsg) \
    D4CD_DECLARE_LABEL(name, preText, text, postText, x, y, 0, flags, pUser, pOnUsrMsg)
    
#define D4CD_DECLARE_STD_LABEL_AUTOSIZE(name, preText, text, postText, x, y) \
    D4CD_DECLARE_STD_LABEL(name, preText, text, postText, x, y, 0)

/******************************************************************************
* Global variables
******************************************************************************/
   

/******************************************************************************
* Global functions
******************************************************************************/

/*********************************************************
*
* Object API
*
*********************************************************/



// Obsolete functions, replaced by any general
#define D4CD_LabelSetText D4CD_SetText
void D4CD_LabelSetTextBuffer(D4CD_OBJECT* pThis, D4CD_STRING* pTxtBuff);
D4CD_STRING* D4CD_LabelGetTextBuffer(D4CD_OBJECT* pThis);



#endif __D4CD_LABEL_H