/******************************************************************************
* 
* Copyright (c) 2010 Freescale Semiconductor;
* All Rights Reserved                       
*
*******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
***************************************************************************//*!
*
* @file      d4cd_object.c
*
* @author    b01119
* 
* @version   0.0.2.0
* 
* @date      Mar-11-2011
* 
* @brief     D4CD driver object function c file 
*
******************************************************************************/

#include "d4cd.h"
#include "d4cd_private.h"

/**************************************************************//*!
*
* Global variables
*
******************************************************************/

/**************************************************************//*!
*
* invalidate object
*
******************************************************************/

void D4CD_InvalidateObject(D4CD_OBJECT_PTR pObject, Byte bComplete)
{
    pObject->flags->bits.bRedraw = 1;
    
    if(bComplete)
        pObject->flags->bits.bRedrawC = 1;
}

/**************************************************************//*!
*
* Show / Hide object
*
******************************************************************/

void D4CD_ShowObject(D4CD_OBJECT_PTR pObject, Byte bShow)
{
    if(bShow)
    {
        pObject->flags->bits.bVisible = 1;
        pObject->flags->bits.bRedraw = 1;
        pObject->flags->bits.bRedrawC = 1;
    }
    else
    {
        pObject->flags->bits.bVisible = 0;
        
        if(!bShow)
        {
          if(pObject == D4CD_GetFocusedObject(D4CD_GetActiveScreen()))
            D4CD_ResetObjectFocus(D4CD_GetActiveScreen());
        }
        
        D4CD_InvalidateScreen(D4CD_GetActiveScreen(), D4CD_TRUE);        
    }
}

/**************************************************************//*!
*
* Get the user pointer / data of of object
*
******************************************************************/

void* D4CD_GetUserPointer(D4CD_OBJECT *pThis)
{
  return pThis->userPointer;
}

/**************************************************************//*!
*
* Capturing keys
*
******************************************************************/

void D4CD_CaptureKeys(D4CD_OBJECT_PTR  pObj)
{
    // NOTE: we need to send message, but we may just be in the middle of
    //       message processing (very likely). This may cause problem with
    //       the global d4cd_msg object as we are changing it...
    //       We better use the temporary memory to instanitate the message
    
    D4CD_MESSAGE* pMsg = (D4CD_MESSAGE*) d4cd_scratchPad;

    pMsg->pScreen = D4CD_GetActiveScreen();
    
    if(pMsg->pScreen == NULL)
    {
      d4cd_pKeysCapturer = NULL;
      return;
    }
    
    if(d4cd_pKeysCapturer)
    {
        pMsg->nMsgId = D4CD_MSG_KILLCAPTURE;
        pMsg->pObject = d4cd_pKeysCapturer;
        D4CD_SendMessage(pMsg);
        
        d4cd_pKeysCapturer->flags->bits.bRedraw = 1;
    }
    
    d4cd_pKeysCapturer = (D4CD_OBJECT*) pObj;

    if(pObj != NULL)
    {
        pMsg->nMsgId = D4CD_MSG_SETCAPTURE;
        pMsg->pObject = d4cd_pKeysCapturer;
        D4CD_SendMessage(pMsg);
        
        pObj->flags->bits.bRedraw = 1;
    }
}

/**************************************************************//*!
*
* Get Object that is capturing keys
*
******************************************************************/


D4CD_OBJECT* D4CD_GetCapturedObject(void)
{
  return d4cd_pKeysCapturer;
}


/**************************************************************//*!
*
* enable or diasble tab stop for an OBJECT
*
******************************************************************/

void D4CD_EnableTabStop(D4CD_OBJECT_PTR pObj, Byte bEnable)
{
    pObj->flags->bits.bTabStop = bEnable ? 1 : 0;
    
    if(!bEnable)
    {
      if(pObj == D4CD_GetFocusedObject(D4CD_GetActiveScreen()))
        D4CD_ResetObjectFocus(D4CD_GetActiveScreen());
    }
}

/**************************************************************//*!
*
* enable or diasble  an OBJECT
*
******************************************************************/

void D4CD_EnableObject(D4CD_OBJECT_PTR pObj, Byte bEnable)
{
  if((pObj->flags->bits.bEnabled && !bEnable) || (!pObj->flags->bits.bEnabled && bEnable))
  {      
    pObj->flags->bits.bEnabled = bEnable ? 1 : 0;
    
    if(!bEnable)
    {
      if(pObj == D4CD_GetFocusedObject(D4CD_GetActiveScreen()))
        D4CD_ResetObjectFocus(D4CD_GetActiveScreen());
    }
    
    pObj->flags->bits.bRedrawC = 1;
  }
}


/**************************************************************//*!
*
* defualt message handler for all OBJECTS
*
******************************************************************/

void D4CD_ObjOnMessage(D4CD_MESSAGE* pMsg)
{
    D4CD_UNUSED(pMsg); 
}