/******************************************************************************
* 
* Copyright (c) 2010 Freescale Semiconductor;
* All Rights Reserved                       
*
*******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
***************************************************************************//*!
*
* @file      d4cd_lldapi.h
*
* @author    b01119
* 
* @version   0.0.2.0
* 
* @date      Feb-14-2011
* 
* @brief     D4CD driver - resistive touch screen driver function header file 
*
*******************************************************************************/

#ifndef __D4CD_LLD_API_H
#define __D4CD_LLD_API_H


// LCD low level driver API functions

typedef enum 
{
  D4CDHW_PIN_PULL_UP_ON,
  D4CDHW_PIN_PULL_UP_OFF,
  D4CDHW_PIN_OUT,
  D4CDHW_PIN_IN,  
  D4CDHW_PIN_SET_0,
  D4CDHW_PIN_SET_1,
  D4CDHW_PIN_GET,
  D4CDHW_PIN_ADC_ON,
  D4CDHW_PIN_ADC_OFF
}D4CDHW_PIN_STATE;

typedef enum 
{
  D4CDLCD_RESET_PIN,
  D4CDLCD_BACKLIGHT_PIN  
}D4CDLCDHW_PINS;



typedef struct D4CDLCD_FUNCTIONS_S
{
  unsigned char (*D4CDLCD_Init)(void);
  unsigned char (*D4CDLCD_GoTo)(unsigned char x, unsigned char y);
  unsigned char (*D4CDLCD_Send_Char)(unsigned char ch);
  unsigned char (*D4CDLCD_Read_Char)(void);
  unsigned char (*D4CDLCD_WriteUserChar)(unsigned char *pData, unsigned char ix);
  unsigned char (*D4CDLCD_SetCursor)(unsigned char enable, unsigned char blink);
  void (*D4CDLCD_Delay_ms)(unsigned short period);
  unsigned char (*D4CDLCD_DeInit)(void);
}D4CDLCD_FUNCTIONS;


typedef struct D4CDLCDHW_FUNCTIONS_S
{
  unsigned char (*D4CDLCDHW_Init)(void);
  unsigned char (*D4CDLCDHW_SendData)(unsigned char value);
  unsigned char (*D4CDLCDHW_SendCmd)(unsigned char Cmd);  
  unsigned char (*D4CDLCDHW_SendNibbleCmd)(unsigned char Cmd);  
  unsigned char (*D4CDLCDHW_ReadData)(void);
  unsigned char (*D4CDLCDHW_ReadCmd)(void);  
  unsigned char (*D4CDLCDHW_PinCtl)(D4CDLCDHW_PINS pinId, D4CDHW_PIN_STATE setState);
  unsigned char (*D4CDLCDHW_DeInit)(void);
}D4CDLCDHW_FUNCTIONS;


// Include the right low level driver for LCD/TFT

#ifndef D4CD_LLD_LCD
  #error "You must #define symbol D4CD_LLD_LCD in d4cd_user_cfg.h header file"
#endif

#ifndef D4CD_LLD_LCD_HW
  #error "You must #define symbol D4CD_LLD_LCD_HW in d4cd_user_cfg.h header file"
#endif

extern const D4CDLCD_FUNCTIONS D4CD_LLD_LCD;
extern const D4CDLCDHW_FUNCTIONS D4CD_LLD_LCD_HW;

#endif /* __D4CD_LLD_API_H */










