/*************************************************************************
 * DISCLAIMER *
 * Services performed by FREESCALE in this matter are performed          *
 * AS IS and without any warranty. CUSTOMER retains the final decision   *
 * relative to the total design and functionality of the end product.    *
 * FREESCALE neither guarantees nor will be held liable by CUSTOMER      *
 * for the success of this project. FREESCALE disclaims all warranties,  *
 * express, implied or statutory including, but not limited to,          *
 * implied warranty of merchantability or fitness for a particular       *
 * purpose on any hardware, software ore advise supplied to the project  *
 * by FREESCALE, and or any product resulting from FREESCALE services.   *
 * In no event shall FREESCALE be liable for incidental or consequential *
 * damages arising out of this agreement. CUSTOMER agrees to hold        *
 * FREESCALE harmless against any and all claims demands or actions      *
 * by anyone on account of any damage, or injury, whether commercial,    *
 * contractual, or tortuous, rising directly or indirectly as a result   *
 * of the advise or assistance supplied CUSTOMER in connection with      *
 * product, services or goods supplied under this Agreement.             *
 *************************************************************************/
/*************************************************************************************************
 * File name   : tasks.h
 *
 * Description : This header file for mouse, define the LED indicator,and extern function
 *               
 *
 * History     :
 * 04/01/2007  : Initial Development
 * 
 *************************************************************************************************/


#ifndef _MOUSE_H
#define _MOUSE_H

/*#define USE_ACCELEROMETER    This Marco use the 3 axis accelerator on demo board as the mouse input*/

#define LED_1_Off()	      	PTED_PTED2 = 1
#define LED_1_On()		      PTED_PTED2 = 0
#define LED_2_Off()	  	    PTED_PTED3 = 1
#define LED_2_On()		      PTED_PTED3= 0
#define LED_3_Off()	  	    PTFD_PTFD0 = 1
#define LED_3_On()		      PTFD_PTFD0= 0
#define LED_4_Off()	  	    PTFD_PTFD1= 1
#define LED_4_On()		      PTFD_PTFD1= 0

#define LED_Both_Off()      {LED_1_Off();LED_2_Off();}
#define LED_Both_On()       {LED_1_On(); LED_2_On();}
#define LED_Only_1_On()     {LED_1_On(); LED_2_Off();}
#define LED_Only_2_On()     {LED_1_Off();LED_2_On();}

#define LED_1_Toggle()      PTED_PTED2 = !PTED_PTED2;
#define LED_2_Toggle()      PTED_PTED3 = !PTED_PTED3;
#define LED_3_Toggle()      PTFD_PTFD0 = !PTFD_PTFD0;
#define LED_4_Toggle()      PTFD_PTFD1 = !PTFD_PTFD1;



extern byte FPGARST_TimeOutCounter;

extern void Sw_Init(void);;
extern void Usr_Task(void);
extern void Emulate_Mouse_WithButton(void);

#endif 
