/* Function Prototypes */
/** Initializes the unit EMIOS 0 */
void vfnInit_Emios_0(void);

/** Sets the channel as a Modulus Up Counter Buffered */
void vfnInit_Emios_0_Mcb(uint8_t u8Channel, uint16_t u16Period);

/** Sets the channel as a Output Pulse Width Modulation Buffered */
void vfnInit_Emios_0_Opwm(uint8_t u8Channel, uint8_t u8PcrVal, uint16_t u16A, uint16_t u16B);

/** Sets the channel as a Input Pulse Width Measurement */
void vfnInit_Emios_0_Ipwm(uint8_t u8Channel, uint8_t u8PcrVal, uint8_t u8Pol);

/** Sets the value of the B Register in the selected channel */
void vfnSet_Duty_Opwm(uint8_t u8Channel, uint16_t u16Duty);

/** Sets the PWM Duty in percent */
void vfnSet_Duty_Perc_Opwm(uint8_t u8Channel, uint16_t u16DutyPerc, uint16_t u16McbChannel);

/** Gets the measure of the input pulse */
int32_t i32Get_Pulse_Width(uint8_t u8Channel);


uint16_t u16Read_Saic(uint8_t u8Channel,uint16_t u16MinVal,uint16_t u16MaxVal);