#include "MPC5604B_0M27V_0102.h"
#include "Driver_MPC5604B.h"


void vfnSelect_Analog_Pin(uint8_t u8Channel)
{
	SIU.PCR[u8Channel].R = 0x2000;         /* MPC56xxB: Initialize Pin X as channel */ 
}

void vfnSelect_Adc_Channel(uint8_t u8Channel)
{
  	ADC.NCMR[1].R |= u8Channel;
}

void vfnInit_Adc(void)
{
	ADC.MCR.R = 0x20000000;         /* Initialize ADC0 for scan mode */
		ADC.MCR.B.PWDN = 1; 
	ADC.MCR.B.ADCLKSEL = 1;
		ADC.MCR.B.PWDN = 0;  

	ADC.CTR[1].B.INPLATCH=1;
	ADC.CTR[1].B.INPCMP=3;
	ADC.CTR[1].B.INPSAMP=9;
	
  	//ADC.CTR[1].R = 0x00008606;      /* Conversion times for 32MHz ADClock */
  	ADC.MCR.B.NSTART=1;             /* Trigger normal conversions for ADC0 */
}

uint16_t u16Read_Adc(uint8_t u8Channel, uint16_t u16MaximumValue)
{
	/* Local Variables */
	/** Result of ADC scan */
	uint16_t u16Result;
	
	/* Wait for last scan to complete */
	while (ADC.CDR[u8Channel+32].B.VALID != 1) {}             
	
	/* Read ADC scan value */
    u16Result = (uint16_t)ADC.CDR[u8Channel+32].B.CDATA;
    
    /* Convert to range from 0 to maximum value */
    u16Result = (uint16_t)(u16MaximumValue * u16Result / 1023); 
	
	return u16Result;
}