/******************************************************************************
													            Copyright (c) Freescale 2010
File Name    : S12XHY_LCD_DEMO.mcp

Current Revision :Revision: 2.0 

PURPOSE:      S12XHY256 LCD Demo software                 
                                                                          
                                                                       
DESCRIPTION:  This software should be used in conjunction with DEMOS12XHY256 board. It demostrates motor operation
.             including the implementation of LCD operation   
              
                                                                          
UPDATE HISTORY                                                            
REV   DATE        DESCRIPTION OF CHANGE                          
---    --------    ---------------------                          
1.0   27/10/09    - initial coding
2.0   17/11/2010  - S12XHY migration, Delays were updated to match new clock bus speed
                    Previous version segments shall not be shown during start up 

 

     *****************************************************************************
     * File created by: Freescale East Kilbride, Scotland MSG Applications Group
     *
     *****************************************************************************

                                                                          
******************************************************************************/
/*===========================================================================*/
/* Freescale reserves the right to make changes without further notice to any*/
/* product herein to improve reliability, function, or design. Freescale does*/
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Freescale*/
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Freescale product  could create a situation where*/
/* personal injury or death may occur. Should Buyer purchase or use Freescale*/
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,*/
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Freescale*/
/* was negligent regarding the  design  or manufacture of the part. Freescale*/
/* and the Freescale logo* are registered trademarks of Freescale Ltd.       */
/*****************************************************************************/

#include <hidef.h>      /* common defines and macros */
#include <mc9s12xhy256.h>     /* derivative information */
#include "cpu.h"     
#include "lcddrv.h"
#include "GD-5506P_DEMO9S12HY64.h"
#include "GD-5506P_enums.h"  
#define D4B3                  // 1/4 duty and 1/3 bias on LCD
  

UINT16  tripA_value, tripB_value, odometer_value;     // 1M miles requires at least 20 bits:                                             
tU16  temperature_value; // Temperature variable      
extern  count=0;   

/******************************************************************************
Function Name	:	Delay
Date			   :	27/10/09
Parameters		:	unsigned int delayTime
Returns			:	NONE
Notes			   :	Simple software delay dependent on CPU clock frequency and
					   compile strategy 
******************************************************************************/
void MDelay(int delayTime)					
  {
    int x;				 //outer loop counter 
    char y;				 //inner loop counter 

    for (x=0; x < delayTime * 2; x++)
    {
        for (y=0; y<100; y++);
    }
  }

/******************************************************************************
Function Name	:	Main
Date			    :	17/11/10
Parameters		:	
Returns			  :
Notes			    : Configures Main Clock, Initializes LCD and handles its refresh
                routines.
					  
******************************************************************************/
void main(void) {

  tU08 temperature_ctr=0;
  tU08 i=0,l=0,V=0;
  tU16 dist=1000;
  
  Configure_Ports();			          // Configure I/O ports - from MC code
  
  CRG_8MHz();
  
  
  LCD_init();                       // Configure LCD, enables all FP pins & LCD

  LCD_RAM_SET_ALL();                // Set all LCD segments
  LCD_RAM_CLEAR_ALL();              // Clear all LCD segments

  SET_LOGO(ON,OFF,OFF,OFF,OFF);     // local_lcdrammode, FSL_logo, HY_64_Part_Num, Jellyfish_Name
  SET_TEMPSEGS(engine_temp, C,ON);  // Display Temp Segments
  
  EnableInterrupts;
  
 
  INIT_LCD_NUMS();
  MDelay (22000); 

//========================== LOOP ROUTINE FOR LCD ======================================  
  for(;;) 
   {                                       //Delay
    MDelay (16000);
 	  if (l == 8) l=0; else l++;;            // Update compass "value"
    SET_GEAR(ON,l);                        // Rolls through gear selector
    
    switch(l) 
      {
      case 0:   SET_COMPASS(ON,N);  break; // update compass
      case 1:   SET_COMPASS(ON,NE); break; // update compass
      case 2:   SET_COMPASS(ON,E);  break; // update compass
      case 3:   SET_COMPASS(ON,SE); break; // update compass
      case 4:   SET_COMPASS(ON,S);  break; // update compass
      case 5:   SET_COMPASS(ON,SW); break; // update compass
      case 6:   SET_COMPASS(ON,W);  break; // update compass
      case 7:   SET_COMPASS(ON,NW); break; // update compass
      }

    SET_VOLT_BAR(ON, V);
    SET_TEMP_BAR(ON, (6-V));               // Update Temp Bar Graph w/inverse of Voltage Graph

 	  if (V == 6) V=0; else V++;             // Update Voltage Bar Graph "value"
 	  
 	  if (dist<=500)                         // short routine for altering the LCD display when distance < 500
 	    {
 	      TYRE_CONFIG (ON,ON,ON,OFF,ON);     // low tire pressure
 	    }
 	  else
 	    {
 	      TYRE_CONFIG (ON,ON,OFF,ON,OFF);     // normal running cruise engaged
 	    }
 	    
 	  
 	  SET_DIST_TITLE (ON,ON,ON);              // set distance remaining
 	  DIST_REMAIN(ON, dist);                  // set the counter for miles left in the tank.
    dist--; if (dist==0) dist=1000;         // decrement the distance number
 	  
 	  SET_TEMP_DIGITS(ON,temperature_ctr);     // Update temperature digits with value of i
    temperature_ctr++; if (temperature_ctr==255) temperature_ctr=0;
           
switch(count)   
    {
      // ODOMETER
      case 0:
                
          SET_ODO_TITLE (ON,ON,OFF,OFF,OFF);   // (ODO, MILES, TRIPA, TRIPB, KM) -->SEGs      
          SET_ODO_DIGITS(ON,odometer_value);   // Update odometer digits with global odometer value
          odometer_value++; if (odometer_value==1000000) odometer_value=0;  
        
                break;
                      
        //TRIP A Meter
        case 1: SET_ODO_TITLE (OFF,ON,ON,OFF,OFF);   // (ODO, MILES, TRIPA, TRIPB, KM) -->SEGs
                SET_TRIPA_DIGITS(ON,tripA_value);   // Update tripA digits with global tripA value
                tripA_value++; if (tripA_value==1000000) tripA_value=0;
                odometer_value++; if (odometer_value==1000000) odometer_value=0; 

                break;
        
        //TRIP B meter
        case 2: SET_ODO_TITLE (OFF,ON,OFF,ON,OFF);   // (ODO, MILES, TRIPA, TRIPB, KM) -->SEGs
                SET_TRIPB_DIGITS(ON,tripB_value);    // Update tripB digits with global odometer value
                tripB_value++; if (tripB_value==1000000) tripB_value=0; 
                odometer_value++; if (odometer_value==1000000) odometer_value=0; // Increment the odometer value
                break;
      } 

    } 
  
 }
  
//==================/\/\/\/\/ INTERRUPT \/\/\/\/\===================


//==================/\/\/\/\/ INTERRUPT \/\/\/\/\===================
// This interrupt service routine controls the switch on the demo board
// and rotates the Odo/tripA/B on LCD 
//==================================================================     
#pragma CODE_SEG NON_BANKED

__interrupt VectorNumber_Vportad void _isr_SW6__Interrupt (void)
  {

extern UINT16  odometer_value;                        // 1M  = 1111 0100 0010 0100 0000  
     
  
       // SELECTOR SWITCH
    if (PT1AD_PT1AD5 == 0)                            // used to toggle between ODO/TRIPA/TRIP B on PTS5 press
      {
        count=count++;
        if (count == 3)
          { 
            count=0; 
          }
    MDelay(2000);                                 // do nothing - debounce for SW6     
    PIF1AD_PIF1AD5	= 1;				        	     // clear PT1AD5  interrupt flag - Menu Switch  
  }  
  
#pragma CODE_SEG DEFAULT

  }
