/********************************************************************************************/
/* FILE NAME: main_z4_ram_update_fresh_part.c                                               */
/*                                                           COPYRIGHT (c) Freescale 2010   */
/*                                                                  All Rights Reserved     */
/* DESCRIPTION:                                                                             */
/* Main program will set up the MPC564xB/C for running on 120Mhz system clock and           */
/* disable the internal watchdog.                                                           */
/* The code will then call the update blank part function                                   */ 
/* SETUP:                                                                                   */
/* Software tested on MPC564xB EVB using GHS 5.1.7 + Lauterbach                             */
/*																		                    */
/********************************************************************************************/

#include "..\header\typedefs.h"
#include "..\header\project.h"
#include "..\header\cse.h"

/*========================================================================*/
/*				 			Global variables							  */
/*========================================================================*/

uint32_t failcount = 0;

/*========================================================================*/
/*				 			Function prototypes							  */
/*========================================================================*/

void Disable_Watchdog(void);
void Mode_Init(void);
void PLL_120MHz(void);

/*========================================================================*/
/*				 			Main program     							  */
/*========================================================================*/

int main(void)
{

  // basic device setup
  Disable_Watchdog();
  Mode_Init();
  PLL_120MHz();
    
//  CSE.CMD.R= CSE_INIT_CSE;     	

  while (CSE.SR.B.BSY ==1){} // wait until CSE is idle

  failcount = update_blank_part();

  while(1);
  
}

/*========================================================================*/
/*				 			Functions        							  */
/*========================================================================*/

void PLL_120MHz(void)
{
  // select FXOSC as PLL input clock
  CGM.AC0_SC.B.SELCTL = 0x1;
  
  // these next 3 lines can be optimised in to a single write 
  ME.RUN[0].B.FXOSC0ON = 1;       // Enable external osc  
  ME.RUN[0].B.FMPLLON  = 1;       // Enable PLL 
  ME.RUN[0].B.SYSCLK   = 0x4;     // System clock is PLL
  
   // Configure PLL for 120MHz with 40MHz xtal                              
   //  PLL frequency = (40 * NDIV) / (IDF * ODF)                            
   //  VCO (PLL * ODF) must be between 256 and 512MHz          
   //                                                          
   // For 120Mhz Output:                                                    
   // these next 3 lines can be optimised in to a single write 
   CGM.FMPLL_CR.B.IDF  = 0x3;  // Input Divider  = 4  -> 10 MHz  
   CGM.FMPLL_CR.B.NDIV = 48;   // Loop Divider   = 48 -> 480 MHz 
   CGM.FMPLL_CR.B.ODF  = 0x1;  // Output Divider = 4  -> 120 MHz  
 
   ME.MCTL.R = 0x40005AF0;         // Mode & Key 
   ME.MCTL.R = 0x4000A50F;         // Mode & Key inverted 
   while(ME.GS.B.S_MTRANS==1) {};  // Wait for mode entry to complete 
  
  // add a RAM wait state for above 64MHz+4% frequency
    ECSM.MUDCR.R |= 0x40000000; 
}

void Mode_Init(void)
{
   // Enbable all peripheral clocks 120MHz configuration according Table 3-2  
   // in the reference manual 
   CGM.SC_DC[0].B.DIV = 0x83;
   CGM.SC_DC[1].B.DIV = 0x81;
   CGM.SC_DC[2].B.DIV = 0x81;

   // Setting RUN Configuration Register ME_RUN_PC[0] 
   ME.RUNPC[0].R=0x000000FE; // Peripheral ON in every mode 
   
   // Re-enter in DRUN mode to update 
   ME.MCTL.R = 0x30005AF0;     	  // Mode & Key 
   ME.MCTL.R = 0x3000A50F;     	  // Mode & Key   

}        

void Disable_Watchdog(void)
{
  SWT.SR.R = 0x0000c520; // key 
  SWT.SR.R = 0x0000d928; // key 
  SWT.CR.R = 0xC000010A; // disable WEN 
}   
