/********************************************************************************************/
/* FILE NAME: main_z4_ram_reprogram_programmed_part.c                                               */
/*                                                           COPYRIGHT (c) Freescale 2010   */
/*                                                                  All Rights Reserved     */
/* DESCRIPTION:                                                                             */
/* Main program will set up the MPC564xB/C for running on 120Mhz system clock and           */
/* disable the internal watchdog.                                                           */
/* The code will then erase the Code and Data Flash and the CSE keys, reprogram the keys    */ 
/* and then ask for a new *.elf file to be programmed. After erasing the part twice         */
/* the new BOOT_MAC is calculated and stored into the secure Flash                          */
/* SETUP:                                                                                   */
/* Software tested on MPC564xB EVB using GHS 5.1.7 + Lauterbach                             */
/*																		                    */
/********************************************************************************************/

#include "..\header\typedefs.h"
#include "..\header\project.h"
#include "..\header\cse.h"

/*========================================================================*/
/*				 			Global variables							  */
/*========================================================================*/

uint32_t failcount = 0;
int32_t result;

uint32_t data_for_encryption[64] =
{
0xB61C75C0,	0x9FEC0524,	0x66414070,	0x6C4E1BD1,
0xAEB7E985,	0xE9AB7CD3,	0xCD779188,	0xB2382049,
0x927CA102,	0x761F195D,	0x404B8C41,	0x86354D38,
0xAF5C1FC5,	0x78983111,	0xA21AC9E3,	0xB2DA46B6,
0x9FD49878,	0x5977A146,	0x3DCC25C2,	0x19337A67,
0x83B3FBBC,	0x2604FE82,	0x7AEEF3AA,	0x2D09E95E,
0xD120C731,	0x5F1102ED,	0x3DE352F9,	0x0E50AEDB,
0x662C5519,	0x0F7368E0,	0xDCA54BBA,	0x0EF728DF,
0xB5954C51,	0x42484B23,	0xA7E1BD36,	0x0CAF25B8,
0x69AD6B86,	0x6F306102,	0xDA7123E7,	0xC52856FC,
0x531770A0,	0x56E27593,	0x6878193B,	0xAB647307,
0xF08356CC,	0x22A8A84C,	0x60D6B28A,	0xCE8B8255,
0x4334C05F,	0x74F0815F,	0xF7DE7AFD,	0x30855913,
0x27A16CD5,	0x99078BA3,	0x3734D50A,	0x96FB5ADD,
0x97870258,	0x0BA0C5F3,	0xF9D69DC0,	0x0B7C2B31,
0x76DA8C55,	0xC23253E3,	0x4B0FE2D8,	0x8E3994B7
};
uint32_t encrypted_data[64]; 

/*========================================================================*/
/*				 			Function prototypes							  */
/*========================================================================*/

void Disable_Watchdog(void);
void Mode_Init(void);
void PLL_120MHz(void);
void Erase_DFlash(void);
void Erase_CFlash(void);

/*========================================================================*/
/*				 			Main program     							  */
/*========================================================================*/

int main(void)
{

  // basic device setup
  Disable_Watchdog();
  Mode_Init();
  PLL_120MHz();

  //erase DFlash
  Erase_DFlash();

  //erase CFlash
  Erase_CFlash(); 
    
  // run debug challenge auth
  result =  debug_chal_auth();

  //CSE.CMD.R= CSE_INIT_CSE;     	

  while (CSE.SR.B.BSY ==1){} // wait until CSE is idle

  failcount = update_blank_part();

  asm("trap");
  
}

/*========================================================================*/
/*				 			Functions        							  */
/*========================================================================*/

void PLL_120MHz(void)
{
  // select FXOSC as PLL input clock
  CGM.AC0_SC.B.SELCTL = 0x1;
  
  // these next 3 lines can be optimised in to a single write 
  ME.RUN[0].B.FXOSC0ON = 1;       // Enable external osc  
  ME.RUN[0].B.FMPLLON  = 1;       // Enable PLL 
  ME.RUN[0].B.SYSCLK   = 0x4;     // System clock is PLL
  
   // Configure PLL for 120MHz with 40MHz xtal                              
   //  PLL frequency = (40 * NDIV) / (IDF * ODF)                            
   //  VCO (PLL * ODF) must be between 256 and 512MHz          
   //                                                          
   // For 120Mhz Output:                                                    
   // these next 3 lines can be optimised in to a single write 
   CGM.FMPLL_CR.B.IDF  = 0x3;  // Input Divider  = 4  -> 10 MHz  
   CGM.FMPLL_CR.B.NDIV = 48;   // Loop Divider   = 48 -> 480 MHz 
   CGM.FMPLL_CR.B.ODF  = 0x1;  // Output Divider = 4  -> 120 MHz  
 
   ME.MCTL.R = 0x40005AF0;         // Mode & Key 
   ME.MCTL.R = 0x4000A50F;         // Mode & Key inverted 
   while(ME.GS.B.S_MTRANS==1) {};  // Wait for mode entry to complete 
  
  // add a RAM wait state for above 64MHz+4% frequency
    ECSM.MUDCR.R |= 0x40000000; 
}

void Mode_Init(void)
{
   // Enbable all peripheral clocks 120MHz configuration according Table 3-2  
   // in the reference manual 
   CGM.SC_DC[0].B.DIV = 0x83;
   CGM.SC_DC[1].B.DIV = 0x81;
   CGM.SC_DC[2].B.DIV = 0x81;

   // Setting RUN Configuration Register ME_RUN_PC[0] 
   ME.RUNPC[0].R=0x000000FE; // Peripheral ON in every mode 
   
   // Re-enter in DRUN mode to update 
   ME.MCTL.R = 0x30005AF0;     	  // Mode & Key 
   ME.MCTL.R = 0x3000A50F;     	  // Mode & Key   

}        

void Erase_DFlash(void)
{
    DFLASH.LML.R = 0xA1A11111;   // Password to unlock LML 
    DFLASH.LML.R = 0x8010FFF0;	 // Unlock Block 0..3
 
    DFLASH.SLL.R = 0xC3C33333;   // Password to unlock SLL 
    DFLASH.SLL.R = 0x8010FFF0;	 // Unlock Block 0..3 
   
    DFLASH.MCR.R = 0x07570604; 		// Set ERS in MCR: Select Operation 
    DFLASH.LMS.R = 0x0000000F; 		// Set LSL3-0 in LMS: Select Sectors to erase 
    *((unsigned long *) 0x00800000) = 0xFFFFFFFF; // Latch a Flash Address with any data 

    DFLASH.MCR.R = 0x07570605; 		// Set EHV in MCR: Operation Start 
    
    while (!DFLASH.MCR.B.DONE);  	// wait for DONE = 1
    while (!DFLASH.MCR.B.PEG);   	// Check PEG flag 

    DFLASH.MCR.R = 0x07570604; 	 	// Reset EHV in MCR: Operation End 
    DFLASH.MCR.R = 0x07570600; 		// Reset ERS in MCR: Deselect Operation 
}

void Erase_CFlash(void)
{
    CFLASH_0.LML.R = 0xA1A11111;     // Password to unlock LML 
    CFLASH_0.LML.R = 0x8010FFC0;	 // Unlock Block Low 0..6 + Mid 0..1 

    CFLASH_0.HBL.R = 0xB2B22222;     // Password to unlock HBL 
    CFLASH_0.HBL.R = 0x80100F00;	 // Unlock Block 0..7 
 
    CFLASH_0.SLL.R = 0xC3C33333;     // Password to unlock SLL  
    CFLASH_0.SLL.R = 0x8010FFC0;	 // Unlock Block Low 0..6 + Mid 0..1 
   
    CFLASH_0.MCR.R = 0x04200604; 		// Set ERS in MCR: Select Operation 
    CFLASH_0.LMS.R = 0x0003003F; 		// Set Low 0..6 Mid 0..1 in LMS: Select Sectors to erase 
    CFLASH_0.HBS.R = 0x000000FF; 		// Set 7-0 in HMS: Select Sectors to erase 
    *((unsigned long *) 0x00000000) = 0xFFFFFFFF; // Latch a Flash Address with any data 

    CFLASH_0.MCR.R = 0x04200605; 		// Set EHV in MCR: Operation Start 
    
    while (!CFLASH_0.MCR.B.DONE);  	// wait for DONE = 1
    while (!CFLASH_0.MCR.B.PEG);   	// Check PEG flag 

    CFLASH_0.MCR.R = 0x042000604; 	 	// Reset EHV in MCR: Operation End 
    CFLASH_0.MCR.R = 0x042000600; 		// Reset ERS in MCR: Deselect Operation 
	
    // start to erase second Flash block
	
	CFLASH_1.LML.R = 0xA1A11111;     // Password to unlock LML 
    CFLASH_1.LML.R = 0x8010FFC0;	 // Unlock Block Low 0..6 + Mid 0..1 

    CFLASH_1.HBL.R = 0xB2B22222;     // Password to unlock HBL
    CFLASH_1.HBL.R = 0x80100F00;	 // Unlock Block 0..7 
 
    CFLASH_1.SLL.R = 0xC3C33333;     // Password to unlock SLL  
    CFLASH_1.SLL.R = 0x8010FFC0;	 // Unlock Block Low 0..6 + Mid 0..1 
   
    CFLASH_1.MCR.R = 0x04200604; 		// Set ERS in MCR: Select Operation 
    CFLASH_1.LMS.R = 0x0003003F; 		// Set Low 0..6 Mid 0..1 in LMS: Select Sectors to erase 
    CFLASH_1.HBS.R = 0x000000FF; 		// Set 7-0 in HMS: Select Sectors to erase 
    *((unsigned long *) 0x00180000) = 0xFFFFFFFF; // Latch a Flash Address with any data

    CFLASH_1.MCR.R = 0x04200605; 		// Set EHV in MCR: Operation Start 
    
    while (!CFLASH_1.MCR.B.DONE);  	// wait for DONE = 1
    while (!CFLASH_1.MCR.B.PEG);   	// Check PEG flag 

    CFLASH_1.MCR.R = 0x042000604; 	 	// Reset EHV in MCR: Operation End 
    CFLASH_1.MCR.R = 0x042000600; 		// Reset ERS in MCR: Deselect Operation 
}

void Disable_Watchdog(void)
{
  SWT.SR.R = 0x0000c520; // key 
  SWT.SR.R = 0x0000d928; // key 
  SWT.CR.R = 0xC000010A; // disable WEN 
}   