/********************************************************************************************/
/* FILE NAME: Pin_Blink.c                                                                   */
/*                                                           COPYRIGHT (c) Freescale 2010   */
/*                                                                  All Rights Reserved     */
/* DESCRIPTION:                                                                             */
/* Main program will set up the MPC564xB/C for running on 120Mhz system clock and           */
/* disable the internal watchdog.                                                           */
/* The code will then toggle and LED on the EVB                                             */ 
/* SETUP:                                                                                   */
/* Software tested on MPC564xB EVB using GHS 5.1.7 + Lauterbach                             */
/*																		                    */
/********************************************************************************************/

#include "..\header\typedefs.h"
#include "..\header\project.h"

/*========================================================================*/
/*				 			Global variables							  */
/*========================================================================*/

const int PIN_NUMBER = 68;  //PE4 
		            
           
long count;

/*========================================================================*/
/*				 			Function prototypes							  */
/*========================================================================*/

void MODE_INIT();
void DISABLE_WATCHDOG();
void PLL_120MHZ();
void ENABLE_PLL_OUT_DIV4();

/*========================================================================*/
/*				 			Main program     							  */
/*========================================================================*/

int main(int argc, char *argv[])
{
	
 	DISABLE_WATCHDOG();

	MODE_INIT();   /* enable all peripherals in all modes and all peripheral clocks */
 
    PLL_120MHZ();

    //enable the CLKOUT pin
	//ENABLE_PLL_OUT_DIV4();
 
     /* Configure GPIO[PIN_NUMBER] for OUTPUT */
    SIU.PCR[PIN_NUMBER].R = 0x0200; /* PA = 00, OBE = 1, */   
    /* SIU_GPDO[PIN_NUMBER] set PDO (PIN DATA OUT to 1) */
    SIU.GPDO[PIN_NUMBER].R = 0x1;
    

    while (1) {
      /* Wait loop */ 
      for (count = 1; count <= 100000; count++)
      {
      	asm("nop");
    	//printf ("Count  = %d \n", count);
      }
      /* SIU_GPDO[PNI_NUMBER} set PDO (PIN DATA OUT to 0) */
      if (SIU.GPDO[PIN_NUMBER].R == 0x1) {
      	SIU.GPDO[PIN_NUMBER].R = 0x0;
      }
      else {
	SIU.GPDO[PIN_NUMBER].R = 0x1;
      }

    }
}

void MODE_INIT(void)
{
   /* Enbable all peripheral clocks 120MHz configuration according Table 3-2 */
  // CGM.SC_DC[0].B.DIV = 0x83;
  // CGM.SC_DC[1].B.DIV = 0x81;
  // CGM.SC_DC[2].B.DIV = 0x81;

    /* Enbable all peripheral clocks 64MHz configuration according Table 3-2 */
   // CGM.SC_DC[0].B.DIV = 0x81;
   // CGM.SC_DC[1].B.DIV = 0x80;
   // CGM.SC_DC[2].B.DIV = 0x80;

    /* Enbable all peripheral clocks 80MHz configuration according Table 3-2 */
   CGM.SC_DC[0].B.DIV = 0x83;
   CGM.SC_DC[1].B.DIV = 0x81;
   CGM.SC_DC[2].B.DIV = 0x81;
  
   /* Setting RUN Configuration Register ME_RUN_PC[0] */
   ME.RUNPC[0].R=0x000000FE; /* Peripheral ON in every mode */
   
   /* Re-enter in DRUN mode to update */
   ME.MCTL.R = 0x30005AF0;     	  /* Mode & Key */
   ME.MCTL.R = 0x3000A50F;     	  /* Mode & Key */  

}        

void DISABLE_WATCHDOG()
{
  SWT.SR.R = 0x0000c520; /* key */
  SWT.SR.R = 0x0000d928; /* key */
  SWT.CR.R = 0xC000010A; /* disable WEN */
}                                                       

void PLL_120MHZ()
{
  // select FXOSC as PLL input clock
  CGM.AC0_SC.B.SELCTL = 0x1;
  
  /* these next 3 lines can be optimised in to a single write */
  ME.RUN[0].B.FXOSC0ON = 1;       /* Enable external osc */ 
  ME.RUN[0].B.FMPLLON  = 1;       /* Enable PLL */
  ME.RUN[0].B.SYSCLK   = 0x4;     /* System clock is PLL */
  
   /* Configure PLL for 120MHz with 40MHz xtal                              */
   /*  PLL frequency = (40 * NDIV) / (IDF * ODF)                            */
   /*  VCO (PLL * ODF) must be between 256 and 512MHz                       */
   /*                                                                       */
   /* For 120Mhz Output:                                                    */
   /* these next 3 lines can be optimised in to a single write */
   // CGM.FMPLL_CR.B.IDF  = 0x3;  /* Input Divider  = 4  -> 10 MHz   */
   // CGM.FMPLL_CR.B.NDIV = 48;   /* Loop Divider   = 48 -> 480 MHz */
   // CGM.FMPLL_CR.B.ODF  = 0x1;  /* Output Divider = 4  -> 120 MHz  */
 
   /* For 64Mhz Output:                                                    */
   /* these next 3 lines can be optimised in to a single write */
   // CGM.FMPLL_CR.B.IDF  = 0x4;  /* Input Divider  = 5  -> 8 MHz   */
   // CGM.FMPLL_CR.B.NDIV = 32;   /* Loop Divider   = 32 -> 256 MHz */
   // CGM.FMPLL_CR.B.ODF  = 0x1;  /* Output Divider = 4  -> 64 MHz  */

   /* For 80Mhz Output:                                                    */
   /* these next 3 lines can be optimised in to a single write */
   CGM.FMPLL_CR.B.IDF  = 0x3;  /* Input Divider  = 4  -> 10 MHz   */
   CGM.FMPLL_CR.B.NDIV = 32;   /* Loop Divider   = 32 -> 320 MHz */
   CGM.FMPLL_CR.B.ODF  = 0x1;  /* Output Divider = 4  -> 80 MHz  */
 
   ME.MCTL.R = 0x40005AF0;         /* Mode & Key */
   ME.MCTL.R = 0x4000A50F;         /* Mode & Key inverted */
   while(ME.GS.B.S_MTRANS==1) {};  /* Wait for mode entry to complete */
  
  // add a RAM wait state for above 64MHz+4% frequency
    ECSM.MUDCR.R |= 0x40000000; 
}

void ENABLE_PLL_OUT_DIV4()
{
  /* Configure CLKOUT on PA0 */
  /* next 4 lines aren't required except to ensure correct Fsys is being generated */  
  SIU.PCR[0].R        = 0x0A04;        /* PA0 clkout               */
  CGM.OC_EN.R          = 1;            /* Enable Output Clock      */
  CGM.OCDS_SC.B.SELDIV = 2;            /* Divide Output Clock by 4 */
  CGM.OCDS_SC.B.SELCTL = 2;            /* PLL is Output Clock      */
}