/**************************************************************************/
/* FILE NAME: cse.h                          COPYRIGHT (c) Freescale 2010 */
/* VERSION:  1.0                                  All Rights Reserved     */
/*                                                                        */
/* DESCRIPTION:                                                           */
/* This file defines values used by the CSE module.                       */
/*========================================================================*/

#ifndef _CSE_H_
#define _CSE_H_

/* Commands*/
#define CSE_ENC_ECB        0x01
#define CSE_ENC_CBC        0x02
#define CSE_DEC_ECB        0x03
#define CSE_DEC_CBC        0x04
#define CSE_GENERATE_MAC   0x05
#define CSE_VERIFY_MAC     0x06
#define CSE_LOAD_KEY       0x07
#define CSE_LOAD_PLAIN_KEY 0x08
#define CSE_EXPORT_RAM_KEY 0x09
#define CSE_INIT_RNG       0x0A
#define CSE_EXTEND_SEED    0x0B
#define CSE_RND            0x0C
#define CSE_SECURE_BOOT    0x0D
#define CSE_BOOT_FAILURE   0x0E
#define CSE_BOOT_OK        0x0F
#define CSE_GET_ID         0x10
#define CSE_CANCEL         0x11
#define CSE_DEBUG_CHAL     0x12
#define CSE_DEBUG_AUTH     0x13
#define CSE_TRNG_RND       0x14
#define CSE_INIT_CSE       0x15

/* Error Codes */
#define CSE_NO_ERR                0x00 
#define CSE_CMD_SEQ_ERR           0x02 
#define CSE_KEY_NOT_AVAIL         0x03 
#define CSE_INV_KEY               0x04 
#define CSE_EMPTY_KEY             0x05 
#define CSE_NO_SECURE_BOOT        0x06 
#define CSE_KEY_WRITE_PROTE       0x07 
#define CSE_KEY_UPDATE_ERR        0x08 
#define CSE_RND_NUM_SEED_NOT_INIT 0x09 
#define CSE_INT_DEBUG_NOT_ALLOWED 0x0A 
#define CSE_CMD_ISSUED_WHILE_BUSY 0x0B 
#define CSE_SYSTEM_MEMORY_ERR     0x0C 
#define CSE_INT_MEMORY_ERR        0x10 
#define CSE_INVALID_CMD           0x11 
#define CSE_TRNG_ERR              0x12 
#define CSE_ERR_READ_CSE_FL_BLOCK 0x13 
#define CSE_INT_CMD_PROC_ERR      0x14 
#define CSE_LENGTH_ERR            0x15

/* KEY IDs*/ 
#define CSE_SECRET_KEY     0x0         
#define CSE_MASTER_ECU_KEY 0x1   
#define CSE_BOOT_MAC_KEY   0x2     
#define CSE_BOOT_MAC       0x3         
#define CSE_KEY_1          0x4
#define CSE_KEY_2          0x5
#define CSE_KEY_3          0x6
#define CSE_KEY_4          0x7
#define CSE_KEY_5          0x8
#define CSE_KEY_6          0x9
#define CSE_KEY_7          0xA
#define CSE_KEY_8          0xB
#define CSE_KEY_9          0xC
#define CSE_KEY_10         0xD
#define CSE_RAM_KEY        0xE

#endif
      