#include "rtc_driver_int.h"

/******************************************************************************/
/* FUNCTION          : irtc_setYearOffset                                     */
/******************************************************************************/
/* Abstract          : This function sets the year offset in IRTC registers   */
/*                                                                            */
/* Input Parameters  : offset: offset from year 2112                          */
/*                                                                            */
/* Return Parameter  : 0 - success, 1 - failure                               */
/******************************************************************************/
unsigned char irtc_setYearOffset(unsigned char offset)
{
  //while(!IRTC_STATUS_INVAL);
	IRTC_YEARMON_H = offset;
  
  if(offset == IRTC_YEARMON_H)
  {
    return 0;
  }
  return 1;
}

/******************************************************************************/
/* FUNCTION          : irtc_setAlarmYearOffset                                */
/******************************************************************************/
/* Abstract          : This function sets alarm year offset in IRTC registers */
/*                                                                            */
/* Input Parameters  : offset: offset from year 2112                          */
/*                                                                            */
/* Return Parameter  : 0 - success, 1 - failure                               */
/******************************************************************************/
unsigned char irtc_setAlarmYearOffset(unsigned char offset)
{
	IRTC_ALM_YRMON_H = offset;

  if(offset == IRTC_ALM_YRMON_H)
  {
    return 0;
  }
  return 1;
}

/******************************************************************************/
/* FUNCTION          : irtc_setMonth                                          */
/******************************************************************************/
/* Abstract          : This function sets the month in IRTC registers         */
/*                                                                            */
/* Input Parameters  : month: a number from 1 to 12                           */
/*                                                                            */
/* Return Parameter  : 0 - success, 1 - failure                               */
/******************************************************************************/
unsigned char irtc_setMonth(unsigned char month)
{
  //while(!IRTC_STATUS_INVAL);
	IRTC_YEARMON_L_MONTH = month;
  
  if(month == IRTC_YEARMON_L_MONTH)
  {
    return 0;
  }
  return 1;
}

/******************************************************************************/
/* FUNCTION          : irtc_setAlarmMonth                                     */
/******************************************************************************/
/* Abstract          : This function sets alarm month in IRTC registers       */
/*                                                                            */
/* Input Parameters  : month: a number from 1 to 12                           */
/*                                                                            */
/* Return Parameter  : 0 - success, 1 - failure                               */
/******************************************************************************/
unsigned char irtc_setAlarmMonth(unsigned char month)
{
	IRTC_ALM_YRMON_L_ALM_MONTH = month;
  
  if(month == IRTC_ALM_YRMON_L_ALM_MONTH)
  {
    return 0;
  }
  return 1;
}

/******************************************************************************/
/* FUNCTION          : irtc_setDayAndDate                                     */
/******************************************************************************/
/* Abstract          : This function sets the day and date in IRTC registers  */
/*                                                                            */
/* Input Parameters  : weekday: week day to be set                            */
/*                     date: date to be set                                   */
/*                                                                            */
/* Return Parameter  : 0 - success, 1 - failure                               */
/******************************************************************************/
unsigned char irtc_setDayAndDate(unsigned char weekday, unsigned char date)
{
  //while(!IRTC_STATUS_INVAL);
	IRTC_DAYS_H_DAY_OF_WEEK = weekday;
	IRTC_DAYS_L_DAYS = date;
  
  if( (weekday == IRTC_DAYS_H_DAY_OF_WEEK) && (date == IRTC_DAYS_L_DAYS) )
  {
    return 0;
  }
  return 1;
}

/******************************************************************************/
/* FUNCTION          : irtc_setAlarmDate                                      */
/******************************************************************************/
/* Abstract          : This function sets the alarm day in RTC registers      */
/*                                                                            */
/* Input Parameters  : date: date to be set                                   */
/*                                                                            */
/* Return Parameter  : 0 - success, 1 - failure                               */
/******************************************************************************/
unsigned char irtc_setAlarmDate(unsigned char date)
{
  IRTC_ALM_DAYS_L_ALM_DAYS = date;
  
  if(date == IRTC_ALM_DAYS_L_ALM_DAYS)
  {
    return 0;
  }
  return 1;
}

/******************************************************************************/
/* FUNCTION          : irtc_setHour                                           */
/******************************************************************************/
/* Abstract          : This function sets the hours in IRTC registers         */
/*                                                                            */
/* Input Parameters  : hour: a number from 0 to 23                            */
/*                                                                            */
/* Return Parameter  : 0 - success, 1 - failure                               */
/******************************************************************************/
unsigned char irtc_setHour(unsigned char hour)
{
  //while(!IRTC_STATUS_INVAL);
	IRTC_HOURMIN_H_HOURS = hour;
  
  if(hour == IRTC_HOURMIN_H_HOURS)
  {
    return 0;
  }
  return 1;
}

/******************************************************************************/
/* FUNCTION          : irtc_setAlarmHour                                      */
/******************************************************************************/
/* Abstract          : This function sets alarm hour in IRTC registers        */
/*                                                                            */
/* Input Parameters  : hour: a number from 0 to 23                            */
/*                                                                            */
/* Return Parameter  : 0 - success, 1 - failure                               */
/******************************************************************************/
unsigned char irtc_setAlarmHour(unsigned char hour)
{
	IRTC_ALM_HM_H_ALM_HOURS = hour;
  
  if(hour == IRTC_ALM_HM_H_ALM_HOURS)
  {
    return 0;
  }
  return 1;
}

/******************************************************************************/
/* FUNCTION          : irtc_setMin                                            */
/******************************************************************************/
/* Abstract          : This function sets the minutes in IRTC registers       */
/*                                                                            */
/* Input Parameters  : min: a number from 0 to 59                             */
/*                                                                            */
/* Return Parameter  : 0 - success, 1 - failure                               */
/******************************************************************************/
unsigned char irtc_setMin(unsigned char min)
{
  //while(!IRTC_STATUS_INVAL);
	IRTC_HOURMIN_L_MINUTES = min;

  if(min == IRTC_HOURMIN_L_MINUTES)
  {
    return 0;
  }
  return 1;
}

/******************************************************************************/
/* FUNCTION          : irtc_setAlarmMin                                       */
/******************************************************************************/
/* Abstract          : This function sets alarm minutes in IRTC registers     */
/*                                                                            */
/* Input Parameters  : min: a number from 0 to 59                             */
/*                                                                            */
/* Return Parameter  : 0 - success, 1 - failure                               */
/******************************************************************************/
unsigned char irtc_setAlarmMin(unsigned char min)
{
	IRTC_ALM_HM_L_ALM_MINUTES = min;

  if(min == IRTC_ALM_HM_L_ALM_MINUTES)
  {
    return 0;
  }
  return 1;
}

/******************************************************************************/
/* FUNCTION          : irtc_setSeconds                                        */
/******************************************************************************/
/* Abstract          : This function sets the saeconds in IRTC registers      */
/*                                                                            */
/* Input Parameters  : sec: a number from 0 to 59                             */
/*                                                                            */
/* Return Parameter  : 0 - success, 1 - failure                               */
/******************************************************************************/
unsigned char irtc_setSeconds(unsigned char sec)
{
  //while(!IRTC_STATUS_INVAL);
	IRTC_SECONDS_L_SECONDS = sec;

  if(sec == IRTC_SECONDS_L_SECONDS)
  {
    return 0;
  }
  return 1;
}

/******************************************************************************/
/* FUNCTION          : irtc_setAlarmSeconds                                   */
/******************************************************************************/
/* Abstract          : This function sets alarm seconds in IRTC registers     */
/*                                                                            */
/* Input Parameters  : sec: a number from 0 to 59                             */
/*                                                                            */
/* Return Parameter  : 0 - success, 1 - failure                               */
/******************************************************************************/
unsigned char irtc_setAlarmSeconds(unsigned char sec)
{
	IRTC_ALM_SEC_L_ALM_SECONDS = sec;

  if(sec == IRTC_ALM_SEC_L_ALM_SECONDS)
  {
    return 0;
  }
  return 1;
}

/******************************************************************************/
/* FUNCTION          : irtc_unprotectRegisters                                */
/******************************************************************************/
/* Abstract          : This function unprotects the IRTC registers for 2 sec  */
/*                                                                            */
/* Input Parameters  : none                                                   */
/*                                                                            */
/* Return Parameter  : none                                                   */
/******************************************************************************/
void irtc_unprotectRegisters(void)
{
  do
  {
    if(IRTC_STATUS_L_WPE)
    {
    	IRTC_CTRL_L_WE = 0b00;
    	IRTC_CTRL_L_WE = 0b01;
    	IRTC_CTRL_L_WE = 0b11;
    	IRTC_CTRL_L_WE = 0b10;
    }
  }while(IRTC_STATUS_L_WPE);
}

/******************************************************************************/
/* FUNCTION          : irtc_protectRegisters                                  */
/******************************************************************************/
/* Abstract          : This function protects the IRTC registers              */
/*                                                                            */
/* Input Parameters  : none                                                   */
/*                                                                            */
/* Return Parameter  : none                                                   */
/******************************************************************************/
void irtc_protectRegisters(void)
{
  do
  {
    if(!IRTC_STATUS_L_WPE)
    {
    	IRTC_CTRL_L_WE = 0b10;
    }
  }while(!IRTC_STATUS_L_WPE);
}
