 #include "mtim8_timer.h"
void (*mtim1_callback)(unsigned char);  //This is a pointer to the function which 
                                        //the user needs to pass in MTIM1_Init
                                        //so that the required function is 
                                        //called in interrupt subroutine

void (*mtim2_callback)(unsigned char);  //This is a pointer to the function which 
                                        //the user needs to pass in MTIM3_Init
                                        //so that the required function is 
                                        //called in interrupt subroutine
                                        

unsigned int MTIM1_TimeOut = 0;   //stores the value of timeout for MTIM1
unsigned int MTIM1_Count = 0;     //stores the count value for MTIM1
unsigned int MTIM2_TimeOut = 0;   //stores the value of timeout for MTIM2
unsigned int MTIM2_Count = 0;     //stores the count value for MTIM2


/******************************************************************************/
/* FUNCTION          : MTIM1_Init                                             */
/******************************************************************************/
/* Abstract          : This function initializes MTIM1 by configuring the     */
/*                     internal reg                                           */
/*					                                                                  */
/*                                                                            */
/* Input Parameters  :                                                        */                                                                                    
/*                                                                            */
/* Return Parameter  :                                                        */
/*                                                                            */
/* Traceability Info :                                                        */
/******************************************************************************/

void MTIM1_Init(void (*p1)(unsigned char))
{
  mtim1_callback = p1;
  PTAPF3_A4 = 1;                //pin muxing for MTIMCLK
  SCGC4_MTIM1  = 1;             //enables the 8 bit MTIM1 module
  MTIM1CLK_CLKS =0b01;           //selects fixed frequency clock as MTIM clk (32.768KHz/2)=16KHz
  MTIM1CLK_PS = 0b0100;         //the MTIM clk is divided by 16

  MTIM1SC_TOIE = 0;             //interrupt disabled
}

/******************************************************************************/
/* FUNCTION          : MTIM2_Init                                             */
/******************************************************************************/
/* Abstract          : This function initializes MTIM2 by configuring the     */
/*                     internal reg                                           */
/*					                                                                  */
/*                                                                            */
/* Input Parameters  :                                                        */                                                                                    
/*                                                                            */
/* Return Parameter  :                                                        */
/*                                                                            */
/* Traceability Info :                                                        */
/******************************************************************************/

void MTIM2_Init(void (*p2)(unsigned char))
{
  mtim2_callback = p2;
  PTAPF3_A4 = 1;                //pin muxing for MTIMCLK
  SCGC4_MTIM2  = 1;             //enables the 8 bit MTIM2 module
  MTIM2CLK_CLKS =0b01;           //selects fixed frequency clock as MTIM clk (32.768KHz/2)=16KHz
  MTIM2CLK_PS = 0b0100;         //the MTIM clk is divided by 16

  MTIM2SC_TOIE = 0;             //interrupt disabled
}

/* Enables the MTIM to start counting*/

/******************************************************************************/
/* FUNCTION          : Enable_MTIM1                                           */
/******************************************************************************/
/* Abstract          : This function enables MTIM1 & configure it to give an  */
/*                     interrupt after every 1 sec                            */
/*					                                                                  */
/*                                                                            */
/* Input Parameters  :                                                        */                                                                                    
/*                                                                            */
/* Return Parameter  :                                                        */
/*                                                                            */
/* Traceability Info :                                                        */
/******************************************************************************/

void Enable_MTIM1()
{
  MTIM1_Count = 0;
  if(MTIM1SC_TOF)
  {
    MTIM1SC_TOF = 0;              //clear the MTIM overflow flag if already set
  }
  MTIM1SC_TOIE = 1;              //interrupt enabled
  MTIM1SC_TSTP = 0;              //makes the counter active
                
}

/******************************************************************************/
/* FUNCTION          : Enable_MTIM2                                           */
/******************************************************************************/
/* Abstract          : This function enables MTIM2 & configure it to give an  */
/*                     interrupt after every 1 sec                            */
/*					                                                                  */
/*                                                                            */
/* Input Parameters  :                                                        */                                                                                    
/*                                                                            */
/* Return Parameter  :                                                        */
/*                                                                            */
/* Traceability Info :                                                        */
/******************************************************************************/

void Enable_MTIM2()
{
  MTIM2_Count = 0;
  if(MTIM2SC_TOF)
  {
    MTIM2SC_TOF = 0;              //clear the MTIM overflow flag if already set
  }
  MTIM2SC_TOIE = 1;              //interrupt enabled
  MTIM2SC_TSTP = 0;              //makes the counter active                
}


/******************************************************************************/
/* FUNCTION          : Disable_MTIM1                                           */
/******************************************************************************/
/* Abstract          : This function disables MTIM1 by disabling the interrupt */
/*                                                                             */
/*					                                                                  */
/*                                                                            */
/* Input Parameters  :                                                        */                                                                                    
/*                                                                            */
/* Return Parameter  :                                                        */
/*                                                                            */
/* Traceability Info :                                                        */
/******************************************************************************/

void Disable_MTIM1()
{       
  MTIM1SC_TOIE = 0;              //interrupt disabled
  MTIM1CNT = 0;
  MTIM1SC_TSTP = 1;              //stops the timer
}

/******************************************************************************/
/* FUNCTION          : Disable_MTIM2                                           */
/******************************************************************************/
/* Abstract          : This function disables MTIM2 by disabling the interrupt */
/*                                                                             */
/*					                                                                  */
/*                                                                            */
/* Input Parameters  :                                                        */                                                                                    
/*                                                                            */
/* Return Parameter  :                                                        */
/*                                                                            */
/* Traceability Info :                                                        */
/******************************************************************************/
void Disable_MTIM2()
{       
  MTIM2SC_TOIE = 0;              //interrupt disabled
  MTIM1CNT =0;
  MTIM2SC_TSTP = 1;              //stops the timer
}


/******************************************************************************/
/* FUNCTION          : Set_TimeOut_MTIM1                                      */
/******************************************************************************/
/* Abstract          : This function sets the time to provide the required delay */
/*                                                                             */
/*					                                                                  */
/*                                                                            */
/* Input Parameters  : num(in seconds) - the delay required                   */                                                                                    
/*                                                                            */
/* Return Parameter  :                                                        */
/*                                                                            */
/* Traceability Info :                                                        */
/******************************************************************************/

void Set_TimeOut_MTIM1(unsigned int num)  //num in milli seconds
{
  unsigned int remainder;
  Disable_MTIM1();          //disables the MTIM1
  remainder = (num%10);
  if(num<=255) 
    {   
      MTIM1MOD = num;
      MTIM1_TimeOut = 1;
    }
  else 
    {
      if(remainder) 
      {
        if(remainder >= 5) 
          {
            num=(num + (10 - (remainder)));   //rounding off the  num greater than 255 to the nearest 10s multiple 
          } 
        else
          {
            num= (num - (remainder));          //rounding off the  num greater than 255 to the nearest 10s multiple
          }
      }
      MTIM1_TimeOut = (num/10);
      MTIM1MOD = 0x0A;
    }
  Enable_MTIM1();           //enables the MTIM1 timer
}
/******************************************************************************/
/* FUNCTION          : Set_TimeOut_MTIM2                                      */
/******************************************************************************/
/* Abstract          : This function sets the time to provide the required delay */
/*                                                                             */
/*					                                                                  */
/*                                                                            */
/* Input Parameters  : num(in seconds) - the delay required                   */                                                                                    
/*                                                                            */
/* Return Parameter  :                                                        */
/*                                                                            */
/* Traceability Info :                                                        */
/******************************************************************************/

void Set_TimeOut_MTIM2(unsigned int num)  //num in milli seconds
{
  unsigned int remainder;
  Disable_MTIM2();          //disables the MTIM1
  remainder = (num%10);
  
  if(num<=255) 
    {   
      MTIM2MOD = num;
      MTIM2_TimeOut = 1;
    }
  else 
    {
      if(remainder) 
      {
        if(remainder >= 5) 
          {
            num=(num + (10 - (remainder)));   //rounding off the  num greater than 255 to the nearest 10s multiple 
          } 
        else
          {
            num= (num - (remainder));          //rounding off the  num greater than 255 to the nearest 10s multiple
          }
      }
      MTIM2_TimeOut = (num/10);
      MTIM2MOD = 0x0A;
    }
  Enable_MTIM2();           //enables the MTIM1 timer
}
/*interrupt subroutine*/
void interrupt VectorNumber_Vmtim1 MTIM1_ISR()        
{
  MTIM1SC_TOF = 0;                //clear the flag
  MTIM1_Count++;
  if(MTIM1_TimeOut == MTIM1_Count)
  {
    if(mtim1_callback != 0)
      (*mtim1_callback)(MTIM_1);// function pointed by sci_callback
  }
}

void interrupt VectorNumber_Vmtim2 MTIM2_ISR()        
{
  MTIM2SC_TOF = 0;                //clear the flag
  MTIM2_Count++;
  if(MTIM1_TimeOut == MTIM1_Count)
  {
    if(mtim2_callback != 0)
      (*mtim2_callback)(MTIM_2);// function pointed by sci_callback
  }
  
}

