#include "mtim16_timer.h"

void (*mtim3_callback)(unsigned char);  //This is a pointer to the function which 
                                        //the user needs to pass in MTIM3_Init
                                        //so that the required function is 
                                        //called in interrupt subroutine


/******************************************************************************/
/* FUNCTION          : MTIM3_Init                                             */
/******************************************************************************/
/* Abstract          : This function initializes MTIM3 by configuring the     */
/*                     internal reg                                           */
/*					                                                                  */
/*                                                                            */
/* Input Parameters  :                                                        */                                                                                    
/*                                                                            */
/* Return Parameter  :                                                        */
/*                                                                            */
/* Traceability Info :                                                        */
/******************************************************************************/

void MTIM3_Init(void (*p3)(unsigned char))
{
  mtim3_callback = p3;
  PTAPF3_A4 = 1;                //pin muxing for MTIMCLK
  SCGC4_MTIM3  = 1;             //enables the 8 bit MTIM1 module
  MTIM3CLK_CLKS =0b01;           //selects fixed frequency clock as MTIM clk (32.768KHz/2)=16KHz
  MTIM3CLK_PS = 0b0100;         //the MTIM clk is divided by 16

  MTIM3SC_TOIE = 0;             //interrupt disabled
}

/******************************************************************************/
/* FUNCTION          : Enable_MTIM3                                           */
/******************************************************************************/
/* Abstract          : This function enables MTIM3 & configure it to give an  */
/*                     interrupt after required no of sec                     */
/*					                                                                  */
/*                                                                            */
/* Input Parameters  : num(in milliseconds) after which the interrupt is      */
/*                     expected.Upper limit is 65535 ms                       */                                                                                   
/*                                                                            */
/* Return Parameter  :                                                        */
/*                                                                            */
/* Traceability Info :                                                        */
/******************************************************************************/

void Enable_MTIM3(unsigned int num)    //num in milliseconds upper limit is 65535 milli seconds 
{
 
  if(MTIM3SC_TOF)
  {
    MTIM3SC_TOF = 0;              //clear the flag if already set
  }
  MTIM3SC_TOIE = 1;              //interrupt enabled
  MTIM3MOD += (num);
  MTIM3SC_TSTP = 0;              //makes the counter active
                
}

/******************************************************************************/
/* FUNCTION          : Disable_MTIM3                                           */
/******************************************************************************/
/* Abstract          : This function disables MTIM3 by disabling the interrupt */
/*                                                                             */
/*					                                                                  */
/*                                                                            */
/* Input Parameters  :                                                        */                                                                                    
/*                                                                            */
/* Return Parameter  :                                                        */
/*                                                                            */
/* Traceability Info :                                                        */
/******************************************************************************/

void Disable_MTIM3()
{       
  MTIM3SC_TOIE = 0;              //interrupt disabled
  MTIM3CNT = 0;
  MTIM1SC_TSTP = 1;              //stops the timer
  
}

/*interrupt subroutine*/
void interrupt VectorNumber_Vmtim3 MTIM3_ISR()        
{
  MTIM3SC_TOF = 0;                //clear the flag
  if(mtim3_callback != 0)
   (*mtim3_callback)(MTIM_3);// function pointed by sci_callback


}
