#ifndef _MAIN_ASM_H
#define _MAIN_ASM_H

#ifdef __cplusplus
  extern "C" { /* our assembly functions have C calling convention */
#endif

/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2004-2008 Freescale Semiconductor, Inc.
* (c) Copyright 2001-2004 Motorola, Inc.
* ALL RIGHTS RESERVED.
*
********************************************************************************
*
* $File Name: math.h$
*
* $Date:      Jul-20-2009$
*
* $Version:   0.0.3.0$
* 
* $Author:    B12615 
*
* Description:
*   File contains basic mathematical functions
*
* Functions Included from S08math.c: 
*   
* Functions Included from S08math.asm:

*   ADD FUNCTIONS
*   signed int add16(signed int x, signed int y)
*   unsigned int uadd16(unsigned int x, unsigned int y)
*   unsigned long uadd32(unsigned long x, unsigned long y)
*   unsigned long uadd32_64(unsigned long x, UINT64 y)
*   unsigned long add32_64(signed long x, UINT64 y)

*   SUB FUNCTIONS
*   unsigned int usub16(unsigned int x, unsigned int y)
*   signed int sub16(signed int x, signed int y)

*   MUL FUNCTIONS
*   unsigned int umul32_32_64(unsigned long x, signed long y, UINT64 z)
*****************************************************************************/

/* Overtyping due to unified order of input variables */

#define sub16(x,y)			sub16(y,x)
#define usub16(x,y)			usub16(y,x)

/* own type to represent 64 bit number */
typedef unsigned long UINT64[2];

/*****************************************************************************
    Intrinsic functions definition
*****************************************************************************/

/* addition of 16 bit signed numbers with saturation*/
signed int add16(signed int x, signed int y);

/*addition of 16 bit unsigned numbers with saturation*/
unsigned int uadd16(unsigned int x, unsigned int y);

/*addition of 32 bit unsigned numbers with saturation*/          
unsigned long uadd32(unsigned long, unsigned long);

/*addition (accumulation) of 32 bit unsigned number with 64 bit number (own type UINT64)*/
void uadd32_64(unsigned long x, UINT64 y);

/*addition (accumulation) of 32 bit signed number with 64 bit number (own type UINT64)*/
void add32_64(signed long x, UINT64 y);

/* substraction of 16 bit signed numbers with saturation*/
signed int sub16(signed int x, signed int y);

/* substraction of 16 bit unsigned numbers with saturation*/
unsigned int usub16(unsigned int x, unsigned int y); 

/*multiplication of 32 bit unsigned numbers -> result 64 bit (own type UINT64)*/
void umul32_32_64(unsigned long x, unsigned long y, UINT64 z);


/*interface to my assembly main function */

#ifdef __cplusplus
  }
#endif

#endif /* _MAIN_ASM_H */
