/////////////////////////////////////////////////////////////////////////////////////////
//
// LCD Library for Freescale DEMO9S08GW64
//
// S-TEK Display (model GD-3980)
// Driving Voltage: 3V
// Duty: 1/4
// Bias: 1/3
// Frequency: 64Hz
//
// --------------------------------------------------------------------------------------
//
// CodeWarrior V5.1 for HC(S)08
// Registers Files version 2.87.175
//
// --------------------------------------------------------------------------------------
//
// Copyright (c) 2006 SofTec Microsystems
// http://www.softecmicro.com/
//
/////////////////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////////////////
// Defines
/////////////////////////////////////////////////////////////////////////////////////////

#define LCD_PIN_44 0


// Put CLOCK=0 for select FEE mode (external crystal = 32.768 KHz)
// Put CLOCK=1 for select FEI (internal clock = 243 KHz)
#define CLOCK                   0

#define LCD_CHAR_SPACE          0       // ' ' (Space)
#define LCD_CHAR_QUOTMARK       1       // '"' (Quotation Mark)
#define LCD_CHAR_APOSTROPHE     2       // ''' (Apostrophe)
#define LCD_CHAR_LPAREN         3       // '(' (Left Parenthesis)
#define LCD_CHAR_RPAREN         4       // ')' (Right Parenthesis)
#define LCD_CHAR_ASTERISK       5       // '*' (Asterisk)
#define LCD_CHAR_PLUS           6       // '+' (Plus Sign)
#define LCD_CHAR_COMMA          7       // ',' (Comma)
#define LCD_CHAR_MINUS          8       // '-' (Minus Sign)
#define LCD_CHAR_PERIOD         9       // '.' (Period)
#define LCD_CHAR_SLASH          10      // '/' (Slash)
#define LCD_CHAR_0              11      // '0'
#define LCD_CHAR_1              12      // '1'
#define LCD_CHAR_2              13      // '2'
#define LCD_CHAR_3              14      // '3'
#define LCD_CHAR_4              15      // '4'
#define LCD_CHAR_5              16      // '5'
#define LCD_CHAR_6              17      // '6'
#define LCD_CHAR_7              18      // '7'
#define LCD_CHAR_8              19      // '8'
#define LCD_CHAR_9              20      // '9'
#define LCD_CHAR_SEMICOLON      21      // ':' (Semicolon)
#define LCD_CHAR_EQUAL          22      // '=' (Equal Sign)
#define LCD_CHAR_A              23      // 'A'
#define LCD_CHAR_B              24      // 'B'
#define LCD_CHAR_C              25      // 'C'
#define LCD_CHAR_D              26      // 'D'
#define LCD_CHAR_E              27      // 'E'
#define LCD_CHAR_F              28      // 'F'
#define LCD_CHAR_G              29      // 'G'
#define LCD_CHAR_H              30      // 'H'
#define LCD_CHAR_I              31      // 'I'
#define LCD_CHAR_J              32      // 'J'
#define LCD_CHAR_K              33      // 'K'
#define LCD_CHAR_L              34      // 'L'
#define LCD_CHAR_M              35      // 'M'
#define LCD_CHAR_N              36      // 'N'
#define LCD_CHAR_O              37      // 'O'
#define LCD_CHAR_P              38      // 'P'
#define LCD_CHAR_Q              39      // 'Q'
#define LCD_CHAR_R              40      // 'R'
#define LCD_CHAR_S              41      // 'S'
#define LCD_CHAR_T              42      // 'T'
#define LCD_CHAR_U              43      // 'U'
#define LCD_CHAR_V              44      // 'V'
#define LCD_CHAR_W              45      // 'W'
#define LCD_CHAR_X              46      // 'X'
#define LCD_CHAR_Y              47      // 'Y'
#define LCD_CHAR_Z              48      // 'Z'
#define LCD_CHAR_LBRACKET       49      // '[' (Left Bracket)
#define LCD_CHAR_RBRACKET       50      // ']' (Right Bracket)
#define LCD_CHAR_BACKSLASH      51      // '\' (Backslash)
#define LCD_CHAR_EXPONENT       52
#define LCD_CHAR_UNDERLINE      53      // '_' (Underline)
#define LCD_CHAR_VERTBAR        54      // '|' (Vertical Bar)
#define LCD_CHAR_TEST           55      // All segments on

#define LCD_SEG_NONE            0x00

#if LCD_PIN_44

#define LCD_SEG_H               0x01
#define LCD_SEG_F               0x02
#define LCD_SEG_E               0x04
#define LCD_SEG_N               0x08

#define LCD_SEG_A               0x01
#define LCD_SEG_J               0x02
#define LCD_SEG_G               0x04
#define LCD_SEG_M               0x08

#define LCD_SEG_K               0x01
#define LCD_SEG_L               0x02
#define LCD_SEG_D               0x04
#define LCD_SEG_SIGN            0x08

#define LCD_SEG_B               0x01
#define LCD_SEG_C               0x02
#define LCD_SEG_M1              0x04
#define LCD_SEG_M2              0x08

#define LCD_SEG_M3              0x01
#define LCD_SEG_M4              0x02
#define LCD_SEG_M5              0x04
#define LCD_SEG_M6              0x08


#define MASK_NEFH               (LCD_SEG_N|LCD_SEG_E|LCD_SEG_F|LCD_SEG_H)
#define MASK_MGJA               (LCD_SEG_M|LCD_SEG_G|LCD_SEG_J|LCD_SEG_A)
#define MASK_DLK                (LCD_SEG_D|LCD_SEG_L|LCD_SEG_K)
#define MASK_CB                 (LCD_SEG_C|LCD_SEG_B)

#define LCDPIN_NEFH             0
#define LCDPIN_MGJA             1
#define LCDPIN_DLK              2
#define LCDPIN_CB               3

#define LCDPIN_NEFH_OPP             3
#define LCDPIN_MGJA_OPP             2
#define LCDPIN_DLK_OPP              1
#define LCDPIN_CB_OPP               0

const struct lcd_char_segs {
  unsigned char NEFH;
  unsigned char MGJA;
  unsigned char DLK;
  unsigned char CB;
  
};

#else

#define LCD_SEG_J                   0x01
#define LCD_SEG_K                   0x02
#define LCD_SEG_B                   0x04
#define LCD_SEG_C                   0x08
#define LCD_SEG_L                   0x10
#define LCD_SEG_M                   0x20
#define LCD_SEG_D                   0x40
#define LCD_SEG_SP1                 0x80

#define LCD_SEG_A                   0x01
#define LCD_SEG_H                   0x02
#define LCD_SEG_F                   0x04
#define LCD_SEG_G                   0x08
#define LCD_SEG_E                   0x10
#define LCD_SEG_N                   0x20
#define LCD_SEG_SP2                 0x40
#define LCD_SEG_SP3                 0x80

#define LCD_SEG_M5                  0x01
#define LCD_SEG_M4                  0x02
#define LCD_SEG_M6                  0x04
#define LCD_SEG_M3                  0x08
#define LCD_SEG_M7                  0x10
#define LCD_SEG_M2                  0x20
#define LCD_SEG_M1                  0x40
#define LCD_SEG_M8                  0x80

#define MASK_JKBCLMD            (LCD_SEG_J|LCD_SEG_K|LCD_SEG_B|LCD_SEG_C|LCD_SEG_L|LCD_SEG_M|LCD_SEG_M|LCD_SEG_D)
#define MASK_AHFGEN             (LCD_SEG_A|LCD_SEG_H|LCD_SEG_F|LCD_SEG_G|LCD_SEG_E|LCD_SEG_N)

#define LCDPIN_JKBCLMD             0
#define LCDPIN_AHFGEN              1

#define LCDPIN_JKBCLMD_OPP         1
#define LCDPIN_AHFGEN_OPP          0

const struct lcd_char_segs {
  unsigned char JKBCLMD;
  unsigned char AHFGEN;
  
};

#endif

#define NUM_DIGITS              9
#define NUM_CHARS   			      sizeof(lcd_char_table)/sizeof(lcd_char_table[0])


enum symbol { TIME,DT,DATE,FREESCALE,FIRE,TEMP,SNOWFLAKE,VOLUME,ALARM,T,P,CONTRAST,MODE,AM,
              PM,OM,KWH,AMPS,VOLTS,PROGRAM,VOL,DTx,COLx,Vx,Tx};

#if LCD_PIN_44

#define LCDPIN1   LCDWF0
#define LCDPIN2   LCDWF1
#define LCDPIN3   LCDWF2
#define LCDPIN4   LCDWF3
#define LCDPIN5   LCDWF4
#define LCDPIN6   LCDWF5
#define LCDPIN7   LCDWF6
#define LCDPIN8   LCDWF7
#define LCDPIN9   LCDWF8
#define LCDPIN10  LCDWF9
#define LCDPIN11  LCDWF10
#define LCDPIN12  LCDWF11
#define LCDPIN13  LCDWF12
#define LCDPIN14  LCDWF13
#define LCDPIN15  LCDWF14
#define LCDPIN16  LCDWF15
#define LCDPIN16  LCDWF15
#define LCDPIN17  LCDWF16
#define LCDPIN18  LCDWF17
#define LCDPIN19  LCDWF18
#define LCDPIN20  LCDWF19
#define LCDPIN21  LCDWF20
#define LCDPIN22  LCDWF21
#define LCDPIN23  LCDWF22
#define LCDPIN24  LCDWF23
#define LCDPIN25  LCDWF24
#define LCDPIN26  LCDWF25
#define LCDPIN27  LCDWF26
#define LCDPIN28  LCDWF27
#define LCDPIN29  LCDWF28
#define LCDPIN30  LCDWF29
#define LCDPIN31  LCDWF30
#define LCDPIN32  LCDWF31
#define LCDPIN33  LCDWF32
#define LCDPIN34  LCDWF33
#define LCDPIN35  LCDWF34
#define LCDPIN36  LCDWF35
#define LCDPIN37  LCDWF36
#define LCDPIN38  LCDWF37
#define LCDPIN39  LCDWF38
#define LCDPIN40  LCDWF39
#define LCDPIN41  LCDWF40
#define LCDPIN42  LCDWF41
#define LCDPIN43  LCDWF42
#define LCDPIN44  LCDWF43

#define LCD_ALLFP_OFF   {\
                          LCDPIN5 = 0x0;\
                          LCDPIN6 = 0x0;\
                          LCDPIN7 = 0x0;\
                          LCDPIN8 = 0x0;\
                          LCDPIN9 = 0x0;\
                          LCDPIN10 = 0x0;\
                          LCDPIN11 = 0x0;\
                          LCDPIN12 = 0x0;\
                          LCDPIN13 = 0x0;\
                          LCDPIN14 = 0x0;\
                          LCDPIN15 = 0x0;\
                          LCDPIN16 = 0x0;\
                          LCDPIN17 = 0x0;\
                          LCDPIN18 = 0x0;\
                          LCDPIN19 = 0x0;\
                          LCDPIN20 = 0x0;\
                          LCDPIN21 = 0x0;\
                          LCDPIN22 = 0x0;\
                          LCDPIN23 = 0x0;\
                          LCDPIN24 = 0x0;\
                          LCDPIN25 = 0x0;\
                          LCDPIN26 = 0x0;\
                          LCDPIN27 = 0x0;\
                          LCDPIN28 = 0x0;\
                          LCDPIN29 = 0x0;\
                          LCDPIN30 = 0x0;\
                          LCDPIN31 = 0x0;\
                          LCDPIN32 = 0x0;\
                          LCDPIN33 = 0x0;\
                          LCDPIN34 = 0x0;\
                          LCDPIN35 = 0x0;\
                          LCDPIN36 = 0x0;\
                          LCDPIN37 = 0x0;\
                          LCDPIN38 = 0x0;\
                          LCDPIN39 = 0x0;\
                          LCDPIN40 = 0x0;\
                          LCDPIN41 = 0x0;\
                          LCDPIN42 = 0x0;\
                          LCDPIN43 = 0x0;\
                          LCDPIN44 = 0x0;\
                        }
                        
#define LCD_ALLFP_ON   {\
                          LCDPIN5 = 0xFF;\
                          LCDPIN6 = 0xFF;\
                          LCDPIN7 = 0xFF;\
                          LCDPIN8 = 0xFF;\
                          LCDPIN9 = 0xFF;\
                          LCDPIN10 = 0xFF;\
                          LCDPIN11 = 0xFF;\
                          LCDPIN12 = 0xFF;\
                          LCDPIN13 = 0xFF;\
                          LCDPIN14 = 0xFF;\
                          LCDPIN15 = 0xFF;\
                          LCDPIN16 = 0xFF;\
                          LCDPIN17 = 0xFF;\
                          LCDPIN18 = 0xFF;\
                          LCDPIN19 = 0xFF;\
                          LCDPIN20 = 0xFF;\
                          LCDPIN21 = 0xFF;\
                          LCDPIN22 = 0xFF;\
                          LCDPIN23 = 0xFF;\
                          LCDPIN24 = 0xFF;\
                          LCDPIN25 = 0xFF;\
                          LCDPIN26 = 0xFF;\
                          LCDPIN27 = 0xFF;\
                          LCDPIN28 = 0xFF;\
                          LCDPIN29 = 0xFF;\
                          LCDPIN30 = 0xFF;\
                          LCDPIN31 = 0xFF;\
                          LCDPIN32 = 0xFF;\
                          LCDPIN33 = 0xFF;\
                          LCDPIN34 = 0xFF;\
                          LCDPIN35 = 0xFF;\
                          LCDPIN36 = 0xFF;\
                          LCDPIN37 = 0xFF;\
                          LCDPIN38 = 0xFF;\
                          LCDPIN39 = 0xFF;\
                          LCDPIN40 = 0xFF;\
                          LCDPIN41 = 0xFF;\
                          LCDPIN42 = 0xFF;\
                          LCDPIN43 = 0xFF;\
                          LCDPIN44 = 0xFF;\
                        }

#define CONFIG_LCD_40x4_MODE  {\
                  LCDPEN0 = 0xFF;     \
                  LCDPEN1 = 0xFF;     \
                  LCDPEN2 = 0xFF;     \
                  LCDPEN3 = 0xFF;     \
                  LCDPEN4 = 0xFF;     \
                  LCDPEN5 = 0x0F;     \
                  LCDBPEN0 = 0x0F;    \
                  LCDBPEN1 = 0x00;    \
                  LCDBPEN2 = 0x00;    \
                  LCDBPEN3 = 0x00;    \
                  LCDBPEN4 = 0x00;    \
                  LCDBPEN5 = 0x00;    \
                  LCDPIN1 = 0x01;     \
                  LCDPIN2 = 0x02;     \
                  LCDPIN3 = 0x04;     \
                  LCDPIN4 = 0x08;     \
                }


#else

#define LCDPIN1   LCDWF2
#define LCDPIN2   LCDWF3
#define LCDPIN3   LCDWF4
#define LCDPIN4   LCDWF5
#define LCDPIN5   LCDWF6
#define LCDPIN6   LCDWF7
#define LCDPIN7   LCDWF8
#define LCDPIN8   LCDWF9
#define LCDPIN9   LCDWF18
#define LCDPIN10  LCDWF19
#define LCDPIN11  LCDWF20
#define LCDPIN12  LCDWF21
#define LCDPIN13  LCDWF22
#define LCDPIN14  LCDWF23
#define LCDPIN15  LCDWF24
#define LCDPIN16  LCDWF25
#define LCDPIN17  LCDWF26
#define LCDPIN18  LCDWF27
#define LCDPIN19  LCDWF28
#define LCDPIN20  LCDWF29
#define LCDPIN21  LCDWF30
#define LCDPIN22  LCDWF31
#define LCDPIN23  LCDWF32
#define LCDPIN24  LCDWF33
#define LCDPIN25  LCDWF34
#define LCDPIN26  LCDWF35
#define LCDPIN27  LCDWF36
#define LCDPIN28  LCDWF37
#define LCDPIN29  LCDWF38



#define LCD_ALLFP_OFF   {\
                          LCDPIN9 = 0x0;\
                          LCDPIN10 = 0x0;\
                          LCDPIN11 = 0x0;\
                          LCDPIN12 = 0x0;\
                          LCDPIN13 = 0x0;\
                          LCDPIN14 = 0x0;\
                          LCDPIN15 = 0x0;\
                          LCDPIN16 = 0x0;\
                          LCDPIN17 = 0x0;\
                          LCDPIN18 = 0x0;\
                          LCDPIN19 = 0x0;\
                          LCDPIN20 = 0x0;\
                          LCDPIN21 = 0x0;\
                          LCDPIN22 = 0x0;\
                          LCDPIN23 = 0x0;\
                          LCDPIN24 = 0x0;\
                          LCDPIN25 = 0x0;\
                          LCDPIN26 = 0x0;\
                          LCDPIN27 = 0x0;\
                          LCDPIN28 = 0x0;\
                          LCDPIN29 = 0x0;\
                        }


                        
#define LCD_ALLFP_ON   {\
                          LCDPIN9 = 0xFF;\
                          LCDPIN10 = 0xFF;\
                          LCDPIN11 = 0xFF;\
                          LCDPIN12 = 0xFF;\
                          LCDPIN13 = 0xFF;\
                          LCDPIN14 = 0xFF;\
                          LCDPIN15 = 0xFF;\
                          LCDPIN16 = 0xFF;\
                          LCDPIN17 = 0xFF;\
                          LCDPIN18 = 0xFF;\
                          LCDPIN19 = 0xFF;\
                          LCDPIN20 = 0xFF;\
                          LCDPIN21 = 0xFF;\
                          LCDPIN22 = 0xFF;\
                          LCDPIN23 = 0xFF;\
                          LCDPIN24 = 0xFF;\
                          LCDPIN25 = 0xFF;\
                          LCDPIN26 = 0xFF;\
                          LCDPIN27 = 0xFF;\
                          LCDPIN28 = 0xFF;\
                          LCDPIN29 = 0xFF;\
                         }


 #define CONFIG_LCD_21x8_MODE  {\
                  LCDPEN0 = 0xFC;     \
                  LCDPEN1 = 0x03;     \
                  LCDPEN2 = 0xFC;     \
                  LCDPEN3 = 0xFF;     \
                  LCDPEN4 = 0x7F;     \
                  LCDPEN5 = 0x00;     \
                  LCDBPEN0 = 0xFC;    \
                  LCDBPEN1 = 0x03;    \
                  LCDBPEN2 = 0x00;    \
                  LCDBPEN3 = 0x00;    \
                  LCDBPEN4 = 0x00;    \
                  LCDBPEN5 = 0x00;    \
                  LCDPIN1 = 0x01;     \
                  LCDPIN2 = 0x02;     \
                  LCDPIN3 = 0x04;     \
                  LCDPIN4 = 0x08;     \
                  LCDPIN5 = 0x10;     \
                  LCDPIN6 = 0x20;     \
                  LCDPIN7 = 0x40;     \
                  LCDPIN8 = 0x80;     \
                }

                  
#endif  

extern unsigned int qseconds;

/////////////////////////////////////////////////////////////////////////////////////////
// Functions
/////////////////////////////////////////////////////////////////////////////////////////
void LCDInit(void);
void LCDBlinkState(void);
void LCDOnOffState(void);
void LCDClear(void);
void LCDPutChar(unsigned char character, unsigned char digit);
void LCDWriteSegment(enum symbol s, unsigned char num);
void LCDClearSegment(enum symbol s, unsigned char num);
void LCDTest(void);
void LCDClearSegs(void);