MEMORY {
//  512K Internal SRAM Assigned to Z6
    sram    	 : ORIGIN = 0x40000000, LENGTH = 512k

//  2M Internal Flash - 1.5M Assigned to Z6
    flash_rcw	  : ORIGIN = 0x00000000, LENGTH = 0x8
    wakeup_config : ORIGIN = 0x00000008, LENGTH = 2K - 0x8
    wakeup_orig	  : ORIGIN = 0x00000FFC, LENGTH = 16K
    int_flash	  : ORIGIN = 0x00080000, LENGTH = 1M
}

DEFAULTS {
    heap_reserve = 1K
    stack_reserve = 1K
}

// Program layout for running out of RAM.

SECTIONS {

// RAM SECTIONS

    .PPC.EMB.sdata0 	          		    ABS : > sram
    .PPC.EMB.sbss0                            CLEAR ABS : > .
   
    .sdabase 		       		       ALIGN(16): > sram	
    .sdata 						: > .
    .sbss 						: > .
    .data 						: > .
    .bss 						: > .
    .heap                  ALIGN(16) PAD(heap_reserve)  : > .   
    .stack                 ALIGN(16) PAD(stack_reserve) : > .

// ROM SECTIONS

    .rcw                                                : { *(.rcw) } > flash_rcw
    .init       					: { *(.init) } > int_flash
    .text						: > .
    .vletext						: > .
    .syscall						: > .

    .rodata		 				: > .
    .sdata2 						: > .

    .secinfo 						: > .
    .fixaddr 						: > .
    .fixtype 						: > .

    .CROM.PPC.EMB.sdata0 	  CROM(.PPC.EMB.sdata0) : > .
    .CROM.sdata  	            	   CROM(.sdata) : > .
    .CROM.data 	            		    CROM(.data) : > .
    
    .isrvectbl    ALIGN(0x800)   : {} > .   /* ISR Vector Table - must be 2K aligned */
    .xptn_vectors ALIGN(0x10000) : {} > .   /* Exception Vector Table (IVPR) - align 64K boundary */
    .IVOR4_HWvectors ALIGN(0x800): {} > .   /* IVOR4 HW Vector Table (IVPR) - align 2K boundary */

    .wakeupo					: > wakeup_orig
    .wakeupc					: > wakeup_config

/* Interrupt Handler Parameters */
__IVPR = ADDR(.xptn_vectors);


//
// These special symbols mark the bounds of RAM and ROM memory.
// They are used by the MULTI debugger.
//
    __ghs_ramstart  = MEMADDR(sram);
    __ghs_ramend    = MEMENDADDR(sram);
    __ghs_romstart  = MEMADDR(int_flash);
    __ghs_romend    = MEMENDADDR(int_flash);

//
// These special symbols mark the bounds of RAM and ROM images of boot code.
// They are used by the GHS startup code (_start and __ghs_ind_crt0).
//
    __ghs_rambootcodestart  = 0;
    __ghs_rambootcodeend    = 0;
    __ghs_rombootcodestart  = ADDR(.text);
    __ghs_rombootcodeend    = ENDADDR(.fixtype);
    
}
