/* +FHDR-----------------------------------------------------------------------
* Copyright (c) 2011, Freescale Semiconductor, Inc.
* ----------------------------------------------------------------------------
* FILE NAME : main.c
* AUTHOR    : Freescale Semiconductor, Inc. 
* ----------------------------------------------------------------------------
* RELEASE HISTORY
* VERSION DATE AUTHOR DESCRIPTION
* (1.0) 11/01/2011   B32599 (Initial Template)
* ----------------------------------------------------------------------------
* KEYWORDS : Xtrinsic
* ----------------------------------------------------------------------------
* PURPOSE: 
* ----------------------------------------------------------------------------
* REUSE ISSUES
*  
* -FHDR-----------------------------------------------------------------------
*/


/******************************************************************************
*
* Includes
*
*******************************************************************************/
#include "main.h"
#include "CustomApp1.h"


/******************************************************************************
*
* Public memory declarations
*
******************************************************************************/

/* Boot from flash */
uint32 fopt @0x3FFC = 0xFFFF0337;


/******************************************************************************
* The customer application map defines properties of each application to enable
* the FSL scheduler to locate customer output data, configuration data,
* function, and execution rate. The customer application map must be placed at a
* FLASH page boundary (512 B).
*******************************************************************************/

#pragma define_section app_table ".app_table" far_absolute R

#pragma force_active on
#pragma options align=packed

__declspec(app_table) app_table_t app_table = {
    TABLE_IDENTIFIER,                    		/* table identifier */
    1,                                         	/* num_of_apps */
    {     
        {(cbFunction)&user_app_init,         	/* init function address */
         (cbFunction)&user_app_reset,           /* reset function address */
         (cbFunction)(NULL),                   	/* clear function address */
         (cbFunction)&user_app_main,           	/* main function address */
         (uint8)(USER_APP_FBID),             	/* application id */
         sizeof(struct user_app_param_tag),   	/* number of parameter bytes */
         sizeof(struct user_app_outs_tag),     	/* number of output bytes */
        }
    } 
    
};
#pragma options align=reset
#pragma force_active reset



