/* +FHDR-----------------------------------------------------------------------
* Copyright (c) 2014, Freescale Semiconductor, Inc.
* ----------------------------------------------------------------------------
* FILE NAME : rsc.h
* AUTHOR    : Freescale Semiconductor, Inc.
* ----------------------------------------------------------------------------
* RELEASE HISTORY
* VERSION DATE AUTHOR DESCRIPTION
* (1.0) 11/01/2011   B32599 (Initial Template)
* (2.0) 2/6/2014	 B32599, r29903 (Fix bug)
* ----------------------------------------------------------------------------
* KEYWORDS : Xtrinsic
* ----------------------------------------------------------------------------
* PURPOSE:
* ----------------------------------------------------------------------------
* REUSE ISSUES
*
* -FHDR-----------------------------------------------------------------------
*/


#ifndef RSC_H
#define RSC_H


/******************************************************************************
*******************************************************************************
*                             Reset Suspend Clear  					                      *
*******************************************************************************
*******************************************************************************/


/******************************************************************************
* Public Macros
*******************************************************************************/

#define RESET				0			/* index of RESET Register configuration */
#define SUSPEND				1			/* index of SUSPEND Register configuration */
#define CLEAR				2			/* index of CLEAR Register configuration */
#define NUMS_OF_RSC			3			/* number of Status Registers */


/******************************************************************************
* Public type definitions
*******************************************************************************/

/* ----------------------------------------------------------------------------
 * Status register parameter structure
 * ----------------------------------------------------------------------------*/

// this structure works for reset
// All userApp bits are not valid for clear/suspend functions

typedef union rcs_app_tag
{
    uint32_t Dword;
    struct{
				//High Byte ; bit nbr - App_ID
		uint8_t MailBoxCfg		:1; //0 - 24
		uint8_t userApp25		:1; //1 - 25
		uint8_t UserApp26		:1; //2 - 26
		uint8_t UserApp27		:1; //3 - 27
		uint8_t UserApp28		:1; //4 - 28
		uint8_t UserApp29		:1; //5 - 29
		uint8_t Rsvd2			:2; //6:7 - 30:31
				//High-1 Byte ; bit nbr - App_ID
		uint8_t EventFIFO		:1; //0 - 16
		uint8_t StatusReg		:1; //1 - 17
		uint8_t AutoWakeSleep	:1; //2 - 18
		uint8_t UserApp19		:1; //3 - 19
		uint8_t UserApp20		:1; //4 - 20 internal usage only for MMA9553L
		uint8_t	UserApp21		:1; //5 - 21 Pedometer Application in MMA9553L
		uint8_t	UserApp22		:1; //6 - 22
		uint8_t RSC				:1; //7 - 23
				//Low+1 Byte ; bit nbr - App_ID
		uint8_t HG				:1; //0 -  8
		uint8_t LG				:1; //1 -  9
		uint8_t TapDetect		:1; //2 - 10
		uint8_t TiltSensing		:1; //3 - 11
		uint8_t UserApp12		:1; //4 - 12
		uint8_t UserApp13		:1; //5 - 13
		uint8_t UserApp14		:1; //6 - 14
		uint8_t DataFIFO		:1; //7 - 15
				//Low Byte //bit nbr - App_ID
		uint8_t GeneralRst		:1; //0 -  0
		uint8_t Scheduler		:1; //1 -  1
		uint8_t CI				:1; //2 -  2
		uint8_t GPIO			:1; //3 -  3
		uint8_t MBOX			:1; //4 -  4
		uint8_t Rsvd1			:1; //5 -  5
		uint8_t AFE				:1; //6 -  6
		uint8_t PL				:1; //7 -  7
	}bits;
}rsc_app_t;


typedef struct rsc_param_tag
{
	rsc_app_t	sr[NUMS_OF_RSC];
}rsc_param_t;



#endif /* RSC_H */
