/* +FHDR-----------------------------------------------------------------------
* Copyright (c) 2011, Freescale Semiconductor, Inc.
* ----------------------------------------------------------------------------
* FILE NAME : mbox.h
* AUTHOR    : Freescale Semiconductor, Inc.
* ----------------------------------------------------------------------------
* RELEASE HISTORY
* VERSION DATE AUTHOR DESCRIPTION
* (1.0) 11/01/2011   B32599 (Initial Template)
* ----------------------------------------------------------------------------
* KEYWORDS : Xtrinsic
* ----------------------------------------------------------------------------
* PURPOSE:
* ----------------------------------------------------------------------------
* REUSE ISSUES
*
* -FHDR-----------------------------------------------------------------------
*/


#ifndef MBOX_H_
#define MBOX_H_


/******************************************************************************
*******************************************************************************
*                             Mailbox 					                      *
*******************************************************************************
*******************************************************************************/


/******************************************************************************
* Public Macros
*******************************************************************************/

#define MBOX4		0			/* index of Mail Box4 configuration */
#define MBOX5		1			/* index of Mail Box5 configuration */
#define MBOX6		2			/* index of Mail Box6 configuration */
#define MBOX7		3			/* index of Mail Box7 configuration */
#define MBOX8		4			/* index of Mail Box8 configuration */
#define MBOX9		5			/* index of Mail Box9 configuration */
#define MBOX10		6			/* index of Mail Box10 configuration */
#define MBOX11		7			/* index of Mail Box11 configuration */
#define MBOX12		8			/* index of Mail Box12 configuration */
#define MBOX13		9			/* index of Mail Box13 configuration */
#define MBOX14		10			/* index of Mail Box14 configuration */
#define MBOX15		11			/* index of Mail Box15 configuration */
#define MBOX16		12			/* index of Mail Box16 configuration */
#define MBOX17		13			/* index of Mail Box17 configuration */
#define MBOX18		14			/* index of Mail Box18 configuration */
#define MBOX19		15			/* index of Mail Box19 configuration */
#define MBOX20		16			/* index of Mail Box20 configuration */
#define MBOX21		17			/* index of Mail Box21 configuration */
#define MBOX22		18			/* index of Mail Box22 configuration */
#define MBOX23		19			/* index of Mail Box23 configuration */
#define MBOX24		20			/* index of Mail Box24 configuration */
#define MBOX25		21			/* index of Mail Box25 configuration */
#define MBOX26		22			/* index of Mail Box26 configuration */
#define MBOX27		23			/* index of Mail Box27 configuration */
#define MBOX28		24			/* index of Mail Box28 configuration */
#define MBOX29		25			/* index of Mail Box29 configuration */
#define MBOX30		26			/* index of Mail Box30 configuration */
#define MBOX31		27			/* index of Mail Box31 configuration */
#define NUMS_OF_MBOX		28			/* number of mailboxes */


/******************************************************************************
* Public type definitions
*******************************************************************************/

/* ----------------------------------------------------------------------------
 * MBOX parameter structure FBID 0x04
 * ----------------------------------------------------------------------------*/

typedef struct mbox_app_tag
{
    uint8_t app_id;
    uint8_t byte_id;
}mbox_app_t;


typedef struct mbox_param_tag
{
	mbox_app_t	mbox[NUMS_OF_MBOX];
}mbox_param_t;


/* ----------------------------------------------------------------------------
 * MBOX configuration parameter structure FBID 0x18
 * ----------------------------------------------------------------------------*/

typedef struct mbox_cfg_tag
{
	uint8_t Byte;
	union{
		uint8_t Rsvd	:1;
		uint8_t WAIT	:1;
		uint8_t UPDMODES:2;
		uint8_t LEGACY	:1;
		uint8_t INT_O_FRAME_EN: 1;
		uint8_t INT_O_POL: 1;
		uint8_t INT_O_EN: 1;
	}bits;
}mbox_cfg_t;




#endif /* MBOX_H_ */
