/* Based on CPU DB MMA9550, version 3.00.000 (RegistersPrg V2.32) */
/*
** ###################################################################
**     Filename  : mma9550.h
**     Processor : MMA9550
**     FileFormat: V2.32
**     DataSheet : EVE 3-Axis Accelerometer Product Specification REV 1.4, Sept 12, 2009
**     Compiler  : CodeWarrior compiler
**     Date/Time : 28.4.2011, 13:46
**     Abstract  :
**         This header implements the mapping of I/O devices.
**
**     Copyright : 1997 - 2011 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
**
**     CPU Registers Revisions:
**               - none
**
**     File-Format-Revisions:
**               - none
**
**     Not all general-purpose I/O pins are available on all packages or on all mask sets of a specific
**     derivative device. To avoid extra current drain from floating input pins, the users reset
**     initialization routine in the application program must either enable on-chip pull-up devices
**     or change the direction of unconnected pins to outputs so the pins do not float.
** ###################################################################
*/

#ifndef _MMA9550_H
#define _MMA9550_H

/*lint -save  -e950 -esym(960,18.4) -e46 -esym(961,19.7) Disable MISRA rule (1.1,18.4,6.4,19.7) checking. */
/* Types definition */
typedef unsigned char byte;
typedef unsigned short word;
typedef unsigned long dword;

/* Watchdog reset macro */
#ifndef __RESET_WATCHDOG
#ifdef _lint
  #define __RESET_WATCHDOG()  /* empty */
#else
  #define __RESET_WATCHDOG()  /* This derivative does not contain watchdog */
#endif
#endif /* __RESET_WATCHDOG */

#pragma options align=packed

/**************** interrupt vector numbers ****************/
#define VectorNumber_INITSP             0U
#define VectorNumber_INITPC             1U
#define VectorNumber_Vaccerr            2U
#define VectorNumber_Vadderr            3U
#define VectorNumber_Viinstr            4U
#define VectorNumber_VReserved5         5U
#define VectorNumber_VReserved6         6U
#define VectorNumber_VReserved7         7U
#define VectorNumber_Vprviol            8U
#define VectorNumber_Vtrace             9U
#define VectorNumber_Vunilaop           10U
#define VectorNumber_Vunilfop           11U
#define VectorNumber_Vdbgi              12U
#define VectorNumber_VReserved13        13U
#define VectorNumber_Vferror            14U
#define VectorNumber_VReserved15        15U
#define VectorNumber_VReserved16        16U
#define VectorNumber_VReserved17        17U
#define VectorNumber_VReserved18        18U
#define VectorNumber_VReserved19        19U
#define VectorNumber_VReserved20        20U
#define VectorNumber_VReserved21        21U
#define VectorNumber_VReserved22        22U
#define VectorNumber_VReserved23        23U
#define VectorNumber_Vspuri             24U
#define VectorNumber_VReserved25        25U
#define VectorNumber_VReserved26        26U
#define VectorNumber_VReserved27        27U
#define VectorNumber_VReserved28        28U
#define VectorNumber_VReserved29        29U
#define VectorNumber_VReserved30        30U
#define VectorNumber_VReserved31        31U
#define VectorNumber_Vtrap0             32U
#define VectorNumber_Vtrap1             33U
#define VectorNumber_Vtrap2             34U
#define VectorNumber_Vtrap3             35U
#define VectorNumber_Vtrap4             36U
#define VectorNumber_Vtrap5             37U
#define VectorNumber_Vtrap6             38U
#define VectorNumber_Vtrap7             39U
#define VectorNumber_Vtrap8             40U
#define VectorNumber_Vtrap9             41U
#define VectorNumber_Vtrap10            42U
#define VectorNumber_Vtrap11            43U
#define VectorNumber_Vtrap12            44U
#define VectorNumber_Vtrap13            45U
#define VectorNumber_Vtrap14            46U
#define VectorNumber_Vtrap15            47U
#define VectorNumber_VReserved48        48U
#define VectorNumber_VReserved49        49U
#define VectorNumber_VReserved50        50U
#define VectorNumber_VReserved51        51U
#define VectorNumber_VReserved52        52U
#define VectorNumber_VReserved53        53U
#define VectorNumber_VReserved54        54U
#define VectorNumber_VReserved55        55U
#define VectorNumber_VReserved56        56U
#define VectorNumber_VReserved57        57U
#define VectorNumber_VReserved58        58U
#define VectorNumber_VReserved59        59U
#define VectorNumber_VReserved60        60U
#define VectorNumber_Vunsinstr          61U
#define VectorNumber_VReserved62        62U
#define VectorNumber_VReserved63        63U
#define VectorNumber_Virq               64U
#define VectorNumber_Vframe_err         65U
#define VectorNumber_VReserved66        66U
#define VectorNumber_VReserved67        67U
#define VectorNumber_VReserved68        68U
#define VectorNumber_VReserved69        69U
#define VectorNumber_Vtpm1ovf           70U
#define VectorNumber_Vtpm1ch0           71U
#define VectorNumber_Vtpm1ch1           72U
#define VectorNumber_VReserved73        73U
#define VectorNumber_VReserved74        74U
#define VectorNumber_Vmtim              75U
#define VectorNumber_Vpdb_a             76U
#define VectorNumber_Vpdb_b             77U
#define VectorNumber_VReserved78        78U
#define VectorNumber_VReserved79        79U
#define VectorNumber_VReserved80        80U
#define VectorNumber_VReserved81        81U
#define VectorNumber_Vsp_wake           82U
#define VectorNumber_VReserved83        83U
#define VectorNumber_VReserved84        84U
#define VectorNumber_VReserved85        85U
#define VectorNumber_VReserved86        86U
#define VectorNumber_VReserved87        87U
#define VectorNumber_VReserved88        88U
#define VectorNumber_VReserved89        89U
#define VectorNumber_Vsp_to_0           90U
#define VectorNumber_Vsp_to_1           91U
#define VectorNumber_VReserved92        92U
#define VectorNumber_VReserved93        93U
#define VectorNumber_VReserved94        94U
#define VectorNumber_Vstart_of_frame    95U
#define VectorNumber_VReserved96        96U
#define VectorNumber_VReserved97        97U
#define VectorNumber_VReserved98        98U
#define VectorNumber_VReserved99        99U
#define VectorNumber_VReserved100       100U
#define VectorNumber_Vmaster_i2c        101U
#define VectorNumber_VReserved102       102U
#define VectorNumber_VL7swi             103U
#define VectorNumber_VL6swi             104U
#define VectorNumber_VL5swi             105U
#define VectorNumber_VL4swi             106U
#define VectorNumber_VL3swi             107U
#define VectorNumber_VL2swi             108U
#define VectorNumber_VL1swi             109U
#define VectorNumber_VReserved110       110U
#define VectorNumber_VReserved111       111U
#define VectorNumber_VReserved112       112U
#define VectorNumber_VReserved113       113U
#define VectorNumber_VReserved114       114U

/**************** interrupt vector table ****************/
#define INITSP                          0x0000U
#define INITPC                          0x0004U
#define Vaccerr                         0x0008U
#define Vadderr                         0x000CU
#define Viinstr                         0x0010U
#define VReserved5                      0x0014U
#define VReserved6                      0x0018U
#define VReserved7                      0x001CU
#define Vprviol                         0x0020U
#define Vtrace                          0x0024U
#define Vunilaop                        0x0028U
#define Vunilfop                        0x002CU
#define Vdbgi                           0x0030U
#define VReserved13                     0x0034U
#define Vferror                         0x0038U
#define VReserved15                     0x003CU
#define VReserved16                     0x0040U
#define VReserved17                     0x0044U
#define VReserved18                     0x0048U
#define VReserved19                     0x004CU
#define VReserved20                     0x0050U
#define VReserved21                     0x0054U
#define VReserved22                     0x0058U
#define VReserved23                     0x005CU
#define Vspuri                          0x0060U
#define VReserved25                     0x0064U
#define VReserved26                     0x0068U
#define VReserved27                     0x006CU
#define VReserved28                     0x0070U
#define VReserved29                     0x0074U
#define VReserved30                     0x0078U
#define VReserved31                     0x007CU
#define Vtrap0                          0x0080U
#define Vtrap1                          0x0084U
#define Vtrap2                          0x0088U
#define Vtrap3                          0x008CU
#define Vtrap4                          0x0090U
#define Vtrap5                          0x0094U
#define Vtrap6                          0x0098U
#define Vtrap7                          0x009CU
#define Vtrap8                          0x00A0U
#define Vtrap9                          0x00A4U
#define Vtrap10                         0x00A8U
#define Vtrap11                         0x00ACU
#define Vtrap12                         0x00B0U
#define Vtrap13                         0x00B4U
#define Vtrap14                         0x00B8U
#define Vtrap15                         0x00BCU
#define VReserved48                     0x00C0U
#define VReserved49                     0x00C4U
#define VReserved50                     0x00C8U
#define VReserved51                     0x00CCU
#define VReserved52                     0x00D0U
#define VReserved53                     0x00D4U
#define VReserved54                     0x00D8U
#define VReserved55                     0x00DCU
#define VReserved56                     0x00E0U
#define VReserved57                     0x00E4U
#define VReserved58                     0x00E8U
#define VReserved59                     0x00ECU
#define VReserved60                     0x00F0U
#define Vunsinstr                       0x00F4U
#define VReserved62                     0x00F8U
#define VReserved63                     0x00FCU
#define Virq                            0x0100U
#define Vframe_err                      0x0104U
#define VReserved66                     0x0108U
#define VReserved67                     0x010CU
#define VReserved68                     0x0110U
#define VReserved69                     0x0114U
#define Vtpm1ovf                        0x0118U
#define Vtpm1ch0                        0x011CU
#define Vtpm1ch1                        0x0120U
#define VReserved73                     0x0124U
#define VReserved74                     0x0128U
#define Vmtim                           0x012CU
#define Vpdb_a                          0x0130U
#define Vpdb_b                          0x0134U
#define VReserved78                     0x0138U
#define VReserved79                     0x013CU
#define VReserved80                     0x0140U
#define VReserved81                     0x0144U
#define Vsp_wake                        0x0148U
#define VReserved83                     0x014CU
#define VReserved84                     0x0150U
#define VReserved85                     0x0154U
#define VReserved86                     0x0158U
#define VReserved87                     0x015CU
#define VReserved88                     0x0160U
#define VReserved89                     0x0164U
#define Vsp_to_0                        0x0168U
#define Vsp_to_1                        0x016CU
#define VReserved92                     0x0170U
#define VReserved93                     0x0174U
#define VReserved94                     0x0178U
#define Vstart_of_frame                 0x017CU
#define VReserved96                     0x0180U
#define VReserved97                     0x0184U
#define VReserved98                     0x0188U
#define VReserved99                     0x018CU
#define VReserved100                    0x0190U
#define Vmaster_i2c                     0x0194U
#define VReserved102                    0x0198U
#define VL7swi                          0x019CU
#define VL6swi                          0x01A0U
#define VL5swi                          0x01A4U
#define VL4swi                          0x01A8U
#define VL3swi                          0x01ACU
#define VL2swi                          0x01B0U
#define VL1swi                          0x01B4U
#define VReserved110                    0x01B8U
#define VReserved111                    0x01BCU
#define VReserved112                    0x01C0U
#define VReserved113                    0x01C4U
#define VReserved114                    0x01C8U

/**************** registers I/O map ****************/

/*** RGPIO_DIR - RGPIO Data Direction Register; 0x00C00000 ***/
typedef union {
  word Word;
  struct {
    word DIR0        :1;                                       /* RGPIO data direction bit 0 */
    word DIR1        :1;                                       /* RGPIO data direction bit 1 */
    word DIR2        :1;                                       /* RGPIO data direction bit 2 */
    word DIR3        :1;                                       /* RGPIO data direction bit 3 */
    word DIR4        :1;                                       /* RGPIO data direction bit 4 */
    word DIR5        :1;                                       /* RGPIO data direction bit 5 */
    word DIR6        :1;                                       /* RGPIO data direction bit 6 */
    word DIR7        :1;                                       /* RGPIO data direction bit 7 */
    word DIR8        :1;                                       /* RGPIO data direction bit 8 */
    word DIR9        :1;                                       /* RGPIO data direction bit 9 */
    word DIR10       :1;                                       /* RGPIO data direction bit 10 */
    word DIR11       :1;                                       /* RGPIO data direction bit 11 */
    word DIR12       :1;                                       /* RGPIO data direction bit 12 */
    word DIR13       :1;                                       /* RGPIO data direction bit 13 */
    word DIR14       :1;                                       /* RGPIO data direction bit 14 */
    word DIR15       :1;                                       /* RGPIO data direction bit 15 */
  } Bits;
} RGPIO_DIRSTR;
extern volatile RGPIO_DIRSTR _RGPIO_DIR @0x00C00000;
#define RGPIO_DIR                       _RGPIO_DIR.Word
#define RGPIO_DIR_DIR0                  _RGPIO_DIR.Bits.DIR0
#define RGPIO_DIR_DIR1                  _RGPIO_DIR.Bits.DIR1
#define RGPIO_DIR_DIR2                  _RGPIO_DIR.Bits.DIR2
#define RGPIO_DIR_DIR3                  _RGPIO_DIR.Bits.DIR3
#define RGPIO_DIR_DIR4                  _RGPIO_DIR.Bits.DIR4
#define RGPIO_DIR_DIR5                  _RGPIO_DIR.Bits.DIR5
#define RGPIO_DIR_DIR6                  _RGPIO_DIR.Bits.DIR6
#define RGPIO_DIR_DIR7                  _RGPIO_DIR.Bits.DIR7
#define RGPIO_DIR_DIR8                  _RGPIO_DIR.Bits.DIR8
#define RGPIO_DIR_DIR9                  _RGPIO_DIR.Bits.DIR9
#define RGPIO_DIR_DIR10                 _RGPIO_DIR.Bits.DIR10
#define RGPIO_DIR_DIR11                 _RGPIO_DIR.Bits.DIR11
#define RGPIO_DIR_DIR12                 _RGPIO_DIR.Bits.DIR12
#define RGPIO_DIR_DIR13                 _RGPIO_DIR.Bits.DIR13
#define RGPIO_DIR_DIR14                 _RGPIO_DIR.Bits.DIR14
#define RGPIO_DIR_DIR15                 _RGPIO_DIR.Bits.DIR15

#define RGPIO_DIR_DIR0_MASK             1U
#define RGPIO_DIR_DIR1_MASK             2U
#define RGPIO_DIR_DIR2_MASK             4U
#define RGPIO_DIR_DIR3_MASK             8U
#define RGPIO_DIR_DIR4_MASK             16U
#define RGPIO_DIR_DIR5_MASK             32U
#define RGPIO_DIR_DIR6_MASK             64U
#define RGPIO_DIR_DIR7_MASK             128U
#define RGPIO_DIR_DIR8_MASK             256U
#define RGPIO_DIR_DIR9_MASK             512U
#define RGPIO_DIR_DIR10_MASK            1024U
#define RGPIO_DIR_DIR11_MASK            2048U
#define RGPIO_DIR_DIR12_MASK            4096U
#define RGPIO_DIR_DIR13_MASK            8192U
#define RGPIO_DIR_DIR14_MASK            16384U
#define RGPIO_DIR_DIR15_MASK            32768U


/*** RGPIO_DATA - RGPIO Data Register; 0x00C00002 ***/
typedef union {
  word Word;
  struct {
    word DATA0       :1;                                       /* RGPIO data bit 0 */
    word DATA1       :1;                                       /* RGPIO data bit 1 */
    word DATA2       :1;                                       /* RGPIO data bit 2 */
    word DATA3       :1;                                       /* RGPIO data bit 3 */
    word DATA4       :1;                                       /* RGPIO data bit 4 */
    word DATA5       :1;                                       /* RGPIO data bit 5 */
    word DATA6       :1;                                       /* RGPIO data bit 6 */
    word DATA7       :1;                                       /* RGPIO data bit 7 */
    word DATA8       :1;                                       /* RGPIO data bit 8 */
    word DATA9       :1;                                       /* RGPIO data bit 9 */
    word DATA10      :1;                                       /* RGPIO data bit 10 */
    word DATA11      :1;                                       /* RGPIO data bit 11 */
    word DATA12      :1;                                       /* RGPIO data bit 12 */
    word DATA13      :1;                                       /* RGPIO data bit 13 */
    word DATA14      :1;                                       /* RGPIO data bit 14 */
    word DATA15      :1;                                       /* RGPIO data bit 15 */
  } Bits;
} RGPIO_DATASTR;
extern volatile RGPIO_DATASTR _RGPIO_DATA @0x00C00002;
#define RGPIO_DATA                      _RGPIO_DATA.Word
#define RGPIO_DATA_DATA0                _RGPIO_DATA.Bits.DATA0
#define RGPIO_DATA_DATA1                _RGPIO_DATA.Bits.DATA1
#define RGPIO_DATA_DATA2                _RGPIO_DATA.Bits.DATA2
#define RGPIO_DATA_DATA3                _RGPIO_DATA.Bits.DATA3
#define RGPIO_DATA_DATA4                _RGPIO_DATA.Bits.DATA4
#define RGPIO_DATA_DATA5                _RGPIO_DATA.Bits.DATA5
#define RGPIO_DATA_DATA6                _RGPIO_DATA.Bits.DATA6
#define RGPIO_DATA_DATA7                _RGPIO_DATA.Bits.DATA7
#define RGPIO_DATA_DATA8                _RGPIO_DATA.Bits.DATA8
#define RGPIO_DATA_DATA9                _RGPIO_DATA.Bits.DATA9
#define RGPIO_DATA_DATA10               _RGPIO_DATA.Bits.DATA10
#define RGPIO_DATA_DATA11               _RGPIO_DATA.Bits.DATA11
#define RGPIO_DATA_DATA12               _RGPIO_DATA.Bits.DATA12
#define RGPIO_DATA_DATA13               _RGPIO_DATA.Bits.DATA13
#define RGPIO_DATA_DATA14               _RGPIO_DATA.Bits.DATA14
#define RGPIO_DATA_DATA15               _RGPIO_DATA.Bits.DATA15

#define RGPIO_DATA_DATA0_MASK           1U
#define RGPIO_DATA_DATA1_MASK           2U
#define RGPIO_DATA_DATA2_MASK           4U
#define RGPIO_DATA_DATA3_MASK           8U
#define RGPIO_DATA_DATA4_MASK           16U
#define RGPIO_DATA_DATA5_MASK           32U
#define RGPIO_DATA_DATA6_MASK           64U
#define RGPIO_DATA_DATA7_MASK           128U
#define RGPIO_DATA_DATA8_MASK           256U
#define RGPIO_DATA_DATA9_MASK           512U
#define RGPIO_DATA_DATA10_MASK          1024U
#define RGPIO_DATA_DATA11_MASK          2048U
#define RGPIO_DATA_DATA12_MASK          4096U
#define RGPIO_DATA_DATA13_MASK          8192U
#define RGPIO_DATA_DATA14_MASK          16384U
#define RGPIO_DATA_DATA15_MASK          32768U


/*** RGPIO_ENB - RGPIO Pin Enable Register; 0x00C00004 ***/
typedef union {
  word Word;
  struct {
    word ENB0        :1;                                       /* RGPIO enable bit 0 */
    word ENB1        :1;                                       /* RGPIO enable bit 1 */
    word ENB2        :1;                                       /* RGPIO enable bit 2 */
    word ENB3        :1;                                       /* RGPIO enable bit 3 */
    word ENB4        :1;                                       /* RGPIO enable bit 4 */
    word ENB5        :1;                                       /* RGPIO enable bit 5 */
    word ENB6        :1;                                       /* RGPIO enable bit 6 */
    word ENB7        :1;                                       /* RGPIO enable bit 7 */
    word ENB8        :1;                                       /* RGPIO enable bit 8 */
    word ENB9        :1;                                       /* RGPIO enable bit 9 */
    word ENB10       :1;                                       /* RGPIO enable bit 10 */
    word ENB11       :1;                                       /* RGPIO enable bit 11 */
    word ENB12       :1;                                       /* RGPIO enable bit 12 */
    word ENB13       :1;                                       /* RGPIO enable bit 13 */
    word ENB14       :1;                                       /* RGPIO enable bit 14 */
    word ENB15       :1;                                       /* RGPIO enable bit 15 */
  } Bits;
} RGPIO_ENBSTR;
extern volatile RGPIO_ENBSTR _RGPIO_ENB @0x00C00004;
#define RGPIO_ENB                       _RGPIO_ENB.Word
#define RGPIO_ENB_ENB0                  _RGPIO_ENB.Bits.ENB0
#define RGPIO_ENB_ENB1                  _RGPIO_ENB.Bits.ENB1
#define RGPIO_ENB_ENB2                  _RGPIO_ENB.Bits.ENB2
#define RGPIO_ENB_ENB3                  _RGPIO_ENB.Bits.ENB3
#define RGPIO_ENB_ENB4                  _RGPIO_ENB.Bits.ENB4
#define RGPIO_ENB_ENB5                  _RGPIO_ENB.Bits.ENB5
#define RGPIO_ENB_ENB6                  _RGPIO_ENB.Bits.ENB6
#define RGPIO_ENB_ENB7                  _RGPIO_ENB.Bits.ENB7
#define RGPIO_ENB_ENB8                  _RGPIO_ENB.Bits.ENB8
#define RGPIO_ENB_ENB9                  _RGPIO_ENB.Bits.ENB9
#define RGPIO_ENB_ENB10                 _RGPIO_ENB.Bits.ENB10
#define RGPIO_ENB_ENB11                 _RGPIO_ENB.Bits.ENB11
#define RGPIO_ENB_ENB12                 _RGPIO_ENB.Bits.ENB12
#define RGPIO_ENB_ENB13                 _RGPIO_ENB.Bits.ENB13
#define RGPIO_ENB_ENB14                 _RGPIO_ENB.Bits.ENB14
#define RGPIO_ENB_ENB15                 _RGPIO_ENB.Bits.ENB15

#define RGPIO_ENB_ENB0_MASK             1U
#define RGPIO_ENB_ENB1_MASK             2U
#define RGPIO_ENB_ENB2_MASK             4U
#define RGPIO_ENB_ENB3_MASK             8U
#define RGPIO_ENB_ENB4_MASK             16U
#define RGPIO_ENB_ENB5_MASK             32U
#define RGPIO_ENB_ENB6_MASK             64U
#define RGPIO_ENB_ENB7_MASK             128U
#define RGPIO_ENB_ENB8_MASK             256U
#define RGPIO_ENB_ENB9_MASK             512U
#define RGPIO_ENB_ENB10_MASK            1024U
#define RGPIO_ENB_ENB11_MASK            2048U
#define RGPIO_ENB_ENB12_MASK            4096U
#define RGPIO_ENB_ENB13_MASK            8192U
#define RGPIO_ENB_ENB14_MASK            16384U
#define RGPIO_ENB_ENB15_MASK            32768U


/*** RGPIO_CLR - RGPIO Clear Data Register; 0x00C00006 ***/
typedef union {
  word Word;
  struct {
    word CLR0        :1;                                       /* RGPIO clear data bit 0 */
    word CLR1        :1;                                       /* RGPIO clear data bit 1 */
    word CLR2        :1;                                       /* RGPIO clear data bit 2 */
    word CLR3        :1;                                       /* RGPIO clear data bit 3 */
    word CLR4        :1;                                       /* RGPIO clear data bit 4 */
    word CLR5        :1;                                       /* RGPIO clear data bit 5 */
    word CLR6        :1;                                       /* RGPIO clear data bit 6 */
    word CLR7        :1;                                       /* RGPIO clear data bit 7 */
    word CLR8        :1;                                       /* RGPIO clear data bit 8 */
    word CLR9        :1;                                       /* RGPIO clear data bit 9 */
    word CLR10       :1;                                       /* RGPIO clear data bit 10 */
    word CLR11       :1;                                       /* RGPIO clear data bit 11 */
    word CLR12       :1;                                       /* RGPIO clear data bit 12 */
    word CLR13       :1;                                       /* RGPIO clear data bit 13 */
    word CLR14       :1;                                       /* RGPIO clear data bit 14 */
    word CLR15       :1;                                       /* RGPIO clear data bit 15 */
  } Bits;
} RGPIO_CLRSTR;
extern volatile RGPIO_CLRSTR _RGPIO_CLR @0x00C00006;
#define RGPIO_CLR                       _RGPIO_CLR.Word
#define RGPIO_CLR_CLR0                  _RGPIO_CLR.Bits.CLR0
#define RGPIO_CLR_CLR1                  _RGPIO_CLR.Bits.CLR1
#define RGPIO_CLR_CLR2                  _RGPIO_CLR.Bits.CLR2
#define RGPIO_CLR_CLR3                  _RGPIO_CLR.Bits.CLR3
#define RGPIO_CLR_CLR4                  _RGPIO_CLR.Bits.CLR4
#define RGPIO_CLR_CLR5                  _RGPIO_CLR.Bits.CLR5
#define RGPIO_CLR_CLR6                  _RGPIO_CLR.Bits.CLR6
#define RGPIO_CLR_CLR7                  _RGPIO_CLR.Bits.CLR7
#define RGPIO_CLR_CLR8                  _RGPIO_CLR.Bits.CLR8
#define RGPIO_CLR_CLR9                  _RGPIO_CLR.Bits.CLR9
#define RGPIO_CLR_CLR10                 _RGPIO_CLR.Bits.CLR10
#define RGPIO_CLR_CLR11                 _RGPIO_CLR.Bits.CLR11
#define RGPIO_CLR_CLR12                 _RGPIO_CLR.Bits.CLR12
#define RGPIO_CLR_CLR13                 _RGPIO_CLR.Bits.CLR13
#define RGPIO_CLR_CLR14                 _RGPIO_CLR.Bits.CLR14
#define RGPIO_CLR_CLR15                 _RGPIO_CLR.Bits.CLR15

#define RGPIO_CLR_CLR0_MASK             1U
#define RGPIO_CLR_CLR1_MASK             2U
#define RGPIO_CLR_CLR2_MASK             4U
#define RGPIO_CLR_CLR3_MASK             8U
#define RGPIO_CLR_CLR4_MASK             16U
#define RGPIO_CLR_CLR5_MASK             32U
#define RGPIO_CLR_CLR6_MASK             64U
#define RGPIO_CLR_CLR7_MASK             128U
#define RGPIO_CLR_CLR8_MASK             256U
#define RGPIO_CLR_CLR9_MASK             512U
#define RGPIO_CLR_CLR10_MASK            1024U
#define RGPIO_CLR_CLR11_MASK            2048U
#define RGPIO_CLR_CLR12_MASK            4096U
#define RGPIO_CLR_CLR13_MASK            8192U
#define RGPIO_CLR_CLR14_MASK            16384U
#define RGPIO_CLR_CLR15_MASK            32768U


/*** RGPIO_SET - RGPIO Set Data Register; 0x00C0000A ***/
typedef union {
  word Word;
  struct {
    word SET0        :1;                                       /* RGPIO set data bit 0 */
    word SET1        :1;                                       /* RGPIO set data bit 1 */
    word SET2        :1;                                       /* RGPIO set data bit 2 */
    word SET3        :1;                                       /* RGPIO set data bit 3 */
    word SET4        :1;                                       /* RGPIO set data bit 4 */
    word SET5        :1;                                       /* RGPIO set data bit 5 */
    word SET6        :1;                                       /* RGPIO set data bit 6 */
    word SET7        :1;                                       /* RGPIO set data bit 7 */
    word SET8        :1;                                       /* RGPIO set data bit 8 */
    word SET9        :1;                                       /* RGPIO set data bit 9 */
    word SET10       :1;                                       /* RGPIO set data bit 10 */
    word SET11       :1;                                       /* RGPIO set data bit 11 */
    word SET12       :1;                                       /* RGPIO set data bit 12 */
    word SET13       :1;                                       /* RGPIO set data bit 13 */
    word SET14       :1;                                       /* RGPIO set data bit 14 */
    word SET15       :1;                                       /* RGPIO set data bit 15 */
  } Bits;
} RGPIO_SETSTR;
extern volatile RGPIO_SETSTR _RGPIO_SET @0x00C0000A;
#define RGPIO_SET                       _RGPIO_SET.Word
#define RGPIO_SET_SET0                  _RGPIO_SET.Bits.SET0
#define RGPIO_SET_SET1                  _RGPIO_SET.Bits.SET1
#define RGPIO_SET_SET2                  _RGPIO_SET.Bits.SET2
#define RGPIO_SET_SET3                  _RGPIO_SET.Bits.SET3
#define RGPIO_SET_SET4                  _RGPIO_SET.Bits.SET4
#define RGPIO_SET_SET5                  _RGPIO_SET.Bits.SET5
#define RGPIO_SET_SET6                  _RGPIO_SET.Bits.SET6
#define RGPIO_SET_SET7                  _RGPIO_SET.Bits.SET7
#define RGPIO_SET_SET8                  _RGPIO_SET.Bits.SET8
#define RGPIO_SET_SET9                  _RGPIO_SET.Bits.SET9
#define RGPIO_SET_SET10                 _RGPIO_SET.Bits.SET10
#define RGPIO_SET_SET11                 _RGPIO_SET.Bits.SET11
#define RGPIO_SET_SET12                 _RGPIO_SET.Bits.SET12
#define RGPIO_SET_SET13                 _RGPIO_SET.Bits.SET13
#define RGPIO_SET_SET14                 _RGPIO_SET.Bits.SET14
#define RGPIO_SET_SET15                 _RGPIO_SET.Bits.SET15

#define RGPIO_SET_SET0_MASK             1U
#define RGPIO_SET_SET1_MASK             2U
#define RGPIO_SET_SET2_MASK             4U
#define RGPIO_SET_SET3_MASK             8U
#define RGPIO_SET_SET4_MASK             16U
#define RGPIO_SET_SET5_MASK             32U
#define RGPIO_SET_SET6_MASK             64U
#define RGPIO_SET_SET7_MASK             128U
#define RGPIO_SET_SET8_MASK             256U
#define RGPIO_SET_SET9_MASK             512U
#define RGPIO_SET_SET10_MASK            1024U
#define RGPIO_SET_SET11_MASK            2048U
#define RGPIO_SET_SET12_MASK            4096U
#define RGPIO_SET_SET13_MASK            8192U
#define RGPIO_SET_SET14_MASK            16384U
#define RGPIO_SET_SET15_MASK            32768U


/*** RGPIO_TOG - RGPIO Toggle Data Register; 0x00C0000E ***/
typedef union {
  word Word;
  struct {
    word TOG0        :1;                                       /* RGPIO toggle data bit 0 */
    word TOG1        :1;                                       /* RGPIO toggle data bit 1 */
    word TOG2        :1;                                       /* RGPIO toggle data bit 2 */
    word TOG3        :1;                                       /* RGPIO toggle data bit 3 */
    word TOG4        :1;                                       /* RGPIO toggle data bit 4 */
    word TOG5        :1;                                       /* RGPIO toggle data bit 5 */
    word TOG6        :1;                                       /* RGPIO toggle data bit 6 */
    word TOG7        :1;                                       /* RGPIO toggle data bit 7 */
    word TOG8        :1;                                       /* RGPIO toggle data bit 8 */
    word TOG9        :1;                                       /* RGPIO toggle data bit 9 */
    word TOG10       :1;                                       /* RGPIO toggle data bit 10 */
    word TOG11       :1;                                       /* RGPIO toggle data bit 11 */
    word TOG12       :1;                                       /* RGPIO toggle data bit 12 */
    word TOG13       :1;                                       /* RGPIO toggle data bit 13 */
    word TOG14       :1;                                       /* RGPIO toggle data bit 14 */
    word TOG15       :1;                                       /* RGPIO toggle data bit 15 */
  } Bits;
} RGPIO_TOGSTR;
extern volatile RGPIO_TOGSTR _RGPIO_TOG @0x00C0000E;
#define RGPIO_TOG                       _RGPIO_TOG.Word
#define RGPIO_TOG_TOG0                  _RGPIO_TOG.Bits.TOG0
#define RGPIO_TOG_TOG1                  _RGPIO_TOG.Bits.TOG1
#define RGPIO_TOG_TOG2                  _RGPIO_TOG.Bits.TOG2
#define RGPIO_TOG_TOG3                  _RGPIO_TOG.Bits.TOG3
#define RGPIO_TOG_TOG4                  _RGPIO_TOG.Bits.TOG4
#define RGPIO_TOG_TOG5                  _RGPIO_TOG.Bits.TOG5
#define RGPIO_TOG_TOG6                  _RGPIO_TOG.Bits.TOG6
#define RGPIO_TOG_TOG7                  _RGPIO_TOG.Bits.TOG7
#define RGPIO_TOG_TOG8                  _RGPIO_TOG.Bits.TOG8
#define RGPIO_TOG_TOG9                  _RGPIO_TOG.Bits.TOG9
#define RGPIO_TOG_TOG10                 _RGPIO_TOG.Bits.TOG10
#define RGPIO_TOG_TOG11                 _RGPIO_TOG.Bits.TOG11
#define RGPIO_TOG_TOG12                 _RGPIO_TOG.Bits.TOG12
#define RGPIO_TOG_TOG13                 _RGPIO_TOG.Bits.TOG13
#define RGPIO_TOG_TOG14                 _RGPIO_TOG.Bits.TOG14
#define RGPIO_TOG_TOG15                 _RGPIO_TOG.Bits.TOG15

#define RGPIO_TOG_TOG0_MASK             1U
#define RGPIO_TOG_TOG1_MASK             2U
#define RGPIO_TOG_TOG2_MASK             4U
#define RGPIO_TOG_TOG3_MASK             8U
#define RGPIO_TOG_TOG4_MASK             16U
#define RGPIO_TOG_TOG5_MASK             32U
#define RGPIO_TOG_TOG6_MASK             64U
#define RGPIO_TOG_TOG7_MASK             128U
#define RGPIO_TOG_TOG8_MASK             256U
#define RGPIO_TOG_TOG9_MASK             512U
#define RGPIO_TOG_TOG10_MASK            1024U
#define RGPIO_TOG_TOG11_MASK            2048U
#define RGPIO_TOG_TOG12_MASK            4096U
#define RGPIO_TOG_TOG13_MASK            8192U
#define RGPIO_TOG_TOG14_MASK            16384U
#define RGPIO_TOG_TOG15_MASK            32768U


/*** SP_MB0_dword - Mailbox Register 0, 32 bit; 0xFFFF8000 ***/
typedef union {
  dword Dword;
   /* Overlapped registers: */
  struct {
    /*** SP_MB0_word - Mailbox Register 0, 16 bit; 0xFFFF8000 ***/
    union {
      word Word;
       /* Overlapped registers: */
      struct {
        /*** SP_MB0 - Mailbox Register0; 0xFFFF8000 ***/
        union {
          byte Byte;
        } SP_MB0STR;
        #define SP_MB0                  _SP_MB0_dword.Overlap_STR.SP_MB0_wordSTR.Overlap_STR.SP_MB0STR.Byte
        /* SP_MB_ARR: Access 32 SP_MBx registers in an array */
        #define SP_MB_ARR               ((volatile byte *) &SP_MB0)
        
    
        /*** SP_MB1 - Mailbox Register1; 0xFFFF8001 ***/
        union {
          byte Byte;
        } SP_MB1STR;
        #define SP_MB1                  _SP_MB0_dword.Overlap_STR.SP_MB0_wordSTR.Overlap_STR.SP_MB1STR.Byte
        
      } Overlap_STR;
    
    } SP_MB0_wordSTR;
    #define SP_MB0_word                 _SP_MB0_dword.Overlap_STR.SP_MB0_wordSTR.Word
    

    /*** SP_MB1_word - Mailbox Register 1, 16 bit; 0xFFFF8002 ***/
    union {
      word Word;
       /* Overlapped registers: */
      struct {
        /*** SP_MB2 - Mailbox Register2; 0xFFFF8002 ***/
        union {
          byte Byte;
        } SP_MB2STR;
        #define SP_MB2                  _SP_MB0_dword.Overlap_STR.SP_MB1_wordSTR.Overlap_STR.SP_MB2STR.Byte
        
    
        /*** SP_MB3 - Mailbox Register3; 0xFFFF8003 ***/
        union {
          byte Byte;
        } SP_MB3STR;
        #define SP_MB3                  _SP_MB0_dword.Overlap_STR.SP_MB1_wordSTR.Overlap_STR.SP_MB3STR.Byte
        
      } Overlap_STR;
    
    } SP_MB1_wordSTR;
    #define SP_MB1_word                 _SP_MB0_dword.Overlap_STR.SP_MB1_wordSTR.Word
    
  } Overlap_STR;

} SP_MB0_dwordSTR;
extern volatile SP_MB0_dwordSTR _SP_MB0_dword @0xFFFF8000;
#define SP_MB0_dword                    _SP_MB0_dword.Dword


/*** SP_MB1_dword - Mailbox Register 1, 32 bit; 0xFFFF8004 ***/
typedef union {
  dword Dword;
   /* Overlapped registers: */
  struct {
    /*** SP_MB2_word - Mailbox Register 2, 16 bit; 0xFFFF8004 ***/
    union {
      word Word;
       /* Overlapped registers: */
      struct {
        /*** SP_MB4 - Mailbox Register4; 0xFFFF8004 ***/
        union {
          byte Byte;
        } SP_MB4STR;
        #define SP_MB4                  _SP_MB1_dword.Overlap_STR.SP_MB2_wordSTR.Overlap_STR.SP_MB4STR.Byte
        
    
        /*** SP_MB5 - Mailbox Register5; 0xFFFF8005 ***/
        union {
          byte Byte;
        } SP_MB5STR;
        #define SP_MB5                  _SP_MB1_dword.Overlap_STR.SP_MB2_wordSTR.Overlap_STR.SP_MB5STR.Byte
        
      } Overlap_STR;
    
    } SP_MB2_wordSTR;
    #define SP_MB2_word                 _SP_MB1_dword.Overlap_STR.SP_MB2_wordSTR.Word
    

    /*** SP_MB3_word - Mailbox Register 3, 16 bit; 0xFFFF8006 ***/
    union {
      word Word;
       /* Overlapped registers: */
      struct {
        /*** SP_MB6 - Mailbox Register6; 0xFFFF8006 ***/
        union {
          byte Byte;
        } SP_MB6STR;
        #define SP_MB6                  _SP_MB1_dword.Overlap_STR.SP_MB3_wordSTR.Overlap_STR.SP_MB6STR.Byte
        
    
        /*** SP_MB7 - Mailbox Register7; 0xFFFF8007 ***/
        union {
          byte Byte;
        } SP_MB7STR;
        #define SP_MB7                  _SP_MB1_dword.Overlap_STR.SP_MB3_wordSTR.Overlap_STR.SP_MB7STR.Byte
        
      } Overlap_STR;
    
    } SP_MB3_wordSTR;
    #define SP_MB3_word                 _SP_MB1_dword.Overlap_STR.SP_MB3_wordSTR.Word
    
  } Overlap_STR;

} SP_MB1_dwordSTR;
extern volatile SP_MB1_dwordSTR _SP_MB1_dword @0xFFFF8004;
#define SP_MB1_dword                    _SP_MB1_dword.Dword


/*** SP_MB2_dword - Mailbox Register 2, 32 bit; 0xFFFF8008 ***/
typedef union {
  dword Dword;
   /* Overlapped registers: */
  struct {
    /*** SP_MB4_word - Mailbox Register 4, 16 bit; 0xFFFF8008 ***/
    union {
      word Word;
       /* Overlapped registers: */
      struct {
        /*** SP_MB8 - Mailbox Register8; 0xFFFF8008 ***/
        union {
          byte Byte;
        } SP_MB8STR;
        #define SP_MB8                  _SP_MB2_dword.Overlap_STR.SP_MB4_wordSTR.Overlap_STR.SP_MB8STR.Byte
        
    
        /*** SP_MB9 - Mailbox Register9; 0xFFFF8009 ***/
        union {
          byte Byte;
        } SP_MB9STR;
        #define SP_MB9                  _SP_MB2_dword.Overlap_STR.SP_MB4_wordSTR.Overlap_STR.SP_MB9STR.Byte
        
      } Overlap_STR;
    
    } SP_MB4_wordSTR;
    #define SP_MB4_word                 _SP_MB2_dword.Overlap_STR.SP_MB4_wordSTR.Word
    

    /*** SP_MB5_word - Mailbox Register 5, 16 bit; 0xFFFF800A ***/
    union {
      word Word;
       /* Overlapped registers: */
      struct {
        /*** SP_MB10 - Mailbox Register10; 0xFFFF800A ***/
        union {
          byte Byte;
        } SP_MB10STR;
        #define SP_MB10                 _SP_MB2_dword.Overlap_STR.SP_MB5_wordSTR.Overlap_STR.SP_MB10STR.Byte
        
    
        /*** SP_MB11 - Mailbox Register11; 0xFFFF800B ***/
        union {
          byte Byte;
        } SP_MB11STR;
        #define SP_MB11                 _SP_MB2_dword.Overlap_STR.SP_MB5_wordSTR.Overlap_STR.SP_MB11STR.Byte
        
      } Overlap_STR;
    
    } SP_MB5_wordSTR;
    #define SP_MB5_word                 _SP_MB2_dword.Overlap_STR.SP_MB5_wordSTR.Word
    
  } Overlap_STR;

} SP_MB2_dwordSTR;
extern volatile SP_MB2_dwordSTR _SP_MB2_dword @0xFFFF8008;
#define SP_MB2_dword                    _SP_MB2_dword.Dword


/*** SP_MB3_dword - Mailbox Register 3, 32 bit; 0xFFFF800C ***/
typedef union {
  dword Dword;
   /* Overlapped registers: */
  struct {
    /*** SP_MB6_word - Mailbox Register 6, 16 bit; 0xFFFF800C ***/
    union {
      word Word;
       /* Overlapped registers: */
      struct {
        /*** SP_MB12 - Mailbox Register12; 0xFFFF800C ***/
        union {
          byte Byte;
        } SP_MB12STR;
        #define SP_MB12                 _SP_MB3_dword.Overlap_STR.SP_MB6_wordSTR.Overlap_STR.SP_MB12STR.Byte
        
    
        /*** SP_MB13 - Mailbox Register13; 0xFFFF800D ***/
        union {
          byte Byte;
        } SP_MB13STR;
        #define SP_MB13                 _SP_MB3_dword.Overlap_STR.SP_MB6_wordSTR.Overlap_STR.SP_MB13STR.Byte
        
      } Overlap_STR;
    
    } SP_MB6_wordSTR;
    #define SP_MB6_word                 _SP_MB3_dword.Overlap_STR.SP_MB6_wordSTR.Word
    

    /*** SP_MB7_word - Mailbox Register 7, 16 bit; 0xFFFF800E ***/
    union {
      word Word;
       /* Overlapped registers: */
      struct {
        /*** SP_MB14 - Mailbox Register14; 0xFFFF800E ***/
        union {
          byte Byte;
        } SP_MB14STR;
        #define SP_MB14                 _SP_MB3_dword.Overlap_STR.SP_MB7_wordSTR.Overlap_STR.SP_MB14STR.Byte
        
    
        /*** SP_MB15 - Mailbox Register15; 0xFFFF800F ***/
        union {
          byte Byte;
        } SP_MB15STR;
        #define SP_MB15                 _SP_MB3_dword.Overlap_STR.SP_MB7_wordSTR.Overlap_STR.SP_MB15STR.Byte
        
      } Overlap_STR;
    
    } SP_MB7_wordSTR;
    #define SP_MB7_word                 _SP_MB3_dword.Overlap_STR.SP_MB7_wordSTR.Word
    
  } Overlap_STR;

} SP_MB3_dwordSTR;
extern volatile SP_MB3_dwordSTR _SP_MB3_dword @0xFFFF800C;
#define SP_MB3_dword                    _SP_MB3_dword.Dword


/*** SP_MB4_dword - Mailbox Register 4, 32 bit; 0xFFFF8010 ***/
typedef union {
  dword Dword;
   /* Overlapped registers: */
  struct {
    /*** SP_MB8_word - Mailbox Register 8, 16 bit; 0xFFFF8010 ***/
    union {
      word Word;
       /* Overlapped registers: */
      struct {
        /*** SP_MB16 - Mailbox Register16; 0xFFFF8010 ***/
        union {
          byte Byte;
        } SP_MB16STR;
        #define SP_MB16                 _SP_MB4_dword.Overlap_STR.SP_MB8_wordSTR.Overlap_STR.SP_MB16STR.Byte
        
    
        /*** SP_MB17 - Mailbox Register17; 0xFFFF8011 ***/
        union {
          byte Byte;
        } SP_MB17STR;
        #define SP_MB17                 _SP_MB4_dword.Overlap_STR.SP_MB8_wordSTR.Overlap_STR.SP_MB17STR.Byte
        
      } Overlap_STR;
    
    } SP_MB8_wordSTR;
    #define SP_MB8_word                 _SP_MB4_dword.Overlap_STR.SP_MB8_wordSTR.Word
    

    /*** SP_MB9_word - Mailbox Register 9, 16 bit; 0xFFFF8012 ***/
    union {
      word Word;
       /* Overlapped registers: */
      struct {
        /*** SP_MB18 - Mailbox Register18; 0xFFFF8012 ***/
        union {
          byte Byte;
        } SP_MB18STR;
        #define SP_MB18                 _SP_MB4_dword.Overlap_STR.SP_MB9_wordSTR.Overlap_STR.SP_MB18STR.Byte
        
    
        /*** SP_MB19 - Mailbox Register19; 0xFFFF8013 ***/
        union {
          byte Byte;
        } SP_MB19STR;
        #define SP_MB19                 _SP_MB4_dword.Overlap_STR.SP_MB9_wordSTR.Overlap_STR.SP_MB19STR.Byte
        
      } Overlap_STR;
    
    } SP_MB9_wordSTR;
    #define SP_MB9_word                 _SP_MB4_dword.Overlap_STR.SP_MB9_wordSTR.Word
    
  } Overlap_STR;

} SP_MB4_dwordSTR;
extern volatile SP_MB4_dwordSTR _SP_MB4_dword @0xFFFF8010;
#define SP_MB4_dword                    _SP_MB4_dword.Dword


/*** SP_MB5_dword - Mailbox Register 5, 32 bit; 0xFFFF8014 ***/
typedef union {
  dword Dword;
   /* Overlapped registers: */
  struct {
    /*** SP_MB10_word - Mailbox Register 10, 16 bit; 0xFFFF8014 ***/
    union {
      word Word;
       /* Overlapped registers: */
      struct {
        /*** SP_MB20 - Mailbox Register20; 0xFFFF8014 ***/
        union {
          byte Byte;
        } SP_MB20STR;
        #define SP_MB20                 _SP_MB5_dword.Overlap_STR.SP_MB10_wordSTR.Overlap_STR.SP_MB20STR.Byte
        
    
        /*** SP_MB21 - Mailbox Register21; 0xFFFF8015 ***/
        union {
          byte Byte;
        } SP_MB21STR;
        #define SP_MB21                 _SP_MB5_dword.Overlap_STR.SP_MB10_wordSTR.Overlap_STR.SP_MB21STR.Byte
        
      } Overlap_STR;
    
    } SP_MB10_wordSTR;
    #define SP_MB10_word                _SP_MB5_dword.Overlap_STR.SP_MB10_wordSTR.Word
    

    /*** SP_MB11_word - Mailbox Register 11, 16 bit; 0xFFFF8016 ***/
    union {
      word Word;
       /* Overlapped registers: */
      struct {
        /*** SP_MB22 - Mailbox Register22; 0xFFFF8016 ***/
        union {
          byte Byte;
        } SP_MB22STR;
        #define SP_MB22                 _SP_MB5_dword.Overlap_STR.SP_MB11_wordSTR.Overlap_STR.SP_MB22STR.Byte
        
    
        /*** SP_MB23 - Mailbox Register23; 0xFFFF8017 ***/
        union {
          byte Byte;
        } SP_MB23STR;
        #define SP_MB23                 _SP_MB5_dword.Overlap_STR.SP_MB11_wordSTR.Overlap_STR.SP_MB23STR.Byte
        
      } Overlap_STR;
    
    } SP_MB11_wordSTR;
    #define SP_MB11_word                _SP_MB5_dword.Overlap_STR.SP_MB11_wordSTR.Word
    
  } Overlap_STR;

} SP_MB5_dwordSTR;
extern volatile SP_MB5_dwordSTR _SP_MB5_dword @0xFFFF8014;
#define SP_MB5_dword                    _SP_MB5_dword.Dword


/*** SP_MB6_dword - Mailbox Register 6, 32 bit; 0xFFFF8018 ***/
typedef union {
  dword Dword;
   /* Overlapped registers: */
  struct {
    /*** SP_MB12_word - Mailbox Register 12, 16 bit; 0xFFFF8018 ***/
    union {
      word Word;
       /* Overlapped registers: */
      struct {
        /*** SP_MB24 - Mailbox Register24; 0xFFFF8018 ***/
        union {
          byte Byte;
        } SP_MB24STR;
        #define SP_MB24                 _SP_MB6_dword.Overlap_STR.SP_MB12_wordSTR.Overlap_STR.SP_MB24STR.Byte
        
    
        /*** SP_MB25 - Mailbox Register25; 0xFFFF8019 ***/
        union {
          byte Byte;
        } SP_MB25STR;
        #define SP_MB25                 _SP_MB6_dword.Overlap_STR.SP_MB12_wordSTR.Overlap_STR.SP_MB25STR.Byte
        
      } Overlap_STR;
    
    } SP_MB12_wordSTR;
    #define SP_MB12_word                _SP_MB6_dword.Overlap_STR.SP_MB12_wordSTR.Word
    

    /*** SP_MB13_word - Mailbox Register 13, 16 bit; 0xFFFF801A ***/
    union {
      word Word;
       /* Overlapped registers: */
      struct {
        /*** SP_MB26 - Mailbox Register26; 0xFFFF801A ***/
        union {
          byte Byte;
        } SP_MB26STR;
        #define SP_MB26                 _SP_MB6_dword.Overlap_STR.SP_MB13_wordSTR.Overlap_STR.SP_MB26STR.Byte
        
    
        /*** SP_MB27 - Mailbox Register27; 0xFFFF801B ***/
        union {
          byte Byte;
        } SP_MB27STR;
        #define SP_MB27                 _SP_MB6_dword.Overlap_STR.SP_MB13_wordSTR.Overlap_STR.SP_MB27STR.Byte
        
      } Overlap_STR;
    
    } SP_MB13_wordSTR;
    #define SP_MB13_word                _SP_MB6_dword.Overlap_STR.SP_MB13_wordSTR.Word
    
  } Overlap_STR;

} SP_MB6_dwordSTR;
extern volatile SP_MB6_dwordSTR _SP_MB6_dword @0xFFFF8018;
#define SP_MB6_dword                    _SP_MB6_dword.Dword


/*** SP_MB7_dword - Mailbox Register 7, 32 bit; 0xFFFF801C ***/
typedef union {
  dword Dword;
   /* Overlapped registers: */
  struct {
    /*** SP_MB14_word - Mailbox Register 14, 16 bit; 0xFFFF801C ***/
    union {
      word Word;
       /* Overlapped registers: */
      struct {
        /*** SP_MB28 - Mailbox Register28; 0xFFFF801C ***/
        union {
          byte Byte;
        } SP_MB28STR;
        #define SP_MB28                 _SP_MB7_dword.Overlap_STR.SP_MB14_wordSTR.Overlap_STR.SP_MB28STR.Byte
        
    
        /*** SP_MB29 - Mailbox Register29; 0xFFFF801D ***/
        union {
          byte Byte;
        } SP_MB29STR;
        #define SP_MB29                 _SP_MB7_dword.Overlap_STR.SP_MB14_wordSTR.Overlap_STR.SP_MB29STR.Byte
        
      } Overlap_STR;
    
    } SP_MB14_wordSTR;
    #define SP_MB14_word                _SP_MB7_dword.Overlap_STR.SP_MB14_wordSTR.Word
    

    /*** SP_MB15_word - Mailbox Register 15, 16 bit; 0xFFFF801E ***/
    union {
      word Word;
       /* Overlapped registers: */
      struct {
        /*** SP_MB30 - Mailbox Register30; 0xFFFF801E ***/
        union {
          byte Byte;
        } SP_MB30STR;
        #define SP_MB30                 _SP_MB7_dword.Overlap_STR.SP_MB15_wordSTR.Overlap_STR.SP_MB30STR.Byte
        
    
        /*** SP_MB31 - Mailbox Register31; 0xFFFF801F ***/
        union {
          byte Byte;
        } SP_MB31STR;
        #define SP_MB31                 _SP_MB7_dword.Overlap_STR.SP_MB15_wordSTR.Overlap_STR.SP_MB31STR.Byte
        
      } Overlap_STR;
    
    } SP_MB15_wordSTR;
    #define SP_MB15_word                _SP_MB7_dword.Overlap_STR.SP_MB15_wordSTR.Word
    
  } Overlap_STR;

} SP_MB7_dwordSTR;
extern volatile SP_MB7_dwordSTR _SP_MB7_dword @0xFFFF801C;
#define SP_MB7_dword                    _SP_MB7_dword.Dword


/*** SP_MUTEX0 - Binary Semaphore (Mutex) Register 0; 0xFFFF8020 ***/
typedef union {
  byte Byte;
  struct {
    byte SSTS0       :1;                                       /* SSTS Semaphore Status, bit 0 */
    byte SSTS1       :1;                                       /* SSTS Semaphore Status, bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpSSTS :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} SP_MUTEX0STR;
extern volatile SP_MUTEX0STR _SP_MUTEX0 @0xFFFF8020;
#define SP_MUTEX0                       _SP_MUTEX0.Byte
#define SP_MUTEX0_SSTS0                 _SP_MUTEX0.Bits.SSTS0
#define SP_MUTEX0_SSTS1                 _SP_MUTEX0.Bits.SSTS1
/* SP_MUTEX_ARR: Access 2 SP_MUTEXx registers in an array */
#define SP_MUTEX_ARR                    ((volatile byte *) &SP_MUTEX0)
#define SP_MUTEX0_SSTS                  _SP_MUTEX0.MergedBits.grpSSTS

#define SP_MUTEX0_SSTS0_MASK            1U
#define SP_MUTEX0_SSTS1_MASK            2U
#define SP_MUTEX0_SSTS_MASK             3U
#define SP_MUTEX0_SSTS_BITNUM           0U


/*** SP_MUTEX1 - Binary Semaphore (Mutex) Register 1; 0xFFFF8021 ***/
typedef union {
  byte Byte;
  struct {
    byte SSTS0       :1;                                       /* SSTS Semaphore Status, bit 0 */
    byte SSTS1       :1;                                       /* SSTS Semaphore Status, bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpSSTS :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} SP_MUTEX1STR;
extern volatile SP_MUTEX1STR _SP_MUTEX1 @0xFFFF8021;
#define SP_MUTEX1                       _SP_MUTEX1.Byte
#define SP_MUTEX1_SSTS0                 _SP_MUTEX1.Bits.SSTS0
#define SP_MUTEX1_SSTS1                 _SP_MUTEX1.Bits.SSTS1
#define SP_MUTEX1_SSTS                  _SP_MUTEX1.MergedBits.grpSSTS

#define SP_MUTEX1_SSTS0_MASK            1U
#define SP_MUTEX1_SSTS1_MASK            2U
#define SP_MUTEX1_SSTS_MASK             3U
#define SP_MUTEX1_SSTS_BITNUM           0U


/*** SP_ADDR - Slave I2C Address Register; 0xFFFF8022 ***/
typedef union {
  byte Byte;
  struct {
    byte ADDR        :7;                                       /* Slave I2C Address, bit 0 */
    byte             :1; 
  } Bits;
} SP_ADDRSTR;
extern volatile SP_ADDRSTR _SP_ADDR @0xFFFF8022;
#define SP_ADDR                         _SP_ADDR.Byte
#define SP_ADDR_ADDR                    _SP_ADDR.Bits.ADDR

#define SP_ADDR_ADDR_MASK               127U
#define SP_ADDR_ADDR_BITNUM             0U


/*** SP_SCR - Slave Port Status & Control Register; 0xFFFF8023 ***/
typedef union {
  byte Byte;
  struct {
    byte WUP0        :1;                                       /* Wakeup Configuration, bit 0 */
    byte WUP1        :1;                                       /* Wakeup Configuration, bit 1 */
    byte WIE         :1;                                       /* Write Interrupt Enable */
    byte RIE         :1;                                       /* Read Interrupt Enable */
    byte STOP_EN     :1;                                       /* Interrupt STOP Enable */
    byte ACTIVE_CSR  :1;                                       /* Slave port is active / Clear Read & Write Status Registers */
    byte PS          :1;                                       /* Port Select */
    byte EN          :1;                                       /* Slave Port Enable */
  } Bits;
  struct {
    byte grpWUP  :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} SP_SCRSTR;
extern volatile SP_SCRSTR _SP_SCR @0xFFFF8023;
#define SP_SCR                          _SP_SCR.Byte
#define SP_SCR_WUP0                     _SP_SCR.Bits.WUP0
#define SP_SCR_WUP1                     _SP_SCR.Bits.WUP1
#define SP_SCR_WIE                      _SP_SCR.Bits.WIE
#define SP_SCR_RIE                      _SP_SCR.Bits.RIE
#define SP_SCR_STOP_EN                  _SP_SCR.Bits.STOP_EN
#define SP_SCR_ACTIVE_CSR               _SP_SCR.Bits.ACTIVE_CSR
#define SP_SCR_PS                       _SP_SCR.Bits.PS
#define SP_SCR_EN                       _SP_SCR.Bits.EN
#define SP_SCR_WUP                      _SP_SCR.MergedBits.grpWUP

#define SP_SCR_WUP0_MASK                1U
#define SP_SCR_WUP1_MASK                2U
#define SP_SCR_WIE_MASK                 4U
#define SP_SCR_RIE_MASK                 8U
#define SP_SCR_STOP_EN_MASK             16U
#define SP_SCR_ACTIVE_CSR_MASK          32U
#define SP_SCR_PS_MASK                  64U
#define SP_SCR_EN_MASK                  128U
#define SP_SCR_WUP_MASK                 3U
#define SP_SCR_WUP_BITNUM               0U


/*** SP_WSTS0 - Write Status Register 0; 0xFFFF8024 ***/
typedef union {
  byte Byte;
  struct {
    byte D24         :1;                                       /* SP_MB24 write status */
    byte D25         :1;                                       /* SP_MB25 write status */
    byte D26         :1;                                       /* SP_MB26 write status */
    byte D27         :1;                                       /* SP_MB27 write status */
    byte D28         :1;                                       /* SP_MB28 write status */
    byte D29         :1;                                       /* SP_MB29 write status */
    byte D30         :1;                                       /* SP_MB30 write status */
    byte D31         :1;                                       /* SP_MB31 write status */
  } Bits;
} SP_WSTS0STR;
extern volatile SP_WSTS0STR _SP_WSTS0 @0xFFFF8024;
#define SP_WSTS0                        _SP_WSTS0.Byte
#define SP_WSTS0_D24                    _SP_WSTS0.Bits.D24
#define SP_WSTS0_D25                    _SP_WSTS0.Bits.D25
#define SP_WSTS0_D26                    _SP_WSTS0.Bits.D26
#define SP_WSTS0_D27                    _SP_WSTS0.Bits.D27
#define SP_WSTS0_D28                    _SP_WSTS0.Bits.D28
#define SP_WSTS0_D29                    _SP_WSTS0.Bits.D29
#define SP_WSTS0_D30                    _SP_WSTS0.Bits.D30
#define SP_WSTS0_D31                    _SP_WSTS0.Bits.D31
/* SP_WSTS_ARR: Access 4 SP_WSTSx registers in an array */
#define SP_WSTS_ARR                     ((volatile byte *) &SP_WSTS0)

#define SP_WSTS0_D24_MASK               1U
#define SP_WSTS0_D25_MASK               2U
#define SP_WSTS0_D26_MASK               4U
#define SP_WSTS0_D27_MASK               8U
#define SP_WSTS0_D28_MASK               16U
#define SP_WSTS0_D29_MASK               32U
#define SP_WSTS0_D30_MASK               64U
#define SP_WSTS0_D31_MASK               128U


/*** SP_WSTS1 - Write Status Register 1; 0xFFFF8025 ***/
typedef union {
  byte Byte;
  struct {
    byte D16         :1;                                       /* SP_MB16 write status */
    byte D17         :1;                                       /* SP_MB17 write status */
    byte D18         :1;                                       /* SP_MB18 write status */
    byte D19         :1;                                       /* SP_MB19 write status */
    byte D20         :1;                                       /* SP_MB20 write status */
    byte D21         :1;                                       /* SP_MB21 write status */
    byte D22         :1;                                       /* SP_MB22 write status */
    byte D23         :1;                                       /* SP_MB23 write status */
  } Bits;
} SP_WSTS1STR;
extern volatile SP_WSTS1STR _SP_WSTS1 @0xFFFF8025;
#define SP_WSTS1                        _SP_WSTS1.Byte
#define SP_WSTS1_D16                    _SP_WSTS1.Bits.D16
#define SP_WSTS1_D17                    _SP_WSTS1.Bits.D17
#define SP_WSTS1_D18                    _SP_WSTS1.Bits.D18
#define SP_WSTS1_D19                    _SP_WSTS1.Bits.D19
#define SP_WSTS1_D20                    _SP_WSTS1.Bits.D20
#define SP_WSTS1_D21                    _SP_WSTS1.Bits.D21
#define SP_WSTS1_D22                    _SP_WSTS1.Bits.D22
#define SP_WSTS1_D23                    _SP_WSTS1.Bits.D23

#define SP_WSTS1_D16_MASK               1U
#define SP_WSTS1_D17_MASK               2U
#define SP_WSTS1_D18_MASK               4U
#define SP_WSTS1_D19_MASK               8U
#define SP_WSTS1_D20_MASK               16U
#define SP_WSTS1_D21_MASK               32U
#define SP_WSTS1_D22_MASK               64U
#define SP_WSTS1_D23_MASK               128U


/*** SP_WSTS2 - Write Status Register 2; 0xFFFF8026 ***/
typedef union {
  byte Byte;
  struct {
    byte D8          :1;                                       /* SP_MB8 write status */
    byte D9          :1;                                       /* SP_MB9 write status */
    byte D10         :1;                                       /* SP_MB10 write status */
    byte D11         :1;                                       /* SP_MB11 write status */
    byte D12         :1;                                       /* SP_MB12 write status */
    byte D13         :1;                                       /* SP_MB13 write status */
    byte D14         :1;                                       /* SP_MB14 write status */
    byte D15         :1;                                       /* SP_MB15 write status */
  } Bits;
} SP_WSTS2STR;
extern volatile SP_WSTS2STR _SP_WSTS2 @0xFFFF8026;
#define SP_WSTS2                        _SP_WSTS2.Byte
#define SP_WSTS2_D8                     _SP_WSTS2.Bits.D8
#define SP_WSTS2_D9                     _SP_WSTS2.Bits.D9
#define SP_WSTS2_D10                    _SP_WSTS2.Bits.D10
#define SP_WSTS2_D11                    _SP_WSTS2.Bits.D11
#define SP_WSTS2_D12                    _SP_WSTS2.Bits.D12
#define SP_WSTS2_D13                    _SP_WSTS2.Bits.D13
#define SP_WSTS2_D14                    _SP_WSTS2.Bits.D14
#define SP_WSTS2_D15                    _SP_WSTS2.Bits.D15

#define SP_WSTS2_D8_MASK                1U
#define SP_WSTS2_D9_MASK                2U
#define SP_WSTS2_D10_MASK               4U
#define SP_WSTS2_D11_MASK               8U
#define SP_WSTS2_D12_MASK               16U
#define SP_WSTS2_D13_MASK               32U
#define SP_WSTS2_D14_MASK               64U
#define SP_WSTS2_D15_MASK               128U


/*** SP_WSTS3 - Write Status Register 3; 0xFFFF8027 ***/
typedef union {
  byte Byte;
  struct {
    byte D0          :1;                                       /* SP_MB0 write status */
    byte D1          :1;                                       /* SP_MB1 write status */
    byte D2          :1;                                       /* SP_MB2 write status */
    byte D3          :1;                                       /* SP_MB3 write status */
    byte D4          :1;                                       /* SP_MB4 write status */
    byte D5          :1;                                       /* SP_MB5 write status */
    byte D6          :1;                                       /* SP_MB6 write status */
    byte D7          :1;                                       /* SP_MB7 write status */
  } Bits;
} SP_WSTS3STR;
extern volatile SP_WSTS3STR _SP_WSTS3 @0xFFFF8027;
#define SP_WSTS3                        _SP_WSTS3.Byte
#define SP_WSTS3_D0                     _SP_WSTS3.Bits.D0
#define SP_WSTS3_D1                     _SP_WSTS3.Bits.D1
#define SP_WSTS3_D2                     _SP_WSTS3.Bits.D2
#define SP_WSTS3_D3                     _SP_WSTS3.Bits.D3
#define SP_WSTS3_D4                     _SP_WSTS3.Bits.D4
#define SP_WSTS3_D5                     _SP_WSTS3.Bits.D5
#define SP_WSTS3_D6                     _SP_WSTS3.Bits.D6
#define SP_WSTS3_D7                     _SP_WSTS3.Bits.D7

#define SP_WSTS3_D0_MASK                1U
#define SP_WSTS3_D1_MASK                2U
#define SP_WSTS3_D2_MASK                4U
#define SP_WSTS3_D3_MASK                8U
#define SP_WSTS3_D4_MASK                16U
#define SP_WSTS3_D5_MASK                32U
#define SP_WSTS3_D6_MASK                64U
#define SP_WSTS3_D7_MASK                128U


/*** SP_RSTS0 - Read Status Register 0; 0xFFFF8028 ***/
typedef union {
  byte Byte;
  struct {
    byte D24         :1;                                       /* SP_MB24 read status */
    byte D25         :1;                                       /* SP_MB25 read status */
    byte D26         :1;                                       /* SP_MB26 read status */
    byte D27         :1;                                       /* SP_MB27 read status */
    byte D28         :1;                                       /* SP_MB28 read status */
    byte D29         :1;                                       /* SP_MB29 read status */
    byte D30         :1;                                       /* SP_MB30 read status */
    byte D31         :1;                                       /* SP_MB31 read status */
  } Bits;
} SP_RSTS0STR;
extern volatile SP_RSTS0STR _SP_RSTS0 @0xFFFF8028;
#define SP_RSTS0                        _SP_RSTS0.Byte
#define SP_RSTS0_D24                    _SP_RSTS0.Bits.D24
#define SP_RSTS0_D25                    _SP_RSTS0.Bits.D25
#define SP_RSTS0_D26                    _SP_RSTS0.Bits.D26
#define SP_RSTS0_D27                    _SP_RSTS0.Bits.D27
#define SP_RSTS0_D28                    _SP_RSTS0.Bits.D28
#define SP_RSTS0_D29                    _SP_RSTS0.Bits.D29
#define SP_RSTS0_D30                    _SP_RSTS0.Bits.D30
#define SP_RSTS0_D31                    _SP_RSTS0.Bits.D31
/* SP_RSTS_ARR: Access 4 SP_RSTSx registers in an array */
#define SP_RSTS_ARR                     ((volatile byte *) &SP_RSTS0)

#define SP_RSTS0_D24_MASK               1U
#define SP_RSTS0_D25_MASK               2U
#define SP_RSTS0_D26_MASK               4U
#define SP_RSTS0_D27_MASK               8U
#define SP_RSTS0_D28_MASK               16U
#define SP_RSTS0_D29_MASK               32U
#define SP_RSTS0_D30_MASK               64U
#define SP_RSTS0_D31_MASK               128U


/*** SP_RSTS1 - Read Status Register 1; 0xFFFF8029 ***/
typedef union {
  byte Byte;
  struct {
    byte D16         :1;                                       /* SP_MB16 read status */
    byte D17         :1;                                       /* SP_MB17 read status */
    byte D18         :1;                                       /* SP_MB18 read status */
    byte D19         :1;                                       /* SP_MB19 read status */
    byte D20         :1;                                       /* SP_MB20 read status */
    byte D21         :1;                                       /* SP_MB21 read status */
    byte D22         :1;                                       /* SP_MB22 read status */
    byte D23         :1;                                       /* SP_MB23 read status */
  } Bits;
} SP_RSTS1STR;
extern volatile SP_RSTS1STR _SP_RSTS1 @0xFFFF8029;
#define SP_RSTS1                        _SP_RSTS1.Byte
#define SP_RSTS1_D16                    _SP_RSTS1.Bits.D16
#define SP_RSTS1_D17                    _SP_RSTS1.Bits.D17
#define SP_RSTS1_D18                    _SP_RSTS1.Bits.D18
#define SP_RSTS1_D19                    _SP_RSTS1.Bits.D19
#define SP_RSTS1_D20                    _SP_RSTS1.Bits.D20
#define SP_RSTS1_D21                    _SP_RSTS1.Bits.D21
#define SP_RSTS1_D22                    _SP_RSTS1.Bits.D22
#define SP_RSTS1_D23                    _SP_RSTS1.Bits.D23

#define SP_RSTS1_D16_MASK               1U
#define SP_RSTS1_D17_MASK               2U
#define SP_RSTS1_D18_MASK               4U
#define SP_RSTS1_D19_MASK               8U
#define SP_RSTS1_D20_MASK               16U
#define SP_RSTS1_D21_MASK               32U
#define SP_RSTS1_D22_MASK               64U
#define SP_RSTS1_D23_MASK               128U


/*** SP_RSTS2 - Read Status Register 2; 0xFFFF802A ***/
typedef union {
  byte Byte;
  struct {
    byte D8          :1;                                       /* SP_MB8 read status */
    byte D9          :1;                                       /* SP_MB9 read status */
    byte D10         :1;                                       /* SP_MB10 read status */
    byte D11         :1;                                       /* SP_MB11 read status */
    byte D12         :1;                                       /* SP_MB12 read status */
    byte D13         :1;                                       /* SP_MB13 read status */
    byte D14         :1;                                       /* SP_MB14 read status */
    byte D15         :1;                                       /* SP_MB15 read status */
  } Bits;
} SP_RSTS2STR;
extern volatile SP_RSTS2STR _SP_RSTS2 @0xFFFF802A;
#define SP_RSTS2                        _SP_RSTS2.Byte
#define SP_RSTS2_D8                     _SP_RSTS2.Bits.D8
#define SP_RSTS2_D9                     _SP_RSTS2.Bits.D9
#define SP_RSTS2_D10                    _SP_RSTS2.Bits.D10
#define SP_RSTS2_D11                    _SP_RSTS2.Bits.D11
#define SP_RSTS2_D12                    _SP_RSTS2.Bits.D12
#define SP_RSTS2_D13                    _SP_RSTS2.Bits.D13
#define SP_RSTS2_D14                    _SP_RSTS2.Bits.D14
#define SP_RSTS2_D15                    _SP_RSTS2.Bits.D15

#define SP_RSTS2_D8_MASK                1U
#define SP_RSTS2_D9_MASK                2U
#define SP_RSTS2_D10_MASK               4U
#define SP_RSTS2_D11_MASK               8U
#define SP_RSTS2_D12_MASK               16U
#define SP_RSTS2_D13_MASK               32U
#define SP_RSTS2_D14_MASK               64U
#define SP_RSTS2_D15_MASK               128U


/*** SP_RSTS3 - Read Status Register 3; 0xFFFF802B ***/
typedef union {
  byte Byte;
  struct {
    byte D0          :1;                                       /* SP_MB0 read status */
    byte D1          :1;                                       /* SP_MB1 read status */
    byte D2          :1;                                       /* SP_MB2 read status */
    byte D3          :1;                                       /* SP_MB3 read status */
    byte D4          :1;                                       /* SP_MB4 read status */
    byte D5          :1;                                       /* SP_MB5 read status */
    byte D6          :1;                                       /* SP_MB6 read status */
    byte D7          :1;                                       /* SP_MB7 read status */
  } Bits;
} SP_RSTS3STR;
extern volatile SP_RSTS3STR _SP_RSTS3 @0xFFFF802B;
#define SP_RSTS3                        _SP_RSTS3.Byte
#define SP_RSTS3_D0                     _SP_RSTS3.Bits.D0
#define SP_RSTS3_D1                     _SP_RSTS3.Bits.D1
#define SP_RSTS3_D2                     _SP_RSTS3.Bits.D2
#define SP_RSTS3_D3                     _SP_RSTS3.Bits.D3
#define SP_RSTS3_D4                     _SP_RSTS3.Bits.D4
#define SP_RSTS3_D5                     _SP_RSTS3.Bits.D5
#define SP_RSTS3_D6                     _SP_RSTS3.Bits.D6
#define SP_RSTS3_D7                     _SP_RSTS3.Bits.D7

#define SP_RSTS3_D0_MASK                1U
#define SP_RSTS3_D1_MASK                2U
#define SP_RSTS3_D2_MASK                4U
#define SP_RSTS3_D3_MASK                8U
#define SP_RSTS3_D4_MASK                16U
#define SP_RSTS3_D5_MASK                32U
#define SP_RSTS3_D6_MASK                64U
#define SP_RSTS3_D7_MASK                128U


/*** SP_MTOR0 - Mutext Timeout Register 0; 0xFFFF802C ***/
typedef union {
  byte Byte;
  struct {
    byte MTE         :5;                                       /* Mutext Timeout Exponent, bit 0 */
    byte EN          :1;                                       /* Mutext Timeout Enable */
    byte TOSTS       :1;                                       /* Mutext Timeout Status */
    byte             :1; 
  } Bits;
} SP_MTOR0STR;
extern volatile SP_MTOR0STR _SP_MTOR0 @0xFFFF802C;
#define SP_MTOR0                        _SP_MTOR0.Byte
#define SP_MTOR0_MTE                    _SP_MTOR0.Bits.MTE
#define SP_MTOR0_EN                     _SP_MTOR0.Bits.EN
#define SP_MTOR0_TOSTS                  _SP_MTOR0.Bits.TOSTS
/* SP_MTOR_ARR: Access 2 SP_MTORx registers in an array */
#define SP_MTOR_ARR                     ((volatile byte *) &SP_MTOR0)

#define SP_MTOR0_MTE_MASK               31U
#define SP_MTOR0_MTE_BITNUM             0U
#define SP_MTOR0_EN_MASK                32U
#define SP_MTOR0_TOSTS_MASK             64U


/*** SP_MTOR1 - Mutext Timeout Register 1; 0xFFFF802D ***/
typedef union {
  byte Byte;
  struct {
    byte MTE         :5;                                       /* Mutext Timeout Exponent, bit 0 */
    byte EN          :1;                                       /* Mutext Timeout Enable */
    byte TOSTS       :1;                                       /* Mutext Timeout Status */
    byte             :1; 
  } Bits;
} SP_MTOR1STR;
extern volatile SP_MTOR1STR _SP_MTOR1 @0xFFFF802D;
#define SP_MTOR1                        _SP_MTOR1.Byte
#define SP_MTOR1_MTE                    _SP_MTOR1.Bits.MTE
#define SP_MTOR1_EN                     _SP_MTOR1.Bits.EN
#define SP_MTOR1_TOSTS                  _SP_MTOR1.Bits.TOSTS

#define SP_MTOR1_MTE_MASK               31U
#define SP_MTOR1_MTE_BITNUM             0U
#define SP_MTOR1_EN_MASK                32U
#define SP_MTOR1_TOSTS_MASK             64U


/*** SP_OIC - Slave Port Output Interrupt (INT_O) Control Register; 0xFFFF802E ***/
typedef union {
  byte Byte;
  struct {
    byte SET_INT_O   :1;                                       /* Set / Assert / Current value of INT_O function */
    byte CLR         :1;                                       /* Clear / De-Assert */
    byte POL         :1;                                       /* Output Polarity */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} SP_OICSTR;
extern volatile SP_OICSTR _SP_OIC @0xFFFF802E;
#define SP_OIC                          _SP_OIC.Byte
#define SP_OIC_SET_INT_O                _SP_OIC.Bits.SET_INT_O
#define SP_OIC_CLR                      _SP_OIC.Bits.CLR
#define SP_OIC_POL                      _SP_OIC.Bits.POL

#define SP_OIC_SET_INT_O_MASK           1U
#define SP_OIC_CLR_MASK                 2U
#define SP_OIC_POL_MASK                 4U


/*** IICA1 - IIC Address Register; 0xFFFF8040 ***/
typedef union {
  byte Byte;
  union { /* Several registers at the same address */
    /*** IICA1 - IIC Address Register; Several registers at the same address ***/
    union {
      struct {
        byte             :1; 
        byte AD1         :1;                                       /* Slave Address Bit 1 */
        byte AD2         :1;                                       /* Slave Address Bit 2 */
        byte AD3         :1;                                       /* Slave Address Bit 3 */
        byte AD4         :1;                                       /* Slave Address Bit 4 */
        byte AD5         :1;                                       /* Slave Address Bit 5 */
        byte AD6         :1;                                       /* Slave Address Bit 6 */
        byte AD7         :1;                                       /* Slave Address Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte grpAD_1 :7;
      } MergedBits;
    } IICA1STR;
    #define IICA1                       _IICA1.Byte
    #define IICA1_AD1                   _IICA1.SameAddr_STR.IICA1STR.Bits.AD1
    #define IICA1_AD2                   _IICA1.SameAddr_STR.IICA1STR.Bits.AD2
    #define IICA1_AD3                   _IICA1.SameAddr_STR.IICA1STR.Bits.AD3
    #define IICA1_AD4                   _IICA1.SameAddr_STR.IICA1STR.Bits.AD4
    #define IICA1_AD5                   _IICA1.SameAddr_STR.IICA1STR.Bits.AD5
    #define IICA1_AD6                   _IICA1.SameAddr_STR.IICA1STR.Bits.AD6
    #define IICA1_AD7                   _IICA1.SameAddr_STR.IICA1STR.Bits.AD7
    #define IICA1_AD_1                  _IICA1.SameAddr_STR.IICA1STR.MergedBits.grpAD_1
    #define IICA1_AD                    IICA1_AD_1
    
    #define IICA1_AD1_MASK              2U
    #define IICA1_AD2_MASK              4U
    #define IICA1_AD3_MASK              8U
    #define IICA1_AD4_MASK              16U
    #define IICA1_AD5_MASK              32U
    #define IICA1_AD6_MASK              64U
    #define IICA1_AD7_MASK              128U
    #define IICA1_AD_1_MASK             254U
    #define IICA1_AD_1_BITNUM           1U
    
    /*** IICA - IIC Address Register; Several registers at the same address ***/
    union {
      struct {
        byte             :1; 
        byte AD1         :1;                                       /* Slave Address Bit 1 */
        byte AD2         :1;                                       /* Slave Address Bit 2 */
        byte AD3         :1;                                       /* Slave Address Bit 3 */
        byte AD4         :1;                                       /* Slave Address Bit 4 */
        byte AD5         :1;                                       /* Slave Address Bit 5 */
        byte AD6         :1;                                       /* Slave Address Bit 6 */
        byte AD7         :1;                                       /* Slave Address Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte grpAD_1 :7;
      } MergedBits;
    } IICASTR;
    #define IICA                        _IICA1.Byte
    #define IICA_AD1                    _IICA1.SameAddr_STR.IICASTR.Bits.AD1
    #define IICA_AD2                    _IICA1.SameAddr_STR.IICASTR.Bits.AD2
    #define IICA_AD3                    _IICA1.SameAddr_STR.IICASTR.Bits.AD3
    #define IICA_AD4                    _IICA1.SameAddr_STR.IICASTR.Bits.AD4
    #define IICA_AD5                    _IICA1.SameAddr_STR.IICASTR.Bits.AD5
    #define IICA_AD6                    _IICA1.SameAddr_STR.IICASTR.Bits.AD6
    #define IICA_AD7                    _IICA1.SameAddr_STR.IICASTR.Bits.AD7
    #define IICA_AD_1                   _IICA1.SameAddr_STR.IICASTR.MergedBits.grpAD_1
    #define IICA_AD                     IICA_AD_1
    
    #define IICA_AD1_MASK               2U
    #define IICA_AD2_MASK               4U
    #define IICA_AD3_MASK               8U
    #define IICA_AD4_MASK               16U
    #define IICA_AD5_MASK               32U
    #define IICA_AD6_MASK               64U
    #define IICA_AD7_MASK               128U
    #define IICA_AD_1_MASK              254U
    #define IICA_AD_1_BITNUM            1U
    
  } SameAddr_STR; /*Several registers at the same address */

} IICA1STR;
extern volatile IICA1STR _IICA1 @0xFFFF8040;


/*** IICF - IIC Frequency Divider Register; 0xFFFF8041 ***/
typedef union {
  byte Byte;
  struct {
    byte ICR0        :1;                                       /* IIC Clock Rate Bit 0 */
    byte ICR1        :1;                                       /* IIC Clock Rate Bit 1 */
    byte ICR2        :1;                                       /* IIC Clock Rate Bit 2 */
    byte ICR3        :1;                                       /* IIC Clock Rate Bit 3 */
    byte ICR4        :1;                                       /* IIC Clock Rate Bit 4 */
    byte ICR5        :1;                                       /* IIC Clock Rate Bit 5 */
    byte MULT0       :1;                                       /* Multiplier Factor Bit 0 */
    byte MULT1       :1;                                       /* Multiplier Factor Bit 1 */
  } Bits;
  struct {
    byte grpICR  :6;
    byte grpMULT :2;
  } MergedBits;
} IICFSTR;
extern volatile IICFSTR _IICF @0xFFFF8041;
#define IICF                            _IICF.Byte
#define IICF_ICR0                       _IICF.Bits.ICR0
#define IICF_ICR1                       _IICF.Bits.ICR1
#define IICF_ICR2                       _IICF.Bits.ICR2
#define IICF_ICR3                       _IICF.Bits.ICR3
#define IICF_ICR4                       _IICF.Bits.ICR4
#define IICF_ICR5                       _IICF.Bits.ICR5
#define IICF_MULT0                      _IICF.Bits.MULT0
#define IICF_MULT1                      _IICF.Bits.MULT1
#define IICF_ICR                        _IICF.MergedBits.grpICR
#define IICF_MULT                       _IICF.MergedBits.grpMULT

#define IICF_ICR0_MASK                  1U
#define IICF_ICR1_MASK                  2U
#define IICF_ICR2_MASK                  4U
#define IICF_ICR3_MASK                  8U
#define IICF_ICR4_MASK                  16U
#define IICF_ICR5_MASK                  32U
#define IICF_MULT0_MASK                 64U
#define IICF_MULT1_MASK                 128U
#define IICF_ICR_MASK                   63U
#define IICF_ICR_BITNUM                 0U
#define IICF_MULT_MASK                  192U
#define IICF_MULT_BITNUM                6U


/*** IICC1 - IIC Control Register 1; 0xFFFF8042 ***/
typedef union {
  byte Byte;
  union { /* Several registers at the same address */
    /*** IICC1 - IIC Control Register 1; Several registers at the same address ***/
    union {
      struct {
        byte             :1; 
        byte WUEN        :1;                                       /* Wake-up Enable */
        byte RSTA        :1;                                       /* Repeat START */
        byte TXAK        :1;                                       /* Transmit Acknowledge Enable */
        byte TX          :1;                                       /* Transmit Mode Select */
        byte MST         :1;                                       /* Master Mode Select */
        byte IICIE       :1;                                       /* IIC Interrupt Enable */
        byte IICEN       :1;                                       /* IIC Enable */
      } Bits;
    } IICC1STR;
    #define IICC1                       _IICC1.Byte
    #define IICC1_WUEN                  _IICC1.SameAddr_STR.IICC1STR.Bits.WUEN
    #define IICC1_RSTA                  _IICC1.SameAddr_STR.IICC1STR.Bits.RSTA
    #define IICC1_TXAK                  _IICC1.SameAddr_STR.IICC1STR.Bits.TXAK
    #define IICC1_TX                    _IICC1.SameAddr_STR.IICC1STR.Bits.TX
    #define IICC1_MST                   _IICC1.SameAddr_STR.IICC1STR.Bits.MST
    #define IICC1_IICIE                 _IICC1.SameAddr_STR.IICC1STR.Bits.IICIE
    #define IICC1_IICEN                 _IICC1.SameAddr_STR.IICC1STR.Bits.IICEN
    
    #define IICC1_WUEN_MASK             2U
    #define IICC1_RSTA_MASK             4U
    #define IICC1_TXAK_MASK             8U
    #define IICC1_TX_MASK               16U
    #define IICC1_MST_MASK              32U
    #define IICC1_IICIE_MASK            64U
    #define IICC1_IICEN_MASK            128U
    
    /*** IICC - IIC Control Register; Several registers at the same address ***/
    union {
      struct {
        byte             :1; 
        byte WUEN        :1;                                       /* Wake-up Enable */
        byte RSTA        :1;                                       /* Repeat START */
        byte TXAK        :1;                                       /* Transmit Acknowledge Enable */
        byte TX          :1;                                       /* Transmit Mode Select */
        byte MST         :1;                                       /* Master Mode Select */
        byte IICIE       :1;                                       /* IIC Interrupt Enable */
        byte IICEN       :1;                                       /* IIC Enable */
      } Bits;
    } IICCSTR;
    #define IICC                        _IICC1.Byte
    #define IICC_WUEN                   _IICC1.SameAddr_STR.IICCSTR.Bits.WUEN
    #define IICC_RSTA                   _IICC1.SameAddr_STR.IICCSTR.Bits.RSTA
    #define IICC_TXAK                   _IICC1.SameAddr_STR.IICCSTR.Bits.TXAK
    #define IICC_TX                     _IICC1.SameAddr_STR.IICCSTR.Bits.TX
    #define IICC_MST                    _IICC1.SameAddr_STR.IICCSTR.Bits.MST
    #define IICC_IICIE                  _IICC1.SameAddr_STR.IICCSTR.Bits.IICIE
    #define IICC_IICEN                  _IICC1.SameAddr_STR.IICCSTR.Bits.IICEN
    
    #define IICC_WUEN_MASK              2U
    #define IICC_RSTA_MASK              4U
    #define IICC_TXAK_MASK              8U
    #define IICC_TX_MASK                16U
    #define IICC_MST_MASK               32U
    #define IICC_IICIE_MASK             64U
    #define IICC_IICEN_MASK             128U
    
  } SameAddr_STR; /*Several registers at the same address */

} IICC1STR;
extern volatile IICC1STR _IICC1 @0xFFFF8042;


/*** IICS - IIC Status Register; 0xFFFF8043 ***/
typedef union {
  byte Byte;
  struct {
    byte RXAK        :1;                                       /* Receive Acknowledge */
    byte IICIF       :1;                                       /* IIC Interrupt Flag */
    byte SRW         :1;                                       /* Slave Read/Write */
    byte             :1; 
    byte ARBL        :1;                                       /* Arbitration Lost */
    byte BUSY        :1;                                       /* Bus Busy */
    byte IAAS        :1;                                       /* Addressed as a Slave */
    byte TCF         :1;                                       /* Transfer Complete Flag */
  } Bits;
} IICSSTR;
extern volatile IICSSTR _IICS @0xFFFF8043;
#define IICS                            _IICS.Byte
#define IICS_RXAK                       _IICS.Bits.RXAK
#define IICS_IICIF                      _IICS.Bits.IICIF
#define IICS_SRW                        _IICS.Bits.SRW
#define IICS_ARBL                       _IICS.Bits.ARBL
#define IICS_BUSY                       _IICS.Bits.BUSY
#define IICS_IAAS                       _IICS.Bits.IAAS
#define IICS_TCF                        _IICS.Bits.TCF

#define IICS_RXAK_MASK                  1U
#define IICS_IICIF_MASK                 2U
#define IICS_SRW_MASK                   4U
#define IICS_ARBL_MASK                  16U
#define IICS_BUSY_MASK                  32U
#define IICS_IAAS_MASK                  64U
#define IICS_TCF_MASK                   128U


/*** IICD - IIC Data I/O Register; 0xFFFF8044 ***/
typedef union {
  byte Byte;
  struct {
    byte DATA0       :1;                                       /* IIC Data Bit 0 */
    byte DATA1       :1;                                       /* IIC Data Bit 1 */
    byte DATA2       :1;                                       /* IIC Data Bit 2 */
    byte DATA3       :1;                                       /* IIC Data Bit 3 */
    byte DATA4       :1;                                       /* IIC Data Bit 4 */
    byte DATA5       :1;                                       /* IIC Data Bit 5 */
    byte DATA6       :1;                                       /* IIC Data Bit 6 */
    byte DATA7       :1;                                       /* IIC Data Bit 7 */
  } Bits;
} IICDSTR;
extern volatile IICDSTR _IICD @0xFFFF8044;
#define IICD                            _IICD.Byte
#define IICD_DATA0                      _IICD.Bits.DATA0
#define IICD_DATA1                      _IICD.Bits.DATA1
#define IICD_DATA2                      _IICD.Bits.DATA2
#define IICD_DATA3                      _IICD.Bits.DATA3
#define IICD_DATA4                      _IICD.Bits.DATA4
#define IICD_DATA5                      _IICD.Bits.DATA5
#define IICD_DATA6                      _IICD.Bits.DATA6
#define IICD_DATA7                      _IICD.Bits.DATA7

#define IICD_DATA0_MASK                 1U
#define IICD_DATA1_MASK                 2U
#define IICD_DATA2_MASK                 4U
#define IICD_DATA3_MASK                 8U
#define IICD_DATA4_MASK                 16U
#define IICD_DATA5_MASK                 32U
#define IICD_DATA6_MASK                 64U
#define IICD_DATA7_MASK                 128U


/*** IICC2 - IIC Control Register 2; 0xFFFF8045 ***/
typedef union {
  byte Byte;
  struct {
    byte AD8         :1;                                       /* Slave Address Bit 8 */
    byte AD9         :1;                                       /* Slave Address Bit 9 */
    byte AD10        :1;                                       /* Slave Address Bit 10 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte ADEXT       :1;                                       /* Address Extension */
    byte GCAEN       :1;                                       /* General Call Address Enable */
  } Bits;
  struct {
    byte grpAD_8 :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} IICC2STR;
extern volatile IICC2STR _IICC2 @0xFFFF8045;
#define IICC2                           _IICC2.Byte
#define IICC2_AD8                       _IICC2.Bits.AD8
#define IICC2_AD9                       _IICC2.Bits.AD9
#define IICC2_AD10                      _IICC2.Bits.AD10
#define IICC2_ADEXT                     _IICC2.Bits.ADEXT
#define IICC2_GCAEN                     _IICC2.Bits.GCAEN
#define IICC2_AD_8                      _IICC2.MergedBits.grpAD_8
#define IICC2_AD                        IICC2_AD_8

#define IICC2_AD8_MASK                  1U
#define IICC2_AD9_MASK                  2U
#define IICC2_AD10_MASK                 4U
#define IICC2_ADEXT_MASK                64U
#define IICC2_GCAEN_MASK                128U
#define IICC2_AD_8_MASK                 7U
#define IICC2_AD_8_BITNUM               0U


/*** IICFLT - IIC Filter register; 0xFFFF8046 ***/
typedef union {
  byte Byte;
  struct {
    byte FLT0        :1;                                       /* Filter value bit 0 */
    byte FLT1        :1;                                       /* Filter value bit 1 */
    byte FLT2        :1;                                       /* Filter value bit 2 */
    byte FLT3        :1;                                       /* Filter value bit 3 */
    byte FLT4        :1;                                       /* Filter value bit 4 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpFLT  :5;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} IICFLTSTR;
extern volatile IICFLTSTR _IICFLT @0xFFFF8046;
#define IICFLT                          _IICFLT.Byte
#define IICFLT_FLT0                     _IICFLT.Bits.FLT0
#define IICFLT_FLT1                     _IICFLT.Bits.FLT1
#define IICFLT_FLT2                     _IICFLT.Bits.FLT2
#define IICFLT_FLT3                     _IICFLT.Bits.FLT3
#define IICFLT_FLT4                     _IICFLT.Bits.FLT4
#define IICFLT_FLT                      _IICFLT.MergedBits.grpFLT

#define IICFLT_FLT0_MASK                1U
#define IICFLT_FLT1_MASK                2U
#define IICFLT_FLT2_MASK                4U
#define IICFLT_FLT3_MASK                8U
#define IICFLT_FLT4_MASK                16U
#define IICFLT_FLT_MASK                 31U
#define IICFLT_FLT_BITNUM               0U


/*** STOPCR - STOP Control Register; 0xFFFF8060 ***/
typedef union {
  byte Byte;
  struct {
    byte SCtoFC      :1;                                       /* Slow Clock to Fast Clock STOP Transition Enabled */
    byte NC          :1;                                       /* STOP Mode Enable for STOP With No Clock */
    byte SC          :1;                                       /* STOP Mode Enable for STOP With Slow Clock */
    byte FC          :1;                                       /* STOP Mode Enable for STOP With Fast Clock */
    byte SIM_CLK_EN  :1;                                       /* Clock Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} STOPCRSTR;
extern volatile STOPCRSTR _STOPCR @0xFFFF8060;
#define STOPCR                          _STOPCR.Byte
#define STOPCR_SCtoFC                   _STOPCR.Bits.SCtoFC
#define STOPCR_NC                       _STOPCR.Bits.NC
#define STOPCR_SC                       _STOPCR.Bits.SC
#define STOPCR_FC                       _STOPCR.Bits.FC
#define STOPCR_SIM_CLK_EN               _STOPCR.Bits.SIM_CLK_EN

#define STOPCR_SCtoFC_MASK              1U
#define STOPCR_NC_MASK                  2U
#define STOPCR_SC_MASK                  4U
#define STOPCR_FC_MASK                  8U
#define STOPCR_SIM_CLK_EN_MASK          16U


/*** FCSR - Frame Control & Status Register; 0xFFFF8061 ***/
typedef union {
  byte Byte;
  struct {
    byte SF          :1;                                       /* Start Frame */
    byte SFDIE       :1;                                       /* Start FD Interrupt Enable */
    byte FE          :1;                                       /* Frame Error */
    byte SFEIE       :2;                                       /* Start Frame Error Interrupt Enable */
    byte A_EN        :1;                                       /* FA Enable */
    byte             :1; 
    byte             :1; 
  } Bits;
} FCSRSTR;
extern volatile FCSRSTR _FCSR @0xFFFF8061;
#define FCSR                            _FCSR.Byte
#define FCSR_SF                         _FCSR.Bits.SF
#define FCSR_SFDIE                      _FCSR.Bits.SFDIE
#define FCSR_FE                         _FCSR.Bits.FE
#define FCSR_SFEIE                      _FCSR.Bits.SFEIE
#define FCSR_A_EN                       _FCSR.Bits.A_EN

#define FCSR_SF_MASK                    1U
#define FCSR_SFDIE_MASK                 2U
#define FCSR_FE_MASK                    4U
#define FCSR_SFEIE_MASK                 24U
#define FCSR_SFEIE_BITNUM               3U
#define FCSR_A_EN_MASK                  32U


/*** RCSR - Reset Control & Status Register; 0xFFFF8062 ***/
typedef union {
  byte Byte;
  struct {
    byte POR         :1;                                       /* STOP Mode Enable for STOP With Fast Clock */
    byte PIN         :1;                                       /* External Pin Reset */
    byte ILAD        :1;                                       /* Illegal Address Reset */
    byte ILOP        :1;                                       /* Illegal Opcode Reset */
    byte SW          :1;                                       /* Software Reset */
    byte ASR         :1;                                       /* Assert Software Reset */
    byte DR          :1;                                       /* Drive Reset Pin */
    byte             :1; 
  } Bits;
} RCSRSTR;
extern volatile RCSRSTR _RCSR @0xFFFF8062;
#define RCSR                            _RCSR.Byte
#define RCSR_POR                        _RCSR.Bits.POR
#define RCSR_PIN                        _RCSR.Bits.PIN
#define RCSR_ILAD                       _RCSR.Bits.ILAD
#define RCSR_ILOP                       _RCSR.Bits.ILOP
#define RCSR_SW                         _RCSR.Bits.SW
#define RCSR_ASR                        _RCSR.Bits.ASR
#define RCSR_DR                         _RCSR.Bits.DR

#define RCSR_POR_MASK                   1U
#define RCSR_PIN_MASK                   2U
#define RCSR_ILAD_MASK                  4U
#define RCSR_ILOP_MASK                  8U
#define RCSR_SW_MASK                    16U
#define RCSR_ASR_MASK                   32U
#define RCSR_DR_MASK                    64U


/*** PCESFC0 - Peripheral Clock in STOPFC Mode Enable  Register 0; 0xFFFF8064 ***/
typedef union {
  byte Byte;
  struct {
    byte FLSH        :1;                                       /* Flash Controller Clock Enable */
    byte PCTRL       :1;                                       /* Port Control Clock Enable */
    byte AFE         :1;                                       /* Analog Front End Clock Enable */
    byte IRQ         :1;                                       /* IRQ Clock Enable */
    byte T0          :1;                                       /* Timer 0 Clock Enable */
    byte T1          :1;                                       /* Timer 1 Clock Enable */
    byte T2          :1;                                       /* Timer 2 Clock Enable */
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpT    :3;
    byte         :1;
  } MergedBits;
} PCESFC0STR;
extern volatile PCESFC0STR _PCESFC0 @0xFFFF8064;
#define PCESFC0                         _PCESFC0.Byte
#define PCESFC0_FLSH                    _PCESFC0.Bits.FLSH
#define PCESFC0_PCTRL                   _PCESFC0.Bits.PCTRL
#define PCESFC0_AFE                     _PCESFC0.Bits.AFE
#define PCESFC0_IRQ                     _PCESFC0.Bits.IRQ
#define PCESFC0_T0                      _PCESFC0.Bits.T0
#define PCESFC0_T1                      _PCESFC0.Bits.T1
#define PCESFC0_T2                      _PCESFC0.Bits.T2
/* PCESFC_ARR: Access 2 PCESFCx registers in an array */
#define PCESFC_ARR                      ((volatile byte *) &PCESFC0)
#define PCESFC0_T                       _PCESFC0.MergedBits.grpT

#define PCESFC0_FLSH_MASK               1U
#define PCESFC0_PCTRL_MASK              2U
#define PCESFC0_AFE_MASK                4U
#define PCESFC0_IRQ_MASK                8U
#define PCESFC0_T0_MASK                 16U
#define PCESFC0_T1_MASK                 32U
#define PCESFC0_T2_MASK                 64U
#define PCESFC0_T_MASK                  112U
#define PCESFC0_T_BITNUM                4U


/*** PCESFC1 - Peripheral Clock in STOPFC Mode Enable  Register 0; 0xFFFF8065 ***/
typedef union {
  byte Byte;
  struct {
    byte SLAVE       :1;                                       /* Slave Port Clock Enable */
    byte MI2C        :1;                                       /* Master I2C Clock Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} PCESFC1STR;
extern volatile PCESFC1STR _PCESFC1 @0xFFFF8065;
#define PCESFC1                         _PCESFC1.Byte
#define PCESFC1_SLAVE                   _PCESFC1.Bits.SLAVE
#define PCESFC1_MI2C                    _PCESFC1.Bits.MI2C

#define PCESFC1_SLAVE_MASK              1U
#define PCESFC1_MI2C_MASK               2U


/*** PCESSC0 - Peripheral Clock in STOPSC Mode Enable  Register 0; 0xFFFF8066 ***/
typedef union {
  byte Byte;
  struct {
    byte FLSH        :1;                                       /* Flash Controller Clock Enable */
    byte PCTRL       :1;                                       /* Port Control Clock Enable */
    byte AFE         :1;                                       /* Analog Front End Clock Enable */
    byte IRQ         :1;                                       /* IRQ Clock Enable */
    byte T0          :1;                                       /* Timer 0 Clock Enable */
    byte T1          :1;                                       /* Timer 1 Clock Enable */
    byte T2          :1;                                       /* Timer 2 Clock Enable */
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpT    :3;
    byte         :1;
  } MergedBits;
} PCESSC0STR;
extern volatile PCESSC0STR _PCESSC0 @0xFFFF8066;
#define PCESSC0                         _PCESSC0.Byte
#define PCESSC0_FLSH                    _PCESSC0.Bits.FLSH
#define PCESSC0_PCTRL                   _PCESSC0.Bits.PCTRL
#define PCESSC0_AFE                     _PCESSC0.Bits.AFE
#define PCESSC0_IRQ                     _PCESSC0.Bits.IRQ
#define PCESSC0_T0                      _PCESSC0.Bits.T0
#define PCESSC0_T1                      _PCESSC0.Bits.T1
#define PCESSC0_T2                      _PCESSC0.Bits.T2
/* PCESSC_ARR: Access 2 PCESSCx registers in an array */
#define PCESSC_ARR                      ((volatile byte *) &PCESSC0)
#define PCESSC0_T                       _PCESSC0.MergedBits.grpT

#define PCESSC0_FLSH_MASK               1U
#define PCESSC0_PCTRL_MASK              2U
#define PCESSC0_AFE_MASK                4U
#define PCESSC0_IRQ_MASK                8U
#define PCESSC0_T0_MASK                 16U
#define PCESSC0_T1_MASK                 32U
#define PCESSC0_T2_MASK                 64U
#define PCESSC0_T_MASK                  112U
#define PCESSC0_T_BITNUM                4U


/*** PCESSC1 - Peripheral Clock in STOPSC Mode Enable  Register 0; 0xFFFF8067 ***/
typedef union {
  byte Byte;
  struct {
    byte SLAVE       :1;                                       /* Slave Port Clock Enable */
    byte MI2C        :1;                                       /* Master I2C Clock Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} PCESSC1STR;
extern volatile PCESSC1STR _PCESSC1 @0xFFFF8067;
#define PCESSC1                         _PCESSC1.Byte
#define PCESSC1_SLAVE                   _PCESSC1.Bits.SLAVE
#define PCESSC1_MI2C                    _PCESSC1.Bits.MI2C

#define PCESSC1_SLAVE_MASK              1U
#define PCESSC1_MI2C_MASK               2U


/*** PCERUN0 - Peripheral Clock in RUN Mode Enable  Register 0; 0xFFFF8068 ***/
typedef union {
  byte Byte;
  struct {
    byte FLSH        :1;                                       /* Flash Controller Clock Enable */
    byte PCTRL       :1;                                       /* Port Control Clock Enable */
    byte AFE         :1;                                       /* Analog Front End Clock Enable */
    byte IRQ         :1;                                       /* IRQ Clock Enable */
    byte T0          :1;                                       /* Timer 0 Clock Enable */
    byte T1          :1;                                       /* Timer 1 Clock Enable */
    byte T2          :1;                                       /* Timer 2 Clock Enable */
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpT    :3;
    byte         :1;
  } MergedBits;
} PCERUN0STR;
extern volatile PCERUN0STR _PCERUN0 @0xFFFF8068;
#define PCERUN0                         _PCERUN0.Byte
#define PCERUN0_FLSH                    _PCERUN0.Bits.FLSH
#define PCERUN0_PCTRL                   _PCERUN0.Bits.PCTRL
#define PCERUN0_AFE                     _PCERUN0.Bits.AFE
#define PCERUN0_IRQ                     _PCERUN0.Bits.IRQ
#define PCERUN0_T0                      _PCERUN0.Bits.T0
#define PCERUN0_T1                      _PCERUN0.Bits.T1
#define PCERUN0_T2                      _PCERUN0.Bits.T2
/* PCERUN_ARR: Access 2 PCERUNx registers in an array */
#define PCERUN_ARR                      ((volatile byte *) &PCERUN0)
#define PCERUN0_T                       _PCERUN0.MergedBits.grpT

#define PCERUN0_FLSH_MASK               1U
#define PCERUN0_PCTRL_MASK              2U
#define PCERUN0_AFE_MASK                4U
#define PCERUN0_IRQ_MASK                8U
#define PCERUN0_T0_MASK                 16U
#define PCERUN0_T1_MASK                 32U
#define PCERUN0_T2_MASK                 64U
#define PCERUN0_T_MASK                  112U
#define PCERUN0_T_BITNUM                4U


/*** PCERUN1 - Peripheral Clock in RUN Mode Enable  Register 0; 0xFFFF8069 ***/
typedef union {
  byte Byte;
  struct {
    byte SLAVE       :1;                                       /* Slave Port Clock Enable */
    byte MI2C        :1;                                       /* Master I2C Clock Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} PCERUN1STR;
extern volatile PCERUN1STR _PCERUN1 @0xFFFF8069;
#define PCERUN1                         _PCERUN1.Byte
#define PCERUN1_SLAVE                   _PCERUN1.Bits.SLAVE
#define PCERUN1_MI2C                    _PCERUN1.Bits.MI2C

#define PCERUN1_SLAVE_MASK              1U
#define PCERUN1_MI2C_MASK               2U


/*** PMCR0 - Pin Mux Control Register 0; 0xFFFF806A ***/
typedef union {
  byte Byte;
  struct {
    byte A4          :1;                                       /* RGPIO Bit 4 Pin Function Select */
    byte             :1; 
    byte A6          :2;                                       /* RGPIO Bit 6 Pin Function Select */
    byte A7          :2;                                       /* RGPIO Bit 7 Pin Function Select */
    byte A8          :1;                                       /* RGPIO Bit 8 Pin Function Select */
    byte A9          :1;                                       /* RGPIO Bit 9 Pin Function Select */
  } Bits;
  struct {
    byte grpA_4  :1;
    byte         :1;
    byte         :2;
    byte         :2;
    byte grpA_8  :2;
  } MergedBits;
} PMCR0STR;
extern volatile PMCR0STR _PMCR0 @0xFFFF806A;
#define PMCR0                           _PMCR0.Byte
#define PMCR0_A4                        _PMCR0.Bits.A4
#define PMCR0_A6                        _PMCR0.Bits.A6
#define PMCR0_A7                        _PMCR0.Bits.A7
#define PMCR0_A8                        _PMCR0.Bits.A8
#define PMCR0_A9                        _PMCR0.Bits.A9
/* PMCR_ARR: Access 3 PMCRx registers in an array */
#define PMCR_ARR                        ((volatile byte *) &PMCR0)
#define PMCR0_A_8                       _PMCR0.MergedBits.grpA_8
#define PMCR0_A                         PMCR0_A_8

#define PMCR0_A4_MASK                   1U
#define PMCR0_A6_MASK                   12U
#define PMCR0_A6_BITNUM                 2U
#define PMCR0_A7_MASK                   48U
#define PMCR0_A7_BITNUM                 4U
#define PMCR0_A8_MASK                   64U
#define PMCR0_A9_MASK                   128U
#define PMCR0_A_8_MASK                  192U
#define PMCR0_A_8_BITNUM                6U


/*** PMCR1 - Pin Mux Control Register 1; 0xFFFF806B ***/
typedef union {
  byte Byte;
  struct {
    byte A0          :2;                                       /* RGPIO Bit 0 Pin Function Select */
    byte A1          :2;                                       /* RGPIO Bit 1 Pin Function Select */
    byte A2          :2;                                       /* RGPIO Bit 2 Pin Function Select */
    byte A3          :2;                                       /* RGPIO Bit 3 Pin Function Select */
  } Bits;
} PMCR1STR;
extern volatile PMCR1STR _PMCR1 @0xFFFF806B;
#define PMCR1                           _PMCR1.Byte
#define PMCR1_A0                        _PMCR1.Bits.A0
#define PMCR1_A1                        _PMCR1.Bits.A1
#define PMCR1_A2                        _PMCR1.Bits.A2
#define PMCR1_A3                        _PMCR1.Bits.A3

#define PMCR1_A0_MASK                   3U
#define PMCR1_A0_BITNUM                 0U
#define PMCR1_A1_MASK                   12U
#define PMCR1_A1_BITNUM                 2U
#define PMCR1_A2_MASK                   48U
#define PMCR1_A2_BITNUM                 4U
#define PMCR1_A3_MASK                   192U
#define PMCR1_A3_BITNUM                 6U


/*** PMCR2 - Pin Mux Control Register 2; 0xFFFF806C ***/
typedef union {
  byte Byte;
  struct {
    byte A5          :2;                                       /* RGPIO Bit 5 Pin Function Select */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} PMCR2STR;
extern volatile PMCR2STR _PMCR2 @0xFFFF806C;
#define PMCR2                           _PMCR2.Byte
#define PMCR2_A5                        _PMCR2.Bits.A5

#define PMCR2_A5_MASK                   3U
#define PMCR2_A5_BITNUM                 0U


/*** CK_OSCTRL - Oscillator Control Registerr; 0xFFFF8080 ***/
typedef union {
  byte Byte;
  struct {
    byte FLE         :5;                                       /* Frame Length Exponent */
    byte FFSEN       :1;                                       /* Fixed Frequency Clock STOP Enable */
    byte FFCEN       :1;                                       /* Fixed Frequency Clock Enable */
    byte FCEN        :1;                                       /* Frame Counter Enable */
  } Bits;
} CK_OSCTRLSTR;
extern volatile CK_OSCTRLSTR _CK_OSCTRL @0xFFFF8080;
#define CK_OSCTRL                       _CK_OSCTRL.Byte
#define CK_OSCTRL_FLE                   _CK_OSCTRL.Bits.FLE
#define CK_OSCTRL_FFSEN                 _CK_OSCTRL.Bits.FFSEN
#define CK_OSCTRL_FFCEN                 _CK_OSCTRL.Bits.FFCEN
#define CK_OSCTRL_FCEN                  _CK_OSCTRL.Bits.FCEN

#define CK_OSCTRL_FLE_MASK              31U
#define CK_OSCTRL_FLE_BITNUM            0U
#define CK_OSCTRL_FFSEN_MASK            32U
#define CK_OSCTRL_FFCEN_MASK            64U
#define CK_OSCTRL_FCEN_MASK             128U


/*** MTIM16SC - MTIM16 Status and Control Register; 0xFFFF80A0 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TSTP        :1;                                       /* MTIM16 Counter Stop */
    byte TRST        :1;                                       /* MTIM16 Counter Reset */
    byte TOIE        :1;                                       /* MTIM16 Overflow Interrupt Enable */
    byte TOF         :1;                                       /* MTIM16 Overflow Flag */
  } Bits;
} MTIM16SCSTR;
extern volatile MTIM16SCSTR _MTIM16SC @0xFFFF80A0;
#define MTIM16SC                        _MTIM16SC.Byte
#define MTIM16SC_TSTP                   _MTIM16SC.Bits.TSTP
#define MTIM16SC_TRST                   _MTIM16SC.Bits.TRST
#define MTIM16SC_TOIE                   _MTIM16SC.Bits.TOIE
#define MTIM16SC_TOF                    _MTIM16SC.Bits.TOF

#define MTIM16SC_TSTP_MASK              16U
#define MTIM16SC_TRST_MASK              32U
#define MTIM16SC_TOIE_MASK              64U
#define MTIM16SC_TOF_MASK               128U


/*** MTIM16CLK - MTIM16 Clock Configuration Register; 0xFFFF80A1 ***/
typedef union {
  byte Byte;
  struct {
    byte PS0         :1;                                       /* Clock source Prescaler Bit 0 */
    byte PS1         :1;                                       /* Clock source Prescaler Bit 1 */
    byte PS2         :1;                                       /* Clock source Prescaler Bit 2 */
    byte PS3         :1;                                       /* Clock source Prescaler Bit 3 */
    byte CLKS0       :1;                                       /* Clock source Select Bit 0 */
    byte CLKS1       :1;                                       /* Clock source Select Bit 1 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPS   :4;
    byte grpCLKS :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} MTIM16CLKSTR;
extern volatile MTIM16CLKSTR _MTIM16CLK @0xFFFF80A1;
#define MTIM16CLK                       _MTIM16CLK.Byte
#define MTIM16CLK_PS0                   _MTIM16CLK.Bits.PS0
#define MTIM16CLK_PS1                   _MTIM16CLK.Bits.PS1
#define MTIM16CLK_PS2                   _MTIM16CLK.Bits.PS2
#define MTIM16CLK_PS3                   _MTIM16CLK.Bits.PS3
#define MTIM16CLK_CLKS0                 _MTIM16CLK.Bits.CLKS0
#define MTIM16CLK_CLKS1                 _MTIM16CLK.Bits.CLKS1
#define MTIM16CLK_PS                    _MTIM16CLK.MergedBits.grpPS
#define MTIM16CLK_CLKS                  _MTIM16CLK.MergedBits.grpCLKS

#define MTIM16CLK_PS0_MASK              1U
#define MTIM16CLK_PS1_MASK              2U
#define MTIM16CLK_PS2_MASK              4U
#define MTIM16CLK_PS3_MASK              8U
#define MTIM16CLK_CLKS0_MASK            16U
#define MTIM16CLK_CLKS1_MASK            32U
#define MTIM16CLK_PS_MASK               15U
#define MTIM16CLK_PS_BITNUM             0U
#define MTIM16CLK_CLKS_MASK             48U
#define MTIM16CLK_CLKS_BITNUM           4U


/*** MTIM16CNT - MTIM16 Counter Register; 0xFFFF80A2 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** MTIM16CNTH - MTIM16 Counter Register High; 0xFFFF80A2 ***/
    union {
      byte Byte;
    } MTIM16CNTHSTR;
    #define MTIM16CNTH                  _MTIM16CNT.Overlap_STR.MTIM16CNTHSTR.Byte
    

    /*** MTIM16CNTL - MTIM16 Counter Register Low; 0xFFFF80A3 ***/
    union {
      byte Byte;
    } MTIM16CNTLSTR;
    #define MTIM16CNTL                  _MTIM16CNT.Overlap_STR.MTIM16CNTLSTR.Byte
    
  } Overlap_STR;

} MTIM16CNTSTR;
extern volatile MTIM16CNTSTR _MTIM16CNT @0xFFFF80A2;
#define MTIM16CNT                       _MTIM16CNT.Word


/*** MTIM16MOD - MTIM16 Modulo Register; 0xFFFF80A4 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** MTIM16MODH - MTIM16 Modulo Register High; 0xFFFF80A4 ***/
    union {
      byte Byte;
    } MTIM16MODHSTR;
    #define MTIM16MODH                  _MTIM16MOD.Overlap_STR.MTIM16MODHSTR.Byte
    

    /*** MTIM16MODL - MTIM16 Modulo Register Low; 0xFFFF80A5 ***/
    union {
      byte Byte;
    } MTIM16MODLSTR;
    #define MTIM16MODL                  _MTIM16MOD.Overlap_STR.MTIM16MODLSTR.Byte
    
  } Overlap_STR;

} MTIM16MODSTR;
extern volatile MTIM16MODSTR _MTIM16MOD @0xFFFF80A4;
#define MTIM16MOD                       _MTIM16MOD.Word


/*** IRQSC - Interrupt request status and control register; 0xFFFF80C0 ***/
typedef union {
  byte Byte;
  struct {
    byte IRQMOD      :1;                                       /* IRQ Detection Mode */
    byte IRQIE       :1;                                       /* IRQ Interrupt Enable */
    byte IRQACK      :1;                                       /* IRQ Acknowledge */
    byte IRQF        :1;                                       /* IRQ Flag */
    byte IRQPE       :1;                                       /* IRQ Pin Enable */
    byte IRQEDG      :1;                                       /* IRQ Edge Select */
    byte IRQPDD      :1;                                       /* IRQ Pull Device Disable */
    byte             :1; 
  } Bits;
} IRQSCSTR;
extern volatile IRQSCSTR _IRQSC @0xFFFF80C0;
#define IRQSC                           _IRQSC.Byte
#define IRQSC_IRQMOD                    _IRQSC.Bits.IRQMOD
#define IRQSC_IRQIE                     _IRQSC.Bits.IRQIE
#define IRQSC_IRQACK                    _IRQSC.Bits.IRQACK
#define IRQSC_IRQF                      _IRQSC.Bits.IRQF
#define IRQSC_IRQPE                     _IRQSC.Bits.IRQPE
#define IRQSC_IRQEDG                    _IRQSC.Bits.IRQEDG
#define IRQSC_IRQPDD                    _IRQSC.Bits.IRQPDD

#define IRQSC_IRQMOD_MASK               1U
#define IRQSC_IRQIE_MASK                2U
#define IRQSC_IRQACK_MASK               4U
#define IRQSC_IRQF_MASK                 8U
#define IRQSC_IRQPE_MASK                16U
#define IRQSC_IRQEDG_MASK               32U
#define IRQSC_IRQPDD_MASK               64U


/*** PC0PE - Pull Enable Register; 0xFFFF80E0 ***/
typedef union {
  byte Byte;
  struct {
    byte PE0         :1;                                       /* Internal Pull Enable, bit 0 */
    byte PE1         :1;                                       /* Internal Pull Enable, bit 1 */
    byte PE2         :1;                                       /* Internal Pull Enable, bit 2 */
    byte PE3         :1;                                       /* Internal Pull Enable, bit 3 */
    byte PE4         :1;                                       /* Internal Pull Enable, bit 4 */
    byte PE5         :1;                                       /* Internal Pull Enable, bit 5 */
    byte PE6         :1;                                       /* Internal Pull Enable, bit 6 */
    byte PE7         :1;                                       /* Internal Pull Enable, bit 7 */
  } Bits;
} PC0PESTR;
extern volatile PC0PESTR _PC0PE @0xFFFF80E0;
#define PC0PE                           _PC0PE.Byte
#define PC0PE_PE0                       _PC0PE.Bits.PE0
#define PC0PE_PE1                       _PC0PE.Bits.PE1
#define PC0PE_PE2                       _PC0PE.Bits.PE2
#define PC0PE_PE3                       _PC0PE.Bits.PE3
#define PC0PE_PE4                       _PC0PE.Bits.PE4
#define PC0PE_PE5                       _PC0PE.Bits.PE5
#define PC0PE_PE6                       _PC0PE.Bits.PE6
#define PC0PE_PE7                       _PC0PE.Bits.PE7

#define PC0PE_PE0_MASK                  1U
#define PC0PE_PE1_MASK                  2U
#define PC0PE_PE2_MASK                  4U
#define PC0PE_PE3_MASK                  8U
#define PC0PE_PE4_MASK                  16U
#define PC0PE_PE5_MASK                  32U
#define PC0PE_PE6_MASK                  64U
#define PC0PE_PE7_MASK                  128U


/*** PC0SE - Slew Rate Enable Register; 0xFFFF80E1 ***/
typedef union {
  byte Byte;
  struct {
    byte SE0         :1;                                       /* Output Slew Rate Enable, bit 0 */
    byte SE1         :1;                                       /* Output Slew Rate Enable, bit 1 */
    byte SE2         :1;                                       /* Output Slew Rate Enable, bit 2 */
    byte SE3         :1;                                       /* Output Slew Rate Enable, bit 3 */
    byte SE4         :1;                                       /* Output Slew Rate Enable, bit 4 */
    byte SE5         :1;                                       /* Output Slew Rate Enable, bit 5 */
    byte SE6         :1;                                       /* Output Slew Rate Enable, bit 6 */
    byte SE7         :1;                                       /* Output Slew Rate Enable, bit 7 */
  } Bits;
} PC0SESTR;
extern volatile PC0SESTR _PC0SE @0xFFFF80E1;
#define PC0SE                           _PC0SE.Byte
#define PC0SE_SE0                       _PC0SE.Bits.SE0
#define PC0SE_SE1                       _PC0SE.Bits.SE1
#define PC0SE_SE2                       _PC0SE.Bits.SE2
#define PC0SE_SE3                       _PC0SE.Bits.SE3
#define PC0SE_SE4                       _PC0SE.Bits.SE4
#define PC0SE_SE5                       _PC0SE.Bits.SE5
#define PC0SE_SE6                       _PC0SE.Bits.SE6
#define PC0SE_SE7                       _PC0SE.Bits.SE7

#define PC0SE_SE0_MASK                  1U
#define PC0SE_SE1_MASK                  2U
#define PC0SE_SE2_MASK                  4U
#define PC0SE_SE3_MASK                  8U
#define PC0SE_SE4_MASK                  16U
#define PC0SE_SE5_MASK                  32U
#define PC0SE_SE6_MASK                  64U
#define PC0SE_SE7_MASK                  128U


/*** PC0DS - Drive Strength Selection Register; 0xFFFF80E2 ***/
typedef union {
  byte Byte;
  struct {
    byte DS0         :1;                                       /* Output Drive Strength Selection, bit 0 */
    byte DS1         :1;                                       /* Output Drive Strength Selection, bit 1 */
    byte DS2         :1;                                       /* Output Drive Strength Selection, bit 2 */
    byte DS3         :1;                                       /* Output Drive Strength Selection, bit 3 */
    byte DS4         :1;                                       /* Output Drive Strength Selection, bit 4 */
    byte DS5         :1;                                       /* Output Drive Strength Selection, bit 5 */
    byte DS6         :1;                                       /* Output Drive Strength Selection, bit 6 */
    byte DS7         :1;                                       /* Output Drive Strength Selection, bit 7 */
  } Bits;
} PC0DSSTR;
extern volatile PC0DSSTR _PC0DS @0xFFFF80E2;
#define PC0DS                           _PC0DS.Byte
#define PC0DS_DS0                       _PC0DS.Bits.DS0
#define PC0DS_DS1                       _PC0DS.Bits.DS1
#define PC0DS_DS2                       _PC0DS.Bits.DS2
#define PC0DS_DS3                       _PC0DS.Bits.DS3
#define PC0DS_DS4                       _PC0DS.Bits.DS4
#define PC0DS_DS5                       _PC0DS.Bits.DS5
#define PC0DS_DS6                       _PC0DS.Bits.DS6
#define PC0DS_DS7                       _PC0DS.Bits.DS7

#define PC0DS_DS0_MASK                  1U
#define PC0DS_DS1_MASK                  2U
#define PC0DS_DS2_MASK                  4U
#define PC0DS_DS3_MASK                  8U
#define PC0DS_DS4_MASK                  16U
#define PC0DS_DS5_MASK                  32U
#define PC0DS_DS6_MASK                  64U
#define PC0DS_DS7_MASK                  128U


/*** PC0IFE - Input Filter Enable Register; 0xFFFF80E3 ***/
typedef union {
  byte Byte;
  struct {
    byte IFE0        :1;                                       /* Input Filter Enable, bit 0 */
    byte IFE1        :1;                                       /* Input Filter Enable, bit 1 */
    byte IFE2        :1;                                       /* Input Filter Enable, bit 2 */
    byte IFE3        :1;                                       /* Input Filter Enable, bit 3 */
    byte IFE4        :1;                                       /* Input Filter Enable, bit 4 */
    byte IFE5        :1;                                       /* Input Filter Enable, bit 5 */
    byte IFE6        :1;                                       /* Input Filter Enable, bit 6 */
    byte IFE7        :1;                                       /* Input Filter Enable, bit 7 */
  } Bits;
} PC0IFESTR;
extern volatile PC0IFESTR _PC0IFE @0xFFFF80E3;
#define PC0IFE                          _PC0IFE.Byte
#define PC0IFE_IFE0                     _PC0IFE.Bits.IFE0
#define PC0IFE_IFE1                     _PC0IFE.Bits.IFE1
#define PC0IFE_IFE2                     _PC0IFE.Bits.IFE2
#define PC0IFE_IFE3                     _PC0IFE.Bits.IFE3
#define PC0IFE_IFE4                     _PC0IFE.Bits.IFE4
#define PC0IFE_IFE5                     _PC0IFE.Bits.IFE5
#define PC0IFE_IFE6                     _PC0IFE.Bits.IFE6
#define PC0IFE_IFE7                     _PC0IFE.Bits.IFE7

#define PC0IFE_IFE0_MASK                1U
#define PC0IFE_IFE1_MASK                2U
#define PC0IFE_IFE2_MASK                4U
#define PC0IFE_IFE3_MASK                8U
#define PC0IFE_IFE4_MASK                16U
#define PC0IFE_IFE5_MASK                32U
#define PC0IFE_IFE6_MASK                64U
#define PC0IFE_IFE7_MASK                128U


/*** PC1PE - Pull Enable Register; 0xFFFF8100 ***/
typedef union {
  byte Byte;
  struct {
    byte PE0         :1;                                       /* Internal Pull Enable, bit 0 */
    byte PE1         :1;                                       /* Internal Pull Enable, bit 1 */
    byte PE2         :1;                                       /* Internal Pull Enable, bit 2 */
    byte PE3         :1;                                       /* Internal Pull Enable, bit 3 */
    byte PE4         :1;                                       /* Internal Pull Enable, bit 4 */
    byte PE5         :1;                                       /* Internal Pull Enable, bit 5 */
    byte PE6         :1;                                       /* Internal Pull Enable, bit 6 */
    byte PE7         :1;                                       /* Internal Pull Enable, bit 7 */
  } Bits;
} PC1PESTR;
extern volatile PC1PESTR _PC1PE @0xFFFF8100;
#define PC1PE                           _PC1PE.Byte
#define PC1PE_PE0                       _PC1PE.Bits.PE0
#define PC1PE_PE1                       _PC1PE.Bits.PE1
#define PC1PE_PE2                       _PC1PE.Bits.PE2
#define PC1PE_PE3                       _PC1PE.Bits.PE3
#define PC1PE_PE4                       _PC1PE.Bits.PE4
#define PC1PE_PE5                       _PC1PE.Bits.PE5
#define PC1PE_PE6                       _PC1PE.Bits.PE6
#define PC1PE_PE7                       _PC1PE.Bits.PE7

#define PC1PE_PE0_MASK                  1U
#define PC1PE_PE1_MASK                  2U
#define PC1PE_PE2_MASK                  4U
#define PC1PE_PE3_MASK                  8U
#define PC1PE_PE4_MASK                  16U
#define PC1PE_PE5_MASK                  32U
#define PC1PE_PE6_MASK                  64U
#define PC1PE_PE7_MASK                  128U


/*** PC1SE - Slew Rate Enable Register; 0xFFFF8101 ***/
typedef union {
  byte Byte;
  struct {
    byte SE0         :1;                                       /* Output Slew Rate Enable, bit 0 */
    byte SE1         :1;                                       /* Output Slew Rate Enable, bit 1 */
    byte SE2         :1;                                       /* Output Slew Rate Enable, bit 2 */
    byte SE3         :1;                                       /* Output Slew Rate Enable, bit 3 */
    byte SE4         :1;                                       /* Output Slew Rate Enable, bit 4 */
    byte SE5         :1;                                       /* Output Slew Rate Enable, bit 5 */
    byte SE6         :1;                                       /* Output Slew Rate Enable, bit 6 */
    byte SE7         :1;                                       /* Output Slew Rate Enable, bit 7 */
  } Bits;
} PC1SESTR;
extern volatile PC1SESTR _PC1SE @0xFFFF8101;
#define PC1SE                           _PC1SE.Byte
#define PC1SE_SE0                       _PC1SE.Bits.SE0
#define PC1SE_SE1                       _PC1SE.Bits.SE1
#define PC1SE_SE2                       _PC1SE.Bits.SE2
#define PC1SE_SE3                       _PC1SE.Bits.SE3
#define PC1SE_SE4                       _PC1SE.Bits.SE4
#define PC1SE_SE5                       _PC1SE.Bits.SE5
#define PC1SE_SE6                       _PC1SE.Bits.SE6
#define PC1SE_SE7                       _PC1SE.Bits.SE7

#define PC1SE_SE0_MASK                  1U
#define PC1SE_SE1_MASK                  2U
#define PC1SE_SE2_MASK                  4U
#define PC1SE_SE3_MASK                  8U
#define PC1SE_SE4_MASK                  16U
#define PC1SE_SE5_MASK                  32U
#define PC1SE_SE6_MASK                  64U
#define PC1SE_SE7_MASK                  128U


/*** PC1DS - Drive Strength Selection Register; 0xFFFF8102 ***/
typedef union {
  byte Byte;
  struct {
    byte DS0         :1;                                       /* Output Drive Strength Selection, bit 0 */
    byte DS1         :1;                                       /* Output Drive Strength Selection, bit 1 */
    byte DS2         :1;                                       /* Output Drive Strength Selection, bit 2 */
    byte DS3         :1;                                       /* Output Drive Strength Selection, bit 3 */
    byte DS4         :1;                                       /* Output Drive Strength Selection, bit 4 */
    byte DS5         :1;                                       /* Output Drive Strength Selection, bit 5 */
    byte DS6         :1;                                       /* Output Drive Strength Selection, bit 6 */
    byte DS7         :1;                                       /* Output Drive Strength Selection, bit 7 */
  } Bits;
} PC1DSSTR;
extern volatile PC1DSSTR _PC1DS @0xFFFF8102;
#define PC1DS                           _PC1DS.Byte
#define PC1DS_DS0                       _PC1DS.Bits.DS0
#define PC1DS_DS1                       _PC1DS.Bits.DS1
#define PC1DS_DS2                       _PC1DS.Bits.DS2
#define PC1DS_DS3                       _PC1DS.Bits.DS3
#define PC1DS_DS4                       _PC1DS.Bits.DS4
#define PC1DS_DS5                       _PC1DS.Bits.DS5
#define PC1DS_DS6                       _PC1DS.Bits.DS6
#define PC1DS_DS7                       _PC1DS.Bits.DS7

#define PC1DS_DS0_MASK                  1U
#define PC1DS_DS1_MASK                  2U
#define PC1DS_DS2_MASK                  4U
#define PC1DS_DS3_MASK                  8U
#define PC1DS_DS4_MASK                  16U
#define PC1DS_DS5_MASK                  32U
#define PC1DS_DS6_MASK                  64U
#define PC1DS_DS7_MASK                  128U


/*** PC1IFE - Input Filter Enable Register; 0xFFFF8103 ***/
typedef union {
  byte Byte;
  struct {
    byte IFE0        :1;                                       /* Input Filter Enable, bit 0 */
    byte IFE1        :1;                                       /* Input Filter Enable, bit 1 */
    byte IFE2        :1;                                       /* Input Filter Enable, bit 2 */
    byte IFE3        :1;                                       /* Input Filter Enable, bit 3 */
    byte IFE4        :1;                                       /* Input Filter Enable, bit 4 */
    byte IFE5        :1;                                       /* Input Filter Enable, bit 5 */
    byte IFE6        :1;                                       /* Input Filter Enable, bit 6 */
    byte IFE7        :1;                                       /* Input Filter Enable, bit 7 */
  } Bits;
} PC1IFESTR;
extern volatile PC1IFESTR _PC1IFE @0xFFFF8103;
#define PC1IFE                          _PC1IFE.Byte
#define PC1IFE_IFE0                     _PC1IFE.Bits.IFE0
#define PC1IFE_IFE1                     _PC1IFE.Bits.IFE1
#define PC1IFE_IFE2                     _PC1IFE.Bits.IFE2
#define PC1IFE_IFE3                     _PC1IFE.Bits.IFE3
#define PC1IFE_IFE4                     _PC1IFE.Bits.IFE4
#define PC1IFE_IFE5                     _PC1IFE.Bits.IFE5
#define PC1IFE_IFE6                     _PC1IFE.Bits.IFE6
#define PC1IFE_IFE7                     _PC1IFE.Bits.IFE7

#define PC1IFE_IFE0_MASK                1U
#define PC1IFE_IFE1_MASK                2U
#define PC1IFE_IFE2_MASK                4U
#define PC1IFE_IFE3_MASK                8U
#define PC1IFE_IFE4_MASK                16U
#define PC1IFE_IFE5_MASK                32U
#define PC1IFE_IFE6_MASK                64U
#define PC1IFE_IFE7_MASK                128U


/*** TPMSC - TPM Status and Control Register; 0xFFFF8120 ***/
typedef union {
  byte Byte;
  struct {
    byte PS0         :1;                                       /* Prescale Divisor Select Bit 0 */
    byte PS1         :1;                                       /* Prescale Divisor Select Bit 1 */
    byte PS2         :1;                                       /* Prescale Divisor Select Bit 2 */
    byte CLKSA       :1;                                       /* Clock Source Select A */
    byte CLKSB       :1;                                       /* Clock Source Select B */
    byte CPWMS       :1;                                       /* Center-Aligned PWM Select */
    byte TOIE        :1;                                       /* Timer Overflow Interrupt Enable */
    byte TOF         :1;                                       /* Timer Overflow Flag */
  } Bits;
  struct {
    byte grpPS   :3;
    byte grpCLKSx :2;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} TPMSCSTR;
extern volatile TPMSCSTR _TPMSC @0xFFFF8120;
#define TPMSC                           _TPMSC.Byte
#define TPMSC_PS0                       _TPMSC.Bits.PS0
#define TPMSC_PS1                       _TPMSC.Bits.PS1
#define TPMSC_PS2                       _TPMSC.Bits.PS2
#define TPMSC_CLKSA                     _TPMSC.Bits.CLKSA
#define TPMSC_CLKSB                     _TPMSC.Bits.CLKSB
#define TPMSC_CPWMS                     _TPMSC.Bits.CPWMS
#define TPMSC_TOIE                      _TPMSC.Bits.TOIE
#define TPMSC_TOF                       _TPMSC.Bits.TOF
#define TPMSC_PS                        _TPMSC.MergedBits.grpPS
#define TPMSC_CLKSx                     _TPMSC.MergedBits.grpCLKSx

#define TPMSC_PS0_MASK                  1U
#define TPMSC_PS1_MASK                  2U
#define TPMSC_PS2_MASK                  4U
#define TPMSC_CLKSA_MASK                8U
#define TPMSC_CLKSB_MASK                16U
#define TPMSC_CPWMS_MASK                32U
#define TPMSC_TOIE_MASK                 64U
#define TPMSC_TOF_MASK                  128U
#define TPMSC_PS_MASK                   7U
#define TPMSC_PS_BITNUM                 0U
#define TPMSC_CLKSx_MASK                24U
#define TPMSC_CLKSx_BITNUM              3U


/*** TPMCNT - TPM Timer Counter Register; 0xFFFF8121 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TPMCNTH - TPM Timer Counter Register High; 0xFFFF8121 ***/
    union {
      byte Byte;
    } TPMCNTHSTR;
    #define TPMCNTH                     _TPMCNT.Overlap_STR.TPMCNTHSTR.Byte
    

    /*** TPMCNTL - TPM Timer Counter Register Low; 0xFFFF8122 ***/
    union {
      byte Byte;
    } TPMCNTLSTR;
    #define TPMCNTL                     _TPMCNT.Overlap_STR.TPMCNTLSTR.Byte
    
  } Overlap_STR;

} TPMCNTSTR;
extern volatile TPMCNTSTR _TPMCNT @0xFFFF8121;
#define TPMCNT                          _TPMCNT.Word


/*** TPMMOD - TPM Timer Counter Modulo Register; 0xFFFF8123 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TPMMODH - TPM Timer Counter Modulo Register High; 0xFFFF8123 ***/
    union {
      byte Byte;
    } TPMMODHSTR;
    #define TPMMODH                     _TPMMOD.Overlap_STR.TPMMODHSTR.Byte
    

    /*** TPMMODL - TPM Timer Counter Modulo Register Low; 0xFFFF8124 ***/
    union {
      byte Byte;
    } TPMMODLSTR;
    #define TPMMODL                     _TPMMOD.Overlap_STR.TPMMODLSTR.Byte
    
  } Overlap_STR;

} TPMMODSTR;
extern volatile TPMMODSTR _TPMMOD @0xFFFF8123;
#define TPMMOD                          _TPMMOD.Word


/*** TPMC0SC - TPM Timer Channel 0 Status and Control Register; 0xFFFF8125 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte ELS0A       :1;                                       /* Edge/Level Select Bit A */
    byte ELS0B       :1;                                       /* Edge/Level Select Bit B */
    byte MS0A        :1;                                       /* Mode Select A for TPM Channel 0 */
    byte MS0B        :1;                                       /* Mode Select B for TPM Channel 0 */
    byte CH0IE       :1;                                       /* Channel 0 Interrupt Enable */
    byte CH0F        :1;                                       /* Channel 0 Flag */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpELS0x :2;
    byte grpMS0x :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} TPMC0SCSTR;
extern volatile TPMC0SCSTR _TPMC0SC @0xFFFF8125;
#define TPMC0SC                         _TPMC0SC.Byte
#define TPMC0SC_ELS0A                   _TPMC0SC.Bits.ELS0A
#define TPMC0SC_ELS0B                   _TPMC0SC.Bits.ELS0B
#define TPMC0SC_MS0A                    _TPMC0SC.Bits.MS0A
#define TPMC0SC_MS0B                    _TPMC0SC.Bits.MS0B
#define TPMC0SC_CH0IE                   _TPMC0SC.Bits.CH0IE
#define TPMC0SC_CH0F                    _TPMC0SC.Bits.CH0F
#define TPMC0SC_ELS0x                   _TPMC0SC.MergedBits.grpELS0x
#define TPMC0SC_MS0x                    _TPMC0SC.MergedBits.grpMS0x

#define TPMC0SC_ELS0A_MASK              4U
#define TPMC0SC_ELS0B_MASK              8U
#define TPMC0SC_MS0A_MASK               16U
#define TPMC0SC_MS0B_MASK               32U
#define TPMC0SC_CH0IE_MASK              64U
#define TPMC0SC_CH0F_MASK               128U
#define TPMC0SC_ELS0x_MASK              12U
#define TPMC0SC_ELS0x_BITNUM            2U
#define TPMC0SC_MS0x_MASK               48U
#define TPMC0SC_MS0x_BITNUM             4U


/*** TPMC0V - TPM Timer Channel 0 Value Register; 0xFFFF8126 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TPMC0VH - TPM Timer Channel 0 Value Register High; 0xFFFF8126 ***/
    union {
      byte Byte;
    } TPMC0VHSTR;
    #define TPMC0VH                     _TPMC0V.Overlap_STR.TPMC0VHSTR.Byte
    

    /*** TPMC0VL - TPM Timer Channel 0 Value Register Low; 0xFFFF8127 ***/
    union {
      byte Byte;
    } TPMC0VLSTR;
    #define TPMC0VL                     _TPMC0V.Overlap_STR.TPMC0VLSTR.Byte
    
  } Overlap_STR;

} TPMC0VSTR;
extern volatile TPMC0VSTR _TPMC0V @0xFFFF8126;
#define TPMC0V                          _TPMC0V.Word


/*** TPMC1SC - TPM Timer Channel 1 Status and Control Register; 0xFFFF8128 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte ELS1A       :1;                                       /* Edge/Level Select Bit A */
    byte ELS1B       :1;                                       /* Edge/Level Select Bit B */
    byte MS1A        :1;                                       /* Mode Select A for TPM Channel 1 */
    byte MS1B        :1;                                       /* Mode Select B for TPM Channel 1 */
    byte CH1IE       :1;                                       /* Channel 1 Interrupt Enable */
    byte CH1F        :1;                                       /* Channel 1 Flag */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpELS1x :2;
    byte grpMS1x :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} TPMC1SCSTR;
extern volatile TPMC1SCSTR _TPMC1SC @0xFFFF8128;
#define TPMC1SC                         _TPMC1SC.Byte
#define TPMC1SC_ELS1A                   _TPMC1SC.Bits.ELS1A
#define TPMC1SC_ELS1B                   _TPMC1SC.Bits.ELS1B
#define TPMC1SC_MS1A                    _TPMC1SC.Bits.MS1A
#define TPMC1SC_MS1B                    _TPMC1SC.Bits.MS1B
#define TPMC1SC_CH1IE                   _TPMC1SC.Bits.CH1IE
#define TPMC1SC_CH1F                    _TPMC1SC.Bits.CH1F
#define TPMC1SC_ELS1x                   _TPMC1SC.MergedBits.grpELS1x
#define TPMC1SC_MS1x                    _TPMC1SC.MergedBits.grpMS1x

#define TPMC1SC_ELS1A_MASK              4U
#define TPMC1SC_ELS1B_MASK              8U
#define TPMC1SC_MS1A_MASK               16U
#define TPMC1SC_MS1B_MASK               32U
#define TPMC1SC_CH1IE_MASK              64U
#define TPMC1SC_CH1F_MASK               128U
#define TPMC1SC_ELS1x_MASK              12U
#define TPMC1SC_ELS1x_BITNUM            2U
#define TPMC1SC_MS1x_MASK               48U
#define TPMC1SC_MS1x_BITNUM             4U


/*** TPMC1V - TPM Timer Channel 1 Value Register; 0xFFFF8129 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TPMC1VH - TPM Timer Channel 1 Value Register High; 0xFFFF8129 ***/
    union {
      byte Byte;
    } TPMC1VHSTR;
    #define TPMC1VH                     _TPMC1V.Overlap_STR.TPMC1VHSTR.Byte
    

    /*** TPMC1VL - TPM Timer Channel 1 Value Register Low; 0xFFFF812A ***/
    union {
      byte Byte;
    } TPMC1VLSTR;
    #define TPMC1VL                     _TPMC1V.Overlap_STR.TPMC1VLSTR.Byte
    
  } Overlap_STR;

} TPMC1VSTR;
extern volatile TPMC1VSTR _TPMC1V @0xFFFF8129;
#define TPMC1V                          _TPMC1V.Word


/*** PDB_SCR - PDB Status & Control Register; 0xFFFFEC00 ***/
typedef union {
  word Word;
  struct {
    word EN          :1;                                       /* Module Enable */
    word TRIGSEL0    :1;                                       /* Input Trigger Select, bit 0 */
    word TRIGSEL1    :1;                                       /* Input Trigger Select, bit 1 */
    word SWTRIG      :1;                                       /* Software Trigger */
    word CONT        :1;                                       /* Continuous Mode Enable */
    word AOS0        :1;                                       /* A Output Select, bit 0 */
    word AOS1        :1;                                       /* A Output Select, bit 1 */
    word BOS0        :1;                                       /* B Output Select, bit 0 */
    word BOS1        :1;                                       /* B Output Select, bit 1 */
    word IENA        :1;                                       /* Interrupt Enable A */
    word IENB        :1;                                       /* Interrupt Enable B */
    word SA          :1;                                       /* Sticky A */
    word SB          :1;                                       /* Sticky B */
    word PRESCALER0  :1;                                       /* Clock Prescaler Select, bit 0 */
    word PRESCALER1  :1;                                       /* Clock Prescaler Select, bit 1 */
    word PRESCALER2  :1;                                       /* Clock Prescaler Select, bit 2 */
  } Bits;
  struct {
    word         :1;
    word grpTRIGSEL :2;
    word         :1;
    word         :1;
    word grpAOS  :2;
    word grpBOS  :2;
    word grpIENx :2;
    word grpSx   :2;
    word grpPRESCALER :3;
  } MergedBits;
} PDB_SCRSTR;
extern volatile PDB_SCRSTR _PDB_SCR @0xFFFFEC00;
#define PDB_SCR                         _PDB_SCR.Word
#define PDB_SCR_EN                      _PDB_SCR.Bits.EN
#define PDB_SCR_TRIGSEL0                _PDB_SCR.Bits.TRIGSEL0
#define PDB_SCR_TRIGSEL1                _PDB_SCR.Bits.TRIGSEL1
#define PDB_SCR_SWTRIG                  _PDB_SCR.Bits.SWTRIG
#define PDB_SCR_CONT                    _PDB_SCR.Bits.CONT
#define PDB_SCR_AOS0                    _PDB_SCR.Bits.AOS0
#define PDB_SCR_AOS1                    _PDB_SCR.Bits.AOS1
#define PDB_SCR_BOS0                    _PDB_SCR.Bits.BOS0
#define PDB_SCR_BOS1                    _PDB_SCR.Bits.BOS1
#define PDB_SCR_IENA                    _PDB_SCR.Bits.IENA
#define PDB_SCR_IENB                    _PDB_SCR.Bits.IENB
#define PDB_SCR_SA                      _PDB_SCR.Bits.SA
#define PDB_SCR_SB                      _PDB_SCR.Bits.SB
#define PDB_SCR_PRESCALER0              _PDB_SCR.Bits.PRESCALER0
#define PDB_SCR_PRESCALER1              _PDB_SCR.Bits.PRESCALER1
#define PDB_SCR_PRESCALER2              _PDB_SCR.Bits.PRESCALER2
#define PDB_SCR_TRIGSEL                 _PDB_SCR.MergedBits.grpTRIGSEL
#define PDB_SCR_AOS                     _PDB_SCR.MergedBits.grpAOS
#define PDB_SCR_BOS                     _PDB_SCR.MergedBits.grpBOS
#define PDB_SCR_IENx                    _PDB_SCR.MergedBits.grpIENx
#define PDB_SCR_Sx                      _PDB_SCR.MergedBits.grpSx
#define PDB_SCR_PRESCALER               _PDB_SCR.MergedBits.grpPRESCALER

#define PDB_SCR_EN_MASK                 1U
#define PDB_SCR_TRIGSEL0_MASK           2U
#define PDB_SCR_TRIGSEL1_MASK           4U
#define PDB_SCR_SWTRIG_MASK             8U
#define PDB_SCR_CONT_MASK               16U
#define PDB_SCR_AOS0_MASK               32U
#define PDB_SCR_AOS1_MASK               64U
#define PDB_SCR_BOS0_MASK               128U
#define PDB_SCR_BOS1_MASK               256U
#define PDB_SCR_IENA_MASK               512U
#define PDB_SCR_IENB_MASK               1024U
#define PDB_SCR_SA_MASK                 2048U
#define PDB_SCR_SB_MASK                 4096U
#define PDB_SCR_PRESCALER0_MASK         8192U
#define PDB_SCR_PRESCALER1_MASK         16384U
#define PDB_SCR_PRESCALER2_MASK         32768U
#define PDB_SCR_TRIGSEL_MASK            6U
#define PDB_SCR_TRIGSEL_BITNUM          1U
#define PDB_SCR_AOS_MASK                96U
#define PDB_SCR_AOS_BITNUM              5U
#define PDB_SCR_BOS_MASK                384U
#define PDB_SCR_BOS_BITNUM              7U
#define PDB_SCR_IENx_MASK               1536U
#define PDB_SCR_IENx_BITNUM             9U
#define PDB_SCR_Sx_MASK                 6144U
#define PDB_SCR_Sx_BITNUM               11U
#define PDB_SCR_PRESCALER_MASK          57344U
#define PDB_SCR_PRESCALER_BITNUM        13U


/*** PDB_DELAYA - PDB Delay A Register; 0xFFFFEC02 ***/
typedef union {
  word Word;
} PDB_DELAYASTR;
extern volatile PDB_DELAYASTR _PDB_DELAYA @0xFFFFEC02;
#define PDB_DELAYA                      _PDB_DELAYA.Word


/*** PDB_DELAYB - PDB Delay B Register; 0xFFFFEC04 ***/
typedef union {
  word Word;
} PDB_DELAYBSTR;
extern volatile PDB_DELAYBSTR _PDB_DELAYB @0xFFFFEC04;
#define PDB_DELAYB                      _PDB_DELAYB.Word


/*** PDB_MOD - PDB Counter Modulus Register; 0xFFFFEC06 ***/
typedef union {
  word Word;
} PDB_MODSTR;
extern volatile PDB_MODSTR _PDB_MOD @0xFFFFEC06;
#define PDB_MOD                         _PDB_MOD.Word


/*** PDB_COUNT - PDB Counter Value Register; 0xFFFFEC08 ***/
typedef union {
  word Word;
} PDB_COUNTSTR;
extern volatile PDB_COUNTSTR _PDB_COUNT @0xFFFFEC08;
#define PDB_COUNT                       _PDB_COUNT.Word


/*** INTC_FRC - INTC Force Interrupt Register; 0xFFFFFFD0 ***/
typedef union {
  byte Byte;
  struct {
    byte LVL7        :1;                                       /* Force Level 7 interrupt */
    byte LVL6        :1;                                       /* Force Level 6 interrupt */
    byte LVL5        :1;                                       /* Force Level 5 interrupt */
    byte LVL4        :1;                                       /* Force Level 4 interrupt */
    byte LVL3        :1;                                       /* Force Level 3 interrupt */
    byte LVL2        :1;                                       /* Force Level 2 interrupt */
    byte LVL1        :1;                                       /* Force Level 1 interrupt */
    byte             :1; 
  } Bits;
} INTC_FRCSTR;
extern volatile INTC_FRCSTR _INTC_FRC @0xFFFFFFD0;
#define INTC_FRC                        _INTC_FRC.Byte
#define INTC_FRC_LVL7                   _INTC_FRC.Bits.LVL7
#define INTC_FRC_LVL6                   _INTC_FRC.Bits.LVL6
#define INTC_FRC_LVL5                   _INTC_FRC.Bits.LVL5
#define INTC_FRC_LVL4                   _INTC_FRC.Bits.LVL4
#define INTC_FRC_LVL3                   _INTC_FRC.Bits.LVL3
#define INTC_FRC_LVL2                   _INTC_FRC.Bits.LVL2
#define INTC_FRC_LVL1                   _INTC_FRC.Bits.LVL1

#define INTC_FRC_LVL7_MASK              1U
#define INTC_FRC_LVL6_MASK              2U
#define INTC_FRC_LVL5_MASK              4U
#define INTC_FRC_LVL4_MASK              8U
#define INTC_FRC_LVL3_MASK              16U
#define INTC_FRC_LVL2_MASK              32U
#define INTC_FRC_LVL1_MASK              64U


/*** INTC_PL6P7 - INTC Programmable Level 6, Priority 7 Register; 0xFFFFFFD8 ***/
typedef union {
  byte Byte;
  struct {
    byte REQN0       :1;                                       /* Request number, bit 0 */
    byte REQN1       :1;                                       /* Request number, bit 1 */
    byte REQN2       :1;                                       /* Request number, bit 2 */
    byte REQN3       :1;                                       /* Request number, bit 3 */
    byte REQN4       :1;                                       /* Request number, bit 4 */
    byte REQN5       :1;                                       /* Request number, bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpREQN :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} INTC_PL6P7STR;
extern volatile INTC_PL6P7STR _INTC_PL6P7 @0xFFFFFFD8;
#define INTC_PL6P7                      _INTC_PL6P7.Byte
#define INTC_PL6P7_REQN0                _INTC_PL6P7.Bits.REQN0
#define INTC_PL6P7_REQN1                _INTC_PL6P7.Bits.REQN1
#define INTC_PL6P7_REQN2                _INTC_PL6P7.Bits.REQN2
#define INTC_PL6P7_REQN3                _INTC_PL6P7.Bits.REQN3
#define INTC_PL6P7_REQN4                _INTC_PL6P7.Bits.REQN4
#define INTC_PL6P7_REQN5                _INTC_PL6P7.Bits.REQN5
#define INTC_PL6P7_REQN                 _INTC_PL6P7.MergedBits.grpREQN

#define INTC_PL6P7_REQN0_MASK           1U
#define INTC_PL6P7_REQN1_MASK           2U
#define INTC_PL6P7_REQN2_MASK           4U
#define INTC_PL6P7_REQN3_MASK           8U
#define INTC_PL6P7_REQN4_MASK           16U
#define INTC_PL6P7_REQN5_MASK           32U
#define INTC_PL6P7_REQN_MASK            63U
#define INTC_PL6P7_REQN_BITNUM          0U


/*** INTC_PL6P6 - INTC Programmable Level 6, Priority 6 Register; 0xFFFFFFD9 ***/
typedef union {
  byte Byte;
  struct {
    byte REQN0       :1;                                       /* Request number, bit 0 */
    byte REQN1       :1;                                       /* Request number, bit 1 */
    byte REQN2       :1;                                       /* Request number, bit 2 */
    byte REQN3       :1;                                       /* Request number, bit 3 */
    byte REQN4       :1;                                       /* Request number, bit 4 */
    byte REQN5       :1;                                       /* Request number, bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpREQN :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} INTC_PL6P6STR;
extern volatile INTC_PL6P6STR _INTC_PL6P6 @0xFFFFFFD9;
#define INTC_PL6P6                      _INTC_PL6P6.Byte
#define INTC_PL6P6_REQN0                _INTC_PL6P6.Bits.REQN0
#define INTC_PL6P6_REQN1                _INTC_PL6P6.Bits.REQN1
#define INTC_PL6P6_REQN2                _INTC_PL6P6.Bits.REQN2
#define INTC_PL6P6_REQN3                _INTC_PL6P6.Bits.REQN3
#define INTC_PL6P6_REQN4                _INTC_PL6P6.Bits.REQN4
#define INTC_PL6P6_REQN5                _INTC_PL6P6.Bits.REQN5
#define INTC_PL6P6_REQN                 _INTC_PL6P6.MergedBits.grpREQN

#define INTC_PL6P6_REQN0_MASK           1U
#define INTC_PL6P6_REQN1_MASK           2U
#define INTC_PL6P6_REQN2_MASK           4U
#define INTC_PL6P6_REQN3_MASK           8U
#define INTC_PL6P6_REQN4_MASK           16U
#define INTC_PL6P6_REQN5_MASK           32U
#define INTC_PL6P6_REQN_MASK            63U
#define INTC_PL6P6_REQN_BITNUM          0U


/*** INTC_WCR - INTC Wake-up Control Register; 0xFFFFFFDB ***/
typedef union {
  byte Byte;
  struct {
    byte MASK0       :1;                                       /* Interrupt mask level, bit 0 */
    byte MASK1       :1;                                       /* Interrupt mask level, bit 1 */
    byte MASK2       :1;                                       /* Interrupt mask level, bit 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte ENB         :1;                                       /* Enable */
  } Bits;
  struct {
    byte grpMASK :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} INTC_WCRSTR;
extern volatile INTC_WCRSTR _INTC_WCR @0xFFFFFFDB;
#define INTC_WCR                        _INTC_WCR.Byte
#define INTC_WCR_MASK0                  _INTC_WCR.Bits.MASK0
#define INTC_WCR_MASK1                  _INTC_WCR.Bits.MASK1
#define INTC_WCR_MASK2                  _INTC_WCR.Bits.MASK2
#define INTC_WCR_ENB                    _INTC_WCR.Bits.ENB
#define INTC_WCR_MASK                   _INTC_WCR.MergedBits.grpMASK

#define INTC_WCR_MASK0_MASK             1U
#define INTC_WCR_MASK1_MASK             2U
#define INTC_WCR_MASK2_MASK             4U
#define INTC_WCR_ENB_MASK               128U
#define INTC_WCR_MASK_MASK              7U
#define INTC_WCR_MASK_BITNUM            0U


/*** INTC_SFRC - INTC Set Interrupt Force Register; 0xFFFFFFDE ***/
typedef union {
  byte Byte;
  struct {
    byte SET0        :1;                                       /* Sets corresponding bits in the INTC_FRC register, bit 0 */
    byte SET1        :1;                                       /* Sets corresponding bits in the INTC_FRC register, bit 1 */
    byte SET2        :1;                                       /* Sets corresponding bits in the INTC_FRC register, bit 2 */
    byte SET3        :1;                                       /* Sets corresponding bits in the INTC_FRC register, bit 3 */
    byte SET4        :1;                                       /* Sets corresponding bits in the INTC_FRC register, bit 4 */
    byte SET5        :1;                                       /* Sets corresponding bits in the INTC_FRC register, bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpSET  :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} INTC_SFRCSTR;
extern volatile INTC_SFRCSTR _INTC_SFRC @0xFFFFFFDE;
#define INTC_SFRC                       _INTC_SFRC.Byte
#define INTC_SFRC_SET0                  _INTC_SFRC.Bits.SET0
#define INTC_SFRC_SET1                  _INTC_SFRC.Bits.SET1
#define INTC_SFRC_SET2                  _INTC_SFRC.Bits.SET2
#define INTC_SFRC_SET3                  _INTC_SFRC.Bits.SET3
#define INTC_SFRC_SET4                  _INTC_SFRC.Bits.SET4
#define INTC_SFRC_SET5                  _INTC_SFRC.Bits.SET5
#define INTC_SFRC_SET                   _INTC_SFRC.MergedBits.grpSET

#define INTC_SFRC_SET0_MASK             1U
#define INTC_SFRC_SET1_MASK             2U
#define INTC_SFRC_SET2_MASK             4U
#define INTC_SFRC_SET3_MASK             8U
#define INTC_SFRC_SET4_MASK             16U
#define INTC_SFRC_SET5_MASK             32U
#define INTC_SFRC_SET_MASK              63U
#define INTC_SFRC_SET_BITNUM            0U


/*** INTC_CFRC - INTC Clear Interrupt Force Register; 0xFFFFFFDF ***/
typedef union {
  byte Byte;
  struct {
    byte CLR0        :1;                                       /* Clears corresponding bits in the INTC_FRC register, bit 0 */
    byte CLR1        :1;                                       /* Clears corresponding bits in the INTC_FRC register, bit 1 */
    byte CLR2        :1;                                       /* Clears corresponding bits in the INTC_FRC register, bit 2 */
    byte CLR3        :1;                                       /* Clears corresponding bits in the INTC_FRC register, bit 3 */
    byte CLR4        :1;                                       /* Clears corresponding bits in the INTC_FRC register, bit 4 */
    byte CLR5        :1;                                       /* Clears corresponding bits in the INTC_FRC register, bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpCLR  :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} INTC_CFRCSTR;
extern volatile INTC_CFRCSTR _INTC_CFRC @0xFFFFFFDF;
#define INTC_CFRC                       _INTC_CFRC.Byte
#define INTC_CFRC_CLR0                  _INTC_CFRC.Bits.CLR0
#define INTC_CFRC_CLR1                  _INTC_CFRC.Bits.CLR1
#define INTC_CFRC_CLR2                  _INTC_CFRC.Bits.CLR2
#define INTC_CFRC_CLR3                  _INTC_CFRC.Bits.CLR3
#define INTC_CFRC_CLR4                  _INTC_CFRC.Bits.CLR4
#define INTC_CFRC_CLR5                  _INTC_CFRC.Bits.CLR5
#define INTC_CFRC_CLR                   _INTC_CFRC.MergedBits.grpCLR

#define INTC_CFRC_CLR0_MASK             1U
#define INTC_CFRC_CLR1_MASK             2U
#define INTC_CFRC_CLR2_MASK             4U
#define INTC_CFRC_CLR3_MASK             8U
#define INTC_CFRC_CLR4_MASK             16U
#define INTC_CFRC_CLR5_MASK             32U
#define INTC_CFRC_CLR_MASK              63U
#define INTC_CFRC_CLR_BITNUM            0U


/*** INTC_SWIACK - INTC Software IACK Register; 0xFFFFFFE0 ***/
typedef union {
  byte Byte;
  struct {
    byte VECN0       :1;                                       /* Vector number, bit 0 */
    byte VECN1       :1;                                       /* Vector number, bit 1 */
    byte VECN2       :1;                                       /* Vector number, bit 2 */
    byte VECN3       :1;                                       /* Vector number, bit 3 */
    byte VECN4       :1;                                       /* Vector number, bit 4 */
    byte VECN5       :1;                                       /* Vector number, bit 5 */
    byte VECN6       :1;                                       /* Vector number, bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpVECN :7;
    byte         :1;
  } MergedBits;
} INTC_SWIACKSTR;
extern volatile INTC_SWIACKSTR _INTC_SWIACK @0xFFFFFFE0;
#define INTC_SWIACK                     _INTC_SWIACK.Byte
#define INTC_SWIACK_VECN0               _INTC_SWIACK.Bits.VECN0
#define INTC_SWIACK_VECN1               _INTC_SWIACK.Bits.VECN1
#define INTC_SWIACK_VECN2               _INTC_SWIACK.Bits.VECN2
#define INTC_SWIACK_VECN3               _INTC_SWIACK.Bits.VECN3
#define INTC_SWIACK_VECN4               _INTC_SWIACK.Bits.VECN4
#define INTC_SWIACK_VECN5               _INTC_SWIACK.Bits.VECN5
#define INTC_SWIACK_VECN6               _INTC_SWIACK.Bits.VECN6
#define INTC_SWIACK_VECN                _INTC_SWIACK.MergedBits.grpVECN

#define INTC_SWIACK_VECN0_MASK          1U
#define INTC_SWIACK_VECN1_MASK          2U
#define INTC_SWIACK_VECN2_MASK          4U
#define INTC_SWIACK_VECN3_MASK          8U
#define INTC_SWIACK_VECN4_MASK          16U
#define INTC_SWIACK_VECN5_MASK          32U
#define INTC_SWIACK_VECN6_MASK          64U
#define INTC_SWIACK_VECN_MASK           127U
#define INTC_SWIACK_VECN_BITNUM         0U


/*** INTC_LVL1IACK - INTC Level 1 IACK Register; 0xFFFFFFE4 ***/
typedef union {
  byte Byte;
  struct {
    byte VECN0       :1;                                       /* Vector number, bit 0 */
    byte VECN1       :1;                                       /* Vector number, bit 1 */
    byte VECN2       :1;                                       /* Vector number, bit 2 */
    byte VECN3       :1;                                       /* Vector number, bit 3 */
    byte VECN4       :1;                                       /* Vector number, bit 4 */
    byte VECN5       :1;                                       /* Vector number, bit 5 */
    byte VECN6       :1;                                       /* Vector number, bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpVECN :7;
    byte         :1;
  } MergedBits;
} INTC_LVL1IACKSTR;
extern volatile INTC_LVL1IACKSTR _INTC_LVL1IACK @0xFFFFFFE4;
#define INTC_LVL1IACK                   _INTC_LVL1IACK.Byte
#define INTC_LVL1IACK_VECN0             _INTC_LVL1IACK.Bits.VECN0
#define INTC_LVL1IACK_VECN1             _INTC_LVL1IACK.Bits.VECN1
#define INTC_LVL1IACK_VECN2             _INTC_LVL1IACK.Bits.VECN2
#define INTC_LVL1IACK_VECN3             _INTC_LVL1IACK.Bits.VECN3
#define INTC_LVL1IACK_VECN4             _INTC_LVL1IACK.Bits.VECN4
#define INTC_LVL1IACK_VECN5             _INTC_LVL1IACK.Bits.VECN5
#define INTC_LVL1IACK_VECN6             _INTC_LVL1IACK.Bits.VECN6
#define INTC_LVL1IACK_VECN              _INTC_LVL1IACK.MergedBits.grpVECN

#define INTC_LVL1IACK_VECN0_MASK        1U
#define INTC_LVL1IACK_VECN1_MASK        2U
#define INTC_LVL1IACK_VECN2_MASK        4U
#define INTC_LVL1IACK_VECN3_MASK        8U
#define INTC_LVL1IACK_VECN4_MASK        16U
#define INTC_LVL1IACK_VECN5_MASK        32U
#define INTC_LVL1IACK_VECN6_MASK        64U
#define INTC_LVL1IACK_VECN_MASK         127U
#define INTC_LVL1IACK_VECN_BITNUM       0U


/*** INTC_LVL2IACK - INTC Level 2 IACK Register; 0xFFFFFFE8 ***/
typedef union {
  byte Byte;
  struct {
    byte VECN0       :1;                                       /* Vector number, bit 0 */
    byte VECN1       :1;                                       /* Vector number, bit 1 */
    byte VECN2       :1;                                       /* Vector number, bit 2 */
    byte VECN3       :1;                                       /* Vector number, bit 3 */
    byte VECN4       :1;                                       /* Vector number, bit 4 */
    byte VECN5       :1;                                       /* Vector number, bit 5 */
    byte VECN6       :1;                                       /* Vector number, bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpVECN :7;
    byte         :1;
  } MergedBits;
} INTC_LVL2IACKSTR;
extern volatile INTC_LVL2IACKSTR _INTC_LVL2IACK @0xFFFFFFE8;
#define INTC_LVL2IACK                   _INTC_LVL2IACK.Byte
#define INTC_LVL2IACK_VECN0             _INTC_LVL2IACK.Bits.VECN0
#define INTC_LVL2IACK_VECN1             _INTC_LVL2IACK.Bits.VECN1
#define INTC_LVL2IACK_VECN2             _INTC_LVL2IACK.Bits.VECN2
#define INTC_LVL2IACK_VECN3             _INTC_LVL2IACK.Bits.VECN3
#define INTC_LVL2IACK_VECN4             _INTC_LVL2IACK.Bits.VECN4
#define INTC_LVL2IACK_VECN5             _INTC_LVL2IACK.Bits.VECN5
#define INTC_LVL2IACK_VECN6             _INTC_LVL2IACK.Bits.VECN6
#define INTC_LVL2IACK_VECN              _INTC_LVL2IACK.MergedBits.grpVECN

#define INTC_LVL2IACK_VECN0_MASK        1U
#define INTC_LVL2IACK_VECN1_MASK        2U
#define INTC_LVL2IACK_VECN2_MASK        4U
#define INTC_LVL2IACK_VECN3_MASK        8U
#define INTC_LVL2IACK_VECN4_MASK        16U
#define INTC_LVL2IACK_VECN5_MASK        32U
#define INTC_LVL2IACK_VECN6_MASK        64U
#define INTC_LVL2IACK_VECN_MASK         127U
#define INTC_LVL2IACK_VECN_BITNUM       0U


/*** INTC_LVL3IACK - INTC Level 3 IACK Register; 0xFFFFFFEC ***/
typedef union {
  byte Byte;
  struct {
    byte VECN0       :1;                                       /* Vector number, bit 0 */
    byte VECN1       :1;                                       /* Vector number, bit 1 */
    byte VECN2       :1;                                       /* Vector number, bit 2 */
    byte VECN3       :1;                                       /* Vector number, bit 3 */
    byte VECN4       :1;                                       /* Vector number, bit 4 */
    byte VECN5       :1;                                       /* Vector number, bit 5 */
    byte VECN6       :1;                                       /* Vector number, bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpVECN :7;
    byte         :1;
  } MergedBits;
} INTC_LVL3IACKSTR;
extern volatile INTC_LVL3IACKSTR _INTC_LVL3IACK @0xFFFFFFEC;
#define INTC_LVL3IACK                   _INTC_LVL3IACK.Byte
#define INTC_LVL3IACK_VECN0             _INTC_LVL3IACK.Bits.VECN0
#define INTC_LVL3IACK_VECN1             _INTC_LVL3IACK.Bits.VECN1
#define INTC_LVL3IACK_VECN2             _INTC_LVL3IACK.Bits.VECN2
#define INTC_LVL3IACK_VECN3             _INTC_LVL3IACK.Bits.VECN3
#define INTC_LVL3IACK_VECN4             _INTC_LVL3IACK.Bits.VECN4
#define INTC_LVL3IACK_VECN5             _INTC_LVL3IACK.Bits.VECN5
#define INTC_LVL3IACK_VECN6             _INTC_LVL3IACK.Bits.VECN6
#define INTC_LVL3IACK_VECN              _INTC_LVL3IACK.MergedBits.grpVECN

#define INTC_LVL3IACK_VECN0_MASK        1U
#define INTC_LVL3IACK_VECN1_MASK        2U
#define INTC_LVL3IACK_VECN2_MASK        4U
#define INTC_LVL3IACK_VECN3_MASK        8U
#define INTC_LVL3IACK_VECN4_MASK        16U
#define INTC_LVL3IACK_VECN5_MASK        32U
#define INTC_LVL3IACK_VECN6_MASK        64U
#define INTC_LVL3IACK_VECN_MASK         127U
#define INTC_LVL3IACK_VECN_BITNUM       0U


/*** INTC_LVL4IACK - INTC Level 4 IACK Register; 0xFFFFFFF0 ***/
typedef union {
  byte Byte;
  struct {
    byte VECN0       :1;                                       /* Vector number, bit 0 */
    byte VECN1       :1;                                       /* Vector number, bit 1 */
    byte VECN2       :1;                                       /* Vector number, bit 2 */
    byte VECN3       :1;                                       /* Vector number, bit 3 */
    byte VECN4       :1;                                       /* Vector number, bit 4 */
    byte VECN5       :1;                                       /* Vector number, bit 5 */
    byte VECN6       :1;                                       /* Vector number, bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpVECN :7;
    byte         :1;
  } MergedBits;
} INTC_LVL4IACKSTR;
extern volatile INTC_LVL4IACKSTR _INTC_LVL4IACK @0xFFFFFFF0;
#define INTC_LVL4IACK                   _INTC_LVL4IACK.Byte
#define INTC_LVL4IACK_VECN0             _INTC_LVL4IACK.Bits.VECN0
#define INTC_LVL4IACK_VECN1             _INTC_LVL4IACK.Bits.VECN1
#define INTC_LVL4IACK_VECN2             _INTC_LVL4IACK.Bits.VECN2
#define INTC_LVL4IACK_VECN3             _INTC_LVL4IACK.Bits.VECN3
#define INTC_LVL4IACK_VECN4             _INTC_LVL4IACK.Bits.VECN4
#define INTC_LVL4IACK_VECN5             _INTC_LVL4IACK.Bits.VECN5
#define INTC_LVL4IACK_VECN6             _INTC_LVL4IACK.Bits.VECN6
#define INTC_LVL4IACK_VECN              _INTC_LVL4IACK.MergedBits.grpVECN

#define INTC_LVL4IACK_VECN0_MASK        1U
#define INTC_LVL4IACK_VECN1_MASK        2U
#define INTC_LVL4IACK_VECN2_MASK        4U
#define INTC_LVL4IACK_VECN3_MASK        8U
#define INTC_LVL4IACK_VECN4_MASK        16U
#define INTC_LVL4IACK_VECN5_MASK        32U
#define INTC_LVL4IACK_VECN6_MASK        64U
#define INTC_LVL4IACK_VECN_MASK         127U
#define INTC_LVL4IACK_VECN_BITNUM       0U


/*** INTC_LVL5IACK - INTC Level 5 IACK Register; 0xFFFFFFF4 ***/
typedef union {
  byte Byte;
  struct {
    byte VECN0       :1;                                       /* Vector number, bit 0 */
    byte VECN1       :1;                                       /* Vector number, bit 1 */
    byte VECN2       :1;                                       /* Vector number, bit 2 */
    byte VECN3       :1;                                       /* Vector number, bit 3 */
    byte VECN4       :1;                                       /* Vector number, bit 4 */
    byte VECN5       :1;                                       /* Vector number, bit 5 */
    byte VECN6       :1;                                       /* Vector number, bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpVECN :7;
    byte         :1;
  } MergedBits;
} INTC_LVL5IACKSTR;
extern volatile INTC_LVL5IACKSTR _INTC_LVL5IACK @0xFFFFFFF4;
#define INTC_LVL5IACK                   _INTC_LVL5IACK.Byte
#define INTC_LVL5IACK_VECN0             _INTC_LVL5IACK.Bits.VECN0
#define INTC_LVL5IACK_VECN1             _INTC_LVL5IACK.Bits.VECN1
#define INTC_LVL5IACK_VECN2             _INTC_LVL5IACK.Bits.VECN2
#define INTC_LVL5IACK_VECN3             _INTC_LVL5IACK.Bits.VECN3
#define INTC_LVL5IACK_VECN4             _INTC_LVL5IACK.Bits.VECN4
#define INTC_LVL5IACK_VECN5             _INTC_LVL5IACK.Bits.VECN5
#define INTC_LVL5IACK_VECN6             _INTC_LVL5IACK.Bits.VECN6
#define INTC_LVL5IACK_VECN              _INTC_LVL5IACK.MergedBits.grpVECN

#define INTC_LVL5IACK_VECN0_MASK        1U
#define INTC_LVL5IACK_VECN1_MASK        2U
#define INTC_LVL5IACK_VECN2_MASK        4U
#define INTC_LVL5IACK_VECN3_MASK        8U
#define INTC_LVL5IACK_VECN4_MASK        16U
#define INTC_LVL5IACK_VECN5_MASK        32U
#define INTC_LVL5IACK_VECN6_MASK        64U
#define INTC_LVL5IACK_VECN_MASK         127U
#define INTC_LVL5IACK_VECN_BITNUM       0U


/*** INTC_LVL6IACK - INTC Level 6 IACK Register; 0xFFFFFFF8 ***/
typedef union {
  byte Byte;
  struct {
    byte VECN0       :1;                                       /* Vector number, bit 0 */
    byte VECN1       :1;                                       /* Vector number, bit 1 */
    byte VECN2       :1;                                       /* Vector number, bit 2 */
    byte VECN3       :1;                                       /* Vector number, bit 3 */
    byte VECN4       :1;                                       /* Vector number, bit 4 */
    byte VECN5       :1;                                       /* Vector number, bit 5 */
    byte VECN6       :1;                                       /* Vector number, bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpVECN :7;
    byte         :1;
  } MergedBits;
} INTC_LVL6IACKSTR;
extern volatile INTC_LVL6IACKSTR _INTC_LVL6IACK @0xFFFFFFF8;
#define INTC_LVL6IACK                   _INTC_LVL6IACK.Byte
#define INTC_LVL6IACK_VECN0             _INTC_LVL6IACK.Bits.VECN0
#define INTC_LVL6IACK_VECN1             _INTC_LVL6IACK.Bits.VECN1
#define INTC_LVL6IACK_VECN2             _INTC_LVL6IACK.Bits.VECN2
#define INTC_LVL6IACK_VECN3             _INTC_LVL6IACK.Bits.VECN3
#define INTC_LVL6IACK_VECN4             _INTC_LVL6IACK.Bits.VECN4
#define INTC_LVL6IACK_VECN5             _INTC_LVL6IACK.Bits.VECN5
#define INTC_LVL6IACK_VECN6             _INTC_LVL6IACK.Bits.VECN6
#define INTC_LVL6IACK_VECN              _INTC_LVL6IACK.MergedBits.grpVECN

#define INTC_LVL6IACK_VECN0_MASK        1U
#define INTC_LVL6IACK_VECN1_MASK        2U
#define INTC_LVL6IACK_VECN2_MASK        4U
#define INTC_LVL6IACK_VECN3_MASK        8U
#define INTC_LVL6IACK_VECN4_MASK        16U
#define INTC_LVL6IACK_VECN5_MASK        32U
#define INTC_LVL6IACK_VECN6_MASK        64U
#define INTC_LVL6IACK_VECN_MASK         127U
#define INTC_LVL6IACK_VECN_BITNUM       0U


/*** INTC_LVL7IACK - INTC Level 7 IACK Register; 0xFFFFFFFC ***/
typedef union {
  byte Byte;
  struct {
    byte VECN0       :1;                                       /* Vector number, bit 0 */
    byte VECN1       :1;                                       /* Vector number, bit 1 */
    byte VECN2       :1;                                       /* Vector number, bit 2 */
    byte VECN3       :1;                                       /* Vector number, bit 3 */
    byte VECN4       :1;                                       /* Vector number, bit 4 */
    byte VECN5       :1;                                       /* Vector number, bit 5 */
    byte VECN6       :1;                                       /* Vector number, bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpVECN :7;
    byte         :1;
  } MergedBits;
} INTC_LVL7IACKSTR;
extern volatile INTC_LVL7IACKSTR _INTC_LVL7IACK @0xFFFFFFFC;
#define INTC_LVL7IACK                   _INTC_LVL7IACK.Byte
#define INTC_LVL7IACK_VECN0             _INTC_LVL7IACK.Bits.VECN0
#define INTC_LVL7IACK_VECN1             _INTC_LVL7IACK.Bits.VECN1
#define INTC_LVL7IACK_VECN2             _INTC_LVL7IACK.Bits.VECN2
#define INTC_LVL7IACK_VECN3             _INTC_LVL7IACK.Bits.VECN3
#define INTC_LVL7IACK_VECN4             _INTC_LVL7IACK.Bits.VECN4
#define INTC_LVL7IACK_VECN5             _INTC_LVL7IACK.Bits.VECN5
#define INTC_LVL7IACK_VECN6             _INTC_LVL7IACK.Bits.VECN6
#define INTC_LVL7IACK_VECN              _INTC_LVL7IACK.MergedBits.grpVECN

#define INTC_LVL7IACK_VECN0_MASK        1U
#define INTC_LVL7IACK_VECN1_MASK        2U
#define INTC_LVL7IACK_VECN2_MASK        4U
#define INTC_LVL7IACK_VECN3_MASK        8U
#define INTC_LVL7IACK_VECN4_MASK        16U
#define INTC_LVL7IACK_VECN5_MASK        32U
#define INTC_LVL7IACK_VECN6_MASK        64U
#define INTC_LVL7IACK_VECN_MASK         127U
#define INTC_LVL7IACK_VECN_BITNUM       0U



/***********************************************/
/**   D E P R E C I A T E D   S Y M B O L S   **/
/***********************************************/
#pragma options align=reset

#endif
/*lint -restore  +esym(961,18.4) +esym(961,19.7) Enable MISRA rule (1.1,18.4,6.4,19.7) checking. */
