/* +FHDR-----------------------------------------------------------------------
* Copyright (c) 2011, Freescale Semiconductor, Inc.
* * ----------------------------------------------------------------------------
* FILE NAME : CustomApp1.h
* AUTHOR    : Freescale Semiconductor, Inc. 
* ----------------------------------------------------------------------------
* RELEASE HISTORY
* VERSION DATE AUTHOR DESCRIPTION
* (1.0) 11/01/2011   B32599 (Initial Template)
* ----------------------------------------------------------------------------
* KEYWORDS : Xtrinsic
* ----------------------------------------------------------------------------
* PURPOSE: 
* ----------------------------------------------------------------------------
* REUSE ISSUES
*  
* -FHDR-----------------------------------------------------------------------
*/



/******************************************************************************
*
* Includes
*
*******************************************************************************/
#include "main.h"


/******************************************************************************
*
* Public User Application Definitions
*
*******************************************************************************/

#define USER_APP_FBID          	25	 		/* user app identifier, decimal 25, available user application ID range 25..31 	*/
#define MAX_COUNTER_LIMIT       10 			/* User app counter limit, decimal 10 */


/******************************************************************************
*
* Public User Application Prototypes
*
******************************************************************************/

void user_app_main(void);		// User Application Main Function
void user_app_init(void);		// User Application Initialization Function
void user_app_reset(void);	// User Application Reset Function
void user_app_clear(void);	// User Application Clear Function 


/******************************************************************************
*
* Private Definitions for Prototypes
*
*******************************************************************************/

#define Data 			1
#define Zlock			2
#define PLmix			3


/* user data structure. note that the outputs must be first, followed
 * immediately by the parameters without any padding in between */
typedef struct user_app_struct_tag {
	struct user_app_outs_tag {
        uint8  	GPIO_State;			/* GPIO7 output value */
        uint8  	DataCnt;			/* number of raw data, roll over to 0 at event_cnt */
        uint8	ZlockCnt;			/* Portrait-landscape Zlock count, roll over to 0 at event_cnt */
        uint8  	PLmixCnt;			/* Portrait-landscape count, roll over to 0 at event_cnt */
        uint8  	EventCnt;			/* Event count, roll over to 0 at event_cnt */
        int16  	accelX;             /* raw x axis accelerometer */
        int16  	accelY;             /* raw y axis accelerometer */
        int16  	accelZ;             /* raw z axis accelerometer */        
        int16  	FaccelX;			/* Filtered x axis accelerometer */
        int16  	FaccelY;			/* Filtered y axis accelerometer */
        int16  	FaccelZ;			/* Filtered Z axis accelerometer */
    } outs;
    struct user_app_param_tag {        
        uint8	event_cnt;			/* event_cnt, accessible from MBox */
        uint8	cfg;				/* cfg 	= 1; event = g-force (Z-axis) > 0.8g
											= 2; event = Zlock
											= 3; event = Zlock & Portrait_landscape
									*/
    } param;
    struct user_app_private_tag {
    	uint8	state;
    	uint8 	flag:1;
    } private;
} user_app_struct_t;


