/***************** SCI.h *****************/

/*Input parameters used by u8SCI_init function*/
#define DATA_LENGTH_EIGTH         0
#define DATA_LENGTH_NINE          1
#define PARITY_NONE               0  
#define PARITY_EVEN               1
#define PARITY_ODD                2
#define TX_DISABLED               0
#define TX_NOT_INVERTED           1
#define TX_INVERTED               2  
#define RX_DISABLED               0
#define RX_NOT_INVERTED           1
#define RX_INVERTED               2
#define PIN_OPTION_DEFAULT        0
#define PIN_OPTION_ALTERNATIVE    1

/*Input parameters used by u8IR_TX_init function*/
#define DRIVE_STRENGTH_DISABLED   0
#define DRIVE_STRENGTH_ENABLED    1
#define DRIVE_STRENGTH_TOGGLE     2
#define MODULATION_DISABLED       0
#define MODULATION_BY_TPM1CH0     1
#define MODULATION_BY_TPM1CH1     2
#define MODULATION_BY_TPM2CH0     3
#define MODULATION_BY_TPM2CH1     4
#define TX_INTERRUPT_DISABLED     0
#define TX_INTERRUPT_ENABLED      1

/*Input parameters used by u8IR_RX_init function*/
#define COMPARATOR_DISABLED       0
#define RX_INTERRUPT_DISABLED     0
#define RX_INTERRUPT_ENABLED      1


/*****************************************************************************************************/

                    
/*Function prototypes for general SCI ports*/
UINT8 u8SCI_init(UINT8 port, UINT32 baudrate, UINT8 length, UINT8 parity, UINT8 TXmode, UINT8 RXmode, UINT8 pin_option);
UINT8 u8Set_baudrate(UINT8 port, UINT32 baudrate);

/*Function prototypes for SCI Transmission options*/
UINT8 u8IR_TX_init(UINT8 port, UINT8 strength, UINT8 modulation, UINT8 tx_ie);
UINT8 u8drive_strength_set(UINT8 port, UINT8 strength);
UINT8 u8modulation_set(UINT8 port, UINT8 modulation);

/*Function prototypes for SCI Reception options*/
UINT8 u8IR_RX_init(UINT8 port, UINT8 cmp_level, UINT8 rx_ie);



/************ COMMANDS USED FOR TEXT COMMUNICATION ***********/
#define CR             13         /*ASCII code for carry return*/
#define LF             10         /*ASCII code for line feed*/


/********************** FUNCTION PROTOTYPES *****************/
void sendCR (void);
void vfnSCI_init(UINT8 port, UINT16 br);
void vfnSCI_SendChr(UINT8 port, UINT8 data);
void vfnSCI_SendMsg(UINT8 port, UINT8 *str);
void SCI_set_baudrate(UINT8 port, UINT16  br);
