#include "XTWR-MCF51JE.h"
#include "SDbyIrDA.h"
#include "sci.h"
#include "IrDA.h"
#include "Fat.h"


/************************************************************************************/
/************************* START OF THE PROGRAM *************************************/
/************************************************************************************/


void main(void) 
{
  /* Turn off Watchdog Timer and enable RST and BGND pins*/
  SOPT1 = SOPT1_RSTPE_MASK | SOPT1_BKGDPE_MASK;  
  vfnMGC_init();            /* Clock at 48 MHz using 16 MHz external crystal */   
  
  SW2_DD = 0;               /* Switch 2 pin declared as input (Switch 4 pin is input only) */
  SW2_PE = 1;               /* Switch 2 internal pull up enabled */
  SW4_PE = 1;               /* Switch 4 internal pull up enabled */
  
  if(u8SCI_init(USED_PORT, BAUDRATE, DATA_LENGTH_EIGTH, PARITY_NONE, TX_NOT_INVERTED, RX_NOT_INVERTED, PIN_OPTION_ALTERNATIVE)) for(;;){};
  if(u8IR_TX_init(USED_PORT, DRIVE_STRENGTH_ENABLED, MODULATION_DISABLED, TX_INTERRUPT_DISABLED)) for(;;){};
  
  vfnCMT_init();            /* Configures CMT for IrDA transmission */
  vfnTPM1_rx_init();        /* Configures TPM1 for IrDA reception */
  if(u8ACMP_rx_init (REFERENCE_LEVEL)) for(;;){};  
    
  EnableInterrupts;         /* Enable interrupts */ 
  vfnWelcome();             /* Send a Welcome message */
  
  if(u8IR_RX_init(USED_PORT, COMPARATOR_DISABLED, RX_INTERRUPT_ENABLED)) for(;;){};  
  u8sd_status = SD_Init();  /* Configures SPI module and File System to handle a SD card */
  vfnSDwelcome();           /* Send messages of card detection and file status */
   
  for(;;) 
  {   
    /* If card is removed, an error message is sent */
    if(SD_PRESENT)
    { 
      vfnSysHalt();         
    } 
    
    /* If SW2 is pressed or the buffer reaches its maximum value, modify the file */
    if( (SW2_ON()) || (u16buffer_index >= 512) )  
    {
      vfnWriteFile();
    }
    
    /* If SW4 is pressed ,reads the file */
    if( SW4_ON() )  
    {
      vfnReadFile();
    }                       
  }
}/* loop forever */
/* please make sure that you never leave main */


/************************************************************************************/
