#include "Flash_Func.h"

UINT8 memp,memh,meml,Erased;
UINT16 pages;

void DATAFLASH_WriteEnableLatch(void); 
void DATAFLASH_WriteStatusEnableLatch(void);
UINT8 DATAFLASH_Status(void);

void DATAFLASH_Unprotect(void) 
{
    
    DATAFLASH_WriteStatusEnableLatch();
    
    SPI_SS0();
    SPI_ChrShift(0x01);
    SPI_ChrShift(0x00);
    SPI_SS1();
}

void DATAFLASH_ReadSequentialStop(void)
{
    SPI_SS1();
}


/**************** Test Functions **********************/

void DATAFLASH_ReadPage(UINT8 u8Page, UINT8 *pu8Buffer)
{
    UINT16 lcv;
    
    DATAFLASH_ReadSequentialStart(0x00,u8Page,0x00);
    for(lcv = 0; lcv < 256; lcv++)
    {
        pu8Buffer[lcv] = DATAFLASH_ReadSequentialNext();
    }
    DATAFLASH_ReadSequentialStop();
}

void DATAFLASH_WritePage(UINT8 u8Page)
{
    UINT16 lcv;
    
                                /*  A0 ,  A1 ,  A2 , D0 , D1 */
    DATAFLASH_WriteSequentialStart(0x00,u8Page,0x00,0x00,0x01);   /* Starts sequential write and writes first two bytes (0x00, 0x01) */
    
    for(lcv = 2; lcv < 256; lcv+=2)
    {
        while (DATAFLASH_Status());
        (void)DATAFLASH_WriteSequentialNext(lcv, lcv+1);
    }
    
    DATAFLASH_WriteSequentialDone();
}

void DATAFLASH_Init(void)
{
    SPI_Init();
    DATAFLASH_Unprotect();
    //DATAFLASH_Erase();
}

/************************************************************/

UINT8 DATAFLASH_ReadSequentialNext(void)
{
    return SPI_ChrShiftR(0x00);
}


void DATAFLASH_Erase4k(UINT8 memp, UINT8 memh, UINT8 meml)   // erases 4k block
{
    DATAFLASH_WriteEnableLatch(); 
    SPI_FullShift4(0x20,memp,memh,meml); 
    while (DATAFLASH_Status());
}

void DATAFLASH_Erase(void)                   // erases 0x000000 through 0x077FFF (leaves last 32k untouched)
{
    DATAFLASH_WriteEnableLatch(); 
    SPI_SS0();
    SPI_ChrShift(0x60); 
    SPI_SS1();
    while (DATAFLASH_Status());
}

UINT8 DATAFLASH_CheckErased(void) 
{
    UINT8 erased256;
    UINT32 count;
    erased256=count=0;
    SPI_SS0(); 
    SPI_ChrShift5(0x0B,0x00,0x00,0x00,0x00); 
    while ((SPI_ChrShiftR(0x00)==0xFF)&&(count<0x00100)) count++;
    SPI_SS1();
    if (count>0x000FF) erased256=1;
    return erased256;
}

void DATAFLASH_ReadSequentialStart(UINT8 memp, UINT8 memh, UINT8 meml)
{
    DATAFLASH_WriteEnableLatch(); 
    SPI_SS0(); 
    SPI_ChrShift5(0x0B,memp,memh,meml,0x00); 
}
//---------------------------------------------------------------------
void DATAFLASH_FirstEmpty256Page(void) 
{
    UINT8 a,empty,empty256;
    memp=memh=meml=empty256=0;
    empty=1;
    DATAFLASH_WriteEnableLatch(); SPI_SS0(); SPI_ChrShift5(0x0B,memp,memh,meml,0x00); 
    do
    {
        a=SPI_ChrShiftR(0x00);
        if (a!=0xFF) empty=0;
        meml++; if (meml==0) {empty256=empty; empty=1; memh++; if (memh==0) memp++;}
    }
    
    while ((empty256==0)&&(memp<7));
    SPI_SS1();
    pages=memp*256+memh;
}
//---------------------------------------------------------------------
void DATAFLASH_Write(UINT8 memp, UINT8 memh, UINT8 meml, UINT8 data) 
{
    DATAFLASH_WriteEnableLatch(); 
    SPI_SS0(); 
    SPI_ChrShift5(0x02,memp,memh,meml,data); 
    SPI_SS1();
}
//---------------------------------------------------------------------
void DATAFLASH_WriteNext(UINT8 data) 
{
    DATAFLASH_Write(memp,memh,meml,data); 
    meml++; 
    if (!meml) {memh++; if (!memh) memp++;} 
}
//---------------------------------------------------------------------
UINT8 DATAFLASH_Read(UINT8 memp, UINT8 memh, UINT8 meml)
{
    UINT8 a; 
    DATAFLASH_WriteEnableLatch(); 
    SPI_SS0(); 
    SPI_ChrShift5(0x0B,memp,memh,meml,0x00); 
    a=SPI_ChrShiftR(0x00); 
    SPI_SS1(); 
    return a;
}
//---------------------------------------------------------------------
void DATAFLASH_WriteSequentialStart(UINT8 memp, UINT8 memh, UINT8 meml, UINT8 data1, UINT8 data2) 
{
    DATAFLASH_WriteEnableLatch(); 
    SPI_SS0(); 
    SPI_ChrShift(0xAD);
    SPI_ChrShift(memp);
    SPI_ChrShift(memh);
    SPI_ChrShift(meml);
    SPI_ChrShift(data1);
    SPI_ChrShift(data2);
    SPI_SS1(); 
}
//---------------------------------------------------------------------
UINT8 DATAFLASH_WriteSequentialNext(UINT8 data1, UINT8 data2) 
{
    SPI_SS0();
    SPI_ChrShift(0xAD);
    SPI_ChrShift(data1);
    SPI_ChrShift(data2);
    SPI_SS1();
    return 0;
}
//---------------------------------------------------------------------
void DATAFLASH_WriteSequentialDone(void) 
{
    SPI_SS0();
    SPI_ChrShift(0x04);
    SPI_SS1();
}
//---------------------------------------------------------------------
UINT8 DATAFLASH_Busy(void) 
{
    UINT8 a; 
    SPI_SS0(); 
    SPI_ChrShift(0x05); 
    a=SPI_ChrShiftR(0x00); 
    SPI_SS1(); 
    return (a&0x01);
}




void DATAFLASH_WriteEnableLatch(void)  
{
    SPI_SS0(); 
    SPI_ChrShift(0x06); 
    SPI_SS1();
}

void DATAFLASH_WriteStatusEnableLatch(void)  
{
    SPI_SS0(); 
    SPI_ChrShift(0x50); 
    SPI_SS1();
}

UINT8 DATAFLASH_Status(void)            
{
    UINT8 cstat; 
    SPI_SS0(); 
    SPI_ChrShift(0x05); 
    cstat=SPI_ChrShiftR(0x00)&0x01; 
    SPI_SS1(); 
    return cstat;
}

