
/*------------------------------------------------------------------------*/
/* FILE NAME: GH_MPC5534_rom.ld             COPYRIGHT (c) Freescale 2006  */
/*                                                                        */
/* DESCRIPTION:                                                           */
/*    MPC5534 Example linker File for program in ROM only                 */
/* ORIGINAL AUTHOR: Chris Baker                                           */
/* REV      AUTHOR       DATE       DESCRIPTION OF CHANGE                 */
/* ---   -----------   ----------   ---------------------                 */
/* 0.1   Chris Baker   19/Jul/06     Initial version.                     */
/* 0.2   Chris Baker   22/Jan/07    Aligned heap on 16byte boundary.      */
/*------------------------------------------------------------------------*/


MEMORY
{
/* 2M External Flash (unused) */
/* 512K External SRAM (unused) */
        ext_flash : org = 0x20000000, len = 0x00200000
        ext_ram   : org = 0x3ff80000, len = 0x80000

/* Internal Flash RCW */
/* MPC5534 1M Internal Flash, but subtract one 128K block for use by BAM. */
/* MPC5534 64K Internal SRAM minus the 4K required for the stack. */
/* MPC5534 4K of Internal SRAM used for stack. */
        flash_rcw : org = 0x40006000, len = 0x8
        int_flash : org = 0x40006008, len = 0x0005FF8

//	flash_rcw : org = 0x00000000, len = 0x8
//      int_flash : org = 0x00000008, len = 0x000FFFF8
        int_sram  : org = 0x40000000, len = 0x4000
        stack_ram : org = 0x40005000, len = 0x1000
        
        smet_ram  : org = 0x4000FB80, len = 0x480
/* Spectrum graphics memory */
	graphics_ram : org = 0x60000000, len =0x28000
}

DEFAULTS {

    stack_reserve = 4K
}


SECTIONS
{

/* ROM data */
    .rcw  : { *(.rcw) } > flash_rcw

    .init       	: { *(.init) } 	> int_flash
    .text       	: {}  		> int_flash
    .vletext		: {}		> int_flash
    .flash_data 	: {} 		> int_flash
    .rodata  :
    {
         *(.rdata) 
         *(.rodata) 
    }  
	 
    .CROM.data   CROM(.data) : {} > int_sram /*int_flash*/
    .CROM.sdata    CROM(.sdata)  : {} > int_sram /*int_flash*/

    .ctors : {} > int_flash
    .dtors : {} > int_flash

    /*the interrupt vector table for the INTC must be aligned on 2K boundary*/
	.isrvectbl ALIGN(0x800): {}
	
	/* align the IVPR on a 8K boundary */
	.xcptn ALIGN(0x4000): {}  
     
/* DCU data */
	.graphics : {} > graphics_ram

/* SRAM data */
    .data   : {} > int_sram
    .sdata  : {} > int_sram
    .sbss   : {} > int_sram
    .sdata2 : {} > int_sram
    .sbss2  : {} > int_sram
    .bss    : {} > int_sram
    .heap ALIGN(0x10): {} > int_sram

/* Stack area */
    .stack  ALIGN(16) PAD(stack_reserve) : {} > stack_ram

///* Stack Address Parameters */
__SP_INIT      = ADDR(stack_ram) + SIZEOF(stack_ram); 
//__SP_END       = ADDR(stack_ram); 
//__STACK_SIZE   = SIZEOF(stack_ram); 

///* SRAM Address Parameters */
__SRAM_CPY_START = ADDR(.data);
__ROM_COPY_SIZE  = ((SIZEOF(.data) + SIZEOF(.sdata)));
__SRAM_LOAD      = ADDR(.heap);
__SRAM_LOAD_SIZE = (SIZEOF(.flash_data)/4);

__DATA_ROM	= ADDR(.CROM.data);
__SDATA_ROM	= ADDR(.CROM.sdata);


/* The EABI defines the location of _SDA_BASE_ and _SDA2_BASE_  */
/*  cfg_PNTRS places _SDA_BASE_ into R13 and _SDA2_BASE into R2 */
/*_SDA_BASE_ = ADDR(.sdata) + 0x8000 (+0x7FF0 for WindRiver)    */
/*_SDA2_BASE_ = ADDR(.sdata2) + 0x8000 (+0x7FF0 for WindRiver)  */

/* Interrupt Handler Parameters */
__IV_ADDR      = ADDR(.xcptn);



/* These special symbols mark the bounds of RAM and ROM memory. */
/* They are used by the MULTI debugger.                         */

    __ghs_ramstart  = MEMADDR(int_sram);
    __ghs_ramend    = MEMENDADDR(int_sram);
    __ghs_romstart  = MEMADDR(int_flash);
    __ghs_romend    = MEMENDADDR(int_flash);

    __ghs_rambootcodestart = 0;           /* zero for ROM image */
    __ghs_rambootcodeend = 0;             /* zero for ROM image */
    __ghs_rombootcodestart = MEMADDR(int_flash);
    __ghs_rombootcodeend = MEMENDADDR(int_flash);

}
