/**************************************************************************/
/* FILE NAME: mpc5500_xcptn.c              COPYRIGHT (c) Freescale 2007   */
/*                                                All Rights Reserved     */
/* DESCRIPTION:                                                           */
/* This software is part of the MPC5516 Interrupt Controller Validation.  */
/* This test only uses the Z1 core on MPC5516.							  */
/* This is the interrupt controller configuration file. It configures the */
/* interrupt handler for Z1 core only, to trigger on Software Settable    */
/* Interrupt 4 (SSI4). The ISR for this interrupt "SwIrq4ISR" will flash  */
/* the Flash LED.                                                         */
/*                                                                        */
/*========================================================================*/
/* REV      AUTHOR        DATE        DESCRIPTION OF CHANGE               */
/* ---   -----------    ----------    ---------------------               */
/* 0.1	  R. Moran		 23/Feb/07    Initial Version					  */
/**************************************************************************/
#include "..\header\MPC5606S_2.h"

/*========================================================================*/
/*				 		GLOBAL VARIABLES								  */
/*========================================================================*/
extern vuint32_t __IV_ADDR;     		// Defined in the linker file */
extern uint32_t IntcIsrVectorTable[];	// Reference the Vector Table

/*========================================================================*/
/*			 			EXTERNAL PROTOTYPES								  */
/*========================================================================*/
extern void IVOR4Handler (void);
extern void IVORnTable (void);
extern void LINFLEX_A_TX_ISR();

/*========================================================================*/
/*		 					FUNCTIONS									  */
/*========================================================================*/

/**************************************************************************/
/* FUNCTION     : initIrqVectors		  								  */
/* PURPOSE      : This function intializes the IVPR register for 		  */
/*                exceptions. 							  			  	  */
/**************************************************************************/
void initIrqVectors(void) {
  	
	// IVPR = address base used with IVOR's
	asm ("e_lis r5, __IV_ADDR@h");   
  	asm ("e_or2i r5, __IV_ADDR@l");
  	asm ("mtIVPR r5 ");
}


/**************************************************************************/
/* FUNCTION     : initINTC		  								  		  */
/* PURPOSE      : This function intializes the INTC for software vector   */
/*                mode.  Set up INTC vector table base address to the 	  */
/*			 	  address defined in the linker			  			  	  */
/**************************************************************************/
void initINTC(void) {	
  	
	// Initialize INTC for software vector mode
	INTC.MCR.B.HVEN = 1;
  	
	// Use the default vector table entry offsets of 4 bytes
	INTC.MCR.B.VTES = 0;	
	
}

/**************************************************************************/
/* FUNCTION     : SwIrq4ISR			  								  	  */
/* PURPOSE      : This is the ISR for SSI4. Once entered this will flash  */
/*				  the flashing LED pin and increment the interrupt counter*/
/**************************************************************************/



/**************************************************************************/
/* FUNCTION     : enableIrq			  								  	  */
/* PURPOSE      : This function sets INTC's current priority to 0.        */
/*                External interrupts to the core are enabled.			  */
/**************************************************************************/
void enableIrq(void) {
  	
	// Ensure INTC's current priority is 0
	INTC.CPR.B.PRI = 0;
	
	// Enable external interrupts
  	asm(" wrteei 1");		
}


/**************************************************************************/
/* FUNCTION     : xcptn_xmpl			  								  */
/* PURPOSE      : This function sets up the necessary functions to raise  */
/*				  and handle a SSI4 in software vector mode               */
/**************************************************************************/
void xcptn_xmpl(void) {
    
	// Initialise IVPR in Z1
	initIrqVectors();       
	
	// Initialize INTC for software vector mode
  initINTC();
}

