/****************************************************************************************************/
/**
\file       	GPIO.h
\brief      
\author     Alejandra Guzmn Castellanos
\author     Freescale Semiconductor
\author     Technical Information Center (TIC)
\version    1.0
\date			August 2009      
*/
/****************************************************************************************************/
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.     					*/
/* CUSTOMER retains the final decision relative to the total design and functionality of the end    						*/
/* product.                                                                                         														*/
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.					*/
/*                                                                                                  															*/
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, 							*/
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         							*/
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      						*/
/* FREESCALE services.                                                                              													*/
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     						*/
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or 			*/
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        					*/
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER							*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      							*/
/*                                                                                                  															*/
/****************************************************************************************************/

/*****************************************************************************************************
* Module definition against multiple inclusion
*****************************************************************************************************/
#ifndef __APP_GPIO_H
#define __APP_GPIOI_H

/*****************************************************************************************************
* Include files
*****************************************************************************************************/

/** Variable types and common definitions */
#include "FslTypes.h"
#include "derivative.h"

/*****************************************************************************************************
* Declaration of project wide TYPES
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of project wide VARIABLES
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of project wide MACROS / #DEFINE-CONSTANTS 
*****************************************************************************************************/
#define LED1 PTAD_PTAD5
#define LED2 PTAD_PTAD6
#define LED3 PTED_PTED4
#define LED4 PTED_PTED5

#define LED1_DD PTADD_PTADD5
#define LED2_DD PTADD_PTADD6
#define LED3_DD PTEDD_PTEDD4
#define LED4_DD PTEDD_PTEDD5

#define LED1_PE PTAPE_PTAPE5
#define LED2_PE PTAPE_PTAPE6
#define LED3_PE PTEPE_PTEPE4
#define LED4_PE PTEPE_PTEPE5

#define LED1_ON		LED1 = 0
#define LED1_OFF	LED1 = 1
#define LED2_ON		LED2 = 0
#define LED2_OFF	LED2 = 1
#define LED3_ON		LED3 = 0
#define LED3_OFF	LED3 = 1
#define LED4_ON		LED4 = 0
#define LED4_OFF	LED4 = 1

#define LED1_TOGGLE		LED1 ^= 1;
#define LED2_TOGGLE		LED2 ^= 1;
#define LED3_TOGGLE		LED3 ^= 1;
#define LED4_TOGGLE		LED4 ^= 1;

/*****************************************************************************************************
* Declaration of project wide FUNCTIONS
*****************************************************************************************************/

void vfnGPIO_Init (void);

/*****************************************************************************************************
* Declaration of module wide FUNCTIONs - NOT for use in other modules
*****************************************************************************************************/

#endif /* __APP_GPIO_H */