/**HEADER********************************************************************
* 
* Copyright (c) 2008 Freescale Semiconductor;
* All Rights Reserved
*
* Copyright (c) 2004-2008 Embedded Access Inc.;
* All Rights Reserved
*
*************************************************************************** 
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
**************************************************************************
*
* $FileName: HVAC_Task.c$
* $Version : 3.0.10.0$
* $Date    : Jan-15-2009$
*
* Comments:
*
*   
*
*END************************************************************************/


#include "defines.h"
#include <ipcfg.h>

#define IMAGE_FILE "c:\\fslimage.jpg"

#define SW_2 (GPIO_PORT_NQ | GPIO_PIN1)

extern MUTEX_STRUCT   cam_mutex;

FILE_PTR             image_fp;
extern unsigned char data_mcf5225x_jpg[];
extern LWSEM_STRUCT  USB_Stick;
extern pointer       usb_fs_handle;
extern uint_16       ImageSize;

boolean Initialize_GPIO_input(void);
boolean GetInput(void);

static FILE_PTR input_port=NULL;
_task_id cam_task_id = 0;

void task_init(uint_32)
{   
  	
   	MUTEX_ATTR_STRUCT mutexattr;
   	boolean  value=FALSE;

   _int_install_unexpected_isr();


   /* Initialize mutex attributes */
   if (_mutatr_init(&mutexattr) != MQX_OK) {
      printf("Initialize mutex attributes failed.\n");
      _mqx_exit(0);
   }
   
   /* Initialize the mutex */ 
   if (_mutex_init(&cam_mutex, &mutexattr) != MQX_OK) {
      printf("Initialize print mutex failed.\n");
      _mqx_exit(0);
   }
	
	_time_delay(1000);
   InitNetworking();

   cam_task_id = _task_create(0, CAM_TASK, 0);
   if (cam_task_id == MQX_NULL_TASK_ID) 
   {
       printf("\n Could not create Camera TASK\n");
   }
   else 
   {
       printf(" Camera Task created \n");
   }
 
 
    value = Initialize_GPIO_input();

	if (value == TRUE)
	{
		while (TRUE)
		{
		    value = GetInput();
		    if (value == TRUE)
		    {
    			// check to see if a filesystem is available
    			if (_lwsem_poll(&USB_Stick)) 
    			{
    			
			    	if (_mutex_lock(&cam_mutex) != MQX_OK) 
					{
       					printf("Mutex lock failed in camera.\n");
       					//_mqx_exit(0);
    				}
        			image_fp = fopen(IMAGE_FILE,"w+");
					write(image_fp, &data_mcf5225x_jpg[0], ImageSize);
					fclose(image_fp);
					printf("Got snapshot\n\r");
					_mutex_unlock(&cam_mutex);
        			// Indicate that the USB stick is no longer in use
        			_lwsem_post(&USB_Stick);
    			}
	
		    }
		}
	}
  	  
}

boolean Initialize_GPIO_input(void) 
{
	const uint_32 input_set[] = 
	{
		SW_2,
		GPIO_LIST_END
	};
	
	/* Open and set port DD as input to read value from switches */
	input_port = fopen("gpio:read", (char_ptr) &input_set);
	
	return (input_port!=NULL);
}

boolean GetInput(void)
{
   boolean  value=FALSE;
   
   static uint_32 data[] = 
   {
		SW_2,
		GPIO_LIST_END
	};

   if (input_port) {
      ioctl(input_port, GPIO_IOCTL_READ,  &data);
   }

   value = (data[0] & GPIO_PIN_STATUS)==0;

   return value;
}