/**HEADER********************************************************************
* 
* Copyright (c) 2008 Freescale Semiconductor;
* All Rights Reserved
*
* Copyright (c) 2004-2008 Embedded Access Inc.;
* All Rights Reserved
*
*************************************************************************** 
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
**************************************************************************
*
* $FileName: RTCS.c$
* $Version : 3.0.24.0$
* $Date    : Jan-15-2009$
*
* Comments:
*
*   Example of HVAC using RTCS.
*
*END************************************************************************/

#include "defines.h"
#include  <ipcfg.h>
#include "httpd_types.h"
#include "tfs.h"

const HTTPD_ROOT_DIR_STRUCT root_dir[] = {
	{ "", "tfs:" },
	{ "usb", "c:" },
	{ 0, 0 }
};

void InitNetworking(void) 
{
    int_32					error;
	IPCFG_IP_ADDRESS_DATA	ip_data;

	printf ("Init Networking...\n");

   /* runtime RTCS configuration */
   _RTCSPCB_init = 4;
   _RTCSPCB_grow = 2;
   _RTCSPCB_max = 20;
   _RTCS_msgpool_init = 4;
   _RTCS_msgpool_grow = 2;
   _RTCS_msgpool_max  = 20;
   _RTCS_socket_part_init = 4;
   _RTCS_socket_part_grow = 2;
   _RTCS_socket_part_max  = 20;
   FTPd_buffer_size = 536;

    error = RTCS_create();

	//FSL starting DHCP client enable

	IPCFG_default_enet_device = BSP_DEFAULT_ENET_DEVICE;
	IPCFG_default_ip_address = ENET_IPADDR;
	IPCFG_default_ip_mask = ENET_IPMASK;
	IPCFG_default_ip_gateway = 0;

	ip_data.ip = IPCFG_default_ip_address;
	ip_data.mask = IPCFG_default_ip_mask;
	ip_data.gateway = IPCFG_default_ip_gateway;
	
    ENET_get_mac_address (IPCFG_default_enet_device, IPCFG_default_ip_address, IPCFG_default_enet_address);
	error = ipcfg_init_device (IPCFG_default_enet_device, IPCFG_default_enet_address);
	
	do 
 	{
      _time_delay (200);
      error = ipcfg_bind_dhcp (IPCFG_default_enet_device, TRUE);
      //printf ("Error during DHCP bind 1 %08x!\n", error);
 	} while (error == IPCFG_ERROR_BUSY);
 	
 	if (error == IPCFG_ERROR_OK)
 	{
    	do 
    	{
    	  _time_delay (200);
       	  error = ipcfg_poll_dhcp (IPCFG_default_enet_device, TRUE, &ip_data);
       	  //printf ("Error during DHCP poll %08x!\n", error);
    	}while (error == IPCFG_ERROR_BUSY);
 	}
 	
 	if (error != IPCFG_ERROR_OK)
 	{
 		//printf ("Error during DHCP bind %08x!\n", error);
 	}
	else
	{
		printf ("DHCP bind successful.\n");	
	}
	
	ipcfg_get_ip(0, &ip_data);
	ipcfg_get_ip(IPCFG_default_enet_device, &ip_data);
    printf("\nIP Address      : %d.%d.%d.%d",IPBYTES(ip_data.ip));
    printf("\nIP address HEX  : %x.",ip_data.ip);
    printf("\nSubnet Address  : %d.%d.%d.%d",IPBYTES(ip_data.mask));
    printf("\nGateway Address : %d.%d.%d.%d",IPBYTES(ip_data.gateway));
    printf("\nDNS Address     : %d.%d.%d.%d\n",IPBYTES(ipcfg_get_dns_ip(IPCFG_default_enet_device,0)));
     
    //FSL finishing DHCP client enable
 	
 	//The installation of a trivial file system is needed for the web server.
    {
		HTTPD_STRUCT *server;
		extern const TFS_DIR_ENTRY tfs_data[];
		
		//Install the trivial file system using the files stored in tfs_data array.
		if ((error = _io_tfs_install("tfs:", tfs_data))) {
		    printf("\ninstall returned: %08x\n", error);
		}
	
		//Initialize the web server with a root directory 
		//and define for the index the mqx.html file.
		server = httpd_server_init((HTTPD_ROOT_DIR_STRUCT*)root_dir, "\\mqx.html");
		
		//Start the web server, now any web browser should be able to reach it.
		httpd_server_run(server);
    }


}

/* EOF */
