/*!
 * Copyright (c) 2005, Freescale Semiconductor
 *
 * \file    mcu_spi_config.h
 * \brief   Header used to select the desired core.
 * \author  Larry Roshak
 * \version 4.1a
 * \date    2005/08/11 20:44:37 
 * 
 * \b Description:
 *
 * This is the SMAC C source driver header file for SPI
 * Driver in the MCU.  The header defines all externals, prototypes and 
 * mask bits used by the actual C driver.
 *
 * \b Department: Freescale Radio Products Division 
 *
 * \b Project: SMAC (Simple Media Access Controller)
 *
 * \b History:
 * - 17/04/2004 : Initial Development. (FLR005)
 * - 07/01/2005 : Code Standarization. (A19259)
 * - 11/16/2005 Doc. update to Doxygen compliant by Gonzalo Delgado 
 * Huitron rgd04c
 */ 


#ifndef _SPI_DRIVERS_H
#define _SPI_DRIVERS_H

#include "derivative.h"
#include "pub_def.h"
#include "mcu_hw_config.h"
#include "app_config.h"

/*  SPI Function Defines */

#if defined (HCS08G) | defined (HCS08R) | defined (HCS08Q) | defined (MCF51HCS08JM) 

void SPIInit(void);
/* Changed by PG */
//#define SPIWaitTransferDone() while (!(SPI1S_SPRF))
void SPIWaitTransferDone(void);
#define SPIClearRecieveStatReg(u8TempValue) *u8TempValue = SPI1S
#define SPIClearRecieveDataReg(u8TempValue) *u8TempValue = SPI1D
#define SPISendChar(u8Char) SPI1D = u8Char
#define SPIRead() SPI1D
#define SPIReadMSB(u16Data) ((UINT8*)u16Data)[0] = SPI1D /*!<SPI More Significant Byte*/	
#define SPIReadLSB(u16Data) ((UINT8*)u16Data)[1] = SPI1D /*!<SPI Less Significant Byte*/

              

#define SPIClkInvert    SPI1C1 |= 0x04; /*!< Set CPHA bit of SPCR (clk polarity) */
#define SPIClkNormal    SPI1C1 &= 0xFB; /*!< Clr CPHA bit of SPCR (clk polarity) */



#elif defined (HC08JW)
 
 void SPIInit(void);

/*
 * SPIWaitTransferDone : Waits until the SPI1D has been 
 * transferred and received
 *
 * Parameters : None
 *
 * Return : None
 */
#define SPIWaitTransferDone()       while (!(SPSCR_SPRF));
/*
 * SPI_ClearRecieveStatReg : Clears any flags that may be activated in the
 * the SPI Data Register.
 *
 * Parameters : None
 *
 * Return : None
 */
#define SPIClearRecieveStatReg(u8TempValue)    *u8TempValue = SPSCR
//#define SPIClearRecieveStatReg()    /*u8TempValue = */ SPSCR;
/*
 * SPIClearRecieveDataReg : Clear receive data register. SPI entirely ready 
 * for read or write 
 *
 * Parameters : None
 *
 * Return : None
 */

#define SPIClearRecieveDataReg(u8TempValue)    *u8TempValue = SPDR
//#define SPIClearRecieveDataReg()    /*u8TempValue = */ SPDR;
/*
 * SPI_SendChar : Sends a Char through the SPI port that is being used
 *
 * Parameters : u8Char - Char to be sent through the SPI
 *
 * Return : None
 */
#define SPISendChar(u8Char)         SPDR = u8Char
//#define SPISendChar(u8Char)         SPDR = u8Char;
/*
 * SPIRead : Returns the data that is in the SPI port.
 *
 * Parameters : None
 *
 * Return : UINT8 - Data that is in the SPI port being used.
 */
#define SPIRead()                   SPDR

#define SPIReadMSB(u16Data) ((UINT8*)u16Data)[0] = SPDR /*!<SPI More Significant Byte*/	
#define SPIReadLSB(u16Data) ((UINT8*)u16Data)[1] = SPDR /*!<SPI Less Significant Byte*/


#endif
#endif /*! _SPI_DRIVERS_H */