/* toro_gen_header.h 
 * toro header for test verification

 * $Author: b01119 $
 * $Date: Mar-28-2008$
 * $Name:  $
 */
 
//includes
#include "pub_def.h"
#include "board_config.h"
/* Prototypes */
void RadioInit(void);



#define HCS08Q																/*!<HCS08G family member*/
#define MC13192_CE              PTBD_PTBD5    /*!<Enables SPI transfers*/              
#define MC13192_CE_PORT         PTBDD_PTBDD5  /*!<SPI enable pin data direction */              
//#define MC13192_ATTN            PTDD_PTDD5		/*!<Transitions IC from either Hibernate 
//                                                  or Doze Modes to Idle.  */
//#define MC13192_ATTN_PORT       PTDDD_PTDDD5  /*!<ATTN pin data direction  */
//#define MC13192_RTXEN           PTDD_PTDD6		/*!<Enables Transmission or Reception from SPI  */
//#define MC13192_RTXEN_PORT      PTDDD_PTDDD6  /*!<SPI Transmission pin direction */
#define RXTXEN_NOT_USED         TRUE          /* RXTXEN pin isn't used  */
#define ATTN_NOT_USED           TRUE          /* ATTN pin isn't used  */
#define RESET_NOT_USED          TRUE          /* RESET pin isn't used  */

//#define MC13192_RESET           PTDD_PTDD7		/*!<Transciever Reset */
//#define MC13192_RESET_PORT      PTDDD_PTDDD7  /*!<Transciever Reset pin data direction */
//#define MC13192_RESET_PULLUP    PTDPE_PTDPE7  /*!<Enables pull up for Reset */

#define MC13192_IRQ_SOURCE      IRQSC					/*!<IRQ register */
#define MC13192_IRQ_IE_BIT 	    IRQSC_IRQIE			 /*!<Enables IRQ pin */


/**************************************************************
Enable peripherials that are on the Board
**************************************************************/

#define ACCEL_ENABLED         TRUE
#define TEMP_SENSOR_ENABLED   FALSE
#define BUZZER_ENABLED        FALSE
#define BUS_SPEED	            8000000

/**************************************************************
Define the SCI perameters
**************************************************************/
/*#if (DEFAULT_SCI_PORT == 1)
   #define  SCIBDH     SCIBDH
   #define  SCIBDL     SCIBDL
   #define  SCIC1      SCIC1 
   #define  SCIC2      SCIC2 
   #define  SCIS1      SCIS1 
   #define  SCIS2      SCIS2 
   #define  SCIC3      SCIC3 
   #define  SCID       SCID

   #define  SCIS1_TDRE  SCI1S1_TDRE
   #define  SCIS1_TC    SCI1S1_TC
   
   #define  RTS			   PTFD_PTFD7
   #define  RTSDIR		 PTFDD_PTFDD7
   
#else 

   #define  SCIBDH     SCI2BDH
   #define  SCIBDL     SCI2BDL
   #define  SCIC1      SCI2C1 
   #define  SCIC2      SCI2C2 
   #define  SCIS1      SCI2S1 
   #define  SCIS2      SCI2S2 
   #define  SCIC3      SCI2C3 
   #define  SCID       SCI2D
   
   #define  RTS			PTFD_PTFD7
   #define  RTSDIR		PTFDD_PTFDD7
   
   #define  SCIS1_TDRE  SCI2S1_TDRE
   #define  SCIS1_TC    SCI2S1_TC

#endif */
#define  SCI_DEFAULT_BAUD  38400

/**************************************************************
Define the TPM perameters
**************************************************************/

 #define  TPM1SC     TPMSC
 #define  TPM1CNTH   TPMCNTH         
 #define  TPM1CNTL   TPMCNTL
 #define  TPM1MOD    TPMMOD  
 
/**************************************************************
Define the SPI perameters
**************************************************************/

 #define  SPI1C1     SPIC1
 #define  SPI1C2     SPIC2
 #define  SPI1BR     SPIBR
 #define  SPI1S_SPRF  SPIS_SPRF
 #define  SPI1S      SPIS
 #define  SPI1D      SPID
 
   

/**************************************************************
Define the LED perameters
**************************************************************/
/*
#define LED1                    PTFD_PTFD0
#define LED1DIR                 PTFDD_PTFDD0
#define LED2                    PTFD_PTFD1
#define LED2DIR                 PTFDD_PTFDD1
    
#define LED_ON                  0
#define LED_OFF					1
#define DDIR_OUTPUT             1
#define DDIR_INPUT              0
    
#define LED_INIT_MACRO LED1     = LED_OFF; \
                       LED2     = LED_OFF; \
                       LED1DIR  = DDIR_OUTPUT; \
                       LED2DIR  = DDIR_OUTPUT; 
*/                              
    
/***********************************************
Define Buzzer
***********************************************/
    
/*    
#define BUZZER         PTDD_PTDD0
#define BUZZERDIR      PTDDD_PTDDD0
#define BUZZER_ON      1
#define BUZZER_OFF     0
   
#define BUZZER_INIT_MACRO BUZZER      = BUZZER_OFF; \
                          BUZZERDIR   = DDIR_OUTPUT;
*/    
/***********************************************
Define Switches
***********************************************/
    
    
/* SW1 on schematic */
#define PB0 PTBD_PTBD7
#define PB0PU PTBPE_PTBPE7
#define PB0DIR PTBDD_PTBDD7
  
/* SW2 on schematic */
#define PB1 PTBD_PTBD6
#define PB1PU PTBPE_PTBPE6
#define PB1DIR PTBDD_PTBDD6

#define PB_MASK 0xc0
   

//#define SWITCH_INIT_MACRO    PB0PU = TRUE; \
//                             PB1PU = TRUE; \
//                             PB0DIR = FALSE;\
//                             PB1DIR = FALSE;
                             
#define SWITCH_INIT_MACRO    PTBDD &= ~PB_MASK; PTBPE |= PB_MASK; 
                             
/***********************************************
LCD Settings
***********************************************/
/*                             
#define LCD_ENABLE        // None Dip Switch 
#define LCD_REG_SEL       PTED_PTED6
#define LCD_EN            PTED_PTED7
#define LCD_RW            PTGD_PTGD3
    // Data bits are 4-7 
#define LCD_DATA1         PTGD_PTGD4
#define LCD_DATA2         PTGD_PTGD5
#define LCD_DATA3         PTGD_PTGD6
#define LCD_DATA4         PTGD_PTGD7
#define LCD_INIT_MACRO    PTGDD = 0xF8; \
                          PTEDD |= 0xC0;
*/                                           
#define ENTER_LOW_POWER _asm wait

/***********************************************
Define Port A/B
Accelerometer 
***********************************************/

#define ACCEL_PS          PTAD_PTAD3
#define ACCEL_GSELECT1    PTBD_PTBD0
#define ACCEL_GSELECT2    PTBD_PTBD1
#define ACCEL_START_X     ATD1SC = 2;
#define ACCEL_START_Y     ATD1SC = 1;
#define ACCEL_START_Z     ATD1SC = 0;         
  
#define ACCEL_INIT_MACRO  ATD1PE=0x83; ATD1C=0xE1;\
                          PTADD_PTADD0=DDIR_OUTPUT;\
                          PTADD_PTADD1=DDIR_OUTPUT;\
                          PTADD_PTADD2=DDIR_OUTPUT; 
                          
#define ACCEL_G_OFF       ACCEL_PS = 0;
#define ACCEL_G_ON        ACCEL_PS = 1; 
#define ACCEL_G_1p5       ACCEL_GSELECT1 = 0; ACCEL_GSELECT2 = 0;
#define ACCEL_G_2p0       ACCEL_GSELECT1 = 0; ACCEL_GSELECT2 = 1;
#define ACCEL_G_4p0       ACCEL_GSELECT1 = 1; ACCEL_GSELECT2 = 0;
#define ACCEL_G_6p0       ACCEL_GSELECT1 = 1; ACCEL_GSELECT2 = 1;


/***********************************************
Duplicate PB0 to PUSH_BUTTON1 etc for different
formats.
***********************************************/

#define PUSH_BUTTON1 PB0
#define PUSH_BUTTON2 PB1

#define BUTTON1 PB0
#define BUTTON2 PB1

#define PB_PRESSED 0
