/* toro_gen_header.h 
 * toro header for test verification

 * $Author: a20639 $
 * $Date: Sep-12-2007$
 * $Name:  $
 */
 
//includes
#include "pub_def.h"
#include "board_config.h"

//Prototypes
void RadioInit(void);

//Defines


#define HC08JW																	 /*!<HCS08G family member*/
#define MC13192_CE              PTE_PTE7       /*!<Enables SPI transfers */         
#define MC13192_CE_PORT         DDRE_DDRE7     /*!<SPI enable pin data direction */           
#define MC13192_ATTN            PTD_PTD0			 /*!<Transitions IC from either Hibernate                                                      or Doze Modes to Idle. */
#define MC13192_ATTN_PORT       DDRD_DDRD0		 /*!<ATTN pin data direction */
#define MC13192_RTXEN           PTD_PTD2			 /*!<Enables Transmission or Reception from SPI  */
#define MC13192_RTXEN_PORT      DDRD_DDRD2		 /*!<SPI Transmission pin direction */
#define MC13192_RESET           PTD_PTD1			 /*!<Transciever Reset */
#define MC13192_RESET_PORT      DDRD_DDRD1		 /*!<Transciever Reset pin data direction */
//#define MC13192_RESET_PULLUP    PTDPE_PTDPE1		 /*!<Enables pull up for Reset */
#define MC13192_IRQ_SOURCE      KBSCR						 /*!<IRQ register */
#define MC13192_IRQ_IE_BIT      KBSCR_IMASKK_MASK			 /*!<Enables IRQ pin */



#ifdef ANTENNA_SWITCH
    #define MC13192_ANT_CTRL        PTBD_PTBD6	 /*!<Control line 1 for antenna */
    #define MC13192_ANT_CTRL2       PTBD_PTBD6   /*!< 
                                                  * Second Control line not
                                                  * used in MC13192EVB
                                                  */
    #define MC13192_ANT_CTRL_PORT   PTBDD_PTBDD6 /*!<Control line 1 pin direction */
    #define MC13192_ANT_CTRL2_PORT  PTBDD_PTBDD6 /*!<Control line 1 pin direction */
    #define ANT_CTRL_OFF            0       /*!<Control line Logic low is off */
    #define ANT_CTRL_ON             1       /*!<Control line Logic high is on */
#endif ANTENNA_SWITCH

#ifdef LNA
    #define MC13192_LNA_CTRL        PTBD_PTBD0		/*!<LNA Control*/
    #define MC13192_LNA_CTRL_PORT   PTBDD_PTBDD0  /*!<LNA control pin direction*/
    #define LNA_ON                  1							/*!<Turns on LNA*/
    #define LNA_OFF                 0							/*!<Turns of LNA*/
#endif LNA  

/**************************************************************
Enable peripherials that are on the Board
**************************************************************/
#define ACCEL_ENABLED         FALSE
#define TEMP_SENSOR_ENABLED   FALSE
#define BUZZER_ENABLED        FALSE
#define BUS_SPEED	            8000000

/**************************************************************
Define the SCI perameters
**************************************************************/
#if (DEFAULT_SCI_PORT == 1)
   #define  SCIBDH     SCIBDH
   #define  SCIBDL     SCIBDL
   #define  SCIC1      SCIC1 
   #define  SCIC2      SCIC2 
   #define  SCIS1      SCIS1 
   #define  SCIS2      SCIS2 
   #define  SCIC3      SCIC3 
   #define  SCID       SCID

   #define  SCIS1_TDRE  SCIS1_TDRE
   #define  SCIS1_TC    SCIS1_TC
   
   #define  RTS				PTAD_PTAD1
   #define  RTSDIR		  	PTADD_PTADD1

#else 

   #define  SCIBDH     SCI2BDH
   #define  SCIBDL     SCI2BDL
   #define  SCIC1      SCI2C1 
   #define  SCIC2      SCI2C2 
   #define  SCIS1      SCI2S1 
   #define  SCIS2      SCI2S2 
   #define  SCIC3      SCI2C3 
   #define  SCID       SCI2D

   #define  SCIS1_TDRE  SCI2S1_TDRE
   #define  SCIS1_TC    SCI2S1_TC

   #define  RTS				PTAD_PTAD7
   #define  RTSDIR		  	PTADD_PTADD7
#endif 
#define  SCI_DEFAULT_BAUD  38400

/**************************************************************
Define the LED perameters
**************************************************************/

#define LED1                    PTB_PTB0
#define LED1DIR                 DDRB_DDRB0
#define LED2                    PTB_PTB1
#define LED2DIR                 DDRB_DDRB1
#define LED3                    PTB_PTB5
#define LED3DIR                 DDRB_DDRB5
    
#define LED_ON                  0
#define LED_OFF					        1
#define LEDON                   LED_ON                 
#define LEDOFF                  LED_OFF					        

#define DDIR_OUTPUT             1
#define DDIR_INPUT              0
    
#define LED_INIT_MACRO LED1     = LED_OFF; \
                       LED2     = LED_OFF; \
                       LED3     = LED_OFF; \
                       LED1DIR  = DDIR_OUTPUT; \
                       LED2DIR  = DDIR_OUTPUT; \
                       LED3DIR  = DDIR_OUTPUT;

#define LEDS_ON        LED1     = LED_ON; \
                       LED2     = LED_ON; \
                       LED3     = LED_ON;                        

#define LEDS_OFF       LED1     = LED_OFF; \
                       LED2     = LED_OFF; \
                       LED3     = LED_OFF;                        
    
    
/***********************************************
Define Switches
***********************************************/
    
    
#define ENTER_LOW_POWER _asm stop


#define TPM1SC T1SC
#define TPM1CNTH T1CNTH
#define TPM1CNTL T1CNTL


//#define SPI1C1 SPCR
//#define SPI1C2 SPSCR
//#define SPI1BR SPSCR
//#define SPI1S SPSCR
//#define SPI1S_SPRF SPSCR_SPRF
//#define SPI1D SPDR
