/* toro_gen_header.h 
 * toro header for test verification

 * $Author: a20639 $
 * $Date: Sep-12-2007$
 * $Name:  $
 */
 
//includes
#include "pub_def.h"
#include "board_config.h"

//Prototypes
void RadioInit(void);

//Defines


#define MCF51HCS08JM														 /*!<FLEXISJM family member*/
#define MC13192_CE              PTBD_PTBD5       /*!<Enables SPI transfers */         
#define MC13192_CE_PORT         PTBDD_PTBDD5     /*!<SPI enable pin data direction */           
#define MC13192_ATTN            PTHD_PTHD1			 /*!<Transitions IC from either Hibernate                                                      or Doze Modes to Idle. */
#define MC13192_ATTN_PORT       PTHDD_PTHDD1		 /*!<ATTN pin data direction */
#define MC13192_RTXEN           PTHD_PTHD0			 /*!<Enables Transmission or Reception from SPI  */
#define MC13192_RTXEN_PORT      PTHDD_PTHDD0		 /*!<SPI Transmission pin direction */
#define MC13192_RESET           PTGD_PTGD1			 /*!<Transciever Reset */
#define MC13192_RESET_PORT      PTGDD_PTGDD1		 /*!<Transciever Reset pin data direction */
#define MC13192_RESET_PULLUP    PTGPE_PTGPE1		 /*!<Enables pull up for Reset */
#define MC13192_IRQ_SOURCE      IRQSC						 /*!<IRQ register */
#define MC13192_IRQ_IE_BIT      IRQSC_IRQIE			 /*!<Enables IRQ pin */


//#define ANTENNA_SWITCH 0

#ifdef ANTENNA_SWITCH
    #define MC13192_ANT_CTRL        PTBD_PTBD6	 /*!<Control line 1 for antenna */
    #define MC13192_ANT_CTRL2       PTFD_PTFD6   /*!< 
                                                  * Second Control line not
                                                  * used in MC13192EVB
                                                  */
    #define MC13192_ANT_CTRL_PORT   PTBDD_PTBDD6 /*!<Control line 1 pin direction */
    #define MC13192_ANT_CTRL2_PORT  PTBDD_PTBDD6 /*!<Control line 1 pin direction */
    #define ANT_CTRL_OFF            0       /*!<Control line Logic low is off */
    #define ANT_CTRL_ON             1       /*!<Control line Logic high is on */
#endif ANTENNA_SWITCH

#ifdef LNA
    #define MC13192_LNA_CTRL        PTBD_PTBD0		/*!<LNA Control*/
    #define MC13192_LNA_CTRL_PORT   PTBDD_PTBDD0  /*!<LNA control pin direction*/
    #define LNA_ON                  1							/*!<Turns on LNA*/
    #define LNA_OFF                 0							/*!<Turns of LNA*/
#endif LNA  

/**************************************************************
Enable peripherials that are on the Board
**************************************************************/
#define ACCEL_ENABLED         FALSE
#define TEMP_SENSOR_ENABLED   FALSE
#define BUZZER_ENABLED        FALSE
#define BUS_SPEED	            24000000

/**************************************************************
Define the SCI perameters
**************************************************************/
/*#if (DEFAULT_SCI_PORT == 1)
   #define  SCIBDH     SCIBDH
   #define  SCIBDL     SCIBDL
   #define  SCIC1      SCIC1 
   #define  SCIC2      SCIC2 
   #define  SCIS1      SCIS1 
   #define  SCIS2      SCIS2 
   #define  SCIC3      SCIC3 
   #define  SCID       SCID

   #define  SCIS1_TDRE  SCIS1_TDRE
   #define  SCIS1_TC    SCIS1_TC
   
   #define  RTS				PTAD_PTAD1
   #define  RTSDIR		  	PTADD_PTADD1

#else 

   #define  SCIBDH     SCI2BDH
   #define  SCIBDL     SCI2BDL
   #define  SCIC1      SCI2C1 
   #define  SCIC2      SCI2C2 
   #define  SCIS1      SCI2S1 
   #define  SCIS2      SCI2S2 
   #define  SCIC3      SCI2C3 
   #define  SCID       SCI2D

   #define  SCIS1_TDRE  SCI2S1_TDRE
   #define  SCIS1_TC    SCI2S1_TC

   #define  RTS				PTAD_PTAD7
   #define  RTSDIR		  	PTADD_PTADD7
#endif 
#define  SCI_DEFAULT_BAUD  38400
  */
/**************************************************************
Define the LED perameters
**************************************************************/

//#define LED1                    PTED_PTED2
//#define LED1DIR                 PTEDD_PTEDD2
//#define LED2                    PTED_PTED3
//#define LED2DIR                 PTEDD_PTEDD3
#define LED1                    PTCD_PTCD0
#define LED1DIR                 PTCDD_PTCDD0
#define LED2                    PTCD_PTCD1
#define LED2DIR                 PTCDD_PTCDD1
#define LED3                    PTCD_PTCD2
#define LED3DIR                 PTCDD_PTCDD2
#define LED4                    PTCD_PTCD3
#define LED4DIR                 PTCDD_PTCDD3
#define LED5                    PTCD_PTCD4
#define LED5DIR                 PTCDD_PTCDD4
#define LED6                    PTCD_PTCD5
#define LED6DIR                 PTCDD_PTCDD5

    
#define LED_ON                  0
#define LED_OFF					        1
#define LEDON                   LED_ON                 
#define LEDOFF                  LED_OFF					        

#define DDIR_OUTPUT             1
#define DDIR_INPUT              0
    
#define LED_INIT_MACRO LED1     = LED_OFF; \
                       LED2     = LED_OFF; \
                       LED3     = LED_OFF; \
                       LED4     = LED_OFF; \
                       LED5     = LED_OFF; \
                       LED6     = LED_OFF; \
                       LED1DIR  = DDIR_OUTPUT; \
                       LED2DIR  = DDIR_OUTPUT; \
                       LED3DIR  = DDIR_OUTPUT; \
                       LED4DIR  = DDIR_OUTPUT; \
                       LED5DIR  = DDIR_OUTPUT; \
                       LED6DIR  = DDIR_OUTPUT;

#define LEDS_ON        LED1     = LED_ON; \
                       LED2     = LED_ON; \
                       LED3     = LED_ON; \
                       LED4     = LED_ON; \
                       LED5     = LED_ON; \
                       LED6     = LED_ON;

#define LEDS_OFF       LED1     = LED_OFF; \
                       LED2     = LED_OFF; \
                       LED3     = LED_OFF; \
                       LED4     = LED_OFF; \
                       LED5     = LED_OFF; \
                       LED6     = LED_OFF;  
/***********************************************
Define Switches
***********************************************/
    
    
#define ENTER_LOW_POWER _asm stop
