;####################################################################################
;# (c) Copyright 2009, Freescale, Inc.  All rights reserved.
;#
;# No part of this document must be reproduced in any form - including copied,
;# transcribed, printed or by any electronic means - without specific written
;# permission from Freescale.
;#
;####################################################################################

F_Bit      EQU   0x40
I_Bit      EQU   0x80

Mode_Uvc   EQU   0x10  ; // user mode - has same registers as system mode
Mode_Fvc   EQU   0x11  ; // FIQ mode
Mode_Ivc   EQU   0x12  ; // IRQ mode
Mode_Svc   EQU   0x13  ; // supervisor mode
Mode_Avc   EQU   0x17  ; // Abort mode
Mode_und   EQU   0x1B  ; // undefined instr mode
Mode_sys   EQU   0x1F  ; // system mode

__SUP_stack_size     EQU  64*4

  EXPORT _start_vector_

  IMPORT Main
  IMPORT __iar_data_init2
  
  SECTION .vect: CODE

;//--Entry point-------------------------------------------------  

    CODE32 

_start_vector_
    B       __start_                      ; // reset
//    B       .                             ; // reserved
//    B       .                             ; // reserved
//    B       .                             ; // reserved
//    B       .                             ; // reserved
//    B       .                             ; // reserved
//    B       .                             ; // reserved
//    B       .                             ; // reserved

  SECTION .text: CODE

__start_
    LDR     r0, =system_stack + __SUP_stack_size
    MOV     sp, r0

    MOV     r0, #Mode_Svc | F_Bit | I_Bit   ;// supervisor mode, disable all interrupts
    MSR     cpsr_c,r0

    BL      __iar_data_init2
;// the main function was renamed to Main in order to avoid inclusion of C library code for supplementary initializations
    B        Main         ; // jump to "Main()"



  SECTION .stack:DATA(4)   ;// stack in internal RAM
system_stack  DS8  __SUP_stack_size

    END

;//---------------------------------------------------------------  
