/************************************************************************************
*
* (c) Copyright 2009, Freescale, Inc.  All rights reserved.
*
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale.
*
************************************************************************************/
#ifndef _UART_H_
#define _UART_H_

#include "EmbeddedTypes.h"

/************************************************************************************
*************************************************************************************
* Public macros
*************************************************************************************
************************************************************************************/
#define UART_SOF     0x55
#define HEADER_SIZE  0x02
/************************************************************************************
*************************************************************************************
* Public prototypes
*************************************************************************************
************************************************************************************/

/************************************************************************************
*  Configures the GPIO for UART1 usage. Configure the UART1 to 115200 baud rate.
*
*  Input parameters:
*  - None.
*  Return:
*  - Nothing.
************************************************************************************/
void    UART_Init(void);

/************************************************************************************
*  Receives a command on the UART. It waits for the SOF, receives the length
* and the command, computes the CRC and verifies it against the received CRC.
*
*  Input parameters:
*  - pBuffer: pointer to the buffer to place the received command in.
*  - pBytesReceived: the length of the received command.
*  Return:
*  - TRUE if the received packet's CRC was correct.
*  - FALSE if the received packet's CRC was incorrect.
************************************************************************************/
bool_t  UART_ReceiveCmd(uint8_t* pBuffer, uint16_t* pBytesReceived);

/************************************************************************************
*  Transmits a command on the UART. The command is accompanied by the start 
* of frame delimiter, the length of the command, the command itself and a very simple
* 8 bit  CRC.
*
*  Input parameters:
*  - pBuffer: pointer to the data to transmit as the command.
*  - bytesToSend: number of bytes to transmit from the pBuffer.
*  Return:
*  - Nothing.
************************************************************************************/
void    UART_SendCmd(uint8_t* pBuffer, uint16_t bytesToSend);

/************************************************************************************
*  Transmits a raw data buffer over the UART.
*
*  Input parameters:
*  - pBuffer: pointer to the data to transmit.
*  - bytesToSend: number of bytes to transmit from the pBuffer.
*  Return:
*  - Nothing.
************************************************************************************/
void    UART_SendRawData(uint8_t* pBuffer, uint16_t bytesToSend);
#endif // _UART_H_
