/************************************************************************************
*
* (c) Copyright 2009, Freescale, Inc.  All rights reserved.
*
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale.
*
************************************************************************************/
#ifndef _UART_H_
#define _UART_H_

#include "stdafx.h"
#include <stdio.h>
#include <process.h>
#include <time.h>

/************************************************************************************
*************************************************************************************
* Public macros
*************************************************************************************
************************************************************************************/
#define UART_SOF      0x55
#define VERBOSE_MODE  0
/************************************************************************************
*************************************************************************************
* Public type definitions
*************************************************************************************
************************************************************************************/
typedef enum {
  gUARTSuccess_c = 0x00,
  gUARTFailure_c,
  gUARTWriteFailure_c,
  gUARTReadFailure_c,
  gUARTTimeOut_c,
  gUARTCrcError_c,
  gUARTStatusMax_c
} UARTStatus_t;

/************************************************************************************
*************************************************************************************
* Public prototypes
*************************************************************************************
************************************************************************************/

/************************************************************************************
*  Tries to open and configure a COM port.
*
*  Input parameters:
*  - comPort: pointer to the COM port, as a string, to open.
*  - baudRate: baud rate to be used for this port.
*  Return:
*  - HANDLE: handle to be used for this port. INVALID_HANDLE_VALUE is the process
*      failed
************************************************************************************/
HANDLE UART_OpenCom(char* comPort, int baudRate);

/************************************************************************************
*  Transmits a command on the specified COM. The command is accompanied by the start 
* of frame delimiter, the length of the command, the command itself and a very simple
* 8 bit  CRC.
*
*  Input parameters:
*  - hCom: the handle of the COM port to use.
*  - pBuffer: pointer to the data to transmit as the command.
*  - bytesToSend: number of bytes to transmit from the pBuffer.
*  Return:
*  - UARTStatus_t: status of the operation.
************************************************************************************/
UARTStatus_t UART_SendCmd(HANDLE hCom, char* pBuffer, unsigned short bytesToSend);

/************************************************************************************
*  Receives a command on the specified COM. It waits for the SOF, receives the length
* and the command, computes the CRC and verifies it against the received CRC.
*
*  Input parameters:
*  - hCom: the handle of the COM port to use.
*  - timeOut: time, in miliseconds, to wait for the command.
*  - pBuffer: pointer to the buffer to place the received command in.
*  - pBytesReceived: the length of the received command.
*  Return:
*  - UARTStatus_t: status of the operation.
************************************************************************************/
UARTStatus_t UART_ReceiveCmd(HANDLE hCom, DWORD timeOut, char* pBuffer, unsigned short* pBytesReceived);

#endif _UART_H_