/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2008 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
********************************************************************************
*
* $File Name:  intram.ld$
*
* $Date: $
*
* $Version: $
*
* Description: MPC5604B Linker Command File for Internal RAM
*
*******************************************************************************/
MEMORY {
    // 32KB of internal SRAM
    rom             : ORIGIN = 0x40000000, LENGTH = 0x6000
    ram             : ORIGIN = 0x40006500, LENGTH = 0x1300
    ram_stack       : ORIGIN = 0x40007800, LENGTH = 0x800
}

//
// Program layout for running out of RAM.
//
//

SECTIONS
{
//
// RAM SECTIONS
//
    .isrvectbl            ALIGN(0x1000) : > rom
    .text                               : > .
    .vletext                            : > .
    .rodata                             : > .
    .sdata2                             : > .
    .syscall                            : > .
    .secinfo                            : > .
    .fixaddr                            : > .
    .fixtype                            : > .
    .PPC.EMB.sdata0                 ABS : > .
    .PPC.EMB.sbss0            CLEAR ABS : > .
    .pbcan_cfg                          : > .
    .pbcan_data                         : > .
    .pbadc_cfg                          : > .
    .pbadc_data                         : > .
    .pbport_cfg                         : > .
    .pbport_data                        : > .
    .pbgpt_cfg                          : > .
    .pbgpt_data                         : > .
    .pbicu_cfg                          : > .
    .pbicu_data                         : > .
    .pbpwm_cfg                          : > .
    .pbpwm_data                         : > .
    .pbfls_cfg                          : > .
    .pbfls_data                         : > .
    .pbfee_cfg                          : > .
    .pbfee_data                         : > .
    .pbspi_cfg                          : > .
    .pbspi_data                         : > .
    .pbmcu_cfg                          : > .
    .pbmcu_data                         : > .
    .pbwdg_cfg                          : > .
    .pbwdg_data                         : > .
    .pbfr_cfg                           : > .
    .pbfr_data                          : > .

    .sdabase                   ALIGN(8) : > ram    
    .sdata                              : > .
    .sbss                               : > .
    .data                               : > .
    .bss                                : > .
    .rcw                                : > .

//
//
// These special symbols mark the bounds of RAM and ROM memory.
// They are used by the MULTI debugger.
//
    __ghs_ramstart  = MEMADDR(rom);
    __ghs_ramend    = MEMENDADDR(ram_stack);
    __ghs_romstart  = MEMADDR(rom);
    __ghs_romend    = MEMADDR(rom);

    __IV_ADDR       = MEMADDR(rom);

    INT_SRAM_START  = ADDR(rom);
    INT_SRAM_SIZE   = 0x8000/128;                    // Init 128 bytes at a time
    SBSS_SRAM_START = ADDR(.sbss);
    SBSS_SRAM_SIZE  = (SIZEOF(.sbss)+3)/4;           // Init 4 bytes at a time
    BSS_SRAM_START  = ADDR(.bss);
    BSS_SRAM_SIZE   = (SIZEOF(.bss)+3)/4;            // Init 4 bytes at a time
    SDATA_RW_START  = ADDR(.sdata);
    SDATA_RO_START  = ADDR(.sdata2);

    RC_PPC_SDATA2_SRC  = ADDR(.PPC.EMB.sdata0);
    RC_PPC_SDATA2_DEST = ADDR(.PPC.EMB.sdata0);
    RC_PPC_SDATA2_SIZE = 0;
    RC_SDATA_SRC       = ADDR(.sdata);
    RC_SDATA_DEST      = ADDR(.sdata);
    RC_SDATA_SIZE      = 0;
    RC_DATA_SRC        = ADDR(.data);
    RC_DATA_DEST       = ADDR(.data);
    RC_DATA_SIZE       = 0;

    __SP_INIT      = ADDR(ram_stack) + SIZEOF(ram_stack);
    __SP_END       = ADDR(ram_stack);
    __STACK_SIZE   = SIZEOF(ram_stack);

    MEMSEC_0_ADDR  = ADDR(ram_stack);
    MEMSEC_0_SIZE  = 0x20;
}
