/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2008 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file      pin.h
*
* @author    rc574c
*
* @version   1.0.0.0
*
* @date      Dec-11-2008
*
* @brief     MCU pins function control.
*
******************************************************************************/

#ifndef _PIN_H_
#define _PIN_H_

/******************************************************************************
* Include
******************************************************************************/

#include "typedefs.h"

/******************************************************************************
* Defines
******************************************************************************/

#define RST   0x0000   /* Reset state */
#define GPI   0x0100   /* GP Input mode */
#define GPO   0x0200   /* GP Output mode */
#define F1O   0x0400   /* Alternative Function 1 */
#define F2O   0x0800   /* Alternative Function 2 */
#define F3O   0x0C00   /* Alternative Function 3 */
#define FXI   0x0100   /* Alternative Function 1, 2, 3 Input mode */
#define FAI   0x2000   /* Alternative Function ADC input pin */

/******************************************************************************
* Function Prototypes
******************************************************************************/

// Configure MCU pins
void Mcu_Pin_Config(void);


#endif /* _PIN_H_ */


