/****************************************************************************************************/
/**
Copyright (c) 2008 Freescale Semiconductor
Freescale Confidential Proprietary
\file       Adc_Fltr_Cfg.h
\brief      This file contains all Configuration parameters of ADC Filter driver
\author     Freescale Semiconductor
\author     Guadalajara Applications Laboratory RTAC Americas
\author     R01160
\version    1.0
\date       11/24/2008 
*/
/****************************************************************************************************/
/*                                                                                                  */
/* All software, source code, included documentation, and any implied know-how are property of      */
/* Freescale Semiconductor and therefore considered CONFIDENTIAL INFORMATION.                       */
/* This confidential information is disclosed FOR DEMONSTRATION PURPOSES ONLY.                      */
/*                                                                                                  */
/* All Confidential Information remains the property of Freescale Semiconductor and will not be     */
/* copied or reproduced without the express written permission of the Discloser, except for copies  */
/* that are absolutely necessary in order to fulfill the Purpose.                                   */
/*                                                                                                  */
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.     */
/* CUSTOMER retains the final decision relative to the total design and functionality of the end    */
/* product.                                                                                         */
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/
#ifndef __ADC_FLTR_CFG_H__
 #define __ADC_FLTR_CFG_H__
 
/* For each filtered ATD create and assign the following parameters */
/* For ATD0 */
#define ATDFLTR_0_AVERAGE                /* Create filter 1 */
#define ATDFLTR_0_AVERAGECHANNELS 8      /* 1..8/16 ; number of active channels used on this ATD */
#define ATDFLTR_0_AVERAGE0 0             /* 1.. 8/16; Define which ATD channel goes to filter 0 */
#define ATDFLTR_0_AVERAGE1 1             /* 1.. 8/16; Define which ATD channel goes to filter 1 */
#define ATDFLTR_0_AVERAGE2 2             /* 1.. 8/16; Define which ATD channel goes to filter 2 */
#define ATDFLTR_0_AVERAGE3 3             /* 1.. 8/16; Define which ATD channel goes to filter 3 */
#define ATDFLTR_0_AVERAGE4 4             /* 1.. 8/16; Define which ATD channel goes to filter 4 */
#define ATDFLTR_0_AVERAGE5 5             /* 1.. 8/16; Define which ATD channel goes to filter 5 */
#define ATDFLTR_0_AVERAGE6 6             /* 1.. 8/16; Define which ATD channel goes to filter 6 */
#define ATDFLTR_0_AVERAGE7 7             /* 1.. 8/16; Define which ATD channel goes to filter 7 */
#define ATDFLTR_0_AVERAGETAPS 8          /* 1..64 ; size of filter - shared among all filters on this ATD */
#define ATDFLTR_0_AVERAGEINTERRUPT ON    /* If TRUE then XGATE interrupts CPU when done */

/* For ATD1 */
#define ADCFLTR_1_AVERAGE                /* Create filter 2 */
#define ADCFLTR_1_AVERAGECHANNELS 10     /* 1..8/16 ; number of active channels used on this ATD */
#define ADCFLTR_1_AVERAGE0 0             /* 1.. 8/16; Define which ATD channel goes to filter 0 */
#define ADCFLTR_1_AVERAGE1 1             /* 1.. 8/16; Define which ATD channel goes to filter 1 */
#define ADCFLTR_1_AVERAGE2 2             /* 1.. 8/16; Define which ATD channel goes to filter 2 */
#define ADCFLTR_1_AVERAGE3 3             /* 1.. 8/16; Define which ATD channel goes to filter 3 */
#define ADCFLTR_1_AVERAGE4 7             /* 1.. 8/16; Define which ATD channel goes to filter 4 */
#define ADCFLTR_1_AVERAGE5 6             /* 1.. 8/16; Define which ATD channel goes to filter 5 */
#define ADCFLTR_1_AVERAGE6 5             /* 1.. 8/16; Define which ATD channel goes to filter 6 */
#define ADCFLTR_1_AVERAGE7 4             /* 1.. 8/16; Define which ATD channel goes to filter 7 */
#define ADCFLTR_1_AVERAGE8 8             /* 1.. 8/16; Define which ATD channel goes to filter 4 */
#define ADCFLTR_1_AVERAGE9 9             /* 1.. 8/16; Define which ATD channel goes to filter 5 */
#define ADCFLTR_1_AVERAGETAPS 8          /* 1..64 ; size of filter - shared among all filters on this ATD */
#define ADCFLTR_1_AVERAGEINTERRUPT ON    /* If TRUE then XGATE interrupts CPU when done */

 
#endif