/****************************************************************************************/
/**
  Copyright (c) 2008 Freescale Semiconductor
  Freescale Confidential Proprietary
  \file     	Pit.h
  \brief    	This file contains all Pit functions and definition declarations. 
  \author   	Freescale Semiconductor
  \author     r01160
  \author   	Guadalajara Applications Laboratory RTAC Americas
  \version    0.1
  \date     	5/23/2008 
  \warning      
  
  * History:
  
*/
/****************************************************************************************/
#ifndef _PIT_H_
  #define _PIT_H_
  
  #include "Derivative.h"
  #include "System_Cfg.h"
  #include "Scheduler.h"
  #include "Adc_Filter_ReportError.h"
    
/*------------------------- Type definitions --------------------------------------------------------------*/    
 typedef void(*Pit_CallbackType)(void);
    
/*--------------------- Macros --------------------------*/
/** Assign Counter value to desired Pit channel. Violates MISRA 2004 rule 11.3 and 14.3 because addressing memory mapped registers */
#define PIT_LOAD_VALUE(u8Pit_Ch, u32Val)        \
{                                               \
    switch(u8Pit_Ch)                            \
    {                                           \
       case 0:  PIT_TLVAL0 = (uint32_t)u32Val;  \
           break;                               \
       case 1:  PIT_TLVAL1 = (uint32_t)u32Val;  \
           break;                               \
       case 2:  PIT_TLVAL2 = (uint32_t)u32Val;  \
           break;                               \
       case 3:  PIT_TLVAL3 = (uint32_t)u32Val;  \
           break;                               \
       case 4:  PIT_TLVAL4 = (uint32_t)u32Val; \
           break;                               \
       case 5:  PIT_TLVAL5 = (uint32_t)u32Val; \
           break;                               \
       case 6:  PIT_TLVAL6 = (uint32_t)u32Val; \
           break;                               \
       case 7:  PIT_TLVAL7 = (uint32_t)u32Val;\
           break;                               \
       default:                                 \
           break;                               \
    }                                           \
}

 /** Timing constants                           */
 #define   PIT_LOOP_TIME_100ms    ((float32_t)0.100 * (float32_t)SYS_FREQ) 
 #define   PIT_LOOP_TIME_50ms     ((float32_t)0.050 * (float32_t)SYS_FREQ) 
 #define   PIT_LOOP_TIME_5ms      ((float32_t)0.005 * (float32_t)SYS_FREQ) 
	
 /** Pit Channel 1 */
 #define PIT_CH_1         ((uint32_t)1)
 /** Pit Channel 2 */
 #define PIT_CH_2         ((uint32_t)2)
 /** Pit Channel 3 */
 #define PIT_CH_3         ((uint32_t)3)
 /** Pit Channel 4 */
 #define PIT_CH_4         ((uint32_t)4)
 /** Pit Channel 5 */
 #define PIT_CH_5         ((uint32_t)5)
 
 /*------------------PIT Interrupt Base Times ------------------------*/
 #define _PIT_INT_TIME_33US_          ((uint32_t)0x0840)
 /** Pit Vector Interrupt Offset                   */
 #define PIT_BASE_OFFSET              ((uint8_t)148)
/** Enables a particular PIT channel timer. */
 #define PIT_ENABLED(u8PitChannel)    (PIT_EN  = (PIT_EN | ((uint32_t)1 << (uint32_t)u8PitChannel))); /* Enable PIT x Channel                           */
 /*--------------------- Functions --------------------------*/
 void vfnPit_Init(uint8_t u8PitChannel, uint32_t u32Period);
 void vfnPit_Set_Callback_Fnc(Pit_CallbackType Callback_Fnc);
 extern void vfnPit_Ch1_Isr(void);  
 
 



#endif