/******************************************************************************************************************/
/**
Copyright (c) 2008 Freescale Semiconductor
Freescale Confidential Proprietary
\file		Emios.c
\brief		This file handles Multi-Thread Scheduler timebase
\author  	Freescale Semiconductor
\author  	Guadalajara Applications Laboratory RTAC Americas
\author  	R01160
\version	0.1
\date		5/23/2008 
*/
/******************************************************************************************************************/
/*																									*/
/* All software, source code, included documentation, and any implied know-how are property of		*/
/* Freescale Semiconductor and therefore considered CONFIDENTIAL INFORMATION.						*/
/* This confidential information is disclosed FOR DEMONSTRATION PURPOSES ONLY.						*/
/*																									*/
/* All Confidential Information remains the property of Freescale Semiconductor and will not be  	*/
/* copied or reproduced without the express written permission of the Discloser, except for copies	*/
/* that are absolutely necessary in order to fulfill the Purpose.									*/
/*																									*/
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.  	*/
/* CUSTOMER retains the final decision relative to the total design and functionality of the end	*/
/* product.  																						*/
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*																									*/
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,  		*/
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from		*/
/* FREESCALE services.																				*/
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of  	*/
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or		*/
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/
/* in connectionwith product, services or goods supplied under this Agreement.						*/
/*																									*/
/******************************************************************************************************************/
#include	 "Emios.h"

/** Emsci Callback types */
	   Emios_CallbackType  Emios_CallBack_1;
	   Emios_CallbackType  Emios_CallBack_2;
	   Emios_CallbackType  Emios_CallBack_3;
	   Emios_CallbackType  Emios_CallBack_4;
	   Emios_CallbackType  Emios_CallBack_5;
	   Emios_CallbackType  Emios_CallBack_6;
	   Emios_CallbackType  Emios_CallBack_7;
	   Emios_CallbackType  Emios_CallBack_8;
	   Emios_CallbackType  Emios_CallBack_9;
	   

/*----------------------------------------------------------------------------------------------------------------*/
/**
* \brief	Enable General Emios Clocks.   
* \author	R01160
* \param	void
* \return	void
*/
void vfnEmiosConfig_General_Clocks( void  )
{
	
    eMIOS_ENABLE_GLOBAL_TIMEBASE;                               /* Assert Global Time base enable, to enable internal counters */
	eMIOS_SET_GLOBAL_PRESCALER_VALUE( eMIOS_GLOBAL_PRESCALER - 1 );	/*	Divide sysclk by (11+1) for eMIOS clock  	           */
	eMIOS_ENABLE_GLOBAL_PRESCALER;								/*	Enable eMIOS clock							               */
	eMIOS_ENABLE_GLOBAL_FREEZE_IN_DEBUG;						/*	Enable stopping channels when in debug mode                */
	
}

/*----------------------------------------------------------------------------------------------------------------*/
/**
 * \brief	 Initialize specific emios channel.
 * \author	 R01160
 * \param	 Emios Channel, Interrupt Vector Number.
 * \return	 void
 * \warning  This function does not intialize the emios pin functionality of the MCU \n
             neither the operation mode of the Emios channel.
 */
void vfnEmios_Init_Channel( uint8_t u8EmiosChannel, uint8_t u8Emios_Interrupt_Num )
{
	
    /* Local Prescaler Enabled                                     */
    eMIOS_ENABLE_LOCAL_PRESCALER(u8EmiosChannel);           
    /* Local Divide Ratio = 1. Total Target freq = 16MHz           */ 
    eMIOS_SET_PRESCALER(u8EmiosChannel,eMIOS_TM_LOCAL_PRESCALER - (uint8_t)1);         
    /*Allows unified channel FLAG bit to generate an interrupt signal */
    eMIOS_ENABLE_CHANNEL_INTERRUPT(u8EmiosChannel);
    /* Use the internal time base for channel                      */
    eMIOS_SET_INTERNAL_TIME_BASE(u8EmiosChannel);       
    /* Stop (freeze) channel registers when in debug mode          */
    eMIOS_FREEZE_IN_DEBUG(u8EmiosChannel);             
  #if (Z0_CORE == ON) 
    /* Raise priority of interrupt to Level 1: Interrupt handled by Z0 Core */
    INT_PSR(u8Emios_Interrupt_Num ,0xC1);
  #else   
    /* Raise priority of interrupt to Level 1: Interrupt handled by Z0 Core */
    INT_PSR(u8Emios_Interrupt_Num ,0x01); 
  #endif  
    /* Set function pointer to jump when emios interrupt occurs    */
    vfnEmios_Set_Callback_Fnc(Scheduler_Fnc_Handler, 0U);
}

/*----------------------------------------------------------------------------------------------------------------*/
/**
 * \brief	 Configures the Emios Modulus Counter Mode and starts the Specific Emios channel.
 * \author	 R01160
 * \param	 Emios Channel, Timming Interrupt.
 * \return	 void
 * \warning  This functions works only to operate the Modulus Up counter of the \n
             Emios module.
 */
void vfnEmios_Modulous_Cntr_Mode(uint8_t u8EmiosChannel, uint32_t u32Timming)
{
	 /*Load Timer constant to primary compare register */
    eMIOS_SET_COUNT_A(u8EmiosChannel,u32Timming);
    /* Select Modulus Counter, up counter, internal clock source, by selecting a valid MODE, timer starts counting */
    eMIOS_SET_MODULUS_UP_COUNTER(u8EmiosChannel);
}

/*----------------------------------------------------------------------------------------------------------------*/
/**
 * \brief	  Sets the function to which the emios interrupt shall \n
			  jump once interrupt occurs.
 * \author	  R01160
 * \param	  Emios_CallbackType - Callback type definition, Fnc Callback \n
			  to be used.
 * \return	  none
 * \warning   this function will skip any null pointer parameter passed \n
			  as a input parameter.
 */
void vfnEmios_Set_Callback_Fnc( const Emios_CallbackType  Callback_Fnc, uint8_t  u8FncCallback )
{   
  #if (  EMSCI_ERROR_DETECT  ==  ON  )							/*If Pwm Error Layer Enabled validate errors	  */
	if( Callback_Fnc == NULL_PTR )								/*	Pwm module already initilized?				  */
	{
		vfnEmsci_Report_Error( EMSCI_CALLBACK_PTR_ID, EMSCI_E_FNC_CALLBACK_UNINIT );
																/*	  Report None initilized module  			  */
	}
	else
	{
  #endif															
  	 																
	  /*--- MISRA Rule 16.9 violation: A function identifier shal only be used with either a preceding ---*/
	  /*---- & or with parenthisised parameter list                                                       */
	  	  
	  switch(u8FncCallback)
	  {
			case 0U: Emios_CallBack_1 = Callback_Fnc;
				break;
			case 1U: Emios_CallBack_2 = Callback_Fnc;
				break;
			case 2U: Emios_CallBack_3 = Callback_Fnc;
				break;
			case 3U: Emios_CallBack_4 = Callback_Fnc;
				break;
			case 4U: Emios_CallBack_5 = Callback_Fnc;
				break;				
			case 5U: Emios_CallBack_6 = Callback_Fnc;
				break;
			case 6U: Emios_CallBack_7 = Callback_Fnc;
				break;
			case 7U: Emios_CallBack_8 = Callback_Fnc;
				break;
			case 8U: Emios_CallBack_9 = Callback_Fnc;
				break;
			default:
				break;
	  }
	
	
	
#if (  EMSCI_ERROR_DETECT  ==  ON  )
	}
#endif

}

/*----------------------------------------------------------------------------------------------------------------*/
/**
 * \brief	  Service Interrupt routine from Emios channel 0
 * \author	  R01160
 * \param	  none
 * \return	  none
 */
void vfnEmios_Isr_0( void  )
{
	if( eMIOS_STATUS_FLAG( EMIOS_CH0 ) == 1U )
	{
		/* Jump into Tx routine for channel number 1 */
		Emios_CallBack_1( );
	}

	/* clear the interrupt flag */
	eMIOS_STATUS_FLAG( EMIOS_CH0 ) = 0x01U;
}
/*----------------------------------------------------------------------------------------------------------------*/
/**
 * \brief	  Service Interrupt routine from Emios channel 0
 * \author	  R01160
 * \param	  none
 * \return	  none
 */

void vfnEmios_Isr_1( void  )
{
	if( eMIOS_STATUS_FLAG( EMIOS_CH1 ) == 1U )
	{
		/* Jump into Rx routine for channel number 1 */
		Emios_CallBack_2( );
	}

	/* clear the interrupt flag */
	eMIOS_STATUS_FLAG( EMIOS_CH1 ) = 0x01U;
}

/*----------------------------------------------------------------------------------------------------------------*/
/**
 * \brief	  Service Interrupt routine from Emios channel 2
 * \author	  R01160
 * \param	  none
 * \return	  none
 */
void vfnEmios_Isr_2( void  )
{
	if( eMIOS_STATUS_FLAG( EMIOS_CH2 ) == 1U )
	{
		/* Jump into Tx routine for channel number 1 */
		Emios_CallBack_3( );
	}

	/* clear the interrupt flag */
	eMIOS_STATUS_FLAG( EMIOS_CH2 ) = 0x01U;
}
/*----------------------------------------------------------------------------------------------------------------*/
/**
 * \brief	  Service Interrupt routine from Emios channel 3
 * \author	  R01160
 * \param	  none
 * \return	  none
 */

void vfnEmios_Isr_3( void  )
{
	if( eMIOS_STATUS_FLAG( EMIOS_CH3 ) == 1U )
	{
		/* Jump into Rx routine for channel number 1 */
		Emios_CallBack_4( );
	}

	/* clear the interrupt flag */
	eMIOS_STATUS_FLAG( EMIOS_CH3 ) = 0x01U;
}

/*----------------------------------------------------------------------------------------------------------------*/
/**
 * \brief	  Service Interrupt routine from Emios channel 4
 * \author	  R01160
 * \param	  none
 * \return	  none
 */
void vfnEmios_Isr_4( void  )
{
	if( eMIOS_STATUS_FLAG( EMIOS_CH4 ) == 1U )
	{
		/* Jump into Tx routine for channel number 1 */
		Emios_CallBack_5( );
	}

	/* clear the interrupt flag */
	eMIOS_STATUS_FLAG( EMIOS_CH4 ) = 0x01U;
}
/*----------------------------------------------------------------------------------------------------------------*/
/**
 * \brief	  Service Interrupt routine from Emios channel 5
 * \author	  R01160
 * \param	  none
 * \return	  none
 */

void vfnEmios_Isr_5( void  )
{
	if( eMIOS_STATUS_FLAG( EMIOS_CH5 ) == 1U )
	{
		/* Jump into Rx routine for channel number 1 */
		Emios_CallBack_6( );
	}

	/* clear the interrupt flag */
	eMIOS_STATUS_FLAG( EMIOS_CH5 ) = 0x01U;
}

/*----------------------------------------------------------------------------------------------------------------*/
/**
 * \brief	  Service Interrupt routine from Emios channel 6
 * \author	  R01160
 * \param	  none
 * \return	  none
 */
void vfnEmios_Isr_6( void  )
{
	if( eMIOS_STATUS_FLAG( EMIOS_CH6 ) == 1U )
	{
		/* Jump into Tx routine for channel number 1 */
		Emios_CallBack_7( );
	}

	/* clear the interrupt flag */
	eMIOS_STATUS_FLAG( EMIOS_CH6 ) = 0x01U;
}
/*----------------------------------------------------------------------------------------------------------------*/
/**
 * \brief	  Service Interrupt routine from Emios channel 7
 * \author	  R01160
 * \param	  none
 * \return	  none
 */

void vfnEmios_Isr_7( void  )
{
	if( eMIOS_STATUS_FLAG( EMIOS_CH7 ) == 1U )
	{
		/* Jump into Rx routine for channel number 1 */
		Emios_CallBack_8( );
	}

	/* clear the interrupt flag */
	eMIOS_STATUS_FLAG( EMIOS_CH7 ) = 0x01U;
}
/*----------------------------------------------------------------------------------------------------------------*/
/**
 * \brief	  Service Interrupt routine from Emios channel 9 \n
 *          this interrupt calls Scheduler function.
 * \author	R01160
 * \param	  none
 * \return	none
 */
void vfnEmios_Isr_9(void)
{
  if( eMIOS_STATUS_FLAG( EMIOS_CH9 ) == 1U )
	{
		/* Jump into Rx routine for channel number 1 */
		Emios_CallBack_9( );
	}

	/* clear the interrupt flag */
	eMIOS_STATUS_FLAG( EMIOS_CH9 ) = 0x01U;

}