#ifndef __XL_ATD_FILTER_H_
#define __XL_ATD_FILTER_H_


/* Defines the config structure used for in channel */
typedef struct
{
  unsigned int numTAPS:6;  /* Number of taps used by this driver */
  unsigned int numChannels:4;  /* Number of channels managed by this driver */
  unsigned int interruptCPU:1;      /* TRUE if CPU should be interrupted at end of thread */
} txl_atd_ChannelConfig;

/* Defines the structure used for each channel */
typedef struct
{
	unsigned int* pSampleBuffer;    /* Pointer to the stored ATD samples */
	unsigned int* pResultRegister;  /* Pointer to the ATD results register*/
  unsigned int*	pFilterResult;    /* Pointer to the latest filter output value */
} txl_atd_ChannelStruct;

/* Defines the structure used for each ATD */
typedef struct
{
  txl_atd_ChannelStruct* channels; /* Array of channelstructs */
  txl_atd_ChannelConfig config;
} txl_atd_FilterStruct;

/* Function prototypes */
interrupt void xl_atd_Average(txl_atd_FilterStruct* filter);
interrupt void xl_atd_initaverage();

#endif