/**
  \mainpage 
  
  \n Copyright (c) 2008 Freescale Semiconductor
  \n Freescale Confidential Proprietary
  
  \brief      Emulated SCi sample application. This code demonstrates the features \n
              of the EMSCI driver.
  
  \author   	Freescale Semiconductor
  \author     R01160
  \author   	Guadalajara Applications Laboratory RTAC Americas
  
  \version    1.0
  \date       10/3/2008
  
    
  DISCLAIMER: 
  
  *** Services performed by FREESCALE in this matter are performed AS IS and without any warranty. 
  CUSTOMER retains the final decision relative to the total design and functionality of the end product. 
  FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project. 
  FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, implied 
  warranty of merchantability or fitness for a particular purpose on any hardware, software ore advise 
  supplied to the project by FREESCALE, and or any product resulting from FREESCALE services . 
  In no event shall FREESCALE be liable for incidental or consequential damages arising out of this agreement. 
  CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or actions by anyone on account 
  of any damage, or injury, whether commercial, contractual, or tortuous, rising directly or indirectly as a 
  result of the advice or assistance supplied CUSTOMER in connection with product, services or goods supplied
  under this Agreement. ***
*/

#include "MPC551x.h"
#include "main.h"
#include "Scheduler.h"
#include "Emsci.h"
#include "Emios.h"

extern long __IVPR_VALUE;

void enableIrq(void);
asm void initIrqVectors(void);
void initINTC(void);

/** Indicates the status of each Tx module */
uint32_t u32aTxMsgStatus[4];
/** Indicates whether a frame has been received in every Rx module */
uint32_t u32aRxMsgStatus[4];
/** Rx buffer for module 1 */
uint32_t *pu32RxBuffer_0 = (uint32_t*)0x40000100;


void main(void) 
{
  uint32_t u32TestPtr = 0;
  
  /* Initialise Scheduler handling variables */
  gu8SleepModeEnabled = 0;
  gu8Scheduler_Ctrl   = 0;
  gu8Scheduler_Flag   = 0;

  u32aTxMsgStatus[0] = TX_FRAME_CLEAR;
  u32aTxMsgStatus[1] = TX_FRAME_CLEAR;
  u32aTxMsgStatus[2] = TX_FRAME_CLEAR;
  u32aTxMsgStatus[3] = TX_FRAME_CLEAR;
  u32aRxMsgStatus[0] = RX_FRAME_CLEAR;
  u32aRxMsgStatus[1] = RX_FRAME_CLEAR;
  u32aRxMsgStatus[2] = RX_FRAME_CLEAR;
  u32aRxMsgStatus[3] = RX_FRAME_CLEAR;
  
   
  vfnInit_PLL();
  initIrqVectors();   /* Initialize exceptions: only need to load IVPR */
  initINTC();         /* Initialize INTC for hardware vector mode */
  //vfnemsci_init(Emsci_ChannelConfig);
  vfnScheduler_Init();    /* Initialize Scheduler timebase                 */
  enableIrq();		  /* Ensure INTC current prority=0 & enable IRQ */
  vfnStart_Scheduler();   /* Start Tasks execution                         */
  //EMSCI_TX(EMSCI0,0x15);

  while (gu8SleepModeEnabled == 0)
  {
       if ((gu8Scheduler_Flag & (uint8_t)0x01) == (uint8_t)0x01)
        {
            /*-- Allow 100 ms periodic tasks to be executed --*/
            EXECUTE_100MS_TASKS(); 
	        /* Scheduled tasks finished, clear control flag */
            gu8Scheduler_Flag = (uint8_t)0x00;
        }
        else
        { 
            if ((gu8Scheduler_Flag & (uint8_t)0x02) == (uint8_t)0x02)
            {    
                /*-- Allow 200 ms periodic tasks to be executed --*/
                 EXECUTE_200MS_TASKS(); 
	       	    /* Scheduled tasks finished, clear control flag */
                 gu8Scheduler_Flag = (uint8_t)0x00;
            }
            else
            { 
                if ((gu8Scheduler_Flag & (uint8_t)0x04) == (uint8_t)0x04)
                {
                    /*-- Allow 400 ms periodic tasks to be executed --*/
                     EXECUTE_400MS_TASKS(); 
                    /* Scheduled tasks finished, clear control flag */
                    gu8Scheduler_Flag = (uint8_t)0x00;
                }
                else
                {     
                    if ((gu8Scheduler_Flag & (uint8_t)0x08) == (uint8_t)0x08)
                    {
                        /*-- Allow 800 ms group A periodic tasks to be executed --*/
                         EXECUTE_800MS_A_TASKS();
		            	/* Scheduled tasks finished, clear control flag */
                        gu8Scheduler_Flag = (uint8_t)0x00;
                    }
                    else
                    {     
                        if ((gu8Scheduler_Flag & (uint8_t)0x10) == (uint8_t)0x10)
                        {
                            /*-- Allow 800 ms group B periodic tasks to be executed --*/
			                
                            /* Scheduled tasks finished, clear control flag */
                            gu8Scheduler_Flag = (uint8_t)0x00;                 
                        }
                    }
                }
            }
        }   
   }
}


asm void initIrqVectors(void) 
{
  lis	   r3, __IVPR_VALUE@h   /* IVPR value is passed from link file */
  ori      r3, r3, __IVPR_VALUE@l 
  mtivpr   r3									 
}

void initINTC(void) 
{	
  INTC.MCR.B.HVEN_PRC0 = 1;   /* MPC551x: Proc'r 0: initialize for HW vector mode */
}
void enableIrq(void) 
{
  INTC.CPR_PRC0.B.PRI = 0;     /* MPC551x Proc'r 0: Lower INTC's current priority */
  asm(" wrteei 1");	    	   /* Enable external interrupts */
}


void TxInterrupt(void)
{
	u32aTxMsgStatus[0] = TX_FRAME_DONE;
}

void RxInterrupt(void)
{
  static uint32_t u32RxDataIx = 0;
  
  if(u32RxDataIx < 10)
  {
    EMSCI_RX(0,pu32RxBuffer_0[u32RxDataIx]);   /* Save New Data           */
    u32RxDataIx++;	                           /* Increase buffer pointer */
  }
  else
  {
  	u32RxDataIx = 0;                          /* Clear Buffer Pointer     */
  }
  
  u32aRxMsgStatus[0] = RX_FRAME_READY;  /* Mark buffer as ready */
}

